<?php

class BiometricController extends Controller {

//	public function actionIndex()
//	{
//		$this->render('index');
//	}

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'Loademployeeexcludelist', 'SaveEmployeeBiometricDetail', 'GetList', 'DeleteBiometric'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $model_module_attendance = HrModules::model()->findByPK(2);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_empatt_biometric_exclude_menu']) || Yii::app()->user->authorised_user == 1) && ($model_module_attendance->grant_access == 1 && $model_module_attendance->isActive == 'Y')) {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access');
        }
    }

    public function actionGetList() {
        //BiometricExclude
        $model = new BiometricExclude();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'branch',
            1 => 'employeedetail.employee_code',
            2 => 'branchdetail.branch_or_sponsor_name',
            3 => 'employee_id',
            4 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];

            $searchString_encryption = $this->ciphertext($searchString, "e");

            $condition .= " and (branchdetail.branch_or_sponsor_name LIKE '%" . $searchString . "%'
                                         OR employeedetail.first_name LIKE '%" . $searchString_encryption . "%'
                                         OR employeedetail.last_name LIKE '%" . $searchString_encryption . "%'
                                         OR employeedetail.employee_code LIKE '%" . $searchString_encryption . "%')";
        }
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' and employeedetail.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        $count = $model->with('employeedetail', 'branchdetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'branchdetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $delete=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_att_biometric_exclude_list_delete']) || Yii::app()->user->authorised_user == 1) {
                $delete=1;
//                $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteEmpBiometric(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>';
            }
            $rowData[] = array($m, $this->ciphertext($row['employeedetail']['employee_code'], "d"), $row['branchdetail']['branch_or_sponsor_name'], $this->ciphertext($row['employeedetail']['first_name'], "d") . " " . $this->ciphertext($row['employeedetail']['last_name'], "d"), array('id' => $row['id'],'delete'=>$delete));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new BiometricExclude();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }


        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('biometric_form', array('model' => $model), false, true);
    }

    public function actionLoademployeeexcludelist() {
        $branch_id = $_POST['branch_id'];
        $model_biometric = BiometricExclude::model()->with('employeedetail')->findAll(array('condition' => 'branch="' . $branch_id . '" and employeedetail.isActive="Y"'));
        $SQL = " SELECT * 
                FROM  `erp_hr_employee` E
                WHERE isActive!='B'  AND branch_or_sponsor_id='" . $branch_id . "' && id 
                NOT IN (
                    SELECT  employee_id 
                    FROM  erp_hr_employee_biometric_exclude 
                    WHERE branch ='" . $branch_id . "'
                )";
        $model_employee = Yii::app()->db->createCommand($SQL)->queryAll();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('list_employee_biometric', array('model' => $model_employee, 'model_biometric' => $model_biometric, 'branch_id' => $branch_id), false, true);
    }

    public function actionSaveEmployeeBiometricDetail() {
        if (isset($_POST['BiometricExclude'])) {
            foreach ($_POST['BiometricExclude'] as $each_biometric) {
                if (in_array($each_biometric['employee_id'], $_POST['arraycid'])) {
                    if ($each_biometric['id'] != '') {
                        $model_biometric = BiometricExclude::model()->findByPK($each_biometric['id']);
                    } else {
                        $model_biometric = new BiometricExclude();
                    }
                    $model_biometric->employee_id = $each_biometric['employee_id'];
                    $model_biometric->branch = $_POST['branch_id'];
                    $model_biometric->save(false);
                    Employee::model()->updateByPK($each_biometric['employee_id'], array('employee_exclude_biometric' => 1));
                } else {
                    if ($each_biometric['id'] != '') {
                        $model_biometric = BiometricExclude::model()->DeleteByPK($each_biometric['id']);
                        Employee::model()->updateByPK($each_biometric['employee_id'], array('employee_exclude_biometric' => 0));
                    }
                }
            }
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }

    public function actionDeleteBiometric() {
        $id = (int) Yii::app()->request->getParam('id');
        $model_biometric = BiometricExclude::model()->findbyPK($id);
        Employee::model()->updateByPK($model_biometric->employee_id, array('employee_exclude_biometric' => 0));
        BiometricExclude::model()->deleteByPK($id);
        echo CJSON::encode(array('status' => 'success'));
    }

}
