<?php
class BankController extends Controller
{
    public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','DisableBank','SaveBank','GetBankList','DirectAdd'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    
    public function filters()
    {
        return array(
        'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_bank_menu']) || Yii::app()->user->authorised_user == 1) {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetBankList()
    {
        $model=new MasBank();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
            0 =>'id',
            1 =>'bank_name',
            2 =>'bank_code',
            3 =>'routing_code',
            4=>''
           );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = 't.isActive="Y"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $condition = "1=1 ";
            $searchString = $_POST['search']['value'];
          $condition.=" and (bank_name LIKE '%".$searchString."%' OR bank_code LIKE '%".$searchString."%' OR t.routing_code LIKE '%".$searchString."%' )";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=$offset;
        foreach ($model as $row)
        {
            $button_string="";
            $disable_button=$edit_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_bank_edit']) || Yii::app()->user->authorised_user == 1) { 
                $edit_button=1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_bank_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable_button=1;
            }
            $rowData[]=array(++$m,$row['bank_name'],
                $row['bank_code'],
                $row['routing_code'],
                array('id' => $row['id'],'code'=>$row['bank_name'],'isActive'=>$row['isActive'],'edit_button'=>$edit_button,'disable_button'=>$disable_button)
               );
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new MasBank(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
                   
            
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('bank_form', array('model' => $model), false, true);
    }
    public function actionSaveBank()
    {
        $model = new MasBank();
        if (isset($_POST['MasBank']))
        {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime =date('Y-m-d h:i:s');

            if ((int) @$_POST['MasBank']['id'] > 0)
            {
                $id= (int) @$_POST['MasBank']['id'];
                $model=$model->findByPk($id); 
                $model->scenario = 'update';
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime =date('Y-m-d h:i:s');
               
            }else{
                $model->scenario = 'add';
            }
            $model->attributes=$_POST['MasBank'];
            if($model->save())
            {       
                    $bank_form ="";
                    if(!empty($_POST['bank_form'])){
                    $bank_form = $_POST['bank_form'];   
                    }
                    $jsonData['status'] = 'success';
                    $jsonData['frm'] = $bank_form;
                    $jsonData['id'] = $model->id;
                    echo CJSON::encode($jsonData);
                   // $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
            }
            else
            {
                    $error = CActiveForm::validate($model, '', false);
                    if ($error != '[]')
                           echo $error;
            }
           // $this->render('bank_form', array('model' => $model), false, true);

        }
    }
    public function actionDisableBank()
    {
        date_default_timezone_set("Asia/Dubai");
        $id = $_POST['id'];
        //$model_c = Customer::model()->findAll(array('condition'=>'customer_bank_id='.$id.''));
        //$model_v = Vendor::model()->findAll(array('condition'=>'vendor_bank_name='.$id.''));
        //if(empty($model_c) && empty($model_v)){
        if(!empty($id))  {
            $model=new MasBank();
            $model=$model->findByPk($id);
            if($model->isActive=='N'){
                $model->isActive='Y';
            }else{
                $model->isActive = 'N';            
            }           
            $model->updated_by = Yii::app()->user->id;
            $model->updated_datetime =date('Y-m-d h:i:s');
            $model->save(FALSE);
            echo "success";
        }
        else{
              echo "fail";
        }
              
    }
    public function actionDirectAdd(){
       $from = $_POST['from'];
       $name = $_POST['name'];
       $status =  array();
       $drop = '';
       if($name != ''){
           $modelBank = new MasBank;
           $modelBank->bank_name = $name;
           if($modelBank->save()){
                $status['status']= "success";
                $data  = MasBank::getBanks();
                if($from == 'vendor'){
                    $model = new Vendor;
                    $field_name = 'vendor_bank_name';
                }
                $model->$field_name = $modelBank->id;
                $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Bank'));  
                $status['drop']= $drop;
                echo CJSON::encode($status); 
           }else{
                $error = CActiveForm::validate($modelBank, '', false);
                    if ($error != '[]')
                           echo $error;
           }
       }
    }   
  
}