<?php

class ApprovelevelController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('AddApprovelevel','loademployeedetails','listleveldetail','SaveApprovelevel','listdetaillevel','addsingleapprovelevel',
                    'SaveSameApprovelevel','Report','loadleveldetails','getfunctionality','checkuserexistwithadmin','ChangeApprover','loadlevelwithapprover'
                    ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }	 
    public function actionAddApprovelevel() {
        $model = new Employee();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('approve_level', array('model' => $model), false, true);
    }
    public function actionloademployeedetails() {
        $branch =Yii::app()->request->getparam('branch'); 
        $functionality_id =Yii::app()->request->getparam('functionality_id'); 
        $department_id =Yii::app()->request->getparam('department_id'); 
        $condition='branch_or_sponsor_id="' . $branch . '" and isActive!="B"';
        if($department_id>0){
            $condition.=' AND department="' . $department_id . '"';
        }
        $model_employee = Employee::model()->findAll(array('condition' =>$condition));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d"). ' ' . $value['employeecode']]=$value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('employee_list', array('branch' => $branch,'functionality_id' => $functionality_id,'arr_employee'=>$arr_employee), false, true); 
    }
    public function actionlistleveldetail() {
        $max_level =Yii::app()->request->getparam('max_level'); 
        $functionality_id =Yii::app()->request->getparam('functionality_id'); 
        $employee_id =Yii::app()->request->getparam('employee_id'); 
        $row =Yii::app()->request->getparam('row'); 
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('level_list', array('max_level' => $max_level,'functionality_id' => $functionality_id,'employee_id'=>$employee_id,'row'=>$row), false, true); 
    }
    public function actionSaveApprovelevel() {
        if ((isset($_POST['HrEmployeeApproveLevel']))){
            $valid=true;
            foreach ($_POST['HrEmployeeApproveLevel'] as $i => $items) {
                if($items['id']>0){
                    $model_level[$i] = HrEmployeeApproveLevel::model()->findByPK($items['id']);  
                    $model_level[$i]->updated_by= Yii::app()->user->id;
                    $model_level[$i]->updated_date_time = date('Y-m-d H:i:s');
                }else{
                    $model_level[$i] = new HrEmployeeApproveLevel();   
                    $model_level[$i]->created_by= Yii::app()->user->id;
                    $model_level[$i]->created_date_time = date('Y-m-d H:i:s');
                }   
                $model_level[$i]->attributes = $_POST['HrEmployeeApproveLevel'][$i];   
                $valid=$model_level[$i]->validate() && $valid;                   
            }
            if($valid){
                if (!empty($model_level)) {
                    foreach ($model_level as $eachModel) {
                        $eachModel->save();

                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($model_level, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionlistdetaillevel() {
        $max_level =Yii::app()->request->getparam('max_level'); 
        $functionality_id =Yii::app()->request->getparam('functionality_id'); 
        $employee_id =Yii::app()->request->getparam('employee_id'); 
        $row =Yii::app()->request->getparam('row'); 
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('level_detail_list', array('max_level' => $max_level,'functionality_id' => $functionality_id,'employee_id'=>$employee_id,'row'=>$row), false, true); 
    }
    //Setting all employees to the same level
    public function actionaddsingleapprovelevel() {
        $model = new Employee();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('same_approve_level', array('model' => $model), false, true);
    }
    public function actionSaveSameApprovelevel() {
        $branch = $_POST['branch_detail'];
        $functionality_id = $_POST['functionality_id'];
        $model_employee = Employee::model()->findAll(array('condition' => 'branch_or_sponsor_id="' . $branch . '"'));
        foreach ($model_employee as $key => $value) {
            $model_approved_level = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$value->id. '" and functionality_id="'.$functionality_id.'"'));
            if(!empty($model_approved_level) && $model_approved_level->id>0){
                $model_level = HrEmployeeApproveLevel::model()->findByPK($model_approved_level->id);  
                $model_level->updated_by= Yii::app()->user->id;
                $model_level->updated_date_time = date('Y-m-d H:i:s');
            }else{
                $model_level = new HrEmployeeApproveLevel();   
                $model_level->created_by= Yii::app()->user->id;
                $model_level->created_date_time = date('Y-m-d H:i:s');
            }
            $model_level->functionality_id = $_POST['functionality_id'];
            $model_level->employee_id = $value->id;
            $model_level->max_level = $_POST['max_level_id'];
            $model_level->level_1_type = $_POST['set_level_1'];
            $level_1=$_POST['set_level_1'];
            if($level_1=='L'){
                $model_level->level_1_authority = $value->reporting_manager;
            }else if($level_1=='S'){
                $model_level->level_1_authority = $value->attendance_manager;
            }else if($level_1=='N' && $_POST['set_level_1_employee']==''){
                $model_level->level_1_authority =  $value->id;
            }else{
                $model_level->level_1_authority = $_POST['set_level_1_employee'];
            }
            $model_level->level_2_type = $_POST['set_level_2'];
            $level_2=$_POST['set_level_2'];
            if($level_2=='L'){
                $model_level->level_2_authority = $value->reporting_manager;
            }else if($level_2=='S'){
                $model_level->level_2_authority = $value->attendance_manager;
            }else if($level_2=='N' && $_POST['set_level_2_employee']==''){
                $model_level->level_2_authority =  $value->id;
            }else{
                $model_level->level_2_authority = $_POST['set_level_2_employee'];
            }
            $model_level->level_3_type = $_POST['set_level_3'];
            $level_3=$_POST['set_level_3'];
            if($level_3=='L'){
                $model_level->level_3_authority = $value->reporting_manager;
            }else if($level_3=='S'){
                $model_level->level_3_authority = $value->attendance_manager;
            }else if($level_3=='N' && $_POST['set_level_3_employee']==''){
                $model_level->level_3_authority =  $value->id;
            }else{
                $model_level->level_3_authority = $_POST['set_level_3_employee'];
            }
            $model_level->level_4_type = $_POST['set_level_4']; 
            $level_4=$_POST['set_level_4'];
            if($level_4=='L'){
                $model_level->level_4_authority = $value->reporting_manager;
            }else if($level_4=='S'){
                $model_level->level_4_authority = $value->attendance_manager;
            }else if($level_4=='N' && $_POST['set_level_4_employee']==''){
                $model_level->level_4_authority =  $value->id;
            }else{
                $model_level->level_4_authority = $_POST['set_level_4_employee'];
            }
            $model_level->level_5_type = $_POST['set_level_5']; 
            $level_5=$_POST['set_level_5'];
            if($level_5=='L'){
                $model_level->level_5_authority = $value->reporting_manager;
            }else if($level_5=='S'){
                $model_level->level_5_authority = $value->attendance_manager;
            }else if($level_5=='N' && $_POST['set_level_5_employee']==''){
                $model_level->level_5_authority =  $value->id;
            }else{
                $model_level->level_5_authority = $_POST['set_level_5_employee'];
            }
            if($model_level->validate()){
                $model_level->save();
            }
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionReport() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('report', array(), false, true);
    }
    public function actionloadleveldetails() {
        $branch =Yii::app()->request->getparam('branch'); 
        $functionality_id =Yii::app()->request->getparam('functionality_id'); 
        $department_id =Yii::app()->request->getparam('department_id'); 
        $condition='branch_or_sponsor_id="' . $branch . '" and isActive!="B"';
        if($department_id>0){
            $condition.=' AND department="' . $department_id . '"';
        }
        $model_employee = Employee::model()->findAll(array('condition' =>$condition));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d"). ' ' . $value['employeecode']]=$value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('view_level_list', array('branch' => $branch,'functionality_id' => $functionality_id,'arr_employee'=>$arr_employee), false, true); 
    }
    public function actiongetfunctionality() {
        $branch = $_POST['branch_id'];
        if($branch==''){
            $branch=0;
        }
        $jsonData['functionality'] = CHtml::dropdownlist("functionality_id", '', HrMasterFunction::getfunctionality($branch), array('data-label' => 'Functionality <span style="color:red">*</span>', 'empty' => 'Select'));
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actioncheckuserexistwithadmin() {
        $user_id = $_POST['user_id'];
        $model_user = User::model()->find(array('condition' =>'hr_connected_employee_id="'.$user_id.'" AND company_id="'.Yii::app()->user->master_user_company_id.'" AND level!=2'));
        if(!empty($model_user)){
            $jsonData['status'] = 'success';
        }else{
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    //added on 24/3/2025 by DR
    public function actionChangeApprover() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('change_approver', array(), false, true);
    }
    public function actionloadlevelwithapprover() {
        $old_approver_id =Yii::app()->request->getparam('old_approver_id'); 
        $new_approver_id =Yii::app()->request->getparam('new_approver_id'); 
        $model_details= array();
        //Level 1 
        $model_level_admin_1 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="1" AND level_1_authority="'.$old_approver_id.'" AND level_1_type="H"'));
        //Level 2 
        $model_level_admin_2 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="2" AND ((level_1_authority="'.$old_approver_id.'"  AND level_1_type="H") OR (level_2_authority="'.$old_approver_id.'" AND level_2_type="H"))'));
        //Level 3 
        $model_level_admin_3 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="3" AND ((level_1_authority="'.$old_approver_id.'"  AND level_1_type="H") OR (level_2_authority="'.$old_approver_id.'" AND level_2_type="H") OR (level_3_authority="'.$old_approver_id.'" AND level_3_type="H"))'));
        //Level 4 
        $model_level_admin_4 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="4" AND ((level_1_authority="'.$old_approver_id.'"  AND level_1_type="H") OR (level_2_authority="'.$old_approver_id.'" AND level_2_type="H") OR (level_3_authority="'.$old_approver_id.'" AND level_3_type="H") OR (level_4_authority="'.$old_approver_id.'" AND level_4_type="H"))'));
        //Level 5 
        $model_level_admin_5 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="5" AND ((level_1_authority="'.$old_approver_id.'"  AND level_1_type="H") OR (level_2_authority="'.$old_approver_id.'" AND level_2_type="H") OR (level_3_authority="'.$old_approver_id.'" AND level_3_type="H") OR (level_4_authority="'.$old_approver_id.'" AND level_4_type="H") OR (level_5_authority="'.$old_approver_id.'" AND level_5_type="H"))'));
        //HR admin
        $model_user = User::model()->find(array('condition' =>'hr_connected_employee_id="'.$new_approver_id.'" AND company_id="'.Yii::app()->user->master_user_company_id.'" AND level!=2'));
        $other= array();
        $jsonData= array();
        if((!empty($model_level_admin_1) || !empty($model_level_admin_2) || !empty($model_level_admin_3) || !empty($model_level_admin_4) || !empty($model_level_admin_5)) && empty($model_user)){
            $message= 'Please create a new user as an approver with admin access';
        }else{
            //New Approver In Other Levels
            //Level 1 
            $model_level_admin_1 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="1" AND (level_1_authority="'.$old_approver_id.'" OR level_2_authority="'.$new_approver_id.'" OR level_3_authority="'.$new_approver_id.'" OR level_4_authority="'.$new_approver_id.'" OR level_5_authority="'.$new_approver_id.'")'));
            //Level 2 
            $model_level_admin_2 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="2" AND (level_2_authority="'.$old_approver_id.'" OR level_1_authority="'.$new_approver_id.'" OR level_3_authority="'.$new_approver_id.'" OR level_4_authority="'.$new_approver_id.'" OR level_5_authority="'.$new_approver_id.'")'));
            //Level 3 
            $model_level_admin_3 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="3" AND (level_3_authority="'.$old_approver_id.'" OR level_1_authority="'.$new_approver_id.'" OR level_2_authority="'.$new_approver_id.'" OR level_4_authority="'.$new_approver_id.'" OR level_5_authority="'.$new_approver_id.'")'));
            //Level 4 
            $model_level_admin_4 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="4" AND (level_4_authority="'.$old_approver_id.'" OR level_1_authority="'.$new_approver_id.'" OR level_2_authority="'.$new_approver_id.'" OR level_3_authority="'.$new_approver_id.'" OR level_5_authority="'.$new_approver_id.'")'));
            //Level 5 
            $model_level_admin_5 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="5" AND (level_5_authority="'.$old_approver_id.'" OR level_1_authority="'.$new_approver_id.'" OR level_2_authority="'.$new_approver_id.'" OR level_3_authority="'.$new_approver_id.'" OR level_4_authority="'.$new_approver_id.'")'));
            if((empty($model_level_admin_1) && empty($model_level_admin_2) && empty($model_level_admin_3) && empty($model_level_admin_4) && empty($model_level_admin_5))){
                //Updating
                //Level 1 
                $model_level_admin_1 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="1" AND level_1_authority="'.$old_approver_id.'"'));
                if(!empty($model_level_admin_1)){    
                    foreach ($model_level_admin_1 as $key => $value) {
                        if($value->level_1_authority==$old_approver_id){
                            $value->level_1_authority = $new_approver_id;
                            if($value->level_1_type=='L' || $value->level_1_type=='S'){
                                $value->level_1_type='N';
                            }
                            $value->save();
                        }
                    }
                }
                //Updating Level 2 Approve
                $model_level_admin_2 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="2" AND level_2_authority="'.$old_approver_id.'"'));
                if(!empty($model_level_admin_2)){    
                    foreach ($model_level_admin_2 as $key => $value) {
                        if($value->level_2_authority==$old_approver_id){
                            $value->level_2_authority = $new_approver_id;
                            if($value->level_2_type=='L' || $value->level_2_type=='S'){
                                $value->level_2_type='N';
                            }
                            $value->save();
                        }
                    }
                }
                //Updating Level 3 Approve
                $model_level_admin_3 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="3" AND level_3_authority="'.$old_approver_id.'"'));
                if(!empty($model_level_admin_3)){    
                    foreach ($model_level_admin_3 as $key => $value) {
                        if($value->level_3_authority==$old_approver_id){
                            $value->level_3_authority = $new_approver_id;
                            if($value->level_3_type=='L' || $value->level_3_type=='S'){
                                $value->level_3_type='N';
                            }
                            $value->save();
                        }
                    }
                }
                //Updating Level 4 Approve
                $model_level_admin_4 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="4" AND level_4_authority="'.$old_approver_id.'"'));
                if(!empty($model_level_admin_4)){    
                    foreach ($model_level_admin_4 as $key => $value) {
                        if($value->level_4_authority==$old_approver_id){
                            $value->level_4_authority = $new_approver_id;
                            if($value->level_4_type=='L' || $value->level_4_type=='S'){
                                $value->level_4_type='N';
                            }
                            $value->save();
                        }
                    }
                }
                //Updating Level 5 Approve
                $model_level_admin_5 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="5" AND level_5_authority="'.$old_approver_id.'"'));
                if(!empty($model_level_admin_5)){
                    foreach ($model_level_admin_5 as $key => $value) {
                        if($value->level_5_authority==$old_approver_id){
                            $value->level_5_authority = $new_approver_id;
                            if($value->level_5_type=='L' || $value->level_5_type=='S'){
                                $value->level_5_type='N';
                            }
                            $value->save();
                        }
                    }
                }
                $message = 'Successfully Updated with new approver';
            }else{
                //Level 1 
                $model_level_admin_1 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="1" AND level_1_authority="'.$old_approver_id.'"'));
                if(!empty($model_level_admin_1)){    
                    foreach ($model_level_admin_1 as $key => $value) {
                        $value->level_1_authority = $new_approver_id;
                        if($value->level_1_type=='L' || $value->level_1_type=='S'){
                            $value->level_1_type='N';
                        }
                        $value->level_2_authority = 0;
                        $value->level_3_authority = 0;
                        $value->level_4_authority = 0;
                        $value->level_5_authority = 0;
                        $value->save();
                    }
                }
                //Level 2
                $model_level_admin_2 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="2" AND (level_1_authority="'.$old_approver_id.'" OR level_2_authority="'.$old_approver_id.'")'));
                if(!empty($model_level_admin_2)){    
                    foreach ($model_level_admin_2 as $key => $value) {
                        if($value->level_1_authority==$old_approver_id){
                            $value->level_1_authority = $new_approver_id;
                            if($value->level_1_type=='L' || $value->level_1_type=='S'){
                                $value->level_1_type='N';
                            }
                            $value->level_3_authority = 0;
                            $value->level_4_authority = 0;
                            $value->level_5_authority = 0;
                        }else if($value->level_2_authority==$old_approver_id){
                            $value->level_2_authority = $new_approver_id;
                            if($value->level_2_type=='L' || $value->level_2_type=='S'){
                                $value->level_2_type='N';
                            }
                            $value->level_3_authority = 0;                          
                            $value->level_4_authority = 0;
                            $value->level_5_authority = 0;
                        }
                        $value->save();
                    }
                }
                //Level 3
                $model_level_admin_3 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="3" AND (level_1_authority="'.$old_approver_id.'" OR level_2_authority="'.$old_approver_id.'" OR level_3_authority="'.$old_approver_id.'")'));
                if(!empty($model_level_admin_3)){    
                    foreach ($model_level_admin_3 as $key => $value) {
                        if($value->level_1_authority==$old_approver_id){
                            $value->level_1_authority = $new_approver_id;
                            if($value->level_1_type=='L' || $value->level_1_type=='S'){
                                $value->level_1_type='N';
                            }
                            $value->level_4_authority = 0;
                            $value->level_5_authority = 0;
                        }else if($value->level_2_authority==$old_approver_id){
                            $value->level_2_authority = $new_approver_id;
                            if($value->level_2_type=='L' || $value->level_2_type=='S'){
                                $value->level_2_type='N';
                            }
                            $value->level_4_authority = 0;
                            $value->level_5_authority = 0;
                        }else if($value->level_3_authority==$old_approver_id){
                            $value->level_3_authority = $new_approver_id;
                            if($value->level_3_type=='L' || $value->level_3_type=='S'){
                                $value->level_3_type='N';
                            }
                            $value->level_4_authority = 0;
                            $value->level_5_authority = 0;
                        }
                        $value->save();
                    }
                }
                //Level 4
                $model_level_admin_4 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="4" AND (level_1_authority="'.$old_approver_id.'" OR level_2_authority="'.$old_approver_id.'"  OR level_3_authority="'.$old_approver_id.'" OR level_4_authority="'.$old_approver_id.'")'));
                if(!empty($model_level_admin_4)){    
                    foreach ($model_level_admin_4 as $key => $value) {
                        if($value->level_1_authority==$old_approver_id){
                            $value->level_1_authority = $new_approver_id;
                            if($value->level_1_type=='L' || $value->level_1_type=='S'){
                                $value->level_1_type='N';
                            }
                            $value->level_5_authority = 0;
                        }else if($value->level_2_authority==$old_approver_id){
                            $value->level_2_authority = $new_approver_id;
                            if($value->level_2_type=='L' || $value->level_2_type=='S'){
                                $value->level_2_type='N';
                            }
                            $value->level_5_authority = 0;
                        }else if($value->level_3_authority==$old_approver_id){
                            $value->level_3_authority = $new_approver_id;
                            if($value->level_3_type=='L' || $value->level_3_type=='S'){
                                $value->level_3_type='N';
                            }
                            $value->level_5_authority = 0;
                        }else if($value->level_4_authority==$old_approver_id){
                            $value->level_4_authority = $new_approver_id;
                            if($value->level_4_type=='L' || $value->level_4_type=='S'){
                                $value->level_4_type='N';
                            }
                            $value->level_5_authority = 0;
                        }
                        $value->save();
                    }
                }
                //Level 5
                $model_level_admin_5 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="5" AND (level_1_authority="'.$old_approver_id.'" OR level_2_authority="'.$old_approver_id.'"  OR level_3_authority="'.$old_approver_id.'"  OR level_4_authority="'.$old_approver_id.'"OR level_5_authority="'.$old_approver_id.'")'));
                if(!empty($model_level_admin_5)){
                    foreach ($model_level_admin_5 as $key => $value) {
                        if($value->level_1_authority==$old_approver_id){
                            $value->level_1_authority = $new_approver_id;
                            if($value->level_1_type=='L' || $value->level_1_type=='S'){
                                $value->level_1_type='N';
                            }
                        }else if($value->level_2_authority==$old_approver_id){
                            $value->level_2_authority = $new_approver_id;
                            if($value->level_2_type=='L' || $value->level_2_type=='S'){
                                $value->level_2_type='N';
                            }
                        }else if($value->level_3_authority==$old_approver_id){
                            $value->level_3_authority = $new_approver_id;
                            if($value->level_3_type=='L' || $value->level_3_type=='S'){
                                $value->level_3_type='N';
                            }
                        }else if($value->level_4_authority==$old_approver_id){
                            $value->level_4_authority = $new_approver_id;
                            if($value->level_4_type=='L' || $value->level_4_type=='S'){
                                $value->level_4_type='N';
                            }
                        }else if($value->level_5_authority==$old_approver_id){
                            $value->level_5_authority = $new_approver_id;
                            if($value->level_5_type=='L' || $value->level_5_type=='S'){
                                $value->level_5_type='N';
                            }
                        }
                        $value->save();
                    }
                }
                //Duplicate Level List
                //Level 1 
                $model_level_admin_1 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="1" AND (level_1_authority="'.$old_approver_id.'" AND (level_2_authority="'.$new_approver_id.'" OR level_3_authority="'.$new_approver_id.'" OR level_4_authority="'.$new_approver_id.'" OR level_5_authority="'.$new_approver_id.'"))'));
                if(!empty($model_level_admin_1)){
                    $model_details = array_merge($model_details, $model_level_admin_1);
                }
                //Level 2 
                $model_level_admin_2 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="2" AND (level_2_authority="'.$old_approver_id.'" AND (level_1_authority="'.$new_approver_id.'" OR level_3_authority="'.$new_approver_id.'" OR level_4_authority="'.$new_approver_id.'" OR level_5_authority="'.$new_approver_id.'"))'));
                if(!empty($model_level_admin_2)){
                    $model_details = array_merge($model_details, $model_level_admin_2);
                }
                //Level 3 
                $model_level_admin_3 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="3" AND (level_3_authority="'.$old_approver_id.'" AND (level_1_authority="'.$new_approver_id.'" OR level_2_authority="'.$new_approver_id.'" OR level_4_authority="'.$new_approver_id.'" OR level_5_authority="'.$new_approver_id.'"))'));
                if(!empty($model_level_admin_3)){
                    $model_details = array_merge($model_details, $model_level_admin_3);
                }
                //Level 4 
                $model_level_admin_4 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="4" AND (level_4_authority="'.$old_approver_id.'" AND (level_1_authority="'.$new_approver_id.'" OR level_2_authority="'.$new_approver_id.'" OR level_3_authority="'.$new_approver_id.'" OR level_5_authority="'.$new_approver_id.'"))'));
                if(!empty($model_level_admin_4)){
                    $model_details = array_merge($model_details, $model_level_admin_4);
                }
                //Level 5 
                $model_level_admin_5 = HrEmployeeApproveLevel::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$old_approver_id. '" and max_level="5" AND (level_5_authority="'.$old_approver_id.'" AND (level_1_authority="'.$new_approver_id.'" OR level_2_authority="'.$new_approver_id.'" OR level_3_authority="'.$new_approver_id.'" OR level_4_authority="'.$new_approver_id.'"))'));  
                if(!empty($model_level_admin_5)){
                    $model_details = array_merge($model_details, $model_level_admin_5);
                }
                usort($model_details, function($a, $b) {
                    return $b->functionality_id - $a->functionality_id;
                });
                if(empty($model_details)){
                    $message='Updated Successfully';
                }
            }
        }
        $this->renderPartial('change_employee_list', array('model_details' => $model_details,'message' => $message), false, true); 
    }
}
