<?php
class ApprovalschemeController extends Controller {
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'GetList', 'DirectAdd', 'Create', 'SaveScheme', 'DirectAdd','Disable','UploadDepartment','UploadEmployeecsv','DownloadSampleCsv','DownloadErrorCsv','readDepartmentCSV','SaveDepartmentUploadCsv','listdetaillevel','checkuserexistwithadmin','leveldetailsdata'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_scheme_level_menu']) || Yii::app()->user->authorised_user == 1) {
            $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
   public function actionGetList() {
        $model = new HrMasApprovalScheme();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 't.id',
            2 => 'scheme_name'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (scheme_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $button_string = "";
            $edit_button=$disable_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_scheme_level_edit'])  || Yii::app()->user->authorised_user == 1) {
                $button_string = '<div style="width:100%; text-align:center;"><button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'department/create&id=' . $row['id'] . '\',\'Edit Department \',\'xl\')"><i class="fa fa-edit"></i></button></div>';
                $edit_button =1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_scheme_level_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable_button =1;  
            }
            $rowData[] = array(++$m, $row['scheme_name'], $row['id'], array('id' => $row->id, 'status' => $row->isActive,'edit_button'=>$edit_button,'disable_button'=>$disable_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new HrMasApprovalScheme();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }


        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionSaveScheme() {
        $model = new HrMasApprovalScheme();
        if (isset($_POST['HrMasApprovalScheme'])) {
            if ((int) @$_POST['HrMasApprovalScheme']['id'] > 0) {
                $id = (int) @$_POST['HrMasApprovalScheme']['id'];
                $model = $model->findByPk($id);
                $model->scenario = 'update';
            } else {
                $model->scenario = 'add';
            }
            $model->scheme_name = $_POST['HrMasApprovalScheme']['scheme_name'];
            $model->isActive = 'Y';
            $valid = $model->validate();
            //Level
            if ((isset($_POST['HrSchemeApproveLevel'])) && ($_POST['HrSchemeApproveLevel'][0]['functionality_id'] != '')) {
                $i = 0;
                foreach ($_POST['HrSchemeApproveLevel'] as $j => $items) {
                    if ($items['functionality_id'] >0) {
                        if ($items['id'] > 0) {
                            $model_level[$i] = HrSchemeApproveLevel::model()->findByPK($items['id']);
                            $model_level[$i]->updated_by = Yii::app()->user->id;
                            $model_level[$i]->updated_date_time = date('Y-m-d H:i:s');
                        } else {
                            $model_level[$i] = new HrSchemeApproveLevel();
                            $model_level[$i]->created_by = Yii::app()->user->id;
                            $model_level[$i]->created_date_time = date('Y-m-d H:i:s');
                        }
                        $model_level[$i]->attributes = $_POST['HrSchemeApproveLevel'][$j];
                        $valid = $model_level[$i]->validate() && $valid;
                        $i++;
                    }
                }
            }
            //End Level
            if ($valid) {
                $model->save();
                if (!empty($model_level)) {
                    foreach ($model_level as $eachModel) {
                        $eachModel->scheme_id = $model->id;
                        $eachModel->save();
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = $error2 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($model_level) && $model_level[0]->functionality_id > 0) {
                    $error2 = json_decode(CActiveForm::validateTabular($model_level, '', false), true);
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new HrMasApprovalScheme();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

    public function actionlistdetaillevel() {
        $max_level =Yii::app()->request->getparam('max_level'); 
        $functionality_id =Yii::app()->request->getparam('functionality_id'); 
        $scheme_id =Yii::app()->request->getparam('scheme_id'); 
        $row =Yii::app()->request->getparam('row'); 
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('level_detail_list', array('max_level' => $max_level,'functionality_id' => $functionality_id,'scheme_id'=>$scheme_id,'row'=>$row), false, true); 
    }
     public function actioncheckuserexistwithadmin() {
        $user_id = $_POST['user_id'];
        $model_user = User::model()->find(array('condition' =>'hr_connected_employee_id="'.$user_id.'" AND company_id="'.Yii::app()->user->master_user_company_id.'" AND level!=2'));
        if(!empty($model_user)){
            $jsonData['status'] = 'success';
        }else{
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionleveldetailsdata() {
        $employee_id =Yii::app()->request->getparam('employee_id'); 
        $scheme_id =Yii::app()->request->getparam('scheme_id'); 
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('level_detail_list', array('employee_id' => $employee_id,'scheme_id'=>$scheme_id), false, true); 
    }
}
