<?php
class AppraisalController extends Controller {
    public $layout = 'layout';
    public function accessRules() {
        return array(array('allow', // allow all users to perform 'index' and 'view' actions
        'actions' => array('login', 'error', 'logout'), 'users' => array('*'),), array('allow', // allow authenticated user to perform 'create' and 'update' actions
        'actions' => array('Index', 'GetAppraisalList', 'Create', 'GetquestionDetails', 'SaveAppraisal', 'deleteappraisaldetail', 'employeeindex', 'GetAppraisalEmployeeList', 'SelfReview', 'Saveselfreview', 'lmindex', 'GetAppraisalReview', 'ReviewbyLm', 'Savelmreview', 'HrReview', 'Savehrreview', 'View', 'PrintappraisalReportPDF', 'SaveAppraisalMultiple', 'loadmasterbranch', 'GetreviewedList', 'reviewindex', 'reviewlmindex', 'GetreviewedlmList','PrintEmployeeAppraisal','PrintEmployeeAppraisalGradeReview'), 'expression' => '$user->isMember()',), array('deny', // deny all users
        'users' => array('*'),),);
    }
    public function filters() {
        return array('accessControl', // perform access control for CRUD operations
        );
    }
    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_appraisal_menu']) || Yii::app()->user->authorised_user == 1) {
            $en_id = Yii::app()->request->getParam('id');
            $branch = $this->ciphertext($en_id, "d");
            if ($branch != '') {
                $model = new HrAppraisal();
                Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
                $this->render('index', array('model' => $model, 'branch' => $branch));
            } else {
                throw new CHttpException(404, 'Page not found.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetAppraisalList() {
        $model = new HrAppraisal();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $employee_id = $_POST['employee_id'];
        $branch_id = $_POST['branch_id'];
        $columns = array(
        // datatable column index  => database column name
        0 => 't.id', 1 => 'employeedetail.employee_code', 2 => 'employeedetail.first_name', 3 => 'departmentdetail.department_name', 4 => 'designationdetail.designation_name', 5 => 'employeedetail.date_join', 6 => 'appraisal_for', 7 => 't.created_date_time', 8 => 'status', 9 => '',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $arr_status=$_POST['status'];
        $status='H';
        $pending_status_flag=0;
        if(is_countable($arr_status) && count($arr_status)>1){
            if (in_array('H', $arr_status)) {
                $pending_status_flag= 1;
            }
            $arr_status = array_diff($arr_status, ['H']);
            if (in_array('1', $arr_status)) {
                $arr_status[] = 0;
            }
            $status=implode(',',$arr_status);
        }else{
            $status=$arr_status[0];
        }
        $pending_appraisal = HrAppraisal::getPendingapproval($branch_id, 1);
        $condition = "employeedetail.branch_or_sponsor_id='" . $branch_id . "'";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition.= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        if($status=='H'){
            $condition.= " AND t.id IN(".$pending_appraisal.")";
        }else if($status!=''){
            if($pending_status_flag==0){
                $condition.= " AND status IN(".$status.")";
            }else if($pending_status_flag==1){
                $condition.= " AND (status IN(".$status.") OR t.id IN(".$pending_appraisal."))";
            }
        } 
        /*if ($status != '' && $status != 'H') {
            $condition.= " And status= '" . $status . "'";
        } else if ($status == 'H') {
            $condition.= " And t.id IN(" . $pending_appraisal . ")";
        } else {
            $condition.= " And status NOT IN(-3,-2,-1)";
        }*/
        if ($employee_id > 0) {
            $condition.= ' and t.employee_id ="' . $employee_id . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition.= " and (employee_code LIKE '%" . $searchString_en . "%' OR first_name LIKE '%" . $searchString_en . "%' OR middle_name LIKE '%" . $searchString_en . "%' OR last_name LIKE '%" . $searchString_en . "%' OR appraisal_for LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail', 'employeedetail.departmentdetail', 'employeedetail.designationdetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'employeedetail.departmentdetail', 'employeedetail.designationdetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $last_approved_level = $row->last_approved_level;
            $next_approval_level = $last_approved_level + 1;
            $show_approve_button = 0;
            $level_no = 0;
            $final_level = 'N';
            $en_slip_id = $this->ciphertext($row['id'], "e");
            if ($next_approval_level <= $row->max_level) {
                if ($next_approval_level == 1 && $row->approvelevel->level_1_type == 'H') {
                    $show_approve_button = 1;
                    $level_no = 1;
                } else if ($next_approval_level == 2 && $row->approvelevel->level_2_type == 'H') {
                    $show_approve_button = 1;
                    $level_no = 2;
                } else if ($next_approval_level == 3 && $row->approvelevel->level_3_type == 'H') {
                    $show_approve_button = 1;
                    $level_no = 3;
                } else if ($next_approval_level == 4 && $row->approvelevel->level_4_type == 'H') {
                    $show_approve_button = 1;
                    $level_no = 4;
                } else if ($next_approval_level == 5 && $row->approvelevel->level_5_type == 'H') {
                    $show_approve_button = 1;
                    $level_no = 5;
                }
            }
            if ($next_approval_level == $row->max_level) {
                $final_level = 'Y';
            }
             $review_appraisal =$delete_appraisal=$view_appraisal=$print_appraisal=$print_appraisal_report=0;
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_employee_appraisal_approve']) || Yii::app()->user->authorised_user == 1)) {
                if ($show_approve_button == 1) {
                    $button_string.= '<button class="btn btn-primary btn-xs" title="Review Appraisal" onclick="loadPopupModal(\'hr/appraisal/reviewbylm&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '\',\'Review Appraisal\',\'xl\')"><i class="fa fa-tasks"></i></button>&nbsp;';
                    $review_appraisal =1;
                }
            }
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_employee_appraisal_edit']) || Yii::app()->user->authorised_user == 1) && $row['status'] == 1) {
                //  $button_string .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/appraisal/create&id=' . $row['id'] . '\',\'Edit Appraisal Detail \',\'xl\')"><i class="fa fa-edit"></i></button>&nbsp;';
               
            }
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_employee_appraisal_delete']) || Yii::app()->user->authorised_user == 1) && $row['status'] == 1) {
                $button_string.= '<a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deleteappraisaldetail(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>&nbsp;';
                $delete_appraisal =1;
                
            }
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_employee_appraisal_view']) || Yii::app()->user->authorised_user == 1) && $row['status'] == 12) {
                $button_string.= '<button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'hr/appraisal/view&id=' . $row['id'] . '\',\'View Appraisal Detail \',\'xl\')"><i class="fa fa-eye"></i></button>&nbsp;';
                $view_appraisal =1;
                
            }
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_employee_appraisal_print']) || Yii::app()->user->authorised_user == 1) && $row['status'] == 12) {
                $button_string.= '<a class="btn btn-primary btn-xs" title="Print Appraisal Details" target="_blank" href="?r=hr/appraisal/PrintappraisalReportPDF&id=' . $en_slip_id . '"><i class="fa fa-file-pdf-o"></i></a>&nbsp;';
                $button_string .= '<a class="btn btn-success btn-xs" title="Appraisal Report" target="_blank" href="?r=hr/appraisal/PrintEmployeeAppraisalGradeReview&id=' . $en_slip_id . '"><i class="fa fa-file-pdf-o"></i></a>&nbsp;';
                $print_appraisal=1;
                $print_appraisal_report=1;
                
            }
            $joining_date = "";
            if ($row['employeedetail']['date_join'] != '' && $row['employeedetail']['date_join'] != '0000-00-00') {
                $joining_date = date("d/m/Y", strtotime($row['employeedetail']['date_join']));
            }
            $created_date = "";
            if ($row['created_date_time'] != '' && $row['created_date_time'] != '0000-00-00') {
                $created_date = date("d/m/Y", strtotime($row['created_date_time']));
            }
            $rowData[] = array($m, $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $row['employeedetail']['departmentdetail']['department_name'], $row['employeedetail']['designationdetail']['designation_name'], $joining_date, $row['appraisal_for'], $created_date, HrAppraisal::getstatus($row['status']), array('id'=>$row['id'],'final_level'=>$final_level,'level_no'=>$level_no,'en_slip_id'=>$en_slip_id,'review_appraisal'=>$review_appraisal,'delete_appraisal'=>$delete_appraisal,'view_appraisal'=>$view_appraisal,'print_appraisal'=>$print_appraisal,'print_appraisal_report'=>$print_appraisal_report));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        $id = (int)Yii::app()->request->getParam('id');
        $branch = (int)Yii::app()->request->getParam('branch');
        $model = new HrAppraisal();
        $model_analysis = array(new HrAppraisalAnalysis());
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_analysis = HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="' . $id . '"'));
            $model_type = HrAppraisalType::model()->findAll(array('condition' => 'appraisal_id="' . $id . '"'));
            if (empty($model_analysis)) {
                $model_analysis = array(new HrAppraisalAnalysis());
            }
            if (empty($model_type)) {
                $model_type = array(new HrAppraisalType());
            }
        }
        $model_settings = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model, 'model_analysis' => $model_analysis, 'model_Type' => $model_type, 'model_settings' => $model_settings, 'branch' => $branch), false, true);
    }
    public function actionGetquestionDetails() {
        $id = (int)Yii::app()->request->getParam('id');
        $model_questions = HrAppraisalQuestions::model()->with('typedetail')->findAll(array('condition' => 'department_id="' . $id . '" AND typedetail.default_weightage>0'));
        $arr_type = HrAppraisalQuestions::model()->with('typedetail')->findAll(array('select' => 't.appraisal_type', 'condition' => 'department_id="' . $id . '" AND typedetail.default_weightage>0', 'group' => 't.appraisal_type'));
        $model_analysis = new HrAppraisalAnalysis();
        $model_settings = HrGenerelSettings::model()->find();
        $model_Type = new HrAppraisalType();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('appraisal_questions', array('model_questions' => $model_questions, 'model_type' => $arr_type, 'model_analysis' => $model_analysis, 'model_Type' => $model_Type, 'model_settings' => $model_settings), false, true);
    }
    public function actionSaveAppraisalMultiple() {
        $other = array();
        $groups = array();
        $analysis_ids = array();
        $type_ids = array();
        $employees = array();
        $model = new HrAppraisal();
        if (isset($_POST['HrAppraisal'])) {
//            $model_HrAppraisalType = new HrAppraisalType();
            $employees = $_POST['HrAppraisal']['employee_id'];
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d H:i:s');
            $model->attributes = $_POST['HrAppraisal'];
            $model->employee_id = $employees[0];
            $model->appraisal_description = $_POST['HrAppraisal']['appraisal_description'];
            $model->status = 1;
            $employee_id = $employees[0];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="6"'));
            $model->function_type = $model_master_approve_setting->id;
            $model->max_level = $model_master_approve_setting->max_level;
            $valid = $model->validate();
            //Adding Analysis Data
            if (isset($_POST['HrAppraisalAnalysis'])) {
                $i = 0;
                foreach ($_POST['HrAppraisalAnalysis'] as $m => $items) {
                    if ($items['question_id'] != '') {
                        $model_analysis[$i] = new HrAppraisalAnalysis();
                        $model_analysis[$i]->created_by = Yii::app()->user->id;
                        $model_analysis[$i]->created_date_time = date('Y-m-d H:i:s');
                        $model_analysis[$i]->appraisal_type = $items['appraisal_type'];
                        $model_analysis[$i]->appraisal_goal = $items['appraisal_goal'];
                        $model_analysis[$i]->question_weightage = $items['question_weightage'];
                        $model_analysis[$i]->question_id = $items['question_id'];
                        $model_analysis[$i]->question = $items['question'];
                        if ($items['target_achieved_date'] != '0000-00-00' && $items['target_achieved_date']  != '') {
                            $model_analysis[$i]->target_achieved_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['target_achieved_date'])));
                        }
                        $key = $items['appraisal_type'];
                        if (!array_key_exists($key, $groups)) {
                            $groups[$key] = array('id' => $items['appraisal_type'], 'total_weightage' => $items['question_weightage'],);
                        } else {
                            $groups[$key]['total_weightage'] = $groups[$key]['total_weightage'] + $items['question_weightage'];
                        }
                        $valid = $model_analysis[$i]->validate() && $valid;
                        $i++;
                    }
                }
            }
            //weightage percent on 100
            if (!empty($groups)) {
                foreach ($groups as $key => $eachType) {
                    $mas_type = HrMasAppraisalType::model()->findByPk($key);
                    if ($eachType['total_weightage'] != 100) {
                        $other[] = $mas_type->appraisal_type . ' should have maximum weightage 100. Now its ' . (floatval($eachType['total_weightage']));
                        $valid = false;
                    }
                }
            }
            if (isset($_POST['HrAppraisalType'])) {
                $j = 0;
                $total_weightage = 0;
                foreach ($_POST['HrAppraisalType'] as $n => $itemtype) {
                    $model_HrAppraisalType[$j] = new HrAppraisalType();
                    $model_HrAppraisalType[$j]->created_by = Yii::app()->user->id;
                    $model_HrAppraisalType[$j]->created_date_time = date('Y-m-d H:i:s');
                    $model_HrAppraisalType[$j]->type_id = $itemtype['type_id'];
                    $model_HrAppraisalType[$j]->weightage = $itemtype['weightage'];
                    $total_weightage+= (float)$itemtype['weightage'];
                    $model_HrAppraisalType[$j]->appraisal_id = 0;
                    $valid = $model_HrAppraisalType[$j]->validate() && $valid;
                    $j++;
                }
            }
            if ($total_weightage != 100) {
                $other[] = 'Sum of Weightage of Goal should be 100. Now its ' . (floatval($total_weightage));
                $valid = false;
            }
            if ($model_analysis[0]->question_id == '') {
                $valid = false;
            }
            //End Analysis Data
            if ($valid) {
                for ($i = 0;$i < count($employees);$i++) {
                    $modelAppraisal = new HrAppraisal();
                    $modelAppraisal->created_by = Yii::app()->user->id;
                    $modelAppraisal->created_date_time = date('Y-m-d H:i:s');
                    $modelAppraisal->appraisal_for = $_POST['HrAppraisal']['appraisal_for'];
                    $modelAppraisal->employee_id = $employees[$i];
                    $employee_id = $employees[$i];
                    $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="6"'));
                    $modelAppraisal->function_type = $model_master_approve_setting->id;
                    $modelAppraisal->max_level = $model_master_approve_setting->max_level;
                    $modelAppraisal->appraisal_description = $_POST['HrAppraisal']['appraisal_description'];
                    $modelAppraisal->status = 1;
                    $modelAppraisal->last_approved_level = 0;
                    $modelAppraisal->save();
                    $app_id = $modelAppraisal->id;
                    $jsonData['app_id_' . $i] = $app_id;
                    //Save Analysis
                    if (!empty($model_analysis)) {
                        foreach ($model_analysis as $eachanalysisModel) {
                            $each_analysis = new HrAppraisalAnalysis();
                            $each_analysis->attributes = $eachanalysisModel->attributes;
                            $each_analysis->target_achieved_date = $eachanalysisModel->target_achieved_date;
                            $each_analysis->appraisal_id = $app_id;
                            $each_analysis->save();
                        }
                    }
                    if (!empty($model_HrAppraisalType)) {
                        foreach ($model_HrAppraisalType as $eachModel) {
                            $eachtype = new HrAppraisalType();
                            $eachtype->attributes = $eachModel->attributes;
                            $eachtype->appraisal_id = $app_id;
                            $eachtype->save();
                        }
                    }
                    //Mail
                    $model_settings = HrGenerelSettings::model()->find();
                    $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="23"'));
                    if(!empty($model_settings) && !empty($model_mail_settings)){
                        if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                            Yii::import('application.modules.hr.controllers.MailController');
                            MailController::sendmail(23, $modelAppraisal->employee_id, $modelAppraisal->id);
                        }
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($model_analysis[0]->question_id != '') {
                    $error2 = json_decode(CActiveForm::validateTabular($model_analysis, '', false), true);
                } else {
                    $error2[] = 'Please add atleast one KPI';
                }
                $error3 = json_decode(CActiveForm::validateTabular($model_HrAppraisalType, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $other));
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actionSaveAppraisal() {
        $other = array();
        $groups = array();
        $analysis_ids = array();
        $type_ids = array();
        $model = new HrAppraisal();
        if (isset($_POST['HrAppraisal'])) {
            if ($_POST['HrAppraisal']['id'] > 0) {
                $id = (int)$_POST['HrAppraisal']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['HrAppraisal'];
            $model->appraisal_description = $_POST['HrAppraisal']['appraisal_description'];
            $model->status = 1;
            $employee_id = $_POST['HrAppraisal']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="6"'));
            $model->function_type = $model_master_approve_setting->id;
            $model->max_level = $model_master_approve_setting->max_level;
            $valid = $model->validate();
            //Adding Analysis Data
            if (isset($_POST['HrAppraisalAnalysis'])) {
                $i = 0;
                foreach ($_POST['HrAppraisalAnalysis'] as $m => $items) {
                    if ($items['question_id'] != '') {
                        if ($items['id'] > 0) {
                            $model_analysis[$i] = HrAppraisalAnalysis::model()->findByPK($items['id']);
                            $model_analysis[$i]->updated_by = Yii::app()->user->id;
                            $model_analysis[$i]->updated_date_time = date('Y-m-d H:i:s');
                            $analysis_ids[] = $items['id'];
                        } else {
                            $model_analysis[$i] = new HrAppraisalAnalysis();
                            $model_analysis[$i]->created_by = Yii::app()->user->id;
                            $model_analysis[$i]->created_date_time = date('Y-m-d H:i:s');
                        }
                        $model_analysis[$i]->appraisal_type = $items['appraisal_type'];
                        $model_analysis[$i]->question_weightage = $items['question_weightage'];
                        $model_analysis[$i]->question_id = $items['question_id'];
                        $model_analysis[$i]->question = $items['question'];
                        if ($items['target_achieved_date'] != '0000-00-00' && $items['target_achieved_date']  != '') {
                            $model_analysis[$i]->target_achieved_date = str_replace('/', '-', $items['target_achieved_date']);
                            $model_analysis[$i]->target_achieved_date = date("Y-m-d", strtotime($model_analysis[$i]->target_achieved_date));
                        }
                        $key = $items['appraisal_type'];
                        if (!array_key_exists($key, $groups)) {
                            $groups[$key] = array('id' => $items['appraisal_type'], 'total_weightage' => $items['question_weightage'],);
                        } else {
                            $groups[$key]['total_weightage'] = $groups[$key]['total_weightage'] + $items['question_weightage'];
                        }
                        $valid = $model_analysis[$i]->validate() && $valid;
                        $i++;
                    }
                }
            }
            //weightage percent on 100
            if (!empty($groups)) {
                foreach ($groups as $key => $eachType) {
                    $mas_type = HrMasAppraisalType::model()->findByPk($key);
                    if ($eachType['total_weightage'] != 100) {
                        $other[] = $mas_type->appraisal_type . ' should have maximum weightage 100. Now its ' . (floatval($eachType['total_weightage']));
                        $valid = false;
                    }
                }
            }
            if (isset($_POST['HrAppraisalType'])) {
                $i = 0;
                $total_weightage = 0;
                foreach ($_POST['HrAppraisalType'] as $m => $itemtype) {
                    if ($itemtype['id'] > 0) {
                        $model_HrAppraisalType[$i] = HrAppraisalType::model()->findByPK($itemtype['id']);
                        $model_HrAppraisalType[$i]->updated_by = Yii::app()->user->id;
                        $model_HrAppraisalType[$i]->updated_date_time = date('Y-m-d H:i:s');
                        $type_ids[] = $itemtype['id'];
                    } else {
                        $model_HrAppraisalType[$i] = new HrAppraisalType();
                        $model_HrAppraisalType[$i]->created_by = Yii::app()->user->id;
                        $model_HrAppraisalType[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $model_HrAppraisalType[$i]->type_id = $itemtype['type_id'];
                    $model_HrAppraisalType[$i]->weightage = $itemtype['weightage'];
                    $total_weightage+= $itemtype['weightage'];
                    $model_HrAppraisalType[$i]->appraisal_id = 0;
                    $valid = $model_HrAppraisalType[$i]->validate() && $valid;
                    $i++;
                }
            }
            if ($total_weightage != 100) {
                $other[] = 'Sum of Weightage of Goal should be 100. Now its ' . (floatval($total_weightage));
                $valid = false;
            }
            //End Analysis Data
            if ($valid) {
                if (!empty($analysis_ids)) {
                    HrAppraisalAnalysis::model()->deleteAll('appraisal_id=' . $model->id . ' AND id NOT IN (' . implode(',', $analysis_ids) . ')');
                }
                if (!empty($type_ids)) {
                    HrAppraisalType::model()->deleteAll('appraisal_id=' . $model->id . ' AND id NOT IN (' . implode(',', $type_ids) . ')');
                }
                $model->save();
                //Save Analysis
                if (!empty($model_analysis)) {
                    foreach ($model_analysis as $eachModel) {
                        $eachModel->appraisal_id = $model->id;
                        $eachModel->save();
                    }
                }
                if (!empty($model_HrAppraisalType)) {
                    foreach ($model_HrAppraisalType as $eachModel) {
                        $eachModel->appraisal_id = $model->id;
                        $eachModel->save();
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($model_analysis[0]->question_id != '') {
                    $error2 = json_decode(CActiveForm::validateTabular($model_analysis, '', false), true);
                } else {
                    $error2[] = 'Please add atleast one KPI';
                }
                $error3 = json_decode(CActiveForm::validateTabular($model_HrAppraisalType, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $other));
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actiondeleteappraisaldetail() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = HrAppraisal::model()->findByPk($id);
            if ($model->id) {
                if ($model->approve_question_level1_id > 0) {
                    $model->status = - 1;
                    $model->save();
                    $jsonData['status'] = 'success';
                } else {
                    HrAppraisalType::model()->deleteAll('appraisal_id=:refer_id', array(':refer_id' => $model->id));
                    HrAppraisalAnalysis::model()->deleteAll('appraisal_id=:refer_id', array(':refer_id' => $model->id));
                    $model_analysis_exist = HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="' . $model->id . '"'));
                    $model_type_exist = HrAppraisalType::model()->findAll(array('condition' => 'appraisal_id="' . $model->id . '"'));
                    if (empty($model_analysis_exist) && empty($model_type_exist)) {
                        HrAppraisal::model()->deleteByPk($id);
                        $jsonData['status'] = 'success';
                    } else {
                        $jsonData['status'] = 'error';
                    }
                }
            } else {
                $jsonData['status'] = 'error';
            }
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionemployeeindex() {
        $this->layout = 'main';
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('employee_index');
    }
    public function actionlmindex() {
        $this->layout = 'main';
        $model_module_appraisal = HrModules::model()->findByPK(12);
        if ($model_module_appraisal->grant_access == 1 && $model_module_appraisal->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('lm_index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetAppraisalReview() {
        $model = new HrAppraisal();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
        0 => 't.id', 1 => 'employeedetail.employee_code', 2 => 'employeedetail.first_name', 3 => 'departmentdetail.department_name', 4 => 'designationdetail.designation_name', 5 => 'employeedetail.date_join', 6 => 'appraisal_for', 7 => 't.created_date_time', 8 => 'status', 9 => '',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $modelemployee = User::model()->findByPK(Yii::app()->user->id);
        $employee_id = $modelemployee->employee_id;
        $pending_appraisal = HrAppraisal::getintermediateapproval($employee_id, 1);
        $condition = 'employeedetail.isActive="Y" AND last_approved_level<t.max_level AND t.id IN(' . $pending_appraisal . ')';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition.= " and (employee_code LIKE '%" . $searchString_en . "%' OR first_name LIKE '%" . $searchString_en . "%' OR middle_name LIKE '%" . $searchString_en . "%' OR last_name LIKE '%" . $searchString_en . "%' OR appraisal_for LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail', 'employeedetail.departmentdetail', 'employeedetail.designationdetail', 'approvelevel')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'employeedetail.departmentdetail', 'employeedetail.designationdetail', 'approvelevel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $button_string = "";
            $last_approved_level = $row->last_approved_level;
            $next_approval_level = $last_approved_level + 1;
            $show_approve_button = 0;
            $level_no = 0;
            $final_level = 'N';
            if ($next_approval_level <= $row->max_level) {
                if ($next_approval_level == 1 && (($row->approvelevel->level_1_type == 'L' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'S' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'N' && $row->approvelevel->level_1_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 1;
                } else if ($next_approval_level == 2 && (($row->approvelevel->level_2_type == 'L' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'S' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'N' && $row->approvelevel->level_2_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 2;
                } else if ($next_approval_level == 3 && (($row->approvelevel->level_3_type == 'L' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'S' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'N' && $row->approvelevel->level_3_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 3;
                } else if ($next_approval_level == 4 && (($row->approvelevel->level_4_type == 'L' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'S' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'N' && $row->approvelevel->level_4_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 4;
                } else if ($next_approval_level == 5 && (($row->approvelevel->level_5_type == 'L' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'S' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'N' && $row->approvelevel->level_5_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 5;
                }
            }
            if ($next_approval_level == $row->max_level) {
                $final_level = 'Y';
            }
            $approve_reject =0;
            if ($show_approve_button == 1) { //For Approval
                $approve_reject =1;
                $button_string.= '<button class="btn btn-primary btn-xs" title="Appraisal Review" onclick="loadPopupModal(\'hr/appraisal/reviewbylm&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '\',\'Appraisal Review\',\'xl\')"><i class="fa fa-tasks"></i></button>&nbsp;';
            }
            $joining_date = "";
            if ($row['employeedetail']['date_join'] != '' && $row['employeedetail']['date_join'] != '0000-00-00') {
                $joining_date = date("d/m/Y", strtotime($row['employeedetail']['date_join']));
            }
            $created_date = "";
            if ($row['created_date_time'] != '' && $row['created_date_time'] != '0000-00-00') {
                $created_date = date("d/m/Y", strtotime($row['created_date_time']));
            }
            $rowData[] = array(++$m, $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $row['employeedetail']['departmentdetail']['department_name'], $row['employeedetail']['designationdetail']['designation_name'], $joining_date, $row['appraisal_for'], $created_date, HrAppraisal::getstatus($row['status']), array('id'=>$row['id'],'final_level'=>$final_level,'level_no'=>$level_no,'approve_reject'=>$approve_reject));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionReviewbyLm() {
        $id = (int)Yii::app()->request->getParam('id');
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        $model = new HrAppraisal();
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_analysis = HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="' . $id . '"'));
        }
        $model_settings = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('lm_review', array('model' => $model, 'model_analysis' => $model_analysis, 'model_settings' => $model_settings, 'level' => $level, 'final_level' => $final_level), false, true);
    }
    public function actionSavelmreview() {
        $model = new HrAppraisal();
        if (isset($_POST['HrAppraisal'])) {
            if ($_POST['HrAppraisal']['id'] > 0) {
                $id = (int)$_POST['HrAppraisal']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            $model->status = $_POST['HrAppraisal']['status'];
            $status = $_POST['HrAppraisal']['status'];
            $level = $_POST['approval_level'];
            $final_level = $_POST['final_level'];
            if ($status == 3 || $status == 5 || $status == 7 || $status == 9 || $status == 11 || $status == 12) {
                $model->last_approved_level = $_POST['HrAppraisal']['last_approved_level'];
            }
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id=0;
            if($modelemployee->employee_id>0){
                $approved_employee_id=$modelemployee->employee_id;
            }else if($modelemployee->hr_connected_employee_id>0){
                $approved_employee_id=$modelemployee->hr_connected_employee_id;
            }
            if ($level == 1 && $final_level=='N') {
                $model->approve_level1_date = date('Y-m-d');
                $model->approve_level1_comment = '';
                $model->approve_level1_id =$approved_employee_id;
            } else if ($level == 2 && $final_level=='N') {
                $model->approve_level2_date = date('Y-m-d');
                $model->approve_level2_comment = '';
                $model->approve_level2_id = $approved_employee_id;
            } else if ($level == 3 && $final_level=='N') {
                $model->approve_level3_date = date('Y-m-d');
                $model->approve_level3_comment = '';
                $model->approve_level3_id = $approved_employee_id;
            } else if ($level == 4 && $final_level=='N') {
                $model->approve_level4_date = date('Y-m-d');
                $model->approve_level4_comment = '';
                $model->approve_level4_id = $approved_employee_id;
            } else if ($level == 5 && $final_level=='N') {
                $model->approve_level5_date = date('Y-m-d');
                $model->approve_level5_comment = '';
                $model->approve_level5_id = $approved_employee_id;
            }
            if ($final_level == 'Y') {
                $model->approved_date = date('Y-m-d');
                $model->approval_comment = '';
                $model->approved_by = $approved_employee_id;
            }
            $valid = $model->validate();
            //Adding Analysis Data
            if (isset($_POST['HrAppraisalAnalysis'])) {
                foreach ($_POST['HrAppraisalAnalysis'] as $i => $items) {
                    if ($items['id'] > 0) {
                        $model_analysis[$i] = HrAppraisalAnalysis::model()->findByPK($items['id']);
                        if ($level == 1) {
                            $model_analysis[$i]->scenario = 'level1review';
                            $model_analysis[$i]->level1_answer = $items['level1_answer'];
                            $model_analysis[$i]->level1_score = $items['level1_score'];
                        } else if ($level == 2) {
                            $model_analysis[$i]->scenario = 'level2review';
                            $model_analysis[$i]->level2_answer = $items['level2_answer'];
                            $model_analysis[$i]->level2_score = $items['level2_score'];
                        } else if ($level == 3) {
                            $model_analysis[$i]->scenario = 'level3review';
                            $model_analysis[$i]->level3_answer = $items['level3_answer'];
                            $model_analysis[$i]->level3_score = $items['level3_score'];
                        } else if ($level == 4) {
                            $model_analysis[$i]->scenario = 'level4review';
                            $model_analysis[$i]->level4_answer = $items['level4_answer'];
                            $model_analysis[$i]->level4_score = $items['level4_score'];
                        } else if ($level == 5) {
                            $model_analysis[$i]->scenario = 'level5review';
                            $model_analysis[$i]->level5_answer = $items['level5_answer'];
                            $model_analysis[$i]->level5_score = $items['level5_score'];
                        }
                        $model_analysis[$i]->updated_by = Yii::app()->user->id;
                        $model_analysis[$i]->updated_date_time = date('Y-m-d H:i:s');
                        $valid = $model_analysis[$i]->validate() && $valid;
                    }
                }
            }
            //End Analysis Data
            if ($valid) {
                $model->save();
                //Save Analysis
                if (!empty($model_analysis)) {
                    foreach ($model_analysis as $eachModel) {
                        $eachModel->save();
                    }
                }
                if ($status == 3 || $status == 5 || $status == 7 || $status == 9 || $status == 11 || $status == 12) {
                    //Mail
                    $model_settings = HrGenerelSettings::model()->find();
                    $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="24"'));
                    if(!empty($model_settings) && !empty($model_mail_settings)){
                        if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                            Yii::import('application.modules.hr.controllers.MailController');
                            MailController::sendmail(24, $model->employee_id, $model->id);
                        }
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($model_analysis[0]->question_id != '') {
                    $error2 = json_decode(CActiveForm::validateTabular($model_analysis, '', false), true);
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actionHrReview() {
        $id = (int)Yii::app()->request->getParam('id');
        $model = new HrAppraisal();
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_analysis = HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="' . $id . '"'));
        }
        $model_settings = HrGenerelSettings::model()->find();
        $question_count = HrAppraisalAnalysis::model()->count(array('condition' => 'appraisal_id="' . $id . '"'));
        $employee_score = $lm_score = 0;
        $model_emp_mark = HrAppraisalAnalysis::model()->find(array('select' => 'sum(employee_score) as employee_score', 'condition' => 'appraisal_id="' . $id . '"'));
        $model_lm_mark = HrAppraisalAnalysis::model()->find(array('select' => 'sum(lm_score) as lm_score', 'condition' => 'appraisal_id="' . $id . '"'));
        if ($model_emp_mark->employee_score > 0) {
            $total_score = $question_count * $model_settings->appraisal_score;
            $score_secured = $model_emp_mark->employee_score;
            $employee_score = $score_secured . '/' . number_format((float)$total_score, 2, '.', '');
        }
        if ($model_lm_mark->lm_score > 0) {
            $total_score = $question_count * $model_settings->appraisal_score;
            $score_secured = $model_lm_mark->lm_score;
            $lm_score = $score_secured . '/' . number_format((float)$total_score, 2, '.', '');
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('hr_review', array('lm_score' => $lm_score, 'employee_score' => $employee_score, 'model' => $model, 'model_analysis' => $model_analysis, 'model_settings' => $model_settings), false, true);
    }
    public function actionSavehrreview() {
        $model = new HrAppraisal();
        if (isset($_POST['HrAppraisal'])) {
            if ($_POST['HrAppraisal']['id'] > 0) {
                $id = (int)$_POST['HrAppraisal']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            $model->status = 3;
            $model->hr_review_date = date('Y-m-d H:i:s');
            $valid = $model->validate();
            //Adding Analysis Data
            if (isset($_POST['HrAppraisalAnalysis'])) {
                foreach ($_POST['HrAppraisalAnalysis'] as $i => $items) {
                    if ($items['id'] > 0) {
                        $model_analysis[$i] = HrAppraisalAnalysis::model()->findByPK($items['id']);
                        $model_analysis[$i]->scenario = 'hrreview';
                        $model_analysis[$i]->updated_by = Yii::app()->user->id;
                        $model_analysis[$i]->updated_date_time = date('Y-m-d H:i:s');
                        $model_analysis[$i]->hr_answer = $items['hr_answer'];
                        $model_analysis[$i]->hr_score = $items['hr_score'];
                        $valid = $model_analysis[$i]->validate() && $valid;
                    }
                }
            }
            //End Analysis Data
            if ($valid) {
                $model->save();
                //Save Analysis
                if (!empty($model_analysis)) {
                    foreach ($model_analysis as $eachModel) {
                        $eachModel->save();
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($model_analysis[0]->question_id != '') {
                    $error2 = json_decode(CActiveForm::validateTabular($model_analysis, '', false), true);
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]') echo $error;
            }
        }
    }
    public function actionView() {
        $id = (int)Yii::app()->request->getParam('id');
        $model = new HrAppraisal();
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_analysis = HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="' . $id . '"'));
        }
        $model_settings = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('view', array('model' => $model, 'model_analysis' => $model_analysis, 'model_settings' => $model_settings), false, true);
    }
    public function actionPrintappraisalReportPDF() {
        $en_id = $_GET['id'];
        $id = $this->ciphertext($en_id, "d");
        $model_settings = HrGenerelSettings::model()->find();
        $model = HrAppraisal::model()->findByPk($id);
        $model_analysis = HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="' . $id . '"'));
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.appraisal.pdf_appraisal', array('model' => $model, 'model_settings' => $model_settings, 'id' => $id, 'model_analysis' => $model_analysis), true));
        $mPDF1->Output('appraisal_details.pdf', 'I');
    }
    public function actionloadmasterbranch() {
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('master_branch', array());
    }
    public function actionreviewindex() {
        $this->layout = 'main';
        $model_module_appraisal = HrModules::model()->findByPK(12);
        if ($model_module_appraisal->grant_access == 1 && $model_module_appraisal->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('review_index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetreviewedList() {
        $model = new HrAppraisal();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
        0 => 't.id', 1 => 'employeedetail.employee_code', 2 => 'employeedetail.first_name', 3 => 'departmentdetail.department_name', 4 => 'designationdetail.designation_name', 5 => 'employeedetail.date_join', 6 => 'appraisal_for', 7 => 't.created_date_time', 8 => 'status', 9 => '',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $modelemployee = User::model()->findByPK(Yii::app()->user->id);
        $employee_id = $modelemployee->employee_id;
        $condition = 'employeedetail.isActive="Y" AND (t.employee_id="' . $employee_id . '" OR t.approve_level1_id="' . $employee_id . '" OR t.approve_level2_id="' . $employee_id . '" OR t.approve_level3_id="' . $employee_id . '" OR t.approve_level4_id="' . $employee_id . '" OR t.approve_level5_id="' . $employee_id . '") AND status="12"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition.= " and (employee_code LIKE '%" . $searchString_en . "%' OR first_name LIKE '%" . $searchString_en . "%' OR middle_name LIKE '%" . $searchString_en . "%' OR last_name LIKE '%" . $searchString_en . "%' OR appraisal_for LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail', 'employeedetail.departmentdetail', 'employeedetail.designationdetail', 'approvelevel')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'employeedetail.departmentdetail', 'employeedetail.designationdetail', 'approvelevel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $en_slip_id = $this->ciphertext($row['id'], "e");
            $button_string.= '<button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'hr/appraisal/view&id=' . $row['id'] . '\',\'View Appraisal Detail \',\'xl\')"><i class="fa fa-eye"></i></button>&nbsp;';
            $button_string.= '<a class="btn btn-primary btn-xs" title="Print Appraisal Details" target="_blank" href="?r=hr/appraisal/PrintappraisalReportPDF&id=' . $en_slip_id . '"><i class="fa fa-file-pdf-o"></i></a>';
            $joining_date = "";
            if ($row['employeedetail']['date_join'] != '' && $row['employeedetail']['date_join'] != '0000-00-00') {
                $joining_date = date("d/m/Y", strtotime($row['employeedetail']['date_join']));
            }
            $created_date = "";
            if ($row['created_date_time'] != '' && $row['created_date_time'] != '0000-00-00') {
                $created_date = date("d/m/Y", strtotime($row['created_date_time']));
            }
            $rowData[] = array($m, $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $row['employeedetail']['departmentdetail']['department_name'], $row['employeedetail']['designationdetail']['designation_name'], $joining_date, $row['appraisal_for'], $created_date, HrAppraisal::getstatus($row['status']), array('id'=>$row['id'],'en_slip_id'=>$en_slip_id));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionreviewlmindex() {
        $this->layout = 'main';
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('reviewlm_index');
    }
    public function actionGetreviewedlmList() {
        $model = new HrAppraisal();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
        0 => 't.id', 1 => 'employeedetail.employee_code', 2 => 'employeedetail.first_name', 3 => 'departmentdetail.department_name', 4 => 'designationdetail.designation_name', 5 => 'employeedetail.date_join', 6 => 'appraisal_for', 7 => 't.created_date_time', 8 => 'status', 9 => '',);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $modelemployee = User::model()->findByPK(Yii::app()->user->id);
        $employee_id = $modelemployee->employee_id;
        $condition = 'employeedetail.isActive="Y" AND (t.approve_level1_id="' . $employee_id . '"|| t.approve_level2_id="' . $employee_id . '" || t.approve_level3_id="' . $employee_id . '" || t.approve_level4_id="' . $employee_id . '" ||t.approve_level5_id="' . $employee_id . '") AND status="12"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition.= " and (employee_code LIKE '%" . $searchString_en . "%' OR first_name LIKE '%" . $searchString_en . "%' OR middle_name LIKE '%" . $searchString_en . "%' OR last_name LIKE '%" . $searchString_en . "%' OR appraisal_for LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail', 'employeedetail.departmentdetail', 'employeedetail.designationdetail', 'approvelevel')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'employeedetail.departmentdetail', 'employeedetail.designationdetail', 'approvelevel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $en_slip_id = $this->ciphertext($row['id'], "e");
            $button_string.= '<button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'hr/appraisal/view&id=' . $row['id'] . '\',\'View Appraisal Detail \',\'xl\')"><i class="fa fa-eye"></i></button>&nbsp;';
            $button_string.= '<a class="btn btn-primary btn-xs" title="Print Appraisal Details" target="_blank" href="?r=hr/appraisal/PrintappraisalReportPDF&id=' . $en_slip_id . '"><i class="fa fa-file-pdf-o"></i></a>';
            $joining_date = "";
            if ($row['employeedetail']['date_join'] != '' && $row['employeedetail']['date_join'] != '0000-00-00') {
                $joining_date = date("d/m/Y", strtotime($row['employeedetail']['date_join']));
            }
            $created_date = "";
            if ($row['created_date_time'] != '' && $row['created_date_time'] != '0000-00-00') {
                $created_date = date("d/m/Y", strtotime($row['created_date_time']));
            }
            $rowData[] = array($m, $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $row['employeedetail']['departmentdetail']['department_name'], $row['employeedetail']['designationdetail']['designation_name'], $joining_date, $row['appraisal_for'], $created_date, HrAppraisal::getstatus($row['status']), $button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionPrintEmployeeAppraisal() {
        $en_id = $_GET['id'];
        $id = $this->ciphertext($en_id, "d");
        $model_settings = HrGenerelSettings::model()->find();
        $model = HrAppraisal::model()->findByPk($id);
        $model_analysis = HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="' . $id . '"'));
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.appraisal.print_appraisal', array('model' => $model, 'model_settings' => $model_settings, 'id' => $id, 'model_analysis' => $model_analysis), true));
        $mPDF1->Output('Form 2.pdf', 'I');
    }
     public function actionPrintEmployeeAppraisalGradeReview() {
        $en_id = $_GET['id'];
        $id = $this->ciphertext($en_id, "d");
        $model_settings = HrGenerelSettings::model()->find();
        $model = HrAppraisal::model()->findByPk($id);
        $model_analysis = HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="' . $id . '"'));
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.appraisal.print_appraisal_grade_review', array('model' => $model, 'model_settings' => $model_settings, 'id' => $id, 'model_analysis' => $model_analysis), true));
        $mPDF1->Output('Appraisal Report.pdf', 'I');
    }
     function numberToRoman($num) {
        $map = [
            'M' => 1000,
            'CM' => 900,
            'D' => 500,
            'CD' => 400,
            'C' => 100,
            'XC' => 90,
            'L' => 50,
            'XL' => 40,
            'X' => 10,
            'IX' => 9,
            'V' => 5,
            'IV' => 4,
            'I' => 1
        ];

        $roman = '';
        foreach ($map as $symbol => $value) {
            while ($num >= $value) {
                $roman .= $symbol;
                $num -= $value;
            }
        }
        return $roman;
    }
}
