<?php
//added by nisha on 24-03-2025
class ApisalaryadvanceController extends Controller {
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('GetSalaryAdvanceList','AdvanceDetailsById','SaveEmployeeSalaryAdvance','GetPendingAdvanceDetails','SaveApproveSalaryAdvance','deleteAdvancendetail'),
                'users' => array('*'),
            ),
        );
    }
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function beforeAction($action) {
        $this->ChangeDB();
        return true;
    }
    public function actionGetSalaryAdvanceList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = (int) $data_array['employee_id'];
            $condition="t.isActive='Y' and employee_id ='".$employee_id."'"; 
            EmployeeSalaryAdvance::model()->updateAll(array('view_status' => 1, 'updated_by' => $userModel->id, 'updated_date_time' => date('Y-m-d H:i:s')), 'employee_id="' . $employee_id . '" and view_status="0" and (advance_payment_status="12" OR advance_payment_status="13")');
            $model = new EmployeeSalaryAdvance();
            $model = $model->with('employeedetail')->findAll(array('condition' => $condition,'order'=>'t.id desc'));
            $response = array();
            foreach ($model as $value) {
                $show_btn_edit=$show_btn_delete=0;
                if($value->advance_payment_status==1){
                    $show_btn_edit=1;
                    $show_btn_delete=1;
                }
                $apply_date = "";
                if ($value->apply_date != '' && $value->apply_date != '0000-00-00') {
                    $apply_date = date("d/m/Y", strtotime($value->apply_date));
                }
                $approved_date = "";
                if ($value->approved_date != '0000-00-00') {
                    $approved_date = date("d/m/Y", strtotime($value->approved_date));
                }

                $pending_amount =0;
                if($value->amount>0){
                    $pending_amount =$value->amount-$value->amount_paid;
                }
               // Yii::app()->numberFormatter->formatCurrency(($row['amount']-$row['amount_paid']),"")
                $data[] = array(
                    "id" => $value->id,
                    "employee_code" => $value->employeedetail->employeecode,
                    "employee_name" => $value->employeedetail->employeefullname,
                    "advance_amount" => $value->amount,
                    "amount_paid" => $value->amount_paid,
                    "pending_amount" => $pending_amount,
                    "apply_date" => $apply_date,
                    "approved_date" => $approved_date,
                    "advance_status" => EmployeeSalaryAdvance::getStatus($value->advance_payment_status),
                    "advance_notes"=>$value->payment_note,
                    "show_button_edit"=> $show_btn_edit,
                    "show_button_delete"=> $show_btn_delete
                );
            }
            $response=array('status' => 'success','msg'=>'success','data'=>$data);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        if (empty($data)) {
            $response = array('status' => "failed",'msg' => "No Data Available");
        }
        echo json_encode($response);
    }
    public function actionAdvanceDetailsById() {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            if ($userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                $id = (int) $data_array['id'];
                if ($id > 0) {
                    $modeladvance = EmployeeSalaryAdvance::model()->findByPK($id);
                    $apply_date = "";
                    if ($modeladvance->apply_date != '' && $modeladvance->apply_date != '0000-00-00') {
                        $apply_date = date("d/m/Y", strtotime($modeladvance->apply_date));
                    }
                    $data = array(
                        "id" => $modeladvance->id,
                        "employee_id" => $modeladvance->employee_id,
                        "amount" => $modeladvance->amount,
                        "apply_date"=>$apply_date,
                        "payment_note"=>$modeladvance->payment_note,
                    );
                    $response = array('status' => 'success', 'msg' => 'success', 'data' => $data);
                } else {
                    $response = array('status' => "failed", "msg" => "Input missing");
                }
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "msg" => "Unauthorized user");
            }
            if (empty($data)) {
                $response = array('status' => "failed", 'msg' => "No Data Available");
            }
            echo json_encode($response);
        }
        public function actionSaveEmployeeSalaryAdvance() 
        {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $response = $other = array();
            $userModel = User::model()->findBytoken($token);
            $modeladvance = new EmployeeSalaryAdvance();
            if ($userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                if (!empty($data_array)) {
                    $flag = "N";
                    $id = $data_array['id'];
                    $current_date = date("Y-m-d");
                    $employee_id = $data_array['employee_id'];
                    $salary_amount = 0.00;
                    $condition = 'employee_id="' . $employee_id . '" and isActive="Y" and valid_from <="' . $current_date . '" AND valid_to ="0000-00-00"';
                    $model_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount', 'condition' => $condition));
                    if ($model_salary->amount > 0) {
                        $salary_amount = $model_salary->amount;
                    }
                    $model_details_pending = EmployeeSalaryAdvance::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and (advance_payment_status = "1" or advance_payment_status = "2" or advance_payment_status = "4" or advance_payment_status = "6" or advance_payment_status = "8" or advance_payment_status = "10" or advance_payment_status = "12" or advance_payment_status = "14" or advance_payment_status = "15")'));
                    if ($id == '') {
                        if (!empty($model_details_pending) && $model_details_pending->id > 0) {
                            $flag = "Y";
                            $other[] = "Advance Repayment Exists";
                        }
                        if ($data_array['advance_amount'] > $salary_amount) {
                            $flag = "Y";
                            $other[] = "Amount cannot be greater than salary " . $salary_amount;
                        }
                    }
                    if ($flag == "N") {
                        if (isset($id) && $id > 0) {
                            $id = (int) $id;
                            $modeladvance = EmployeeSalaryAdvance::model()->findByPK($id);
                            $modeladvance->updated_by = $userModel->id;
                            $modeladvance->updated_date_time = date('Y-m-d H:i:s');
                        } else {
                            $modeladvance->apply_date = date("Y-m-d");
                            $modeladvance->created_by = $userModel->id;
                            $modeladvance->created_date_time = date('Y-m-d H:i:s');
                        }
                        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="3"'));
                        if (!empty($model_master_approve_setting)) {
                            $modeladvance->function_type = $model_master_approve_setting->id;
                            $modeladvance->max_level = $model_master_approve_setting->max_level;
                        }
                        $modeladvance->amount = $data_array['advance_amount'];
                        $modeladvance->employee_id = $data_array['employee_id'];
                        $modeladvance->payment_note = $data_array['payment_note']; //remarks
                        $modeladvance->advance_payment_status = 1; //status
                        if ($modeladvance->validate()) {
                            $modeladvance->save();
                            //Mail
                            /*    $model_settings = HrGenerelSettings::model()->find();
                              $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="16"'));
                              if(!empty($model_settings) && !empty($model_mail_settings)){
                              if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                              Yii::import('application.modules.hr.controllers.MailController');
                              MailController::sendmail(16,$model->employee_id,$model->id);
                              }
                              } */
                            $response = array('status' => "success", "msg" => "success", 'id' => $modeladvance->id);
                        } else {
                            foreach ($modeladvance->errors as $t => $value) {
                                $arr_err[] = $value[0];
                            }
                            $response = array('status' => 'error', 'msg' => $arr_err);
                        }
                    } else {
                        $response = array('status' => 'error', 'msg' => $other);
                    }
                } else {
                    $response = array('status' => "failed", "msg" => "Input parameters Missing");
                }
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "msg" => "Unauthorized user");
            }
            echo json_encode($response);
    }
    public function actionGetPendingAdvanceDetails() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = (int) $data_array['employee_id'];
            $condition = "employee_id ='" . $employee_id . "'";
            $pending_salaryadvance=EmployeeSalaryAdvance::getintermediateapproval($employee_id,1);
            $condition = 'employeedetail.isActive="Y" AND t.last_approved_level<t.max_level AND t.id IN('.$pending_salaryadvance.')';
            $model = new EmployeeSalaryAdvance();
            $model = $model->with('employeedetail','approvelevel')->findAll(array('condition' => $condition));
            $response = array();
            foreach ($model as $row)
            {
                $button_string = "";
                $last_approved_level=$row->last_approved_level;
                $next_approval_level=$last_approved_level+1;
                $show_approve_button=0;
                $level_no=0;
                $final_level='N';
                if($next_approval_level<=$row->max_level){
                    if($next_approval_level==1 && (($row->approvelevel->level_1_type=='L' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='S' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='N' && $row->approvelevel->level_1_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=1;
                    }else if($next_approval_level==2 && (($row->approvelevel->level_2_type=='L' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='S' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='N' && $row->approvelevel->level_2_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=2;
                    }else if($next_approval_level==3 && (($row->approvelevel->level_3_type=='L' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='S' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='N' && $row->approvelevel->level_3_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=3;
                    }else if($next_approval_level==4 && (($row->approvelevel->level_4_type=='L' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='S' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='N' && $row->approvelevel->level_4_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=4;
                    }else if($next_approval_level==5 && (($row->approvelevel->level_5_type=='L' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='S' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='N' && $row->approvelevel->level_5_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=5;
                    }
                }
                if($next_approval_level==$row->max_level){
                    $final_level='Y';
                }
                $applydate = date("d/m/Y", strtotime($row['apply_date']));			
                    $data[] = array(
                        "id" => $row->id,
                        "employee_code" => $row->employeedetail->employeecode,
                        "employee_name" => $row->employeedetail->employeefullname,
                        "advance_amount" => $row->amount,
                        "date_apply"=>$applydate,
                        "show_approve_button"=>$show_approve_button,
                        "advance_payment"=> EmployeeSalaryAdvance::getStatus($row['advance_payment_status']),
                        "next_approval_level"=>$level_no,
                        "final_level"=>$final_level,
                        );
            }
            $response = array('status' => 'success', 'msg' => 'success', 'data' => $data);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        if (empty($data)) {
            $response = array('status' => "failed", 'msg' => "No Data Available");
        }
        echo json_encode($response);
    }
    public function actionSaveApproveSalaryAdvance() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        $modeladvance = new EmployeeSalaryAdvance();
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            if (!empty($data_array)) {
                $employee_id = $data_array['employee_id'];
                $id = $data_array['id'];
                if ($id > 0) {
                    $modeladvance = EmployeeSalaryAdvance::model()->findByPK($id);
                    $modeladvance->updated_by = $userModel->id;
                    $modeladvance->updated_date_time = date('Y-m-d H:i:s');
                    $level = $data_array['approval_level'];
                    $final_level = $data_array['final_level'];
                    $modeladvance->last_approved_level = $data_array['approval_level'];
                    if ($level == 1 && $final_level=='N') {
                        $modeladvance->approve_level1_date = date('Y-m-d');
                        $modeladvance->approve_level1_comment = $data_array['approval_comment'];
                        $modeladvance->approve_level1_id = $employee_id;
                    } else if ($level == 2 && $final_level=='N') {

                        $modeladvance->approve_level2_date = date('Y-m-d');
                        $modeladvance->approve_level2_comment = $data_array['approval_comment'];
                        $modeladvance->approve_level2_id = $employee_id;
                    } else if ($level == 3 && $final_level=='N') {
                        $modeladvance->approve_level3_date = date('Y-m-d');
                        $modeladvance->approve_level3_comment = $data_array['approval_comment'];
                        $modeladvance->approve_level3_id = $employee_id;
                    } else if ($level == 4 && $final_level=='N') {
                        $modeladvance->approve_level4_date = date('Y-m-d');
                        $modeladvance->approve_level4_comment = $data_array['approval_comment'];
                        $modeladvance->approve_level4_id = $employee_id;
                    } else if ($level == 5 && $final_level=='N') {
                        $modeladvance->approve_level5_date = date('Y-m-d');
                        $modeladvance->approve_level5_comment = $data_array['approval_comment'];
                        $modeladvance->approve_level5_id = $employee_id;
                    }
                    if ($final_level == 'Y') {
                        $modeladvance->approved_date = date('Y-m-d');
                        $modeladvance->approval_comment = $data_array['approval_comment'];
                        $modeladvance->approved_by = $employee_id;
                    }
                    $status_v = $data_array['advance_status'];
                    if ($status_v == 'A') {
                        $status_msg = "Salary Advance Approved";
                    } else {
                        $status_msg = "Salary Advance Rejected";
                    }
                    if ($final_level == 'Y') {
                        if ($status_v == 'A') {
                            $status = 12;
                        } else {
                            $status = 13;
                        }
                    } else if ($level == 1) {
                        if ($status_v == 'A') {
                            $status = 2;
                        } else {
                            $status = 3;
                        }
                    } else if ($level == 2) {
                        if ($status_v == 'A') {
                            $status = 4;
                        } else {
                            $status = 5;
                        }
                    } else if ($level == 3) {
                        if ($status_v == 'A') {
                            $status = 6;
                        } else {
                            $status = 7;
                        }
                    } else if ($level == 4) {
                        if ($status_v == 'A') {
                            $status = 8;
                        } else {
                            $status = 9;
                        }
                    } else if ($level == 5) {
                        if ($status_v == 'A') {
                            $status = 10;
                        } else {
                            $status = 11;
                        }
                    }
                    $modeladvance->advance_payment_status = $status;
                    if ($modeladvance->validate()) {
                        $modeladvance->save();
                        //Mail
                        /*    $model_settings = HrGenerelSettings::model()->find();
                          $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="14"'));
                          if (!empty($model_settings) && !empty($model_mail_settings)) {
                          if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                          Yii::import('application.modules.hr.controllers.MailController');
                          MailController::sendmail(14, $modelloan->employee_id, $modelloan->id);
                          }
                          } */
                        $response = array('status' => "success", "msg" => $status_msg, 'id' => $modeladvance->id);
                    } else {
                        foreach ($modeladvance->errors as $t => $value) {
                            $arr_err[] = $value[0];
                        }
                        $response = array('status' => 'error', 'msg' => $arr_err);
                    }
                } else {
                    $response = array('status' => "failed", "msg" => "ID Missing");
                }
            } else {
                $response = array('status' => "failed", "msg" => "Input parameters Missing");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($response);
    }
    public function actiondeleteAdvancendetail() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array['id'];
            $model = EmployeeSalaryAdvance::model()->findbyPK($id);
            if ($model->advance_payment_status == 1) {
                $status = $model->deleteByPk($id);
                if ($status == 1) {
                    $response = array('status' => "success", "msg" => "Salary Advance Deleted Successfully");
                    $data['status'] = 'success';
                } else {
                    $response = array('status' => "failed", "msg" => "Salary Advance deletion Failed");
                }
            } else {
                $response = array('status' => "failed", "msg" => "Deletion not Possible");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data);
        }
        echo json_encode($response);
    }
}
