<?php

class ApipunchController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('PunchStatus', 'Savepunchdetails', 'savepunchbreak'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index',),
                'expression' => '$user->isMember()',
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
//for db connection added by nisha on 31-03-2023
        $this->ChangeDB();
        return true;
    }

    public function actionPunchStatus() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $data = [];
        if ($userModel->id > 0) {
            date_default_timezone_set('Asia/Dubai');
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array["employee_id"];
            if (!empty($employee_id)) {
                $current_date = date("Y-m-d");
                $date_from = date('Y-m-d', strtotime('-1 days', strtotime($date_from)));
                $active_status = 'LOG_OUT';
                $model_attendance = EmployeeAttendance::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and attendance_date="' . $current_date . '"'));
                $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $current_date . '" AND to_date>="' . $current_date . '") OR  (from_date BETWEEN  "' . $current_date . '" AND  "' . $current_date . '"OR to_date BETWEEN  "' . $current_date . '" AND  "' . $current_date . '")) AND employee_id="' . $employee_id . '"'));
                $punch_status = 'OUT';
                $break_status = 'BREAK-OUT';
                $model_attendance_puched = HrAttendancePunchHistory::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and attendance_date="' . $current_date . '" AND punch_status IN("I","O")', 'order' => 'punch_time desc'));
                if (!empty($model_attendance_puched)) {
                    if ($model_attendance_puched->punch_status == 'I') {
                        $punch_status = 'IN';
                    } else if ($model_attendance_puched->punch_status == 'O') {
                        $punch_status = 'OUT';
                    }
                }
                $model_break_puched = HrAttendancePunchHistory::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and attendance_date="' . $current_date . '" AND punch_status IN("BI","BO")', 'order' => 'punch_time desc'));
                if (!empty($model_break_puched)) {
                    if ($model_break_puched->punch_status == 'BI') {
                        $break_status = 'BREAK-IN';
                    } else if ($model_break_puched->punch_status == 'BO') {
                        $break_status = 'BREAK-OUT';
                    }
                }
                if ($model_attendance->login_time != '00:00' && $model_attendance->login_time != '') {
                    $login_time = $model_attendance->login_time;
                } else {
                    $login_time = '-';
                }
                if ($model_attendance->logout_time != '00:00' && $model_attendance->logout_time != '') {
                    $logout_time = $model_attendance->logout_time;
                } else {
                    $logout_time = '-';
                }
                $data = [
                    "punch_status" => $punch_status,
                    "break_status" => $break_status,
                ];
                $response = array('status' => "success", "msg" => "success", 'data' => $data);
                if (empty($data)) {
                    $response = array('status' => "error", 'msg' => "No Data Available", 'data' => $data);
                }
            } else {
                $response = array('status' => "error", 'msg' => "Input parameters missing", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "error", "msg" => "Unauthorized user", 'data' => $data);
        }

        echo json_encode($response);
    }

    public function actionSavepunchdetails() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $data = [];
        if ($userModel->id > 0) {
            date_default_timezone_set('Asia/Dubai');
            $data_array = json_decode(file_get_contents('php://input'), true);
            $user_id = $userModel->id;
            $punch_date = $data_array['punch_date'];
            $punch_time = $data_array['punch_time_value'];
            $employee_id = $data_array['punch_employee_id'];
            $shift_id = $data_array['attendance_shift_id'];
            $latitude = $data_array['center_latitude'];
            $longitude = $data_array['center_longitude'];
            $allowed_latitude = $data_array['latitude'];
            $allowed_longitude = $data_array['longitude'];
            $punch_date = date('Y-m-d');
            $model_employee = Employee::model()->findByPK($employee_id);
//Saving Attendance
            $weekvalue = date('w', strtotime($punch_date));
            $weekvalue += 1;
            $day = array(1 => "Sunday", 2 => "Monday", 3 => "Tuesday", 4 => "Wednesday", 5 => "Thursday", 6 => "Friday", 7 => "Saturday");
            $model_attendance_detail = EmployeeAttendance::model()->find(array('condition' => 'attendance_date="' . $punch_date . '" and employee_id="' . $employee_id . '"'));
            $location_details = HrMasGeocodeLocation::model()->find(array('condition' => 'latitude="' . $latitude . '" and longitude="' . $longitude . '"'));
            $time = date("H:i");
            if (empty($model_attendance_detail)) {
                $model_attendance = new EmployeeAttendance();
                $model_attendance->created_by = $user_id;
                $model_attendance->created_date_time = date('Y-m-d H:i:s');
                $model_attendance->status = 1;
                $model_attendance->login_time = '00:00';
                $model_attendance->logout_time = '00:00';
                if ($time != '' && $time != '00:00' && $time != '0:00') {
                    $model_attendance->login_time = $time;
                }
            } else {
                $model_attendance = EmployeeAttendance::model()->findByPK($model_attendance_detail->id);
                $model_attendance->updated_by = $user_id;
                $model_attendance->updated_date_time = date('Y-m-d H:i:s');
                $old_time = $model_attendance->login_time;

                if (strtotime($time) < strtotime($old_time) || $old_time == '00:00') {
                    $model_attendance->login_time = $time;
                } else {
                    $model_attendance->login_time = $old_time;
                }
                if ($model_attendance->logout_time != '00:00' && $model_attendance->logout_time != '') {
                    $model_attendance->logout_time = $time;
                } else {
                    $model_attendance->logout_time = $time;
                }
            }
            $model_attendance->attendance_via = 'A';
            if (($model_attendance->login_time != '00:00' && $model_attendance->login_time != '0:00' && $model_attendance->login_time != '') || ($model_attendance->logout_time != '00:00' && $model_attendance->logout_time != '0:00' && $model_attendance->logout_time != '')) {
                $model_attendance->status = 1;
            } else {
                $model_attendance->status = 2;
            }
            $model_attendance->employee_id = $employee_id;
            $model_attendance->upload_file = '';
//Working Details
            $model_attendance->morning_late = $this->morninglate($employee_id, $punch_date, $model_attendance->login_time);
            $model_attendance->total_working = $this->totalworking($employee_id, $punch_date, $model_attendance->login_time, $model_attendance->logout_time);
            $model_attendance->variance_time_loss = $this->totaltimeloss($employee_id, $punch_date, $model_attendance->login_time, $model_attendance->logout_time);
            $model_attendance->excess_time = $this->excesstime($employee_id, $punch_date, $model_attendance->login_time, $model_attendance->logout_time);
            $model_attendance->shift_id = $this->shiftdetail($employee_id, $punch_date);
            if ($model_attendance->status == 1 && $model_employee->overtime == "Y" && $model_attendance->login_time != '' && $model_attendance->logout_time != '') {
                $model_settings = HrGenerelSettings::model()->find();
                $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("' . $model_employee->branch_or_sponsor_id . '",branch_id)  AND holiday_date="' . $punch_date . '"'));
                if (!empty($model_holiday) && $model_settings->holiday_ot_from == 'O') {
                    $model_attendance->holiday_overtime = $this->holidayasworkingovertime($employee_id, $punch_date, $model_attendance->login_time, $model_attendance->logout_time);
                    $model_attendance->normal_overtime = '00:00:00';
                    $model_attendance->weekend_overtime = '00:00:00';
                    $model_attendance->night_shift_overtime = '00:00:00';
                } else if (!empty($model_holiday)) {
                    $model_attendance->holiday_overtime = $this->holidayovertime($employee_id, $punch_date, $model_attendance->login_time, $model_attendance->logout_time);
                    $model_attendance->normal_overtime = '00:00:00';
                    $model_attendance->weekend_overtime = '00:00:00';
                    $model_attendance->night_shift_overtime = '00:00:00';
                } else if ($model_master_shift->shift_type == 'N') {

                    $model_attendance->holiday_overtime = '00:00:00';
                    $model_attendance->normal_overtime = '00:00:00';
                    $model_attendance->weekend_overtime = '00:00:00';
                    $model_attendance->night_shift_overtime = '00:00:00';
                } else if ($weekend == 1) {
                    $model_attendance->weekend_overtime = $this->weekendovertime($employee_id, $punch_date, $model_attendance->login_time, $model_attendance->logout_time);
                    $model_attendance->normal_overtime = '00:00:00';
                    $model_attendance->holiday_overtime = '00:00:00';
                    $model_attendance->night_shift_overtime = '00:00:00';
                } else if (empty($model_holiday)) {
                    $model_attendance->normal_overtime = $this->normalovertime($employee_id, $punch_date, $model_attendance->login_time, $model_attendance->logout_time);
                    $model_attendance->holiday_overtime = '00:00:00';
                    $model_attendance->weekend_overtime = '00:00:00';
                    $model_attendance->night_shift_overtime = '00:00:00';
                }
            } else {
                $model_attendance->holiday_overtime = '00:00:00';
                $model_attendance->normal_overtime = '00:00:00';
                $model_attendance->weekend_overtime = '00:00:00';
                $model_attendance->night_shift_overtime = '00:00:00';
            }
            $model_attendance->branch_or_sponsor_id = $model_employee->branch_or_sponsor_id;
            $model_attendance->attendance_date = $punch_date;
            $model_attendance->week_day = $day[$weekvalue];
            $model_attendance->save();
//Saving to Punch History

            $punch_status = 'I';
            $model_attendance_puched = HrAttendancePunchHistory::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and attendance_date="' . $punch_date . '"', 'order' => 'punch_time desc'));
            if (!empty($model_attendance_puched)) {
                if ($model_attendance_puched->punch_status == 'I') {
                    $punch_status = 'O';
                } else if ($model_attendance_puched->punch_status == 'O') {
                    $punch_status = 'I';
                }
            }
            $model_punch_history = new HrAttendancePunchHistory();
            $model_punch_history->employee_id = $employee_id;
            $model_punch_history->attendance_date = $punch_date;
            $model_punch_history->punch_time = $time;
            $model_punch_history->punch_status = $punch_status;
            $model_punch_history->created_by = $user_id;
            $model_punch_history->latitude = $latitude;
            $model_punch_history->longitude = $longitude;
            $model_punch_history->current_latitude = $allowed_latitude;
            $model_punch_history->current_longitude = $allowed_longitude;
            $model_punch_history->punch_location = $location_details->geocode_location;
            $model_punch_history->created_date_time = date('Y-m-d H:i:s');
            if ($model_punch_history->validate()) {
                $model_punch_history->save();
                $response = array('status' => "success", "msg" => "success");
            } else {
                $response = ["status" => "error", "error" => $model_punch_history->getErrors()];
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($response);
    }

    public function actionsavepunchbreak() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $data = [];
        if ($userModel->id > 0) {
            date_default_timezone_set('Asia/Dubai');
            $data_array = json_decode(file_get_contents('php://input'), true);
            $user_id = $userModel->id;
            if (!empty($data_array)) {
                $punch_date = $data_array['punch_date'];
                $punch_time = $data_array['punch_time_value'];
                $employee_id = $data_array['punch_employee_id'];
                $latitude = $data_array['center_latitude'];
                $longitude = $data_array['center_longitude'];
                $description = $data_array['punch_description'];
                $allowed_latitude = $data_array['latitude'];
                $allowed_longitude = $data_array['longitude'];
                $punch_status = $data_array['punch_status'];
                $punch_date = date('Y-m-d');
                $time = date("H:i:s");
                $model_punch_history = new HrAttendancePunchHistory();
                $model_punch_history->employee_id = $employee_id;
                $model_punch_history->attendance_date = $punch_date;
                $model_punch_history->punch_time = $time;
                $model_punch_history->punch_status = $punch_status;
                $model_punch_history->created_by = $user_id;
                $model_punch_history->latitude = $latitude;
                $model_punch_history->longitude = $longitude;
                $model_punch_history->current_latitude = $allowed_latitude;
                $model_punch_history->current_longitude = $allowed_longitude;
                $model_punch_history->punch_location = $description;
                $model_punch_history->created_date_time = date('Y-m-d H:i:s');

                if ($model_punch_history->validate()) {
                    $model_punch_history->save();
                    $response = array('status' => "success", "msg" => "success");
                } else {
                    $response = ["status" => "error", "msg" => $model_punch_history->getErrors()];
                }
            } else {
                $response = ["status" => "error", "msg" => "Input parameters missing"];
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($response);
    }

//Morning Late-Start
    function morninglate($employee_id, $date, $login_time) {
        $model_general_settings = HrGenerelSettings::model()->find();
        $cool_off_time = $model_general_settings->cool_off_time;
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue += 1;
        $weektype = '';
//Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off3_type;
        }
//Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("' . $model->branch_or_sponsor_id . '",branch_id)  AND holiday_date="' . $date . '"'));
//Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
        if ($model_shift->shift_id > 0) {
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
        } else if ($weekend == 1 && $weektype == 'H') {
            $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
        } else {
            $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
        }
        $mor_late = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $weektype != 'F' && $model_holiday->id == '') {
            $from_time = strtotime($login_time);
            $secs = strtotime($cool_off_time) - strtotime("00:00:00");
            $morning_start = date("H:i", strtotime($original_start_time) + $secs);
            $morning_shift_in_time = strtotime($morning_start);
            $shift_in_time = strtotime($original_start_time);
            $time_diff = $from_time - $shift_in_time;
            if ($morning_shift_in_time >= $from_time) {
                $mor_late = '00:00';
            } else {
                $mor_late = gmdate('H:i', $time_diff);
            }
        }
        return $mor_late;
    }

//Morning Late-End
//Total Working -Start
    function totalworking($employee_id, $date, $login_time, $logout_time) {
        $total_working = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $working_stop_time = strtotime($login_time);
            $working_start_time = strtotime($logout_time);
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                if ($model_master_shift->shift_type == 'N') {
                    $diff = ($working_start_time - $working_stop_time);
                } else {
                    if ($working_stop_time > $working_start_time) {
                        $diff = ($working_stop_time - $working_start_time);
                    } else {
                        $diff = ($working_start_time - $working_stop_time);
                    }
                }
            } else {
                if ($working_stop_time > $working_start_time) {
                    $diff = ($working_stop_time - $working_start_time);
                } else {
                    $diff = ($working_start_time - $working_stop_time);
                }
            }
            $total_working = gmdate('H:i', $diff);
        }
        return $total_working;
    }

//Total Working -End
//Total Time Loss Per Day -Start
    function totaltimeloss($employee_id, $date, $login_time, $logout_time) {
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue += 1;
        $weektype = '';
//Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off3_type;
        }
//Branch Working Hours
        $model_branch = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
        $branch_working_hours = $model_branch->branch_working_hours;
//Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("' . $model->branch_or_sponsor_id . '",branch_id)  AND holiday_date="' . $date . '"'));
//Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
        if ($model_shift->shift_id > 0) {
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
//Shift time total Hrs
            $shift_working_stop_time = strtotime($original_stop_time);
            $shift_working_start_time = strtotime($original_start_time);
            $shift_working_diff = ($shift_working_stop_time - $shift_working_start_time);
            $branch_working_hours = gmdate('H:i', $shift_working_diff);
        } else if ($weekend == 1 && $weektype == 'H') {
            $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
        } else {
            $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
        }

        $total_working = $total_timeloss = '00:00';
        if ($model_holiday->id == '') {
            if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
                $working_stop_time = strtotime($login_time);
                $working_start_time = strtotime($logout_time);
                if ($working_stop_time > $working_start_time) {
                    $diff = ($working_stop_time - $working_start_time);
                } else {
                    $diff = ($working_start_time - $working_stop_time);
                }
                $total_working = $this->totalworking($employee_id, $date, $login_time, $logout_time);
                if ((strtotime($total_working) < strtotime($branch_working_hours)) && $weekend == 0) {
                    $timeloss_stop_time = strtotime($branch_working_hours);
                    $timeloss_start_time = strtotime($total_working);
                    $timeloss_diff = ($timeloss_stop_time - $timeloss_start_time);
                    $total_timeloss = gmdate('H:i', $timeloss_diff);
                }
            }
        }
        return $total_timeloss;
    }

//Total Time Loss Per Day -End
//Total Excess Time Per Day -Start
    function excesstime($employee_id, $date, $login_time, $logout_time) {
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue += 1;
        $weektype = '';
//Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off3_type;
        }
//Branch Working Hours
        $model_branch = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
        $branch_working_hours = $model_branch->branch_working_hours;
//Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("' . $model->branch_or_sponsor_id . '",branch_id)  AND holiday_date="' . $date . '"'));
//Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
        if ($model_shift->shift_id > 0) {
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
//Shift time total Hrs
            $shift_working_stop_time = strtotime($original_stop_time);
            $shift_working_start_time = strtotime($original_start_time);
            $shift_working_diff = ($shift_working_stop_time - $shift_working_start_time);
            $branch_working_hours = gmdate('H:i', $shift_working_diff);
        } else if ($weekend == 1 && $weektype == 'H') {
            $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
        } else {
            $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
        }

        $total_working = $total_excess_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $working_stop_time = strtotime($login_time);
            $working_start_time = strtotime($logout_time);
            if ($working_stop_time > $working_start_time) {
                $diff = ($working_stop_time - $working_start_time);
            } else {
                $diff = ($working_start_time - $working_stop_time);
            }
            $total_working = $this->totalworking($employee_id, $date, $login_time, $logout_time);
            if ($weekend == 1 || $model_holiday->id > 0) {
                $total_excess_time = $total_working;
            } else if (strtotime($total_working) > strtotime($branch_working_hours)) {
                $stop_time = strtotime($total_working);
                $start_time = strtotime($branch_working_hours);
                ;
                $time_excess = ($stop_time - $start_time);
                $total_excess_time = gmdate('H:i', $time_excess);
            }
        }
        return $total_excess_time;
    }

//Total Excess Time Per Day -End
//Holiday Overtime Calculation Beyond Working Time-Start
    function holidayasworkingovertime($employee_id, $date, $login_time, $logout_time) {
        $over_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue += 1;
            $weektype = '';
//Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off3_type;
            }
//Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            } else if ($weekend == 1 && $weektype == 'H') {
                $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
            } else {
                $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
            }
//Working Time
            $working_stop_time = strtotime($logout_time);
            if ($model_settings->start_time_holiday_ot == 'P') {
                $working_start_time = strtotime($login_time);
            } else if ($model_settings->start_time_holiday_ot == 'C') {
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if ($punch_start_time > $company_start_time) {
                    $working_start_time = $punch_start_time;
                } else {
                    $working_start_time = $company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
//Original time
            $original_start_time = strtotime($original_start_time);
            $original_stop_time = strtotime($original_stop_time);
            $original_diff = ($original_stop_time - $original_start_time);
//Difference
            $overtime_diff = $diff - $original_diff;
            if ($overtime_diff > 0) {
                $work_time_1 = gmdate('H:i', $overtime_diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $overtime_diff);
                }
            }
        }
        return $over_time;
    }

//Holiday Overtime Calculation Beyond Working Time-End
//Holiday Overtime Calculation Beyond Working Time-Start
    function holidayovertime($employee_id, $date, $login_time, $logout_time) {
        $over_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue += 1;
            $weektype = '';
//Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off3_type;
            }
//Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            } else if ($weekend == 1 && $weektype == 'H') {
                $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
            } else {
                $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
            }
//Working Time
            $working_stop_time = strtotime($logout_time);
            if ($model_settings->start_time_holiday_ot == 'P') {
                $working_start_time = strtotime($login_time);
            } else if ($model_settings->start_time_holiday_ot == 'C') {
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if ($punch_start_time > $company_start_time) {
                    $working_start_time = $punch_start_time;
                } else {
                    $working_start_time = $company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            if ($diff > 0) {
                $work_time_1 = gmdate('H:i', $diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $diff);
                }
            }
        }
        return $over_time;
    }

//Holiday Overtime Calculation Beyond Working Time-End
//Normal Overtime Calculation-Start
    function normalovertime($employee_id, $date, $login_time, $logout_time) {
        $over_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue += 1;
            $weektype = '';
//Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off3_type;
            }
//Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            } else if ($weekend == 1 && $weektype == 'H') {
                $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
            } else {
                $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
            }
//Working Time
            $working_stop_time = strtotime($logout_time);
            if ($model_settings->start_time_normal_ot == 'P') {
                $working_start_time = strtotime($login_time);
            } else if ($model_settings->start_time_normal_ot == 'C') {
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if ($punch_start_time > $company_start_time) {
                    $working_start_time = $punch_start_time;
                } else {
                    $working_start_time = $company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
//Original time
            $original_start_time = strtotime($original_start_time);
            $original_stop_time = strtotime($original_stop_time);
            $original_diff = ($original_stop_time - $original_start_time);
//Difference
            $overtime_diff = $diff - $original_diff;
            if ($overtime_diff > 0) {
                $work_time_1 = gmdate('H:i', $overtime_diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $overtime_diff);
                }
            }
        }
        return $over_time;
    }

//Normal Overtime Calculation-End
//Weeekend Overtime Calculation-Start
    function weekendovertime($employee_id, $date, $login_time, $logout_time) {
        $over_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue += 1;
            $weektype = '';
//Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off3_type;
            }
//Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($weekend == 1 && $weektype == 'H') {
                $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
            } else if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            } else {
                $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
            }
//Working Time
            $working_stop_time = strtotime($logout_time);
            if ($model_settings->start_time_weekend_ot == 'P') {
                $working_start_time = strtotime($login_time);
            } else if ($model_settings->start_time_weekend_ot == 'C') {
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if ($punch_start_time > $company_start_time) {
                    $working_start_time = $punch_start_time;
                } else {
                    $working_start_time = $company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            if ($weektype == 'F') {
                if ($diff > 0) {
                    $work_time_1 = gmdate('H:i', $diff);
                    $overtime_diff_1 = strtotime($work_time_1);
                    if ($overtime_diff_1 >= $min_over_time) {
                        $over_time = gmdate('H:i', $diff);
                    }
                }
            } else if ($weektype == 'H') {
//Original time
                $original_start_time = strtotime($original_start_time);
                $original_stop_time = strtotime($original_stop_time);
                $original_diff = ($original_stop_time - $original_start_time);
//Difference
                $overtime_diff = $diff - $original_diff;
                if ($overtime_diff > 0) {
                    $work_time_1 = gmdate('H:i', $overtime_diff);
                    $overtime_diff_1 = strtotime($work_time_1);
                    if ($overtime_diff_1 >= $min_over_time) {
                        $over_time = gmdate('H:i', $overtime_diff);
                    }
                }
            }
        }
        return $over_time;
    }

//Weekend Overtime Calculation-End
//Night Shift Overtime Calculation-Start
    function nightshiftovertime($employee_id, $date, $login_time, $logout_time) {
        $over_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue += 1;
            $weektype = '';
//Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off3_type;
            }
//Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            } else if ($weekend == 1 && $weektype == 'H') {
                $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
            } else {
                $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
            }
//Working Time
            $working_stop_time = strtotime($logout_time);
            if ($model_settings->start_time_night_ot == 'P') {
                $working_start_time = strtotime($login_time);
            } else if ($model_settings->start_time_night_ot == 'C') {
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if ($punch_start_time > $company_start_time) {
                    $working_start_time = $punch_start_time;
                } else {
                    $working_start_time = $company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
//Original time
            $original_start_time = strtotime($original_start_time);
            $original_stop_time = strtotime($original_stop_time);
            $original_diff = ($original_stop_time - $original_start_time);
//Difference
            $overtime_diff = $diff - $original_diff;
            if ($overtime_diff > 0) {
                $work_time_1 = gmdate('H:i', $overtime_diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $overtime_diff);
                }
            }
        }
        return $over_time;
    }

//Night Shift Overtime Calculation-End
    function decimalHours($time) {
        $hms = explode(":", $time);
        return ($hms[0] + ($hms[1] / 60) + ($hms[2] / 3600));
    }

    function shiftdetail($employee_id, $date) {
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
        $shift_id = 0;
        if ($model_shift->shift_id > 0) {
            $shift_id = $model_shift->shift_id;
        }
        return $shift_id;
    }
}
