<?php

/**
 * Created :  21/02/2023
 * Created : Nisha
 */
class ApinotificationController extends Controller {

   public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('FcmtokenUpdateAdmin','LoginSuccess'),
                'users' => array('*'),
            ),
        );

    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

      public function beforeAction($action) {
            //for db connection added by nisha on 27-03-2023
            $this->ChangeDB();
            return true; 
    }

   
    public function actionFcmtokenUpdateAdmin()
    {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $responseArray =array();
        if ($userModel->id > 0)
        {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $input = file_get_contents('php://input');
            $data_array = json_decode($input, true);
            $employee_id    =   $data_array['employee_id'];
            $fcm_token   =   $data_array['fcm_token'];
            if(!empty($fcm_token) && !empty($employee_id)){
               $status= Employee::model()->updateByPk($employee_id, array('fcm_token' => $fcm_token));
               $responseArray = ["status" => "success", "message" => "Token Updated successfully"]; 
            }else{
               $responseArray = ["status" => "error", "message" => "token or Employee id not found"];  

            }
        }
        else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $responseArray = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo CJSON::encode($responseArray);
    }
 public function actionLoginSuccess() {
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);
        $user_id    = trim($variables['user_id']);
        $username   = trim($variables['name']);
        $code = 'BLUESKY';
        $device_id_input = trim($variables['device_id']);
        $device_type_input = trim($variables['device_type']);
        $app_verion_input = trim($variables['app_verion']);
        $device_description =$variables['device_description'];
        $company_id = MasCompany::getCompanyId($code);
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $user = User::model()->findBytoken($token);
        $model_device_details = User::model()->find(array('condition' => "t.username!= '" . $username . "' AND company_id='" . $company_id . "' AND device_id='" . $device_id_input . "' AND device_id!=''"));
        $model_module_app= HrModules::model()->findByPK(29);
        if(!empty($model_module_app) && $model_module_app->grant_access == 1 && $model_module_app->isActive == 'Y'){
        if ($user->id > 0 && $user->level == 2 && empty($model_device_details) && (($user->device_id != '') ? $user->device_id == $device_id_input : true)) {
            $user_id = $user->id;
            $name = $user->fullname;
            $punch_delay =0;
            //Menu Permission
            $staff_board_view = $leave_view = $ticket_encashment_view = $loan_view = $circular_view = $salary_advance_view = $expense_view = $attendance_view = $appraisal_view = $certificate_view = $suggestion_view = $late_in_view = $late_in_approval_menu=$salary_slip_view = $document_view = $notice_conduct_view = $organization_chart_view = 0;
            $leave_encashment_view = $resignation_view = $purchase_view = $expense_add=$expense_upload=$documentemp_add=$documentemp_upload=0;
            $leave_approval_menu = $loan_approval_menu = $salary_advance_approval_menu = $certificate_approval_menu = $resignation_approval_menu = $appraisal_approval_menu = $expense_approval_menu = $purchase_approval_menu = $leave_encashment_approval_menu = $ticket_encashment_approval_menu = $document_upload=$request_view=$ticket_approval_menu=$ticket_view=0;
            $machine_break_button_view=$punch_button_view=$punch_break_button_view=$salary_advance_add=$loan_add=$leave_dashboard_view=$profile_photo_view=0;
            $model_hr_settings = HrGenerelSettings::model()->find();
            $array_hr_permission = json_decode($model_hr_settings->app_permission);
            $arr_menu = array();
            $model_upload_emp_document = HrMasterUpload::model()->findByPK(1);
            if($model_hr_settings->employee_document_upload=="Y"  && $model_upload_emp_document->isActive=='Y'){
                    $document_upload =1;
                }
            //StaffBoard
            $model_module_staffboard= HrModules::model()->findByPK(22);
            if ($array_hr_permission->staff_board_view == 1 && ($model_module_staffboard->grant_access == 1 && $model_module_staffboard->isActive == 'Y')):
                $staff_board_view = 1;
            endif;
            //Circular
            $model_module_circular = HrModules::model()->findByPK(18);
            if ($array_hr_permission->circular_view == 1 && ($model_module_circular->grant_access == 1 && $model_module_circular->isActive == 'Y')):
                $circular_view = 1;
            endif;
             $model_module_attendance = HrModules::model()->findByPK(2);
            if($model_module_attendance->grant_access == 1 && $model_module_attendance->isActive == 'Y'){
                if ($array_hr_permission->punch_button_view == 1):
                    $punch_button_view = 1;
                endif;
                 if ($array_hr_permission->punch_break_button_view == 1):
                    $punch_break_button_view = 1;
                endif;
            }
            //leavedashboard
             $model_module_leave = HrModules::model()->findByPK(3);
            if($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y'){
                if ($array_hr_permission->leave_dashboard_view == 1):
                    $leave_dashboard_view = 1;
                endif;
                //Leave
                if ($array_hr_permission->leave_view == 1):
                    $leave_view = 1;
                    $model_approval_leave_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="1" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                    if ($model_approval_leave_authority > 0):
                        $leave_approval_menu = 1;
                    endif;
                endif;
            }
            
            $model_module_certificate= HrModules::model()->findByPK(10);
            if ($array_hr_permission->certificate_view == 1 && ($model_module_certificate->grant_access == 1 && $model_module_certificate->isActive == 'Y')):
                $request_view = 1;
            endif;
            //Loan
            $model_module_loan= HrModules::model()->findByPK(6);
            if ($array_hr_permission->loan_view == 1 && ($model_module_loan->grant_access == 1 && $model_module_loan->isActive == 'Y')):
                $loan_view = 1;
                $model_approval_loan_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="2" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                if ($model_approval_loan_authority > 0):
                    $loan_approval_menu = 1;
                endif;
            endif;
            //Salary Advance
            $model_module_salary_advance =HrModules::model()->findByPK(5);
            if($model_module_salary_advance->grant_access == 1 && $model_module_salary_advance->isActive == 'Y'){
                if ($array_hr_permission->salary_advance_view == 1):
                    $salary_advance_view = 1;
                    $model_approval_salaryadvance_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="3" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                    if ($model_approval_salaryadvance_authority > 0):
                        $salary_advance_approval_menu = 1;
                    endif;
                endif;
                if ($array_hr_permission->salary_advance_add == 1):
                    $salary_advance_add= 1;
                endif;
            }
            //profilephoto
            $model_upload_profile = HrMasterUpload::model()->findByPK(2);
            if ($array_hr_permission->profile_photo_view == 1 && $model_upload_profile->isActive=='Y'):
                $profile_photo_view = 1;
            endif;
            $model_module_expense= HrModules::model()->findByPK(11);
            $model_upload_expense = HrMasterUpload::model()->findByPK(28);
            if($model_module_expense->grant_access == 1 && $model_module_expense->isActive == 'Y'){
                if ($array_hr_permission->expense_add == 1):
                   $expense_add=1;
               endif;
                if ($array_hr_permission->expense_upload == 1 && $model_upload_expense->isActive=="Y"):
                   $expense_upload=1;
               endif;
            }
             //emp Document
            $model_module_employee = HrModules::model()->findByPK(1);
            if($model_module_employee->grant_access == 1 && $model_module_employee->isActive == 'Y'){
                if ($array_hr_permission->document_view == 1):
                   $document_view = 1;
                endif;
                if ($array_hr_permission->document_add == 1):
                    $documentemp_add=1;
                endif;
                if ($array_hr_permission->document_upload == 1  && $model_upload_emp_document->isActive=='Y'):
                    $documentemp_upload=1;
                endif;
            }
            //Document
            if ($array_hr_permission->certificate_view == 1 && ($model_module_certificate->grant_access == 1 && $model_module_certificate->isActive == 'Y')):
                $certificate_view = 1;
                $model_approval_doc_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="4" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                if ($model_approval_doc_authority > 0):
                    $certificate_approval_menu = 1;
                endif;
            endif;
            $punch_delay = $model_hr_settings->punch_delay;
            //Resignation
            $model_module_resignation= HrModules::model()->findByPK(14); 
            if ($array_hr_permission->resignation_view == 1 && ($model_module_resignation->grant_access == 1 && $model_module_resignation->isActive == 'Y')):
                $resignation_view = 1;
                $model_approval_resignation_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="5" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                if ($model_approval_resignation_authority > 0):
                    $resignation_approval_menu = 1;
                endif;
            endif;
            //Appraisal
            $model_module_appraisal = HrModules::model()->findByPK(12);
            if ($array_hr_permission->appraisal_view == 1 && ($model_module_appraisal->grant_access == 1 && $model_module_appraisal->isActive == 'Y')):
                  $appraisal_view = 1;
                $model_approval_appraisal_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="6" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                if ($model_approval_appraisal_authority > 0):
                    $appraisal_approval_menu = 1;
                endif;
            endif;
            //Expense
             $model_module_expense= HrModules::model()->findByPK(11);
            if ($array_hr_permission->expense_view == 1 && ($model_module_expense->grant_access == 1 && $model_module_expense->isActive == 'Y')):
                $expense_view = 1;
                $model_approval_expense_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="7" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                if ($model_approval_expense_authority > 0):
                    $expense_approval_menu = 1;
                endif;
            endif;
            //Product Purchase
             $model_module_purchase = HrModules::model()->findByPK(16);
            if ($array_hr_permission->purchase_view == 1 && ($model_module_purchase->grant_access == 1 && $model_module_purchase->isActive == 'Y')):
                $purchase_view = 1;
                $model_approval_purchase_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="8" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                if ($model_approval_purchase_authority > 0):
                    $purchase_approval_menu = 1;
                endif;
            endif;
            //Leave Encashment
             $model_module_leave_encashment= HrModules::model()->findByPK(4);
            if ($array_hr_permission->leave_encashment_view == 1  && ($model_module_leave_encashment->grant_access == 1 && $model_module_leave_encashment->isActive == 'Y')):
                $leave_encashment_view = 1;
                $model_approval_leaveencashment_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="9" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                if ($model_approval_leaveencashment_authority > 0):
                    $leave_encashment_approval_menu = 1;
                endif;
            endif;
            //Ticket 
            $model_module_ticket= HrModules::model()->findByPK(8);
            if ($array_hr_permission->ticket_view == 1 && ($model_module_ticket->grant_access == 1 && $model_module_ticket->isActive == 'Y')):
                $ticket_view = 1;
                $model_approval_tkt_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="11" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                if ($model_approval_tkt_authority > 0):
                    $ticket_approval_menu = 1;
                endif;
            endif;
            //Ticket Encashment
            $model_module_ticket_encashment= HrModules::model()->findByPK(9);
            if ($array_hr_permission->ticket_encashment_view == 1  && ($model_module_ticket_encashment->grant_access == 1 && $model_module_ticket_encashment->isActive == 'Y')):
                $ticket_encashment_view = 1;
                $model_approval_tktencashment_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="10" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                if ($model_approval_tktencashment_authority > 0):
                    $ticket_encashment_approval_menu = 1;
                endif;
            endif;
            //Attendance View
            if ($array_hr_permission->attendance_view == 1  && ($model_module_attendance->grant_access == 1 && $model_module_attendance->isActive == 'Y')):
                $attendance_view = 1;
            endif;
            //Complaint/Suggestion
             $model_request_service= HrModules::model()->findByPK(31);
            if ($array_hr_permission->suggestion_view == 1 && ($model_request_service->grant_access == 1 && $model_request_service->isActive == 'Y')):
                $suggestion_view = 1;
            endif;
            
            //Salary Slip
            $model_module_payroll= HrModules::model()->findByPK(7);
            if ($array_hr_permission->salary_slip_view == 1 && ($model_module_payroll->grant_access == 1 && $model_module_payroll->isActive == 'Y')):
                $salary_slip_view = 1;
            endif;
            
            //Notice of Conduct
             $model_module_notice_conduct= HrModules::model()->findByPK(24);
            if ($array_hr_permission->notice_conduct_view == 1  && ($model_module_notice_conduct->grant_access == 1 && $model_module_notice_conduct->isActive == 'Y')):
                $notice_conduct_view = 1;
            endif;
            if ($array_hr_permission->loan_add == 1 && ($model_module_loan->grant_access == 1 && $model_module_loan->isActive == 'Y')):
                $loan_add = 1;
            endif;
            //Organization Chart
            $model_line_manager = Employee::model()->count(array('condition' => 'reporting_manager="' . $user->employee_id . '"'));
            if ($array_hr_permission->organization_chart_view == 1 && $model_line_manager > 0  && ($model_module_employee->grant_access == 1 && $model_module_employee->isActive == 'Y')):
                $organization_chart_view = 1;
            endif;
            //Excuse/Meeting
            $model_module_flexitime= HrModules::model()->findByPK(32);
            if($model_module_flexitime->grant_access == 1 && $model_module_flexitime->isActive == 'Y'){
                if ($array_hr_permission->late_in_add_view == 1):
                    $excuse_add = 1;
                endif;
                if ($array_hr_permission->late_in_view == 1):
                    $late_in_view = 1;
                    $model_approval_excuse_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="12" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                    if ($model_approval_excuse_authority > 0):
                        $late_in_approval_menu = 1;
                    endif;
                endif;
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
            $arr_menu["staff_board_view"] = $staff_board_view;
            $arr_menu["circular_view"] = $circular_view;
            $arr_menu["leave_view"] = $leave_view;
            $arr_menu["leave_dashboard_view"] = $leave_dashboard_view;
            $arr_menu["leave_approval_menu"] = $leave_approval_menu;
            $arr_menu["loan_view"] = $loan_view;
            $arr_menu["loan_add"] = $loan_add;
            $arr_menu["loan_approval_menu"] = $loan_approval_menu;
            $arr_menu["salary_advance_view"] = $salary_advance_view;
            $arr_menu["salary_advance_add"] = $salary_advance_add;
            $arr_menu["salary_advance_approval_menu"] = $salary_advance_approval_menu;
            $arr_menu["certificate_view"] = $certificate_view;
            $arr_menu["profile_photo_view"] = $profile_photo_view;
            $arr_menu["certificate_approval_menu"] = $certificate_approval_menu;
            //            $arr_menu["resignation_view"]=$resignation_view;
            //            $arr_menu["resignation_approval_menu"]=$resignation_approval_menu;
            $arr_menu["appraisal_view"] = $appraisal_view;
            $arr_menu["appraisal_approval_menu"] = $appraisal_approval_menu;
            $arr_menu["expense_view"] = $expense_view;
            $arr_menu["expense_approval_menu"] = $expense_approval_menu;
            $arr_menu["purchase_view"] = $purchase_view;
            $arr_menu["purchase_approval_menu"] = $purchase_approval_menu;
            $arr_menu["leave_encashment_view"] = $leave_encashment_view;
            $arr_menu["leave_encashment_approval_menu"] = $leave_encashment_approval_menu;
            $arr_menu["ticket_encashment_view"] = $ticket_encashment_view;
            $arr_menu["ticket_encashment_approval_menu"] = $ticket_encashment_approval_menu;
            $arr_menu["ticket_view"] = $ticket_view;
            $arr_menu["ticket_approval_menu"] = $ticket_approval_menu;
            $arr_menu["attendance_view"] = $attendance_view;
            $arr_menu["suggestion_view"] = $suggestion_view;
            $arr_menu["late_in_view"] = $late_in_view;
            $arr_menu["late_in_approval_menu"] = $late_in_approval_menu;
            $arr_menu["late_in_add"] = $excuse_add;
            $arr_menu["salary_slip_view"] = $salary_slip_view;
            $arr_menu["document_view"] = $document_view;
            $arr_menu["notice_conduct_view"] = $notice_conduct_view;
            $arr_menu["organization_chart_view"] = $organization_chart_view;
            $arr_menu["document_upload"] = $document_upload;
            $arr_menu["request_view"] = $request_view;
            //added on 12-02-2024
            $arr_menu["expense_add"] = $expense_add;
            $arr_menu["expense_upload"] = $expense_upload;
            $arr_menu["document_emp_add"] = $documentemp_add;
            $arr_menu["document_emp_upload"] = $documentemp_upload;
            
            $arr_menu["punch_button_view"] = $punch_button_view;
            $arr_menu["punch_break_button_view"] = $punch_break_button_view;
            $arr_menu["punch_delay_time"] = $punch_delay;
            //end
            $model_employee = Employee::model()->findByPk($user->employee_id);
            $model_company = MasCompany::model()->findByPk($company_id);
            $company_logo = "images/" . $model_company->company_logo;
            $profile_pic = "uploads/profilephotos/" . $model_employee->profile_photo;
            $sal_slip_app_view =0; 
            if($model_employee->branch_sponsor->salary_slip_view_ess =="Y"){
                $sal_slip_app_view =1; 
            }
            $arr_menu["salary_slip_view_ess"] = $sal_slip_app_view;
            $data = array('status' => "success", "data" => ["pic" => $profile_pic, "user_id" => (string) $user_id,"code" => $model_employee->employeecode,'username'=>$user->username, "name" => $model_employee->employeefullname, "employee_id" => (string) $user->employee_id, "_token" => $user->token, "code" => $model_employee->employeecode, "baseUrl" => $model_company->company_baseurl, "company_logo" => $company_logo]);
            $data = array_merge($data, $arr_menu);
            $device_id = $user->device_id;
            $device_type = $user->device_type;
            if ($device_id_input != "" || $device_type_input != "") {
                if ($device_id == "" && $device_type == "") {
                    if ($model_hr_settings->app_version != $app_verion_input && $model_hr_settings->review_app_version != $app_verion_input) {
                        $data = array('status' => "failed", 'msg' => "Version mismatch.Please update your App");
                    } else {
                        $status = User::model()->updateByPk($user_id, array('device_id' => $device_id_input, 'device_type' => strtoupper($device_type_input), 'device_description' => $device_description));
                    }
                } else if (($device_id != $device_id_input)) {
                    $data = array('status' => "failed", 'msg' => "Device ID mismatch");
                } else if ($device_type != strtoupper($device_type_input)) {
                    $data = array('status' => "failed", 'msg' => "Device Type mismatch");
                } else if ($model_hr_settings->app_version != $app_verion_input && $model_hr_settings->review_app_version != $app_verion_input) {
                    $data = array('status' => "failed", 'msg' => "Version mismatch.Please update your App");
                }
            } else {
                $data = array('status' => "failed", 'msg' => "Device Id or Device type missing");
            }
        }  else {
            if (!empty($model_device_details)) {
                $data = array('status' => "failed", 'msg' => "Device Details Already Register with employee (" . $model_device_details->employee_details->employeefullname . " - " . $model_device_details->employee_details->employeecode . ")");
            } else if (!empty($user)) {
                //Check Password 
                // echo "test";die;
                if (strtolower($user->username) != strtolower($username)) {
                    $data = array('status' => "failed", 'msg' => "Incorrect Username");
                }  else {
                    $data = array('status' => "failed", 'msg' => "Device Id or Device type missing/Incorrect Password ");
                }
          
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $data['status'] = 'failed';
                $data['msg'] = 'Unauthorized user';
        }
        }
        }else{
            if (!empty($user)) {
                  $status = User::model()->updateByPk($user_id, array('token' => ''));
            }
            $data = array('status' => "failed", 'msg' => "You are  not authorized to login");
        }
        echo json_encode($data);
    }


}

