<?php
//added by nisha on 09-10-2024
class ApiloandetailController extends Controller {
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('GetStaffpurchaseList','repaymentMonths','repaymentyears','SaveEmployeeloan','LoanDetailsById','GetPendingLoanDetails','SaveApproveloan','deleteLoandetail'),
                'users' => array('*'),
            ),
        );
    }
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function beforeAction($action) {
        //for db connection added by nisha on 27-03-2023
        $this->ChangeDB();
        return true;
    }
    public function actionGetStaffpurchaseList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = (int) $data_array['employee_id'];
            $condition = "employee_id ='" . $employee_id . "'";
            EmployeeLoanDetail::model()->updateAll(array('view_status' => 1, 'updated_by' => $userModel->id, 'updated_date_time' => date('Y-m-d H:i:s')), 'employee_id="' . $employee_id . '" and view_status="0" and (loan_status="12" OR loan_status="13")');
            $model = new EmployeeLoanDetail();
            $model = $model->with('employeedetail')->findAll(array('condition' => $condition,'order'=>'t.id desc'));
            $response = array();
            foreach ($model as $value) {
                $show_btn_edit=$show_btn_delete=0;
                if($value->loan_status==1){
                    $show_btn_edit=1;
                    $show_btn_delete=1;
                }
                $apply_date = "";
                if ($value->apply_date != '' && $value->apply_date != '0000-00-00') {
                    $apply_date = date("d/m/Y", strtotime($value->apply_date));
                }
                $approved_date = "";
                if ($value->approved_date != '0000-00-00') {
                    $approved_date = date("d/m/Y", strtotime($value->approved_date));
                }
                $paymentdate = "";
                if ($value->payment_date != '0000-00-00') {
                    $paymentdate = date("d/m/Y", strtotime($value->payment_date));
                }
                $repayment_start="";
                if($value->repayment_start_year>0){
                    $repayment_start =HrGenerelSettings::getMonthName1($value->repayment_start_month)." ".$value->repayment_start_year;
                }
                $data[] = array(
                    "id" => $value->id,
                    "employee_code" => $value->employeedetail->employeecode,
                    "employee_name" => $value->employeedetail->employeefullname,
                    "loan_amount" => $value->loan_amount,
                    "loan_monthly_payment" => $value->loan_monthly_payment,
                    "loan_total_installment" => $value->loan_total_installment,
                    "apply_date" => $apply_date,
                    "approved_date" => $approved_date,
                    "payment_date" => $paymentdate,
                    "amount_paid" =>($value->loan_amount - $value->loan_repayment),
                    "loan_status" => EmployeeLoanDetail::getLoanStatus($value->loan_status),
                    "repayment_start"=>$repayment_start,
                    "show_button_edit"=> $show_btn_edit,
                    "show_button_delete"=> $show_btn_delete
                );
            }
            $response=array('status' => 'success','msg'=>'success','data'=>$data);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        if (empty($data)) {
            $response = array('status' => "failed",'msg' => "No Data Available");
        }
        echo json_encode($response);
    }
    
    public function actionSaveEmployeeloan() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        $modelloan = new EmployeeLoanDetail();
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            if(!empty($data_array)){
                $employee_id = $data_array['employee_id'];
                $id = $data_array['id'];
                if (isset($id) && $id > 0) {
                    $id = (int) $id;
                    $modelloan = EmployeeLoanDetail::model()->findByPK($id);
                    $modelloan->updated_by = $userModel->id;
                    $modelloan->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $modelloan->apply_date = date("Y-m-d");
                    $modelloan->created_by = $userModel->id;
                    $modelloan->created_date_time = date('Y-m-d H:i:s');
                }
                $modelloan->loan_amount = $data_array['loan_amount'];
                $modelloan->employee_id = $data_array['employee_id'];
                $modelloan->proposed_installment = $data_array['proposed_installment'];//no of intallment
                $modelloan->proposed_monthly_installment = $data_array['proposed_monthly_installment'];//intallment amount
                $modelloan->reason_loan = $data_array['reason_loan'];
                $modelloan->repayment_start_month = $data_array['repayment_start_month'];
                $modelloan->repayment_start_year = $data_array['repayment_start_year'];
                $repayment_date =$data_array['repayment_start_year']."-".$data_array['repayment_start_month']."-01";
                $modelloan->repayment_start_date = $repayment_date;
            
                $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="2"'));
                if (!empty($model_master_approve_setting)) {
                    $modelloan->function_type = $model_master_approve_setting->id;
                    $modelloan->max_level = $model_master_approve_setting->max_level;
                }
                $modelloan->loan_status = 1;
                if ($modelloan->validate()) {
                    $modelloan->save();
                    //Mail
                /*    $model_settings = HrGenerelSettings::model()->find();
                    $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="14"'));
                    if (!empty($model_settings) && !empty($model_mail_settings)) {
                        if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                            Yii::import('application.modules.hr.controllers.MailController');
                            MailController::sendmail(14, $modelloan->employee_id, $modelloan->id);
                        }
                    }*/
                    $response = array('status' => "success", "msg" => "success", 'id' => $modelloan->id);
                } else {
                    foreach ($modelloan->errors as $t => $value) {
                        $arr_err[] = $value[0];
                    }
                    $response = array('status' => 'error', 'msg' => $arr_err);
                }
            }else{
                 $response = array('status' => "failed", "msg" => "Input parameters Missing");
            }
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "msg" => "Unauthorized user");
            }
        echo json_encode($response);
    }
    public function actionLoanDetailsById() {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            if ($userModel->id > 0) {
                $data_array = json_decode(file_get_contents('php://input'), true);
                $id = (int) $data_array['id'];
                if ($id > 0) {
                    $modelloan = EmployeeLoanDetail::model()->findByPK($id);
                    $repayment_month_name="";
                    if($modelloan->repayment_start_month>0){
                        $repayment_month_name = HrGenerelSettings::getMonthName1($modelloan->repayment_start_month);
                    }
                    $data = array(
                        "id" => $modelloan->id,
                        "employee_id" => $modelloan->employee_id,
                        "proposed_installment" => $modelloan->proposed_installment,
                        "loan_amount" => $modelloan->loan_amount,
                        "proposed_monthly_installment" => $modelloan->proposed_monthly_installment,
                        "reason_loan" => $modelloan->reason_loan,
                        "repayment_start_month"=>$modelloan->repayment_start_month,
                        "repayment_start_year"=>$modelloan->repayment_start_year,
                        "repayment_start_month"=>$modelloan->repayment_start_month,
                        "repayment_month_name"=>$repayment_month_name,
                        "repayment_year_name"=>$modelloan->repayment_start_year
                    );
                    $response = array('status' => 'success', 'msg' => 'success', 'data' => $data);
                } else {
                    $response = array('status' => "failed", "msg" => "Input missing");
                }
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $response = array('status' => "failed", "msg" => "Unauthorized user");
            }
            if (empty($data)) {
                $response = array('status' => "failed", 'msg' => "No Data Available");
            }
            echo json_encode($response);
        }
    public function actionGetPendingLoanDetails() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = (int) $data_array['employee_id'];
            $condition = "employee_id ='" . $employee_id . "'";
            $pending_loans=EmployeeLoanDetail::getintermediateapproval($employee_id,1);
            $condition = 'employeedetail.isActive="Y" AND last_approved_level<t.max_level AND t.id IN('.$pending_loans.')';
            $model = new EmployeeLoanDetail();
            $model = $model->with('employeedetail')->findAll(array('condition' => $condition));
            $response = array();
            foreach ($model as $row)
            {
                $button_string = "";
                $last_approved_level=$row->last_approved_level;
                $next_approval_level=$last_approved_level+1;
                $show_approve_button=0;
                $level_no=0;
                $final_level='N';
                if($next_approval_level<=$row->max_level){
                    if($next_approval_level==1 && (($row->approvelevel->level_1_type=='L' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='S' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='N' && $row->approvelevel->level_1_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=1;
                    }else if($next_approval_level==2 && (($row->approvelevel->level_2_type=='L' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='S' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='N' && $row->approvelevel->level_2_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=2;
                    }else if($next_approval_level==3 && (($row->approvelevel->level_3_type=='L' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='S' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='N' && $row->approvelevel->level_3_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=3;
                    }else if($next_approval_level==4 && (($row->approvelevel->level_4_type=='L' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='S' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='N' && $row->approvelevel->level_4_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=4;
                    }else if($next_approval_level==5 && (($row->approvelevel->level_5_type=='L' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='S' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='N' && $row->approvelevel->level_5_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=5;
                    }
                }
                if($next_approval_level==$row->max_level){
                    $final_level='Y';
                }
                $repayment_start=$repayment_month_name="";
                if($row['repayment_start_year']>0){
                    $repayment_start =HrGenerelSettings::getMonthName1($row['repayment_start_month'])." ".$row['repayment_start_year'];
                    $repayment_month_name =HrGenerelSettings::getMonthName1($row['repayment_start_month']);
                }
                $applydate = date("d/m/Y", strtotime($row['apply_date']));		
                    $data[] = array(
                        "id" => $row->id,
                        "employee_code" => $row->employeedetail->employeecode,
                        "employee_name" => $row->employeedetail->employeefullname,
                        "loan_amount" => $row->loan_amount,
                        "loan_monthly_payment" => $row->loan_monthly_payment,
                        "loan_total_installment" => $row->loan_total_installment,
                        "date_apply"=>$applydate,
                        "proposed_installment"=>$row->proposed_installment,
                        "proposed_monthly_installment"=>$row->proposed_monthly_installment,
                        "show_approve_button"=>$show_approve_button,
                        "loan_status"=>  EmployeeLoanDetail::getLoanStatus($row->loan_status),
                        "next_approval_level"=>$level_no,
                        "final_level"=>$final_level,
                        "repayment_start"=>$repayment_start,
                        "repayment_start_month"=>$row->repayment_start_month,
                        "repayment_start_year"=>$row->repayment_start_year,
                        "repayment_month_name"=>$repayment_month_name,
                        "repayment_year_name"=>$row->repayment_start_year
                        );
            }
            $response = array('status' => 'success', 'msg' => 'success', 'data' => $data);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        if (empty($data)) {
            $response = array('status' => "failed", 'msg' => "No Data Available");
        }
        echo json_encode($response);
    }
    public function actionSaveApproveloan() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        $modelloan = new EmployeeLoanDetail();
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            if (!empty($data_array)) {
                $valid=true;
                $employee_id = $data_array['employee_id'];
                $id = $data_array['id'];
                if ($id > 0) {
                    $modelloan = EmployeeLoanDetail::model()->findByPK($id);
                    $modelloan->updated_by = $userModel->id;
                    $modelloan->updated_date_time = date('Y-m-d H:i:s');
                    $modelloan->loan_monthly_payment = $data_array['loan_monthly_payment'];
                    $modelloan->loan_total_installment = $data_array['loan_total_installment'];
                    $modelloan->repayment_start_month=$data_array['repayment_start_month']; 	
                    $modelloan->repayment_start_year=$data_array['repayment_start_year']; 	
                    $modelloan->repayment_start_date=$data_array['repayment_start_year']."-".$data_array['repayment_start_month']."-01"; 	

                } else {
                    $modelloan->apply_date = date("Y-m-d");
                    $modelloan->created_by = $userModel->id;
                    $modelloan->created_date_time = date('Y-m-d H:i:s');
                }
                $level = $data_array['approval_level'];
                $final_level = $data_array['final_level'];
                $modelloan->last_approved_level = $data_array['approval_level'];
                if ($level == 1  && $final_level=='N') {
                    $modelloan->approve_level1_date = date('Y-m-d');
                    $modelloan->approve_level1_comment = $data_array['approval_comment'];
                    $modelloan->approve_level1_id = $employee_id;
                } else if ($level == 2 && $final_level=='N') {

                    $modelloan->approve_level2_date = date('Y-m-d');
                    $modelloan->approve_level2_comment = $data_array['approval_comment'];
                    $modelloan->approve_level2_id = $employee_id;
                } else if ($level == 3 && $final_level=='N') {
                    $modelloan->approve_level3_date = date('Y-m-d');
                    $modelloan->approve_level3_comment = $data_array['approval_comment'];
                    $modelloan->approve_level3_id = $employee_id;
                } else if ($level == 4 && $final_level=='N') {
                    $modelloan->approve_level4_date = date('Y-m-d');
                    $modelloan->approve_level4_comment = $data_array['approval_comment'];
                    $modelloan->approve_level4_id = $employee_id;
                } else if ($level == 5 && $final_level=='N') {
                    $modelloan->approve_level5_date = date('Y-m-d');
                    $modelloan->approve_level5_comment = $data_array['approval_comment'];
                    $modelloan->approve_level5_id = $employee_id;
                }
                if ($final_level == 'Y') {
                    $modelloan->approved_date = date('Y-m-d');
                    $modelloan->approval_comment = $data_array['approval_comment'];
                    $modelloan->approved_by = $employee_id;
                }
                $status_v = $data_array['loan_status'];
                if ($final_level == 'Y') {
                    if ($status_v == 'A') {
                        $status = 12;
                    } else {
                        $status = 13;
                    }
                } else if ($level == 1) {
                    if ($status_v == 'A') {
                        $status = 2;
                    } else {
                        $status = 3;
                    }
                } else if ($level == 2) {
                    if ($status_v == 'A') {
                        $status = 4;
                    } else {
                        $status = 5;
                    }
                } else if ($level == 3) {
                    if ($status_v == 'A') {
                        $status = 6;
                    } else {
                        $status = 7;
                    }
                } else if ($level == 4) {
                    if ($status_v == 'A') {
                        $status = 8;
                    } else {
                        $status = 9;
                    }
                } else if ($level == 5) {
                    if ($status_v == 'A') {
                        $status = 10;
                    } else {
                        $status = 11;
                    }
                }
                $modelloan->loan_status = $status;
                $valid=$modelloan->validate();
                if($status_v=='A'){
                    $status_msg = "Loan Approved";
                    if($data_array['loan_total_installment']=='' || $data_array['loan_total_installment']==0){
                        $arr_err[] = 'No of Installments must be greater than zero';
                        $valid=false;
                    }
                    if($data_array['loan_monthly_payment']=='' || $data_array['loan_monthly_payment']==0){
                        $arr_err[] = 'Monthly payment must be greater than zero';
                        $valid=false;
                    }
                }else{
                     $status_msg = "Loan Rejected";
                }
                if ($valid) {
                    $modelloan->save();
                    //Mail
                    /*    $model_settings = HrGenerelSettings::model()->find();
                      $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="14"'));
                      if (!empty($model_settings) && !empty($model_mail_settings)) {
                      if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                      Yii::import('application.modules.hr.controllers.MailController');
                      MailController::sendmail(14, $modelloan->employee_id, $modelloan->id);
                      }
                      } */
                    $response = array('status' => "success", "msg" => $status_msg, 'id' => $modelloan->id);
                } else {
                    foreach ($modelloan->errors as $t => $value) {
                        $arr_err[] = $value[0];
                    }
                    $response = array('status' => 'error', 'msg' => $arr_err);
                }
            } else {
                $response = array('status' => "failed", "msg" => "Input parameters Missing");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($response);
    }
   
     public function actiondeleteLoandetail() {
         $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array['id'];
            $model = EmployeeLoanDetail::model()->findbyPK($id);
            if ($model->loan_status == 1) {
                $status = $model->deleteByPk($id);
                if ($status == 1) {
                    $response = array('status' => "success", "msg" => "Loan Deleted Successfully");
                    $data['status'] = 'success';
                } else {
                    $response = array('status' => "failed", "msg" => "Loan deletion Failed");
                }
            } else {
                $response = array('status' => "failed", "msg" => "Deletion not Possible");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data);
        }
        echo json_encode($response);
    }
    public function actionrepaymentMonths() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if ($userModel->id > 0) {
        $data = [];
        $selected_months= HrGenerelSettings::listSelectedMonth();
         foreach ($selected_months as $row => $val) {
            $data[] = [
                "id" => $row,
                "month" => $val,
            ];
}
            $response= array('status' => "success","msg"=>"success","data"=>$data);
            if(empty($data)){
                $response= array('status' => "failed","msg"=>"No data available","data"=>$data);
            }
       }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response= array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($response);
    }
    public function actionrepaymentyears() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if ($userModel->id > 0) {
        $data = [];
        $selected_months= HrGenerelSettings::listYears(0,1);
         foreach ($selected_months as $row => $val) {
            $data[] = [
                "id" => $row,
                "year" => $val,
            ];
            }
            $response= array('status' => "success","msg"=>"success","data"=>$data);
            if(empty($data)){
                $response= array('status' => "failed","msg"=>"No data available","data"=>$data);
            }
       }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response= array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($response);
    }
}
