<?php

class ApihrpurchaseController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('GetPurchaseList','SavePurchase','EditPurchase','GetPurchaseApproval','SavePurchaseApproval','getproductlist','Getproductdetails'),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        $company_db_name = "cumulush_2021_hr_bluesky";
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
        return parent::beforeAction($action);
    }
    public function actionGetPurchaseList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id = $_REQUEST['id'];
            $condition = 'employee_id="'.$employee_id.'"';
            $model = new EmployeePurchase();
            $model = $model->with('employeedetail')->findAll(array('condition' => $condition));
            $data = array();
            $payment_mode=array(1=>'Cash',2=>'From Salary');
            foreach ($model as $value) {
                $date_apply=$approved_date=$payment_date="";
                if ($value->apply_date!= '' && $value->apply_date!= '0000-00-00') {
                    $date_apply = date("d/m/Y", strtotime($value->apply_date));
                }
                $edit_button=0;
                if ($value->status==1) {
                    $edit_button=1;
                }
                $data[] = array(
                    "id" => $value->id,
                    "date_apply" => $date_apply,
                    "payment_mode"=>$payment_mode[$value->payment_mode],
                    "payment_date"=>$payment_date,
                    "grand_total" => $value->grand_total,
                    "status"=>EmployeePurchase::getStatus($value->status),
                    "edit_button"=>$edit_button);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[] = array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionSavePurchase() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true); 
            $user_id   = $userModel->id;
            $validate=true;
            $model  = new EmployeePurchase();
            if ((int)$data_array['id'] > 0) {
                $id =  (int)$data_array['id'];
                $model = $model->findByPK($id);
                $model->updated_by = (int)$user_id;
                $model->updated_date_time =date('Y-m-d H:i:s');
            }else{
                $model->created_by = $user_id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->apply_date = date('Y-m-d');
            }          
            $model->employee_id = $data_array['employee_id'];
            $model->payment_mode = $data_array['payment_mode'];
            $model->grand_total = $data_array['grand_total'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$data_array["employee_id"].'" and functionality_id="8"'));
            $model->function_type = $model_master_approve_setting->id;
            $model->status =1;
            $validate = $model->validate();
            if (is_array($data_array['purchasedetails'])) 
            {
              foreach ($data_array['purchasedetails'] as $i => $items) 
                {
                    if((int)$items['id']>0){
                        $modalpurchasedetails[$i] = EmployeePurchaseDetail::model()->findByPk((int)$items['id']);
                        $modalpurchasedetails[$i]->updated_by = Yii::app()->user->id;
                        $modalpurchasedetails[$i]->updated_date_time = date('Y-m-d H:i:s');
                    }else{
                        $modalpurchasedetails[$i] = new EmployeePurchaseDetail();
                        $modalpurchasedetails[$i]->created_by = Yii::app()->user->id;
                        $modalpurchasedetails[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $modalpurchasedetails[$i]->product_id = $items['product_id'];
                    $modalpurchasedetails[$i]->quantity = $items['quantity'];
                    $modalpurchasedetails[$i]->cost = $items['cost'];
                    $modalpurchasedetails[$i]->amount = $items['amount'];
                    $modalpurchasedetails[$i]->total_amount = $items['total_amount'];
                    $validate = $modalpurchasedetails[$i]->validate() && $validate;
                }
            }
            if($validate){
                $model->save();
                if(!empty($modalpurchasedetails)){
                    foreach ($modalpurchasedetails as $eachModel) 
                    {
                        $eachModel->purchase_id=$model->id;
                        $eachModel->save();
                    }
                }
                //Mail
//                $model_settings = HrGenerelSettings::model()->find();
//                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="28"'));
//                if(!empty($model_settings)){
//                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                         Yii::import('application.modules.hr.controllers.MailController');
//                         MailController::sendmail(28,$model->employee_id,$model->id);
//                    }
//                }
                $data['status'] = 'success';
    
            } else {
                $data['status'] = 'error';
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = json_decode(CActiveForm::validateTabular($modalpurchasedetails, '', false), true);
                $error = array_merge_recursive($error1, $error2);
                foreach($error as $a=>$eacherror){
                    $other[]= $eacherror[0];
                }      
                if ($error != '[]'){
                    $data['msg'] =implode(',',$other);
                }
            }
            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionEditPurchase() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $id =(int)$_REQUEST['id'];
            $model = EmployeePurchase::model()->findByPK($id);
            $data['id'] = $model->id;
            $data['employee_id'] = $model->employee_id;
            $data['payment_mode'] = $model->payment_mode;
            $data['grand_total'] = $model->grand_total;
            $model_details = EmployeePurchaseDetail::model()->findAll(array('condition' => 'purchase_id="'.$id.'"'));
            if(!empty($model_details)){
                foreach ($model_details as $i => $each){  
                    $data['items'][] = [
                        "id" => $each->id,
                        "product_id" => $each->product_id,
                        "quantity" =>$each->quantity,
                        "cost" =>$each->cost,
                        "amount" =>$each->amount,
                        "total_amount" =>$each->total_amount
                    ];
                }
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionGetPurchaseApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id =(int)$_REQUEST['id'];
            $pending_purchase=EmployeePurchase::getintermediateapproval($employee_id,1);
            $condition = 'employeedetail.isActive="Y" AND last_approved_level<approvelevel.max_level AND t.id IN('.$pending_purchase.')';
            $data = [];
            $model = new EmployeePurchase();
            $model = $model->with('employeedetail','approvelevel')->findAll(array('condition' => $condition, 'order' => 'apply_date asc'));
            $payment_mode=array(1=>'Cash',2=>'From Salary');
            foreach ($model as $row) {
                $last_approved_level=$row->last_approved_level;
                $next_approval_level=$last_approved_level+1;
                $show_approve_button=0;
                $level_no=0;
                $final_level='N';
                if($next_approval_level<=$row->approvelevel->max_level){
                    if($next_approval_level==1 && (($row->approvelevel->level_1_type=='L' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='S' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='N' && $row->approvelevel->level_1_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=1;
                    }else if($next_approval_level==2 && (($row->approvelevel->level_2_type=='L' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='S' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='N' && $row->approvelevel->level_2_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=2;
                    }else if($next_approval_level==3 && (($row->approvelevel->level_3_type=='L' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='S' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='N' && $row->approvelevel->level_3_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=3;
                    }else if($next_approval_level==4 && (($row->approvelevel->level_4_type=='L' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='S' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='N' && $row->approvelevel->level_4_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=4;
                    }else if($next_approval_level==5 && (($row->approvelevel->level_5_type=='L' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='S' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='N' && $row->approvelevel->level_5_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=5;
                    }
                }
                if($next_approval_level==$row->approvelevel->max_level){
                    $final_level='Y';
                }
                $apply_date='';
                if ($row->apply_date!= '' && $row->apply_date!= '0000-00-00') {
                    $apply_date = date("d/m/Y", strtotime($row->apply_date));
                }
                $data[] = array(
                    "id" => $row->id,
                    "employee_name" => $row->employeedetail->employeefullname,
                    "employeecode" => $row->employeedetail->employeecode,
                    "apply_date" => $apply_date,
                    "payment_mode"=>$payment_mode[$row->payment_mode],
                    "grand_total" => $row->grand_total,
                    "status"=>EmployeePurchase::getStatus($row->status),
                    "approve_btn" => $show_approve_button);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[] = array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionSavePurchaseApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array["id"];
            $user_id   = $userModel->id;
            $status_v = $data_array["status"];//A-Approved,R-Rejected
            $comment = $data_array["comment"];
            if ($id>0 && $status_v!='' && $user_id>0) {
                $model= EmployeePurchase::model()->findByPK($id); 
                $model->updated_by=$user_id;
                $model->updated_date_time = date('Y-m-d H:i:s');
                $final_level='N';
                $status=0;
                $modelemployee = User::model()->findByPK($user_id);
                //For Approval Level-Start
                 if($model->last_approved_level!=$model->approvelevel->max_level){
                     $level=$model->last_approved_level+1;
                     if($level==$model->approvelevel->max_level){
                         $final_level='Y';
                     }
                     if ($final_level == 'Y') {
                         if($status_v=='A'){
                             $status=12;
                         }else {
                             $status=13;
                         }
                         $model->approved_date = date('Y-m-d');
                         $model->approval_comment = $comment;
                         $model->approved_by =$modelemployee->employee_id;
                     } else if ($level == 1) {
                         if($status_v=='A'){
                             $status=2;
                         }else {
                             $status=3;
                         }
                         $model->approve_level1_date = date('Y-m-d');
                         $model->approve_level1_comment = $comment;
                         $model->approve_level1_id = $modelemployee->employee_id;
                     } else if ($level == 2) {
                         if($status_v=='A'){
                             $status=4;
                         }else {
                             $status=5;
                         }
                         $model->approve_level2_date = date('Y-m-d');
                         $model->approve_level2_comment = $comment;
                         $model->approve_level2_id = $modelemployee->employee_id;
                     } else if ($level == 3) {
                         if($status_v=='A'){
                             $status=6;
                         }else {
                             $status=7;
                         }
                         $model->approve_level3_date = date('Y-m-d');
                         $model->approve_level3_comment = $comment;
                         $model->approve_level3_id = $modelemployee->employee_id;
                     } else if ($level == 4) {
                         if($status_v=='A'){
                             $status=8;
                         }else {
                             $status=9;
                         }
                         $model->approve_level4_date = date('Y-m-d');
                         $model->approve_level4_comment = $comment;
                         $model->approve_level4_id = $modelemployee->employee_id;
                     } else if ($level == 5) {
                         if($status_v=='A'){
                             $status=10;
                         }else {
                             $status=11;
                         }
                         $model->approve_level5_date = date('Y-m-d');
                         $model->approve_level5_comment = $comment;
                         $model->approve_level5_id = $modelemployee->employee_id;
                    }
                    $model->last_approved_level =$level;
                 }
                 //For Approval Level-End
                 //Status End
                 //Updating Table
                $model->status = $status;
                $model->save();
                //Mail
//                $model_settings = HrGenerelSettings::model()->find();
//                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="29"'));
//                if(!empty($model_settings)){
//                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                         Yii::import('application.modules.hr.controllers.MailController');
//                         MailController::sendmail(29,$model->employee_id,$model->id);
//                    }
//                }
                $data['status'] = 'success';
                $data['message'] ='Purchase Details Updated Successfylly';
            }else{
                if($id==''){
                    $data['message'] ='Error in getting Purchase Details';
                }else if($status_v==''){
                    $data['message'] ='Please Select Status';
                }else if($user_id==''){
                    $data['message'] ='Cannot Access User Details';
                }
                $data['status'] = 'error';
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actiongetproductlist() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id = $_REQUEST['id'];
            $condition = 'isActive =  "Y"';
            $model = HrMasProduct::model()->findAll(array('condition' => $condition,'order'=>'product_code'));
            $data=array();
            foreach ($model as $key => $value) {
                 $data[] = array(
                    "id" => $value->id,
                    "value" => $value->productdetail);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionGetproductdetails(){
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $product_id = $_REQUEST['id'];
            $model_product=HrMasProduct::model()->findbyPK($product_id);
            $jsonData['cost_price'] = $model_product->cost_price;   
            $jsonData['selling_price'] = $model_product->selling_price;   
            $jsonData['status'] = 'success';
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $jsonData = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        echo CJSON::encode($jsonData);  
    }
}
