<?php

class ApiencashmentController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('getleavelist','TicketApplyStatus','GetTicketEncashmentList','SaveTicketEncashment','GetTicketEncashmentApproval','SaveTicketEncashmentApproval','EncashmentApprovalDocument','UploadDocument',
                    'GetLeaveEncashmentList','SaveLeaveEncashment','GetLeaveEncashmentApproval','SaveLeaveEncashmentApproval'),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        $company_db_name = "cumulush_2021_hr_bluesky";
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
        return parent::beforeAction($action);
    }
    public function actionTicketApplyStatus() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id =(int)$_REQUEST['id'];
            $year =(int)$_REQUEST['year'];
            $leavetype =(int)$_REQUEST['leavetype'];
            $model_ticket = EmployeeTicket::model()->find(array('condition'=>'employee_id="'.$employee_id.'" and leave_type="'.$leavetype.'" and year="'.$year.'" and status!="3" AND ticket_type="E"'));
            $model_ticket_encashed = EmployeeTicketEncashment::model()->find(array('condition'=>'employee_id="'.$employee_id.'" and leave_id="'.$leavetype.'" and year="'.$year.'" and (status!="3" OR status!="5" OR status!="7" OR status!="9" OR status!="11" OR status!="13")'));
            if(empty($model_ticket) && empty($model_ticket_encashed)){
                $jsonData['status'] = 'success';
            }else{
                $jsonData['status'] = 'error';
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $jsonData[] = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        echo json_encode($jsonData);
    }
    public function actiongetleavelist() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id = $_REQUEST['id'];
            $model_employee = Employee::model()->findByPK($employee_id);
            $condition = 'isActive =  "Y" and ticket_available="Y" AND branch_id="'.$model_employee->branch_or_sponsor_id. '"';
            $model = MasLeave::model()->findAll(array('condition' => $condition,'order'=>'leave_name'));
            $data=array();
            foreach ($model as $key => $value) {
                 $data[] = array(
                    "id" => $value->id,
                    "value" => $value->leave_name);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionGetTicketEncashmentList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id = $_REQUEST['id'];
            $condition = 'employee_id="'.$employee_id.'"';
            $model = new EmployeeTicketEncashment();
            $model = $model->with('employeedetail')->findAll(array('condition' => $condition));
            $data = array();
            $m = 1;
            foreach ($model as $value) {
                $date_apply=$approved_date=$payment_date="";
                if ($value->date_apply!= '' && $value->date_apply!= '0000-00-00') {
                    $date_apply = date("d/m/Y", strtotime($value->date_apply));
                }
                if ($value->approved_date!= '' && $value->approved_date!= '0000-00-00') {
                    $approved_date = date("d/m/Y", strtotime($value->approved_date));
                }
                if ($value->payment_date!= '' && $value->payment_date!= '0000-00-00') {
                    $payment_date = date("d/m/Y", strtotime($value->payment_date));
                }
                $data[] = array(
                    "id" => $value->id,
                    "date_apply" => $date_apply,
                    "approved_date"=>$approved_date,
                    "payment_date"=>$payment_date,
                    "leave_type" => $value->leavedetail->leave_name,
                    "year" => $value->year,
                    "ticket_amt" => $value->ticket_amt,
                    "status"=>EmployeeTicketEncashment::getStatus($value->status));
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[] = array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionSaveTicketEncashment() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true); 
            $model  = new EmployeeTicketEncashment();
            if ((int)$data_array['id'] > 0) {
                $id =  (int)$data_array['id'];
                $model = $model->findByPK($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }else{
                $model->date_apply = date('Y-m-d');
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }        
            $model->employee_id = $data_array['employee_id'];
            $model->leave_id = $data_array['leave_id'];
            $model->year = $data_array['year'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$data_array["employee_id"].'" and functionality_id="10"'));
            $model->function_type = $model_master_approve_setting->id;
            $model->status =1;
            if ($model->validate()) {
                $model->save();
            //Mail
//                $model_settings = HrGenerelSettings::model()->find();
//                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="7"'));
//                if(!empty($model_settings)){
//                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                         Yii::import('application.modules.hr.controllers.MailController');
//                         MailController::sendmail(7,$model->employee_id,$model->id);
//                    }
//                }
              $data['status'] = 'success';
            } else {
                $errors = $model->errors; 
                $arr_err=array();
                foreach ($model->errors as $t=>$value) {
                    $arr_err[]=$value[0];
                }
                $data=array('status' => 'error','message'=>$arr_err);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionGetTicketEncashmentApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id =(int)$_REQUEST['id'];
            $pending_encashment=EmployeeTicketEncashment::getintermediateapproval($employee_id,1);
            $condition = 'employeedetail.isActive="Y" AND last_approved_level<approvelevel.max_level AND t.id IN('.$pending_encashment.')';
            $data = [];
            $model = new EmployeeTicketEncashment();
            $model = $model->with('employeedetail','approvelevel')->findAll(array('condition' => $condition, 'order' => 'date_apply asc'));
            foreach ($model as $row) {
                $last_approved_level=$row->last_approved_level;
                $next_approval_level=$last_approved_level+1;
                $show_approve_button=0;
                $level_no=0;
                $final_level='N';
                if($next_approval_level<=$row->approvelevel->max_level){
                    if($next_approval_level==1 && (($row->approvelevel->level_1_type=='L' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='S' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='N' && $row->approvelevel->level_1_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=1;
                    }else if($next_approval_level==2 && (($row->approvelevel->level_2_type=='L' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='S' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='N' && $row->approvelevel->level_2_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=2;
                    }else if($next_approval_level==3 && (($row->approvelevel->level_3_type=='L' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='S' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='N' && $row->approvelevel->level_3_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=3;
                    }else if($next_approval_level==4 && (($row->approvelevel->level_4_type=='L' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='S' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='N' && $row->approvelevel->level_4_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=4;
                    }else if($next_approval_level==5 && (($row->approvelevel->level_5_type=='L' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='S' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='N' && $row->approvelevel->level_5_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=5;
                    }
                }
                if($next_approval_level==$row->approvelevel->max_level){
                    $final_level='Y';
                }
                $apply_date='';
                if ($row->date_apply!= '' && $row->date_apply!= '0000-00-00') {
                    $apply_date = date("d/m/Y", strtotime($row->date_apply));
                }
                $data[] = array(
                    "id" => $row->id,
                    "employee_name" => $row->employeedetail->employeefullname,
                    "employeecode" => $row->employeedetail->employeecode,
                    "apply_date" => $apply_date,
                    "year" => $row->year,
                    "status"=> EmployeeTicketEncashment::getStatus($row->status),
                    "approve_btn" => $show_approve_button);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[] = array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionSaveTicketEncashmentApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array["id"];
            $user_id   = $userModel->id;
            $status_v = $data_array["status"];//A-Approved,R-Rejected
            $comment = $data_array["comment"];
            if ($id>0 && $status_v!='' && $user_id>0) {
                $model= EmployeeTicketEncashment::model()->findByPK($id); 
                $final_level='N';
                $status=0;
                $modelemployee = User::model()->findByPK($user_id);
                //For Approval Level-Start
                 if($model->last_approved_level!=$model->approvelevel->max_level){
                     $level=$model->last_approved_level+1;
                     if($level==$model->approvelevel->max_level){
                         $final_level='Y';
                     }
                     if ($final_level == 'Y') {
                         if($status_v=='A'){
                             $status=12;
                         }else {
                             $status=13;
                         }
                         $model->approved_date = date('Y-m-d');
                         $model->approval_comment = $comment;
                         $model->approved_by =$modelemployee->employee_id;
                     } else if ($level == 1) {
                         if($status_v=='A'){
                             $status=2;
                         }else {
                             $status=3;
                         }
                         $model->approve_level1_date = date('Y-m-d');
                         $model->approve_level1_comment = $comment;
                         $model->approve_level1_id = $modelemployee->employee_id;
                     } else if ($level == 2) {
                         if($status_v=='A'){
                             $status=4;
                         }else {
                             $status=5;
                         }
                         $model->approve_level2_date = date('Y-m-d');
                         $model->approve_level2_comment = $comment;
                         $model->approve_level2_id = $modelemployee->employee_id;
                     } else if ($level == 3) {
                         if($status_v=='A'){
                             $status=6;
                         }else {
                             $status=7;
                         }
                         $model->approve_level3_date = date('Y-m-d');
                         $model->approve_level3_comment = $comment;
                         $model->approve_level3_id = $modelemployee->employee_id;
                     } else if ($level == 4) {
                         if($status_v=='A'){
                             $status=8;
                         }else {
                             $status=9;
                         }
                         $model->approve_level4_date = date('Y-m-d');
                         $model->approve_level4_comment = $comment;
                         $model->approve_level4_id = $modelemployee->employee_id;
                     } else if ($level == 5) {
                         if($status_v=='A'){
                             $status=10;
                         }else {
                             $status=11;
                         }
                         $model->approve_level5_date = date('Y-m-d');
                         $model->approve_level5_comment = $comment;
                         $model->approve_level5_id = $modelemployee->employee_id;
                    }
                    $model->last_approved_level =$level;
                 }
                 //For Approval Level-End
                 //Status End
                 //Updating Table
                $model->ticket_amt = $data_array['ticket_amt'];
                $model->status = $status;
                $model->approval_document =$data_array['approval_document'];
                $model->save();
                if($status==12){
                    $model_ticket_entitlement= EmployeeTicketEntitlement::model()->find(array('condition' => 'employee_id="'.$model->employee_id.'" and ticket_year="'.$model->year.'"'));
                    if(!empty($model_ticket_entitlement)){
                        $ticket_balance=$model_ticket_entitlement->ticket_balance-100;
                        EmployeeTicketEntitlement::model()->updateByPK($model_ticket_entitlement->id, array('ticket_balance' => $ticket_balance));
                    }else{
                        $model_entitlement = new EmployeeTicketEntitlement();
                        $model_entitlement->created_by = Yii::app()->user->id;
                        $model_entitlement->created_date_time = date('Y-m-d H:i:s');
                        $model_entitlement->employee_id =$model->employee_id;
                        $model_entitlement->ticket_balance=-100;  
                        $model_entitlement->ticket_year=$model->year;  
                        $model_entitlement->branch_id=$model->employeedetail->branch_or_sponsor_id;  
                        $model_entitlement->save();             
                    }
                }
                //Mail
//                $model_settings = HrGenerelSettings::model()->find();
//                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="8"'));
//                if(!empty($model_settings)){
//                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                         Yii::import('application.modules.hr.controllers.MailController');
//                         MailController::sendmail(8,$model->employee_id,$model->id);
//                    }
//                }
                $data['status'] = 'success';
                $data['message'] ='Ticket Encashment Details Updated Successfylly';
            }else{
                if($id==''){
                    $data['message'] ='Error in getting Ticket Encashment Details';
                }else if($status_v==''){
                    $data['message'] ='Please Select Status';
                }else if($user_id==''){
                    $data['message'] ='Cannot Access User Details';
                }
                $data['status'] = 'error';
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionEncashmentApprovalDocument() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $id = $_REQUEST["id"];
            $model_encashment= EmployeeTicketEncashment::model()->findbyPK($id);
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrdocuments.airticket_encashment_document', array('id'=>$id,'model_encashment'=>$model_encashment), true));
            $mPDF1->Output('Air Ticket Encashment Request Form.pdf', 'I');
            Yii::app()->end();
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
            echo json_encode($data);
        }
    }
    public function actionUploadDocument() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $model_employee = Employee::model()->findbypk($_REQUEST['id']);
            $document_name=$model_employee->employeecode.'_'.$_FILES["file"]["name"];
            $folder = Yii::getPathOfAlias('webroot') . '/uploads/ticketencashment/'.$document_name;
            move_uploaded_file($_FILES["file"]["tmp_name"], $folder);
            $jsonData['filename'] = $document_name;
            $jsonData['status'] = 'success';
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $jsonData = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        echo json_encode($jsonData);
    }
    public function actionGetLeaveEncashmentList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id = $_REQUEST['id'];
            $condition = 't.employee_id="'.$employee_id.'" and YEAR(apply_date)="'.date('Y').'"';
            EmployeeLeaveEncashment::model()->updateAll(array('view_status' =>1), 'employee_id="'.$employee_id.'" and view_status="0" and (status="12" OR status="13")');
            $model = new EmployeeLeaveEncashment();
            $model = $model->with('employeedetail','leavetype')->findAll(array('condition' => $condition));
            $data = array();
            $m = 1;
            foreach ($model as $value) {
                $date_apply=$approved_date=$payment_date="";
                if ($value->apply_date!= '' && $value->apply_date!= '0000-00-00') {
                    $date_apply = date("d/m/Y", strtotime($value->apply_date));
                }
                if ($value->approve_date!= '' && $value->approve_date!= '0000-00-00') {
                    $approved_date = date("d/m/Y", strtotime($value->approve_date));
                }
                if ($value->payment_date!= '' && $value->payment_date!= '0000-00-00') {
                    $payment_date = date("d/m/Y", strtotime($value->payment_date));
                }
                $data[] = array(
                    "id" => $value->id,
                    "date_apply" => $date_apply,
                    "approved_date"=>$approved_date,
                    "leave_type"=>$value->leavetype->leave_name,
                    "encashable_leave" => $value->encashable_leave,
                    "encashment_amount" => $value->encashment_amount,
                    "status"=>EmployeeLeaveEncashment::getStatus($value->status));
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[] = array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionSaveLeaveEncashment() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true); 
            $model  = new EmployeeLeaveEncashment();
            if ((int)$data_array['id'] > 0) {
                $id =  (int)$data_array['id'];
                $model = $model->findByPK($id);
            }else{
                $model->apply_date = date('Y-m-d');
            }        
            $model->employee_id = $data_array['employee_id'];
            $model->leave_type_id = $data_array['leave_type_id'];
            $model->encashment_year =date("Y");
            $model->encashable_leave = $data_array['encashable_leave'];
            $model->encashment_amount = $data_array['encashment_amount'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$data_array["employee_id"].'" and functionality_id="9"'));
            $model->function_type = $model_master_approve_setting->id;
            $model->status =1;
            if ($model->validate()) {
                $model->save();
                //Mail
//                $model_settings = HrGenerelSettings::model()->find();
//                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="5"'));
//                if(!empty($model_settings)){
//                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                         Yii::import('application.modules.hr.controllers.MailController');  
//                         MailController::sendmail(5,$model->employee_id,$model->id);
//                    }
//                }
              $data['status'] = 'success';
            } else {
                $errors = $model->errors; 
                $arr_err=array();
                foreach ($model->errors as $t=>$value) {
                    $arr_err[]=$value[0];
                }
                $data=array('status' => 'error','message'=>$arr_err);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    public function actionGetLeaveEncashmentApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id =(int)$_REQUEST['id'];
            $pending_encashment=EmployeeLeaveEncashment::getintermediateapproval($employee_id,1);
            $condition = 'employeedetail.isActive="Y" AND last_approved_level<approvelevel.max_level AND t.id IN('.$pending_encashment.')';
            $data = [];
            $model = new EmployeeLeaveEncashment();
            $model = $model->with('employeedetail','approvelevel')->findAll(array('condition' => $condition, 'order' => 'apply_date asc'));
            foreach ($model as $row) {
                $last_approved_level=$row->last_approved_level;
                $next_approval_level=$last_approved_level+1;
                $show_approve_button=0;
                $level_no=0;
                $final_level='N';
                if($next_approval_level<=$row->approvelevel->max_level){
                    if($next_approval_level==1 && (($row->approvelevel->level_1_type=='L' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='S' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='N' && $row->approvelevel->level_1_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=1;
                    }else if($next_approval_level==2 && (($row->approvelevel->level_2_type=='L' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='S' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='N' && $row->approvelevel->level_2_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=2;
                    }else if($next_approval_level==3 && (($row->approvelevel->level_3_type=='L' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='S' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='N' && $row->approvelevel->level_3_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=3;
                    }else if($next_approval_level==4 && (($row->approvelevel->level_4_type=='L' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='S' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='N' && $row->approvelevel->level_4_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=4;
                    }else if($next_approval_level==5 && (($row->approvelevel->level_5_type=='L' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='S' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='N' && $row->approvelevel->level_5_authority==$employee_id))){
                        $show_approve_button=1;
                        $level_no=5;
                    }
                }
                if($next_approval_level==$row->approvelevel->max_level){
                    $final_level='Y';
                }
                $apply_date='';
                if ($row->apply_date!= '' && $row->apply_date!= '0000-00-00') {
                    $apply_date = date("d/m/Y", strtotime($row->apply_date));
                }
                $data[] = array(
                    "id" => $row->id,
                    "employee_name" => $row->employeedetail->employeefullname,
                    "employeecode" => $row->employeedetail->employeecode,
                    "apply_date" => $apply_date,
                    "leave_type"=>$row->leavetype->leave_name,
                    "encashable_leave" => $row->encashable_leave,
                    "encashment_amount" => $row->encashment_amount,
                    "status"=>EmployeeLeaveEncashment::getStatus($row->status),
                    "approve_btn" => $show_approve_button);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        if(empty($data)){
            $data[] = array('msg' => "No Data Available"); 
                
        }
        echo json_encode($data);
    }
    public function actionSaveLeaveEncashmentApproval() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array["id"];
            $user_id   = $userModel->id;
            $status_v = $data_array["status"];//A-Approved,R-Rejected
            $comment = $data_array["comment"];
            if ($id>0 && $status_v!='' && $user_id>0) {
                $model= EmployeeLeaveEncashment::model()->findByPK($id); 
                $final_level='N';
                $status=0;
                $modelemployee = User::model()->findByPK($user_id);
                //For Approval Level-Start
                 if($model->last_approved_level!=$model->approvelevel->max_level){
                     $level=$model->last_approved_level+1;
                     if($level==$model->approvelevel->max_level){
                         $final_level='Y';
                     }
                     if ($final_level == 'Y') {
                         if($status_v=='A'){
                             $status=12;
                         }else {
                             $status=13;
                         }
                         $model->approve_date = date('Y-m-d');
                         $model->approval_comment = $comment;
                         $model->approved_by =$modelemployee->employee_id;
                     } else if ($level == 1) {
                         if($status_v=='A'){
                             $status=2;
                         }else {
                             $status=3;
                         }
                         $model->approve_level1_date = date('Y-m-d');
                         $model->approve_level1_comment = $comment;
                         $model->approve_level1_id = $modelemployee->employee_id;
                     } else if ($level == 2) {
                         if($status_v=='A'){
                             $status=4;
                         }else {
                             $status=5;
                         }
                         $model->approve_level2_date = date('Y-m-d');
                         $model->approve_level2_comment = $comment;
                         $model->approve_level2_id = $modelemployee->employee_id;
                     } else if ($level == 3) {
                         if($status_v=='A'){
                             $status=6;
                         }else {
                             $status=7;
                         }
                         $model->approve_level3_date = date('Y-m-d');
                         $model->approve_level3_comment = $comment;
                         $model->approve_level3_id = $modelemployee->employee_id;
                     } else if ($level == 4) {
                         if($status_v=='A'){
                             $status=8;
                         }else {
                             $status=9;
                         }
                         $model->approve_level4_date = date('Y-m-d');
                         $model->approve_level4_comment = $comment;
                         $model->approve_level4_id = $modelemployee->employee_id;
                     } else if ($level == 5) {
                         if($status_v=='A'){
                             $status=10;
                         }else {
                             $status=11;
                         }
                         $model->approve_level5_date = date('Y-m-d');
                         $model->approve_level5_comment = $comment;
                         $model->approve_level5_id = $modelemployee->employee_id;
                    }
                    $model->last_approved_level =$level;
                 }
                 //For Approval Level-End
                 //Status End
                 //Updating Table
                $model->status = $status;
//                $model->approval_document =$data_array['approval_document'];
                $model->save();
                if ($status== 12) {
                    $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_year="'.date("Y").'" AND leave_type="' . $model->leave_type_id . '" and employee_id="' . $model->employee_id . '"'));
                    $available_leave = $model_leave->leave_current_balance;
                    $leave_days = $model->encashable_leave;
                    $balance_leave = $available_leave - $leave_days;
                    EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $balance_leave));
                }
                //Mail
//                $model_settings = HrGenerelSettings::model()->find();
//                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="8"'));
//                if(!empty($model_settings)){
//                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
//                         Yii::import('application.modules.hr.controllers.MailController'); 
//                         MailController::sendmail(6,$model->employee_id,$model->id);
//                    }
//                }
                $data['status'] = 'success';
                $data['message'] ='Leave Encashment Details Updated Successfylly';
            }else{
                if($id==''){
                    $data['message'] ='Error in getting Leave Encashment Details';
                }else if($status_v==''){
                    $data['message'] ='Please Select Status';
                }else if($user_id==''){
                    $data['message'] ='Cannot Access User Details';
                }
                $data['status'] = 'error';
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
}
