<?php
class ApiController extends Controller {
    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'Login', 'logout', 'error', 'GetProfile', 'StaffBoard', 'Circular', 'downloadCircular', 'LeaveMaster', 'LeaveDashboard', 'CheckleaveDate', 'UploadDocument', 'SalarySlip', 'Documentlist', 'downloadDocument'
                    , "DocumentTypes", "UpdateDocument", 'SalarySlipPdf', 'GetEmployeeGeocode', 'UpdatePassword','ProfilePhoto','SaveProfilePic','UploadDocumentNew'
                ),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function beforeAction($action) {
        //for db connection added by nisha on 27-03-2023
        $this->ChangeDB();
        return true;
    }
    public function actionLogin() {
        $model_module_app= HrModules::model()->findByPK(29);
        if(!empty($model_module_app) && $model_module_app->grant_access == 1 && $model_module_app->isActive == 'Y'){
                    $input = file_get_contents('php://input');
                    $variables = json_decode($input, true);
                    // $code = trim($variables['code']);
                    $code = 'BLUESKY';
                    $username = trim($variables['username']);
                    $password = trim($variables['password']);
                    $device_id_input = trim($variables['device_id']);
                    $device_type_input = trim($variables['device_type']);
                    $app_verion_input = trim($variables['app_verion']);
                    $device_description = $variables['device_description'];
                    $company_id = MasCompany::getCompanyId($code);
                    $model = new LoginForm;
                    $model->company_code = $code;
                    $model->username = $username;
                    $model->password = $password;

                    $isLogin = $model->validate() && $model->login();
                    $user_id = "";
                    $name = "";
                    $condition = "t.username = '" . $username . "' AND company_id='" . $company_id . "'";
                    $user = User::model()->find(array('condition' => $condition));

                    //    error_log($username.'-'.$device_id_input, 3, "/home/cumulushr/public_html/benchmark/error_log.log");
                    $model_device_details = User::model()->find(array('condition' => "t.username!= '" . $username . "' AND company_id='" . $company_id . "' AND device_id='" . $device_id_input . "' AND device_id!=''"));
                    if (!empty($isLogin) && $user->level == 2 && empty($model_device_details) && (($user->device_id != '') ? $user->device_id == $device_id_input : true)) {
                        $user->_generate_token;
                        $user_id = $user->id;
                        $name = $user->fullname;
                        $punch_delay = 0;
                        //Menu Permission
                        $staff_board_view = $leave_view = $ticket_encashment_view = $loan_view = $circular_view = $salary_advance_view = $expense_view = $attendance_view = $appraisal_view = $certificate_view = $suggestion_view = $late_in_view = $salary_slip_view = $document_view = $notice_conduct_view = $organization_chart_view = 0;
                        $leave_encashment_view = $resignation_view = $purchase_view = $expense_add = $expense_upload = $documentemp_add = $documentemp_upload = 0;
                        $leave_approval_menu = $loan_approval_menu = $salary_advance_approval_menu = $certificate_approval_menu = $resignation_approval_menu = $appraisal_approval_menu = $expense_approval_menu = $purchase_approval_menu = $leave_encashment_approval_menu = $ticket_encashment_approval_menu = $document_upload = $request_view = $ticket_approval_menu = $ticket_view = 0;
                        $punch_button_view = $punch_break_button_view = $late_in_approval_menu=$excuse_add=$loan_add=$leave_dashboard_view=$salary_advance_add=$profile_photo_view=0;
                        $model_hr_settings = HrGenerelSettings::model()->find();
                        $array_hr_permission = json_decode($model_hr_settings->app_permission);
                        $arr_menu = array();
                        $model_upload_emp_document = HrMasterUpload::model()->findByPK(1);
                        if ($model_hr_settings->employee_document_upload == "Y" && $model_upload_emp_document->isActive=='Y') {
                            $document_upload = 1;
                        }
                        //profilephoto
                        $model_upload_profile = HrMasterUpload::model()->findByPK(2);
                        if ($array_hr_permission->profile_photo_view == 1 && $model_upload_profile->isActive=='Y'):
                            $profile_photo_view = 1;
                        endif;
                        //StaffBoard
                        $model_module_staffboard= HrModules::model()->findByPK(22);
                        if ($array_hr_permission->staff_board_view == 1 && ($model_module_staffboard->grant_access == 1 && $model_module_staffboard->isActive == 'Y')):
                            $staff_board_view = 1;
                        endif;
                        //Circular
                        $model_module_circular = HrModules::model()->findByPK(18);
                        if ($array_hr_permission->circular_view == 1 && ($model_module_circular->grant_access == 1 && $model_module_circular->isActive == 'Y')):
                            $circular_view = 1;
                        endif;
                        //Leave
                        $model_module_leave = HrModules::model()->findByPK(3);
                        if ($array_hr_permission->leave_view == 1 && ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y')):
                            $leave_view = 1;
                            $model_approval_leave_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="1" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                            if ($model_approval_leave_authority > 0):
                                $leave_approval_menu = 1;
                            endif;
                        endif;
                        $model_module_certificate= HrModules::model()->findByPK(10);
                        if ($array_hr_permission->certificate_view == 1  && ($model_module_certificate->grant_access == 1 && $model_module_certificate->isActive == 'Y')):
                            $request_view = 1;
                        endif;

                        $model_module_attendance = HrModules::model()->findByPK(2);
                        //  $machine_break__button_view=$punch_button_view=$punch_break_button_view=0;
                        if($model_module_attendance->grant_access == 1 && $model_module_attendance->isActive == 'Y'){
                            if ($array_hr_permission->punch_button_view == 1):
                                $punch_button_view = 1;
                            endif;
                            if ($array_hr_permission->punch_break_button_view == 1):
                                $punch_break_button_view = 1;
                            endif;
                        }
                        //leavedashboard
                        if ($array_hr_permission->leave_dashboard_view == 1 && ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y')):
                            $leave_dashboard_view = 1;
                        endif;
                        //Loan
                        $model_module_loan= HrModules::model()->findByPK(6);
                        if ($array_hr_permission->loan_view == 1 && ($model_module_loan->grant_access == 1 && $model_module_loan->isActive == 'Y')):
                            $loan_view = 1;
                            $model_approval_loan_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="2" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                            if ($model_approval_loan_authority > 0):
                                $loan_approval_menu = 1;
                            endif;
                        endif;
                        $punch_delay = $model_hr_settings->punch_delay;
                        //Salary Advance
                        $model_module_salary_advance =HrModules::model()->findByPK(5);
                        if ($array_hr_permission->salary_advance_view == 1  && ($model_module_salary_advance->grant_access == 1 && $model_module_salary_advance->isActive == 'Y')):
                            $salary_advance_view = 1;
                            $model_approval_salaryadvance_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="3" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                            if ($model_approval_salaryadvance_authority > 0):
                                $salary_advance_approval_menu = 1;
                            endif;
                        endif;
                        //Document
                        if ($array_hr_permission->certificate_view == 1  && ($model_module_certificate->grant_access == 1 && $model_module_certificate->isActive == 'Y')):
                            $certificate_view = 1;
                            $model_approval_doc_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="4" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                            if ($model_approval_doc_authority > 0):
                                $certificate_approval_menu = 1;
                            endif;
                        endif;
                        //Resignation
                        $model_module_resignation= HrModules::model()->findByPK(14); 
                        if ($array_hr_permission->resignation_view == 1 && ($model_module_resignation->grant_access == 1 && $model_module_resignation->isActive == 'Y')):
                            $resignation_view = 1;
                            $model_approval_resignation_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="5" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                            if ($model_approval_resignation_authority > 0):
                                $resignation_approval_menu = 1;
                            endif;
                        endif;
                        //Appraisal
                        $model_module_appraisal = HrModules::model()->findByPK(12);
                        if ($array_hr_permission->appraisal_view == 1 && ($model_module_appraisal->grant_access == 1 && $model_module_appraisal->isActive == 'Y')):
                            $appraisal_view = 1;
                            $model_approval_appraisal_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="6" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                            if ($model_approval_appraisal_authority > 0):
                                $appraisal_approval_menu = 1;
                            endif;
                        endif;
                        //Expense
                        $model_module_expense= HrModules::model()->findByPK(11);
                        if ($array_hr_permission->expense_view == 1  && ($model_module_expense->grant_access == 1 && $model_module_expense->isActive == 'Y')):
                            $expense_view = 1;
                            $model_approval_expense_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="7" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                            if ($model_approval_expense_authority > 0):
                                $expense_approval_menu = 1;
                            endif;
                        endif;
                        if ($array_hr_permission->loan_add == 1 && ($model_module_loan->grant_access == 1 && $model_module_loan->isActive == 'Y')):
                            $loan_add = 1;
                        endif;
                        if ($array_hr_permission->salary_advance_add == 1 && ($model_module_salary_advance->grant_access == 1 && $model_module_salary_advance->isActive == 'Y')):
                            $salary_advance_add= 1;
                        endif;
                        if ($array_hr_permission->expense_add == 1  && ($model_module_expense->grant_access == 1 && $model_module_expense->isActive == 'Y')):
                            $expense_add = 1;
                        endif;
                        $model_upload_expense = HrMasterUpload::model()->findByPK(28);
                        if ($array_hr_permission->expense_upload == 1  && ($model_upload_expense->isActive=="Y") && ($model_module_expense->grant_access == 1 && $model_module_expense->isActive == 'Y')):
                            $expense_upload = 1;
                        endif;
                        //Product Purchase
                        $model_module_purchase = HrModules::model()->findByPK(16);
                        if ($array_hr_permission->purchase_view == 1 && ($model_module_purchase->grant_access == 1 && $model_module_purchase->isActive == 'Y')):
                            $purchase_view = 1;
                            $model_approval_purchase_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="8" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                            if ($model_approval_purchase_authority > 0):
                                $purchase_approval_menu = 1;
                            endif;
                        endif;
                        //Leave Encashment
                        $model_module_leave_encashment= HrModules::model()->findByPK(4);
                        if ($array_hr_permission->leave_encashment_view == 1 && ($model_module_leave_encashment->grant_access == 1 && $model_module_leave_encashment->isActive == 'Y')):
                            $leave_encashment_view = 1;
                            $model_approval_leaveencashment_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="9" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                            if ($model_approval_leaveencashment_authority > 0):
                                $leave_encashment_approval_menu = 1;
                            endif;
                        endif;
                        //Ticket
                        $model_module_ticket= HrModules::model()->findByPK(8);
                        if ($array_hr_permission->ticket_view == 1  && ($model_module_ticket->grant_access == 1 && $model_module_ticket->isActive == 'Y')):
                            $ticket_view = 1;
                            $model_approval_tkt_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="11" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                            if ($model_approval_tkt_authority > 0):
                                $ticket_approval_menu = 1;
                            endif;
                        endif;
                        //Ticket Encashment
                        $model_module_ticket_encashment= HrModules::model()->findByPK(9);
                        if ($array_hr_permission->ticket_encashment_view == 1 && ($model_module_ticket_encashment->grant_access == 1 && $model_module_ticket_encashment->isActive == 'Y')):
                            $ticket_encashment_view = 1;
                            $model_approval_tktencashment_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="10" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                            if ($model_approval_tktencashment_authority > 0):
                                $ticket_encashment_approval_menu = 1;
                            endif;
                        endif;
                        //Attendance View
                        if ($array_hr_permission->attendance_view == 1 && ($model_module_attendance->grant_access == 1 && $model_module_attendance->isActive == 'Y')):
                            $attendance_view = 1;
                        endif;
                        //Complaint/Suggestion
                        $model_request_service= HrModules::model()->findByPK(31);
                        if ($array_hr_permission->suggestion_view == 1 && ($model_request_service->grant_access == 1 && $model_request_service->isActive == 'Y')):
                            $suggestion_view = 1;
                        endif;
                        //Salary Slip
                        $model_module_payroll= HrModules::model()->findByPK(7);
                        if ($array_hr_permission->salary_slip_view == 1 && ($model_module_payroll->grant_access == 1 && $model_module_payroll->isActive == 'Y')):
                            $salary_slip_view = 1;
                        endif;
                        //Employee Document
                        $model_module_employee = HrModules::model()->findByPK(1);
                        if($model_module_employee->grant_access == 1 && $model_module_employee->isActive == 'Y'){
                            if ($array_hr_permission->document_view == 1 ):
                                $document_view = 1;
                            endif;
                            if ($array_hr_permission->document_add == 1):
                                $documentemp_add = 1;
                            endif;
                            if ($array_hr_permission->document_upload == 1 && $model_upload_emp_document->isActive=='Y'):
                                $documentemp_upload = 1;
                            endif;
                        }
                        //Notice of Conduct
                        $model_module_notice_conduct= HrModules::model()->findByPK(24);
                        if ($array_hr_permission->notice_conduct_view == 1 && ($model_module_notice_conduct->grant_access == 1 && $model_module_notice_conduct->isActive == 'Y')):
                            $notice_conduct_view = 1;
                        endif;
                        //Organization Chart
                        $model_line_manager = Employee::model()->count(array('condition' => 'reporting_manager="' . $user->employee_id . '"'));
                        if ($array_hr_permission->organization_chart_view == 1 && $model_line_manager > 0 && ($model_module_employee->grant_access == 1 && $model_module_employee->isActive == 'Y')):
                            $organization_chart_view = 1;
                        endif;
                        //Excuse/Meeting
                        $model_module_flexitime= HrModules::model()->findByPK(32);
                        if($model_module_flexitime->grant_access == 1 && $model_module_flexitime->isActive == 'Y'){
                            if ($array_hr_permission->late_in_add_view == 1):
                                $excuse_add = 1;
                            endif;
                            if ($array_hr_permission->late_in_view == 1):
                                $late_in_view = 1;
                                $model_approval_excuse_authority = HrEmployeeApproveLevel::model()->count(array('condition' => 'functionality_id="12" AND (level_1_authority="' . $user->employee_id . '" OR level_2_authority="' . $user->employee_id . '" OR level_3_authority="' . $user->employee_id . '" OR level_4_authority="' . $user->employee_id . '" OR level_5_authority="' . $user->employee_id . '")'));
                                if ($model_approval_excuse_authority > 0):
                                    $late_in_approval_menu = 1;
                                endif;
                            endif;
                        }
                        $device_id = $user->device_id;
                        $device_type = $user->device_type;
                        header("HTTP/1.1 200 OK");
                        header('Content-Type: application/json');
                        $arr_menu["staff_board_view"] = $staff_board_view;
                        $arr_menu["circular_view"] = $circular_view;
                        $arr_menu["leave_view"] = $leave_view;
                        $arr_menu["profile_photo_view"] = $profile_photo_view;
                        $arr_menu["leave_dashboard_view"] = $leave_dashboard_view;
                        $arr_menu["leave_approval_menu"] = $leave_approval_menu;
                        $arr_menu["loan_view"] = $loan_view;
                        $arr_menu["loan_add"] = $loan_add;
                        $arr_menu["loan_approval_menu"] = $loan_approval_menu;
                        $arr_menu["salary_advance_view"] = $salary_advance_view;
                        $arr_menu["salary_advance_add"] = $salary_advance_add;
                        $arr_menu["salary_advance_approval_menu"] = $salary_advance_approval_menu;
                        $arr_menu["certificate_view"] = $certificate_view;
                        $arr_menu["certificate_approval_menu"] = $certificate_approval_menu;
                        //            $arr_menu["resignation_view"]=$resignation_view;
                        //            $arr_menu["resignation_approval_menu"]=$resignation_approval_menu;
                        $arr_menu["appraisal_view"] = $appraisal_view;
                        $arr_menu["request_view"] = $request_view;
                        $arr_menu["appraisal_approval_menu"] = $appraisal_approval_menu;
                        $arr_menu["expense_view"] = $expense_view;
                        $arr_menu["expense_approval_menu"] = $expense_approval_menu;
                        $arr_menu["purchase_view"] = $purchase_view;
                        $arr_menu["purchase_approval_menu"] = $purchase_approval_menu;
                        $arr_menu["leave_encashment_view"] = $leave_encashment_view;
                        $arr_menu["leave_encashment_approval_menu"] = $leave_encashment_approval_menu;
                        $arr_menu["ticket_encashment_view"] = $ticket_encashment_view;
                        $arr_menu["ticket_encashment_approval_menu"] = $ticket_encashment_approval_menu;
                        $arr_menu["ticket_view"] = $ticket_view;
                        $arr_menu["ticket_approval_menu"] = $ticket_approval_menu;
                        $arr_menu["attendance_view"] = $attendance_view;
                        $arr_menu["suggestion_view"] = $suggestion_view;
                        $arr_menu["late_in_view"] = $late_in_view;
                        $arr_menu["late_in_approval_menu"] = $late_in_approval_menu;
                        $arr_menu["late_in_add"] = $excuse_add;
                        $arr_menu["salary_slip_view"] = $salary_slip_view;
                        $arr_menu["document_view"] = $document_view;
                        $arr_menu["notice_conduct_view"] = $notice_conduct_view;
                        $arr_menu["organization_chart_view"] = $organization_chart_view;
                        $arr_menu["document_upload"] = $document_upload;
                        //added on 08-02-2024
                        $arr_menu["expense_add"] = $expense_add;
                        $arr_menu["expense_upload"] = $expense_upload;
                        $arr_menu["document_emp_add"] = $documentemp_add;
                        $arr_menu["document_emp_upload"] = $documentemp_upload;

                        $arr_menu["punch_button_view"] = $punch_button_view;
                        $arr_menu["punch_break_button_view"] = $punch_break_button_view;
                        $arr_menu["punch_delay_time"] = $punch_delay;
                        //end
                        $model_employee = Employee::model()->findByPk($user->employee_id);
                        $model_company = MasCompany::model()->findByPk($company_id);
                        $company_logo = "images/" . $model_company->company_logo;
                        if($model_employee->profile_photo!=''){
                        $profile_pic = "uploads/profilephotos/" . $model_employee->profile_photo;
                        }else{
                            $profile_pic = "uploads/profilephotos/emp.jpg";
                        }
                        $sal_slip_app_view = 0;
                        if ($model_employee->branch_sponsor->salary_slip_view_ess == "Y") {
                            $sal_slip_app_view = 1;
                        }
                        $arr_menu["salary_slip_view_ess"] = $sal_slip_app_view;
                        $data = array('status' => "success", "data" => ["pic" => $profile_pic, "user_id" => (string) $user_id,'username'=>$user->username, "name" => $model_employee->employeefullname, "employee_id" => (string) $user->employee_id, "_token" => $user->token, "code" => $model_employee->employeecode, "baseUrl" => $model_company->company_baseurl, "company_logo" => $company_logo]);
                        $data = array_merge($data, $arr_menu);
                        if ($device_id_input != "" || $device_type_input != "") {
                            if ($device_id == "" && $device_type == "") {
                                if ($model_hr_settings->app_version != $app_verion_input && $model_hr_settings->review_app_version != $app_verion_input) {
                                    $data = array('status' => "failed", 'msg' => "Version mismatch.Please update your App");
                                } else {
                                    $status = User::model()->updateByPk($user_id, array('device_id' => $device_id_input, 'device_type' => strtoupper($device_type_input), 'device_description' => $device_description));
                                }
                            } else if (($device_id != $device_id_input)) {
                                $data = array('status' => "failed", 'msg' => "Device ID mismatch");
                            } else if ($device_type != strtoupper($device_type_input)) {
                                $data = array('status' => "failed", 'msg' => "Device Type mismatch");
                            } else if ($model_hr_settings->app_version != $app_verion_input && $model_hr_settings->review_app_version != $app_verion_input) {
                                $data = array('status' => "failed", 'msg' => "Version mismatch.Please update your App");
                            }
                        } else {
                            $data = array('status' => "failed", 'msg' => "Device Id or Device type missing");
                        }
                    } else {
                        if (!empty($model_device_details)) {
                            $data = array('status' => "failed", 'msg' => "Device Details Already Register with employee (" . $model_device_details->employee_details->employeefullname . " - " . $model_device_details->employee_details->employeecode . ")");
                        } else if (!empty($user)) {
                            //Check Password 
                            // echo "test";die;
                            $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
                            $encrypt_password = crypt($password, $salt);
                            if (strtolower($user->username) != strtolower($username)) {
                                $data = array('status' => "failed", 'msg' => "Incorrect Username");
                            } else if ($user->password != $encrypt_password) {
                                $data = array('status' => "failed", 'msg' => "Incorrect Password");
                            } else {
                                $data = array('status' => "failed", 'msg' => "Device Id or Device type missing/Already Login with another Device");
                            }
                        } else {
                            header("HTTP/1.1 401 Unauthorized");
                            header('Content-Type: application/json');
                            $data['status'] = 'failed';
                            $data['msg'] = 'Unauthorized user';
                        }
                    }
                } else {
                        $data = array('status' => "failed", 'msg' => "You are  not authorized to login");
                        }
        echo json_encode($data);
    }

    public function actionGetProfile() {
        $response = array();
        $data = array();
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $baseUrl = Yii::app()->baseUrl;
            $id = (int) $_REQUEST['id'];
            if ($id > 0) {
                $model = Employee::model()->findByPk($id);
                if (!empty($model)) {
                    if ($model->profile_photo == "") {
                        $model->profile_photo = "emp.jpg";
                    }
                    $profile_pic = "uploads/profilephotos/" . $model->profile_photo;
                    $date_of_birth = "";
                    if ($model->date_of_birth != '0000-00-00' && $model->date_of_birth != '') {
                        $date_of_birth = date('d-F', strtotime($model->date_of_birth));
                    }
                    $date_join = $service_period = '';
                    if ($model->date_join != 0000 - 00 - 00) {
                        $date_join = date('d/m/Y', strtotime($model->date_join));
                        $current_date = date('Y-m-d');
                        $date1 = new DateTime($model->date_join);
                        $date2 = new DateTime($current_date);
                        $dd = date_diff($date1, $date2);
                        $service_period = "$dd->y Yrs $dd->m Month $dd->d Days";
                    }
                    $manager_name = Employee::model()->findByPk($model->reporting_manager);
                    $supervisor = $model->attendancemanager->employeefullname;
                    $data = [
                        "id" => $model->id,
                        "name" => $model->employeefullname,
                        "pic" => $profile_pic,
                        "code" => $this->ciphertext($model->employee_code, "d"),
                        "department" => $model->departmentdetail->department_name,
                        "designation" => $model->designationdetail->designation_name,
                        "date_of_birth" => $date_of_birth,
                        "date_join" => $date_join,
                        "total_worked" => $service_period,
                        "gender" => ($model->gender == '1') ? "Male" : "Female",
                        "present_address" => $model->present_address,
                        "email" => $model->email,
                        "mobile" => $model->mobile,
                        "manager" => $manager_name->employeefullname,
                        "supervisor" => empty($supervisor) ? "" : $supervisor
                    ];
                    $response = array('status' => "success", "msg" => "success", "data" => $data);
                } else {
                    $response = array('status' => "failed", "msg" => "No data", "data" => $data);
                }
            } else {
                $response = array('status' => "failed", "msg" => "Input parametrs missing", "data" => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", "data" => $data, "token_status" => "UA");
        }
        echo json_encode($response);
    }

    public function actionStaffBoard() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $response = array();
        $data = [];
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array['employee_id'];
            if ($id > 0) {
                $model = Employee::model()->findByPk($id);
                //Holiday

                $model_holiday = MasHoliday::model()->findAll(array('condition' => 'FIND_IN_SET("' . $model->branch_or_sponsor_id . '",branch_id)  AND holiday_date>="' . date('Y-m-d') . '" AND notify="Y"'));
                if(!empty($model_holiday)) {
                    foreach ($model_holiday as $key => $value) {
                        if ($value->holiday_date != '' && $value->holiday_date != '0000-00-00') {
                            $message = date("d/m/Y", strtotime($value->holiday_date)) . '-';
                        }
                        $message .= $value->holiday_description;
                        $data[] = [
                            "title" => 'Holiday',
                            "message" => $message
                        ];
                    }
                }
                //Notification
                $model_general_notification = HrNotification::model()->findAll(array('condition' => '(FIND_IN_SET("' . $model->department . '",department_id) OR FIND_IN_SET("' . $model->designation . '",designation) OR FIND_IN_SET("' . $model->branch_or_sponsor_id . '",branch)) AND (FIND_IN_SET("' . $model->id . '",employee_id) AND !FIND_IN_SET("' . $model->id . '",read_status))'));
                 if(!empty($model_general_notification)) {
                foreach ($model_general_notification as $key => $value) {
                    $readstatus = "";
                    if ($value->read_status != '') {
                        $readstatus = $value->read_status . ',' . $model->id;
                    } else {
                        $readstatus = $model->id;
                    }
                 //   HrNotification::model()->updateByPK($value->id, array('read_status' => $readstatus));
                    $clean_text = html_entity_decode(strip_tags($value->content));
                    $data[] = [
                        "title" => $value->title,
                        "message" => $clean_text
                    ];
                }
                 }
                //Attendance Warning
            /*    $model_late_warning = EmployeeAttendanceWarning::model()->findAll(array('condition' => 'employee_id="' . $model->id . '" and view_status="0"'));
                foreach ($model_late_warning as $key => $value) {
                    $data[] = [
                        "title" => 'Late Coming-Notice',
                        "message" => date_format(date_create($value->date_from), 'd/m/Y') . '-' . date_format(date_create($value->date_to), 'd/m/Y')
                    ];
                }*/
                $response = array('status' => "success", "msg" => "success", "data" => $data);
                if (empty($data)) {
                    $response = array('status' => "failed", "msg" => "No data available", "data" => $data);
                }
            } else {
                $response = array('status' => "failed", "msg" => "Employee ID missing", "data" => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo json_encode($response);
    }

    public function actionCircular() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $response = array();
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array['employee_id'];
            if ($employee_id > 0) {
                $model = Employee::model()->findByPk($employee_id);
                $model_circular = CompanyCircular::model()->findAll(array('condition' => 'isActive="Y" and((branch_or_sponsor_id="" OR FIND_IN_SET("' . $model->branch_or_sponsor_id . '",branch_or_sponsor_id)) AND (employee_id="" OR FIND_IN_SET("' . $model->id . '",employee_id)))'));
                $data = [];
                foreach ($model_circular as $circular) {
                    $dwn_btn = 0;
                    $view_button = 0;
                    $document_file = '';
                    if ($circular->circular_document != '') {
                        $dwn_btn = 1;
                        $file = $circular->circular_document;
                        $extension = pathinfo($file, PATHINFO_EXTENSION);
                        $arr_doc_val = explode(',', $circular->circular_document);
                        if (count($arr_doc_val) > 1) {
                            $document_file = 'circular.zip';
                        } else {
                            $document_file = $circular->circular_document;
                            $view_button=1;
                        }
                    }
                    $circular_array = explode(',', $circular->employees_viewed);
                    $circular_text = html_entity_decode(strip_tags($circular->notes));
                    $document_file_name = str_replace(' ', '%20', $document_file);
                    if (!in_array($model->id, $circular_array)) {
                        $data[] = [
                            "id" => (string) $circular->id,
                            "type" => (string) $circular->circular_type,
                            "title" => $circular->title,
                            "notes" => $circular_text,
                            "circular_document" => $document_file_name,
                            "download" => $dwn_btn,
                            "file_format"=>$extension,
                            "view_button"=>$view_button
                        ];
                    }
                    //Updating circular view if no document
                    if ($circular->circular_document == '') {
                        $employees_viewed = '';
                        if ($circular->employees_viewed != '') {
                            $employees_viewed = $circular->employees_viewed . ',' . $model->id;
                        } else {
                            $employees_viewed = $model->id;
                        }
                        CompanyCircular::model()->updateByPK($circular->id, array('employees_viewed' => $employees_viewed));
                    }
                }
                $response = array('status' => "success", 'msg' => "success", 'data' => $data);
                if (empty($data)) {
                    $response = array('status' => "failed", 'msg' => "No data available", 'data' => $data);
                }
            } else {
                $response = array('status' => "failed", 'msg' => "Input parameters missing", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo json_encode($response);
    }

    public function actiondownloadCircular() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $id = $_REQUEST["id"];
            $arr_circular_document = CompanyCircular::model()->findByPk($id);
            $file = $arr_circular_document->circular_document;
            $arr_doc_val = explode(',', $arr_circular_document->circular_document);
            //Updating circular view
            $employees_viewed = '';
            if ($arr_circular_document->employees_viewed != '') {
                $employees_viewed = $arr_circular_document->employees_viewed . ',' . $userModel->employee_id;
            } else {
                $employees_viewed = $userModel->employee_id;
            }
            CompanyCircular::model()->updateByPK($arr_circular_document->id, array('employees_viewed' => $employees_viewed));
            if (count($arr_doc_val) > 1) {
                $zip = new ZipArchive();
                $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/circular/circular.zip";
                if ($zip->open($zip_file_path, ZipArchive::CREATE) === TRUE) {
                    for ($i = 0; $i < count($arr_doc_val); $i++) {
                        $path = "uploads/circular/" . $arr_doc_val[$i];
                        // Add the files to the .zip file
                        $zip->addFile($path, $arr_doc_val[$i]);
                    }
                    // Closing the zip file
                    $zip->close();
                }
                header("Content-type:application/zip"); //for pdf file
                header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
                header('Content-Length: ' . filesize($zip_file_path));
                readfile($zip_file_path);
                unlink($zip_file_path);
                Yii::app()->end();
            } else {
                $file = $arr_circular_document->circular_document;
                $path = Yii::getPathOfAlias('webroot') . "/uploads/circular/" . $file;
                header("Content-type:application/octet-stream"); //for txt file
                header("Content-Type: application/download");
                header('Content-Disposition: attachment; filename="' . basename($path) . '"');
                header('Content-Length: ' . filesize($path));
                readfile($path);
                Yii::app()->end();
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed", "msg" => "Unauthorized user");
            echo json_encode($data);
        }
    }

    public function actionLeaveMaster() {
        $data = [];
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id = $_REQUEST['id'];
            $master_leave_id = 0;
            $current_date = date('Y-m-d');
            $model_general_setting = HrGenerelSettings::model()->find();
            $year = date("Y");
            $current_year = $year;
            $current_month = date("m");
            if ($current_month < $model_general_setting->leave_carry_forward_month) {
                $year = $year - 1;
            }
            $model_master_employee = Employee::model()->findbypk($employee_id);
            $service_days = 0;
            if (!empty($model_master_employee)) {
                if ($model_master_employee->date_join != '' && $model_master_employee->date_join != "0000-00-00") {
                    $d1 = strtotime($model_master_employee->date_join);
                    $d2 = strtotime(date('Y-m-d'));
                    $datediff = $d2 - $d1;
                    $service_days = $datediff / (60 * 60 * 24) + 1;
                }
            }
            
            $model_lock = SalarySlip::model()->with('processing')->find(array('select' => 'max(t.salary_processing_id) as salary_processing_id', 'condition' => 'processing.payroll_status="2" and employee_id="' . $employee_id . '"'));
            $last_locked_date = "";
            if (!empty($model_lock) && $model_lock->salary_processing_id > 0) {
                $model_last_locked = SalaryProcessing::model()->findbypk($model_lock->salary_processing_id);
                $payroll_enddate = date('Y-m-d', strtotime('+1 days', strtotime($model_last_locked->payroll_enddate)));
                $last_locked_date = date('d/m/Y', strtotime($payroll_enddate));
//                if ($model_general_setting->unpaid_leave_joining_day > 0) {
//                    $pay_year = date('Y', strtotime($model_last_locked->payroll_enddate));
//                    $pay_month = date('m', strtotime($model_last_locked->payroll_enddate));
//                    $last_locked_date = date('d/m/Y', strtotime("{$pay_year}-{$pay_month}-{$model_general_setting->unpaid_leave_joining_day} +1 day"));
//                }
            } else {
                $model_lock_branch = SalaryProcessing::model()->find(array('select' => 'max(payroll_enddate) as payroll_enddate', 'condition' => 'payroll_status="2" and (payroll_branch_or_sponsor_id="' . $model_master_employee->branch_or_sponsor_id . '" OR payroll_branch_or_sponsor_id="0")'));
                if ($model_lock_branch->payroll_enddate != '' && $model_lock_branch->payroll_enddate != '0000-00-00') {
                    $payroll_enddate = date('Y-m-d', strtotime('+1 days', strtotime($model_lock_branch->payroll_enddate)));
                    $last_locked_date = date('d/m/Y', strtotime($payroll_enddate));
//                    if ($model_general_setting->unpaid_leave_joining_day > 0) {
//                        $pay_year = date('Y', strtotime($model_lock_branch->payroll_enddate));
//                        $pay_month = date('m', strtotime($model_lock_branch->payroll_enddate));
//                        $last_locked_date = date('d/m/Y', strtotime("{$pay_year}-{$pay_month}-{$model_general_setting->unpaid_leave_joining_day} +1 day"));
//                    }
                }
            }


            $model_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount', 'condition' => 'employee_id="' . $employee_id . '" and isActive="Y" and consider_for_leave_payment="Y" AND valid_from <="' . $current_date . '" AND valid_to ="0000-00-00"'));
            $salary_amount = $salary_per_day = 0;
            if (!empty($model_salary)) {
                $salary_amount = $model_salary->amount;
                $salary_per_day = ($salary_amount / 30);
            }
            $leave_condition = 'isActive="Y" and sub_type_leave="N" and branch_id="' . $model_master_employee->branch_or_sponsor_id . '"   AND  (visible_portal="Y" OR visible_portal="E") AND (employee_can_apply="0" OR employee_can_apply<="' . $service_days . '")';
            if($model_master_employee->gender>0){
                $leave_condition.= ' AND (gender="0" OR gender="' . $model_master_employee->gender . '")'; 
            }
            $model_master_leave = MasLeave::model()->findAll(array('condition' => $leave_condition, 'order' => 'leave_name asc'));
            $data = [];
            $response = array();
            foreach ($model_master_leave as $i => $value) {
                $year = date("Y");
                $master_leave_apply = '';
                $master_leave_id = $value->id;
                $document_medical_certificate_upload = $value->document_medical_certificate_upload;
                $model_sub_leave = MasLeave::model()->findAll(array('condition' => 'isActive="Y" and (parent_id="' . $value->id . '" OR  id="' . $value->id . '") and branch_id="' . $model_master_employee->branch_or_sponsor_id . '"', 'order' => 'leave_name asc'));
                $opening_leave_value = $leave_current_balance = $balance_leave = $encashable_leave = $leave_taken = 0.00;
                $message = "";
                foreach ($model_sub_leave as $j => $value_details) {
                    //if master leave
                    $opening_leave_value = $leave_current_balance = $balance_leave = $encashable_leave = $leave_taken = $leave_encashed = $curnt_leave_value = $opn_leave_value = 0.00;
                    $message = '';
                    $button_string = $encashable_btn = "N";
                    if ($value_details->sub_type_leave == 'N') {
                        $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $value_details->id . '" and employee_id="' . $employee_id . '" and leave_year="' . $year . '"'));
                        $opening_leave_value = number_format($model_leave->leave_opening, 2);
                        $opn_leave_value = number_format($model_leave->leave_opening, 2);
                        $leave_current_balance = $model_leave->leave_current_balance;
                        if ($model_leave->leave_current_balance > 0) {
                            $balance_leave = $model_leave->leave_current_balance;
                            $curnt_leave_value = $model_leave->leave_current_balance;
                        }
                        if ($value_details->encashable == "Y") {
                            $encashable_leave = $model_leave->leave_current_balance;
                        }
                        //additional leave
                        if ($value_details->additional_leave > 0) {
                            $balance_leave += $value_details->additional_leave;
                            $curnt_leave_value += $value_details->additional_leave;
                            $leave_current_balance += $value_details->additional_leave;
                        }
                        //Check Leave Applied
                        $model_leave_applied = EmployeeLeaveDetail::model()->with('leavetype')->find(array('condition' => 't.employee_id="' . $employee_id . '" AND (t.leave_type="' . $value_details->id . '" OR leavetype.parent_id="' . $value_details->id . '") and (leave_status="1" OR leave_status="2" OR leave_status="4" OR leave_status="6" OR leave_status="8" OR leave_status="10")'));
                        //Check Encashable Applied
                        $model_leave_encashable = EmployeeLeaveEncashment::model()->findAll(array('condition' => '(status="1" OR status="2" OR status="4" OR status="6" OR status="8" OR status="10") and leave_type_id="' . $value_details->id . '" and employee_id="' . $employee_id . '"'));
                        //Encashment Approved
                        $model_leave_encashable_approved = EmployeeLeaveEncashment::model()->find(array('select' => 'sum(encashable_leave) as encashable_leave', 'condition' => '(status="12" OR status="14") and leave_type_id="' . $value_details->id . '" and encashment_year="' . $year . '" and employee_id="' . $employee_id . '"'));
                        if ($model_leave_encashable_approved->encashable_leave > 0) {
                            $message = "Leave Encashed=" . $model_leave_encashable_approved->encashable_leave;
                            $leave_encashed = $model_leave_encashable_approved->encashable_leave;
                        }
                        //Leave Taken
                        $model_leave_details = EmployeeLeaveDetail::model()->find(array('select' => 'sum(normal_leave) as normal_leave', 'condition' => 'YEAR(leave_start_date)="' . $current_year . '" AND employee_id="' . $employee_id . '" AND leave_type="' . $value_details->id . '" and leave_status="12"'));
                        if ($model_leave_details->normal_leave > 0) {
                            $leave_taken = $model_leave_details->normal_leave;
                        }
                        //Incase of Cancelled Leave
                        $model_leave_ledger = EmployeeLeaveLedger::model()->find(array('select' => 'sum(leave_reduce) as leave_reduce', 'condition' => 'leave_type="' . $value_details->id . '" and employee_id="' . $employee_id . '" and YEAR(created_date_time)="' . $current_year . '"'));
                        if ($model_leave_ledger->leave_reduce > 0) {
                            $leave_taken += $model_leave_ledger->leave_reduce;
                        }
//                        $current_leave_value = number_format($leave_current_balance, 2);
                        if ($value_details->leave_count_employee_panel == 'N') {
                            $opn_leave_value = number_format(0.00, 2);
                            $curnt_leave_value = number_format(0.00, 2);
                        }
                        if ($value_details->leave_apply_limit == 'Y' && $curnt_leave_value > $value_details->max_leave_apply) {
                            $curnt_leave_value = number_format($value_details->max_leave_apply, 2);
                        }
                    } else if ($value_details->sub_type_leave == 'Y') {
                        $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $value_details->parent_id . '" and employee_id="' . $employee_id . '" and leave_year="' . $year . '"'));
                        if ($model_leave->leave_current_balance > 0) {
                            $balance_leave = $model_leave->leave_current_balance;
                        }
                        //additional leave
                        if ($value_details->additional_leave > 0 && $model_leave->leave_current_balance >= 0) {
                            $balance_leave += $value_details->additional_leave;
                        }
                    }
                    //Ticket Eligibility
                    $is_ticket_available = 0;
                    if ($value_details->ticket_available == "Y" && $model_master_employee->branch_sponsor->ticket_provided == 'Y') {
                        $model_ticket = EmployeeTicket::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type="' . $value_details->id . '" and year="' . $year . '" AND ticket_type="E" and (status!="3" OR status!="5" OR status!="7" OR status!="9" OR status!="11" OR status!="13")'));
                        $model_ticket_encashed = EmployeeTicketEncashment::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_id="' . $value_details->id . '" and year="' . $year . '" and (status!="3" OR status!="5" OR status!="7" OR status!="9" OR status!="11" OR status!="13")'));
                        if (empty($model_ticket) && empty($model_ticket_encashed)) {
                            $is_ticket_available = 1;
                        } else {
                            $is_ticket_available = 0;
                        }
                    }
                    //Ticket ENds
                    if ($master_leave_apply == 'Y' || (($balance_leave > 0 || ($value_details->negative_leave_apply_permission == 'B' && $balance_leave <= 0)) && empty($model_leave_applied) && (empty($model_leave_encashable)))) {
                        if ($value_details->sub_type_leave == "N") {
                            $master_leave_apply = 'Y';
                        }
                        $button_string = 'Y';
                    } else if (!empty($model_leave_applied) || $master_leave_apply == 'N') {
                        if ($value_details->sub_type_leave == "N") {
                            $master_leave_apply = 'N';
                        }
                        $button_string = 'N';
                    }
                    if ($model_master_employee->branch_sponsor->leave_encashment_provided == 'Y') {
                        if ($value_details->encashable == "Y" && $balance_leave > 0 && empty($model_leave_applied) && empty($model_leave_encashable)) {
                            $encashable_btn = 'Y';
                        } else if ($value_details->encashable == "Y" && !empty($model_leave_encashable)) {
                            $encashable_btn = 'N';
                        }
                    }
                    $data[] = array(
                        "id" => (string) $value_details->id,
                        "type" => $value_details->leave_name,
                        "display_leave_balance" => $value_details->leave_count_employee_panel,
                        "opening_leave" => $opening_leave_value,
                        "leave_taken" => number_format($leave_taken, 2),
                        "leave_encashed" => number_format($leave_encashed, 2),
                        "current_leave" => $balance_leave,
                        "salary_per_day" => $salary_per_day,
                        "show_open_balance" => $opn_leave_value,
                        "show_current_balance" => $curnt_leave_value,
                        "can_applied" => $button_string,
                        "encashable_btn" => $encashable_btn,
                        "leave_encashable" => $encashable_leave,
                        "is_ticket_available" => $is_ticket_available,
                        "document_medical_certificate_upload" => $document_medical_certificate_upload,
                        "leave_apply_start_date"=>$last_locked_date,
                        "message" => $message);
                }
            }
            $response = array('status' => "success", "msg" => "Success", 'data' => $data);
            if (empty($data)) {
                $response = array('status' => "failed", "msg" => "No data found", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data, "token_status" => "UA");
        }

        echo json_encode($response);
    }
        public function actionLeaveDashboard() {
        $data = [];
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $employee_id = $_REQUEST['id'];
            $master_leave_id = 0;
            $current_date = date('Y-m-d');
            $model_general_setting = HrGenerelSettings::model()->find();
            $year = date("Y");
            $current_year = $year;
            $current_month = date("m");
            if ($current_month < $model_general_setting->leave_carry_forward_month) {
                $year = $year - 1;
            }
            $model_master_employee = Employee::model()->findbypk($employee_id);
            $service_days = 0;
            if (!empty($model_master_employee)) {
                if ($model_master_employee->date_join != '' && $model_master_employee->date_join != "0000-00-00") {
                    $d1 = strtotime($model_master_employee->date_join);
                    $d2 = strtotime(date('Y-m-d'));
                    $datediff = $d2 - $d1;
                    $service_days = $datediff / (60 * 60 * 24) + 1;
                }
            }

            $model_lock = SalarySlip::model()->with('processing')->find(array('select' => 'max(t.salary_processing_id) as salary_processing_id', 'condition' => 'processing.payroll_status="2" and employee_id="' . $employee_id . '"'));
            $last_locked_date = "";
            if (!empty($model_lock) && $model_lock->salary_processing_id > 0) {
                $model_last_locked = SalaryProcessing::model()->findbypk($model_lock->salary_processing_id);
                $payroll_enddate = date('Y-m-d', strtotime('+1 days', strtotime($model_last_locked->payroll_enddate)));
                $last_locked_date = date('d/m/Y', strtotime($payroll_enddate));
//                if ($model_general_setting->unpaid_leave_joining_day > 0) {
//                    $pay_year = date('Y', strtotime($model_last_locked->payroll_enddate));
//                    $pay_month = date('m', strtotime($model_last_locked->payroll_enddate));
//                    $last_locked_date = date('d/m/Y', strtotime("{$pay_year}-{$pay_month}-{$model_general_setting->unpaid_leave_joining_day} +1 day"));
//                }
            } else {
                $model_lock_branch = SalaryProcessing::model()->find(array('select' => 'max(payroll_enddate) as payroll_enddate', 'condition' => 'payroll_status="2" and (payroll_branch_or_sponsor_id="' . $model_master_employee->branch_or_sponsor_id . '" OR payroll_branch_or_sponsor_id="0")'));
                if ($model_lock_branch->payroll_enddate != '' && $model_lock_branch->payroll_enddate != '0000-00-00') {
                    $payroll_enddate = date('Y-m-d', strtotime('+1 days', strtotime($model_lock_branch->payroll_enddate)));
                    $last_locked_date = date('d/m/Y', strtotime($payroll_enddate));
//                    if ($model_general_setting->unpaid_leave_joining_day > 0) {
//                        $pay_year = date('Y', strtotime($model_lock_branch->payroll_enddate));
//                        $pay_month = date('m', strtotime($model_lock_branch->payroll_enddate));
//                        $last_locked_date = date('d/m/Y', strtotime("{$pay_year}-{$pay_month}-{$model_general_setting->unpaid_leave_joining_day} +1 day"));
//                    }
                }
            }


            $model_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount', 'condition' => 'employee_id="' . $employee_id . '" and isActive="Y" and consider_for_leave_payment="Y" AND valid_from <="' . $current_date . '" AND valid_to ="0000-00-00"'));
            $salary_amount = $salary_per_day = 0;
            if (!empty($model_salary)) {
                $salary_amount = $model_salary->amount;
                $salary_per_day = ($salary_amount / 30);
            }
            $leave_condition = 'isActive="Y" and sub_type_leave="N" and branch_id="' . $model_master_employee->branch_or_sponsor_id . '"   AND  (visible_portal="Y" OR visible_portal="E") AND (employee_can_apply="0" OR employee_can_apply<="' . $service_days . '")';
            if($model_master_employee->gender>0){
                $leave_condition.= ' AND (gender="0" OR gender="' . $model_master_employee->gender . '")'; 
            }
            $model_master_leave = MasLeave::model()->findAll(array('condition' => $leave_condition, 'order' => 'leave_name asc'));
            $data = [];
            $response = array();
            foreach ($model_master_leave as $i => $value) {
                $year = date("Y");
                $master_leave_apply = '';
                $show_app_dashboard = $value->show_app_dashboard;
                $master_leave_id = $value->id;
                $document_medical_certificate_upload = $value->document_medical_certificate_upload;
                $model_sub_leave = MasLeave::model()->findAll(array('condition' => 'isActive="Y" and (parent_id="' . $value->id . '" OR  id="' . $value->id . '") and branch_id="' . $model_master_employee->branch_or_sponsor_id . '"', 'order' => 'leave_name asc'));
                $opening_leave_value = $leave_current_balance = $balance_leave = $encashable_leave = $leave_taken = 0.00;
                $message = "";
                foreach ($model_sub_leave as $j => $value_details) {
                    //if master leave
                    $opening_leave_value = $leave_current_balance = $balance_leave = $encashable_leave = $leave_taken = $leave_encashed = $curnt_leave_value = $opn_leave_value = 0.00;
                    $message = '';
                    $button_string = $encashable_btn = "N";
                    if ($value_details->sub_type_leave == 'N') {
                        $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $value_details->id . '" and employee_id="' . $employee_id . '" and leave_year="' . $year . '"'));
                        $opening_leave_value = number_format($model_leave->leave_opening, 2);
                        $opn_leave_value = number_format($model_leave->leave_opening, 2);
                        $leave_current_balance = $model_leave->leave_current_balance;
                        if ($model_leave->leave_current_balance > 0) {
                            $balance_leave = $model_leave->leave_current_balance;
                            $curnt_leave_value = $model_leave->leave_current_balance;
                        }
                        if ($value_details->encashable == "Y") {
                            $encashable_leave = $model_leave->leave_current_balance;
                        }
                        //additional leave
                        if ($value_details->additional_leave > 0) {
                            $balance_leave += $value_details->additional_leave;
                            $curnt_leave_value += $value_details->additional_leave;
                            $leave_current_balance += $value_details->additional_leave;
                        }
                        //Check Leave Applied
                        $model_leave_applied = EmployeeLeaveDetail::model()->with('leavetype')->find(array('condition' => 't.employee_id="' . $employee_id . '" AND (t.leave_type="' . $value_details->id . '" OR leavetype.parent_id="' . $value_details->id . '") and (leave_status="1" OR leave_status="2" OR leave_status="4" OR leave_status="6" OR leave_status="8" OR leave_status="10")'));
                        //Check Encashable Applied
                        $model_leave_encashable = EmployeeLeaveEncashment::model()->findAll(array('condition' => 'status="1" and leave_type_id="' . $value_details->id . '" and employee_id="' . $employee_id . '"'));
                        //Encashment Approved
                        $model_leave_encashable_approved = EmployeeLeaveEncashment::model()->find(array('select' => 'sum(encashable_leave) as encashable_leave', 'condition' => 'status="2" and leave_type_id="' . $value_details->id . '" and encashment_year="' . $year . '" and employee_id="' . $employee_id . '"'));
                        if ($model_leave_encashable_approved->encashable_leave > 0) {
                            $message = "Leave Encashed=" . $model_leave_encashable_approved->encashable_leave;
                            $leave_encashed = $model_leave_encashable_approved->encashable_leave;
                        }
                        //Leave Taken
                        $model_leave_details = EmployeeLeaveDetail::model()->find(array('select' => 'sum(normal_leave) as normal_leave', 'condition' => 'YEAR(leave_start_date)="' . $current_year . '" AND employee_id="' . $employee_id . '" AND leave_type="' . $value_details->id . '" and leave_status="12"'));
                        if ($model_leave_details->normal_leave > 0) {
                            $leave_taken = $model_leave_details->normal_leave;
                        }
                        //Incase of Cancelled Leave
                        $model_leave_ledger = EmployeeLeaveLedger::model()->find(array('select' => 'sum(leave_reduce) as leave_reduce', 'condition' => 'leave_type="' . $value_details->id . '" and employee_id="' . $employee_id . '" and YEAR(created_date_time)="' . $current_year . '"'));
                        if ($model_leave_ledger->leave_reduce > 0) {
                            $leave_taken += $model_leave_ledger->leave_reduce;
                        }
//                        $current_leave_value = number_format($leave_current_balance, 2);
                        if ($value_details->leave_count_employee_panel == 'N') {
                            $opn_leave_value = number_format(0.00, 2);
                            $curnt_leave_value = number_format(0.00, 2);
                        }
                        if ($value_details->leave_apply_limit == 'Y' && $curnt_leave_value > $value_details->max_leave_apply) {
                            $curnt_leave_value = number_format($value_details->max_leave_apply, 2);
                        }
                    } else if ($value_details->sub_type_leave == 'Y') {
                        $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $value_details->parent_id . '" and employee_id="' . $employee_id . '" and leave_year="' . $year . '"'));
                        if ($model_leave->leave_current_balance > 0) {
                            $balance_leave = $model_leave->leave_current_balance;
                        }
                        //additional leave
                        if ($value_details->additional_leave > 0 && $model_leave->leave_current_balance >= 0) {
                            $balance_leave += $value_details->additional_leave;
                        }
                    }
                    //Ticket Eligibility
                    $is_ticket_available = 0;
                    if ($value_details->ticket_available == "Y" && $model_master_employee->branch_sponsor->ticket_provided == 'Y') {
                        $model_ticket = EmployeeTicket::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type="' . $value_details->id . '" and year="' . $year . '" AND ticket_type="E" and (status!="3" OR status!="5" OR status!="7" OR status!="9" OR status!="11" OR status!="13")'));
                        $model_ticket_encashed = EmployeeTicketEncashment::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_id="' . $value_details->id . '" and year="' . $year . '" and (status!="3" OR status!="5" OR status!="7" OR status!="9" OR status!="11" OR status!="13")'));
                        if (empty($model_ticket) && empty($model_ticket_encashed)) {
                            $is_ticket_available = 1;
                        } else {
                            $is_ticket_available = 0;
                        }
                    }
                    //Ticket ENds
                    if ($master_leave_apply == 'Y' || (($balance_leave > 0 || ($value_details->negative_leave_apply_permission == 'B' && $balance_leave <= 0)) && empty($model_leave_applied) && (empty($model_leave_encashable)))) {
                        if ($value_details->sub_type_leave == "N") {
                            $master_leave_apply = 'Y';
                        }
                        $button_string = 'Y';
                    } else if (!empty($model_leave_applied) || $master_leave_apply == 'N') {
                        if ($value_details->sub_type_leave == "N") {
                            $master_leave_apply = 'N';
                        }
                        $button_string = 'N';
                    }
                    if ($model_master_employee->branch_sponsor->leave_encashment_provided == 'Y') {
                        if ($value_details->encashable == "Y" && $balance_leave > 0 && empty($model_leave_applied) && empty($model_leave_encashable)) {
                            $encashable_btn = 'Y';
                        } else if ($value_details->encashable == "Y" && !empty($model_leave_encashable)) {
                            $encashable_btn = 'N';
                        }
                    }
                    $data[] = array(
                        "id" => (string) $value_details->id,
                        "type" => $value_details->leave_name,
                        "display_leave_balance" => $value_details->leave_count_employee_panel,
                        "opening_leave" => $opening_leave_value,
                        "leave_taken" => number_format($leave_taken, 2),
                        "leave_encashed" => number_format($leave_encashed, 2),
                        "current_leave" => $balance_leave,
                        "salary_per_day" => $salary_per_day,
                        "show_open_balance" => $opn_leave_value,
                        "show_current_balance" => $curnt_leave_value,
                        "can_applied" => $button_string,
                        "encashable_btn" => $encashable_btn,
                        "leave_encashable" => $encashable_leave,
                        "is_ticket_available" => $is_ticket_available,
                        "document_medical_certificate_upload" => $document_medical_certificate_upload,
                        "leave_apply_start_date"=>$last_locked_date,
                        "show_app_dashboard"=>$show_app_dashboard,
                        "message" => $message);
                }
            }
            $response = array('status' => "success", "msg" => "Success", 'data' => $data);
            if (empty($data)) {
                $response = array('status' => "failed", "msg" => "No data found", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "failed", "msg" => "Unauthorized user", 'data' => $data, "token_status" => "UA");
        }

        echo json_encode($response);
    }
    public function actionCheckleaveDate() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array["employee_id"];
            $available_leave = $data_array["available_leave"];
            $leave_type = $data_array["leave_type"];
            $start_date = $data_array["start_date"];
            $end_date = $data_array["end_date"];
            $checkbox = $data_array["half_leave"];
            $current_leave_year = date('Y');
            if ($start_date != '' && $end_date != '') {
                $start_date = str_replace('/', '-', $start_date);
                $start_date = date("Y-m-d", strtotime($start_date));
                $end_date = str_replace('/', '-', $end_date);
                $end_date = date("Y-m-d", strtotime($end_date));
                $current_date = date('Y-m-d');
                $date1_convert = strtotime($current_date);
                $date2_convert = strtotime($start_date);
                $apply_days = $date2_convert - $date1_convert;
                $applyday = floor($apply_days / (60 * 60 * 24));
                $model_master_leave = MasLeave::model()->findbyPk($leave_type);
                //$additional_leave=$model_master_leave->additional_leave;
                //$available_leave+=$additional_leave;
                $model_setting = HrGenerelSettings::model()->find();
                $model_employee_dtl = Employee::model()->findbyPk($employee_id);
                //Check holiday deducted
                $model_branch_details = MasCompanyBranchSponsor::model()->findbyPK($model_employee_dtl->branch_or_sponsor_id);
                $include_holiday = '';
                if ($model_master_leave->exclude_holiday == 'Y') {
                    $include_holiday = 'N';
                } else if ($model_master_leave->exclude_holiday == 'N') {
                    $include_holiday = 'Y';
                }
                if ($model_setting->leave_apply_before_current_date == 'Y') {
                    $model_master_leave->apply_before = 0;
                }
                $advance_leave = 0;
                if ($model_setting->consider_advance_leave == 'Y' && $model_master_leave->leave_type == 1) {
                    //code updated by nisha on 28-09-2023
                    $service_year = $this->getserviceyear($model_employee_dtl->date_join, $start_date);
                    $incremented_leave = $model_master_leave->leave_days;
                    if ($service_year >= 10) {
                        $incremented_leave = $model_master_leave->leave_days_above_10;
                    } else if ($service_year >= 5) {
                        $incremented_leave = $model_master_leave->leave_days_above_5;
                    }
                    $per_day_leave = ($incremented_leave * 12) / 365;
                    //end code    
                    //Get Max Salary Details
                    $model_max_id = SalarySlip::model()->with('processing')->find(array('select' => 'MAX(salary_processing_id) as salary_processing_id', 'condition' => 'processing.payroll_status="2" AND employee_id="' . $employee_id . '"'));
                    if ($model_max_id->salary_processing_id > 0) {
                        $model_salry_processing = SalaryProcessing::model()->findbyPk($model_max_id->salary_processing_id);
                        $payroll_dt = $model_salry_processing->payroll_enddate;
                        $advance_days = ((strtotime($start_date) - strtotime($payroll_dt)) / (60 * 60 * 24)) - 1;
                        if ($advance_days > 0) {
                            $advance_leave = round($advance_days * $per_day_leave, 2);
                        }
                        /* $date_for_advnc_1 = strtotime($payroll_dt);
                          $date_for_advnc_2 = strtotime($start_date);
                          $year11 = date('Y', $date_for_advnc_1);
                          $year12 = date('Y', $date_for_advnc_2);
                          $month11 = date('m', $date_for_advnc_1);
                          $month12 = date('m', $date_for_advnc_2);
                          $advance_leave_month = (($year12 - $year11) * 12) + ($month12 - $month11);
                          $available_leave += $advance_leave_month * $incremented_leave; */
                        $available_leave += $advance_leave;
                    } else {
                        $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch="' . $model_employee_dtl->branch_or_sponsor_id . '"'));
                        if ($model_lock_month->id == '') {
                            $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch=0'));
                        }
                        $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch="' . $model_employee_dtl->branch_or_sponsor_id . '"'));
                        if ($model_lock_days->id == '') {
                            $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch=0'));
                        }
                        $salary_last_date = $model_lock_month->payroll_year . '-' . $model_lock_month->payroll_month . '-' . $model_lock_days->payroll_start_day;
                        // $salary_last_date=date('Y-m-d', strtotime('+1 month', strtotime($salary_last_date)));

                        if (strtotime($salary_last_date) < strtotime($model_employee_dtl->date_join)) {
                            $salary_last_date = $model_employee_dtl->date_join;
                        }
                        $advance_days = ((strtotime($start_date) - strtotime($salary_last_date)) / (60 * 60 * 24)) - 1;
                        /*   $date_for_advnc_1 = strtotime($salary_last_date);
                          $date_for_advnc_2 = strtotime($start_date);
                          $year11 = date('Y', $date_for_advnc_1);
                          $year12 = date('Y', $date_for_advnc_2);
                          $month11 = date('m', $date_for_advnc_1);
                          $month12 = date('m', $date_for_advnc_2);
                          $advance_leave_month = (($year12 - $year11) * 12) + ($month12 - $month11);
                          $available_leave += $advance_leave_month * $incremented_leave; */
                        if ($advance_days > 0) {
                            $advance_leave = round($advance_days * $per_day_leave, 2);
                        }
                        $available_leave += $advance_leave;
                    }
                }

                if ($model_master_leave->sub_type_leave == "N") {
                    $model_leave_table_exist = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $leave_type . '" and leave_year="' . $current_leave_year . '"'));
                } else if ($model_master_leave->sub_type_leave == "Y") {
                    $model_leave_table_exist = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $current_leave_year . '"'));
                }
                if (!empty($model_leave_table_exist)) {
                    //Attendance marked
                    $model_attendance_present = EmployeeAttendance::model()->findAll(array('condition' => 'employee_id="' . $employee_id . '" and attendance_date>="' . $start_date . '" AND attendance_date<="' . $end_date . '" and status="1"', 'order' => 'attendance_date asc'));
                    if (empty($model_attendance_present)) {
                        if ($applyday >= $model_master_leave->apply_before || $model_master_leave->apply_before == 0) {
                            $model_employee_leave_approved = EmployeeLeaveDetail::model()->findAll(array('condition' => 'employee_id="' . $employee_id . '" and ((leave_start_date<="' . $start_date . '" AND leave_end_date>="' . $end_date . '") OR  (leave_start_date BETWEEN  "' . $start_date . '" AND  "' . $end_date . '"
                                        OR leave_end_date BETWEEN  "' . $start_date . '" AND  "' . $end_date . '")) and (leave_status="1" or leave_status="2" or leave_status="4" or leave_status="6" or leave_status="8" or leave_status="10" or leave_status="12" or leave_status="14" or leave_status="15" or leave_status="17" or leave_status="19" or leave_status="21")'));
                            if (empty($model_employee_leave_approved)) {
                                $model = Employee::model()->findbyPK($employee_id);
                                $weekend_off1 = $model->weekend_off1;
                                $weekend_off2 = $model->weekend_off2;
                                $weekend_off3 = $model->weekend_off3;
                                $weekend = $model_master_leave->exclude_weekend;
                                //Day Calculation
                                $leave_days = 0;
                                $d1 = strtotime($start_date);
                                $d2 = strtotime($end_date);
                                $total_days = $d2 - $d1;
                                if ($weekend == 'Y') {
                                    $datefrom = $start_date;
                                    $diff = floor($total_days / (60 * 60 * 24));
                                    for ($i = 0; $i <= $diff; $i++) {
                                        $model_holiday = MasHoliday::model()->find(array('condition' => 'holiday_date="' . $datefrom . '" AND FIND_IN_SET("' . $model_employee_dtl->branch_or_sponsor_id . '",branch_id)'));
                                        $weekvalue = date('w', strtotime($datefrom));
                                        $weekvalue += 1;
                                        if ($weekend_off1 == $weekvalue) {
                                            if ($model->weekend_off1_type == 'H') {
                                                $leave_days = $leave_days + 0.5;
                                            }
                                        } else if ($weekend_off2 == $weekvalue) {
                                            if ($model->weekend_off2_type == 'H') {
                                                $leave_days = $leave_days + 0.5;
                                            }
                                        } else if ($weekend_off3 == $weekvalue) {
                                            if ($model->weekend_off3_type == 'H') {
                                                $leave_days = $leave_days + 0.5;
                                            }
                                        } else if ($include_holiday == "Y" && !empty($model_holiday)) {
                                            $leave_days++;
                                        } else if ($include_holiday == "N" && !empty($model_holiday)) {
                                            
                                        } else {
                                            $leave_days++;
                                        }
                                        $datefrom = date('Y-m-d', strtotime($datefrom . ' +1 day'));
                                    }
                                    if ($checkbox == 1) {
                                        $leave_days = $leave_days - 0.5;
                                    }
                                } else {
                                    $datefrom = $start_date;
                                    $diff = floor($total_days / (60 * 60 * 24));
                                    for ($i = 0; $i <= $diff; $i++) {
                                        if ($include_holiday == "Y" && !empty($model_holiday)) {
                                            $leave_days++;
                                        } else if ($include_holiday == "N" && !empty($model_holiday)) {
                                            
                                        } else {
                                            $leave_days++;
                                        }
                                        $datefrom = date('Y-m-d', strtotime($datefrom . ' +1 day'));
                                    }
                                    //$leave_days = floor($total_days / (60  60  24) + 1);
                                    if ($checkbox == 1) {
                                        $leave_days = $leave_days - 0.5;
                                    }
                                }

                                //check negative leave apply permission
                                if ($model_master_leave->negative_leave_apply_permission == 'B') {  //Leave limit condition when negative 
                                    if ($leave_days <= $available_leave) {
                                        if ($model_master_leave->leave_apply_limit == 'Y') {
                                            if ($model_master_leave->max_leave_apply >= $leave_days) {
                                                $days = $leave_days;
                                                $normal_leave = $leave_days;
                                                $salary_deduction_leave = 0.00;
                                                $status = 'success';
                                                $message = '';
                                            } else {
                                                $message = 'Maximum leave limit for this leave type is' . $model_master_leave->max_leave_appl;    //Leave apply limit error
                                                $status = 'error';
                                            }
                                        } else {
                                            $days = $leave_days;
                                            $normal_leave = $leave_days;
                                            $salary_deduction_leave = 0.00;
                                            $status = 'success';
                                            $message = '';
                                        }
                                    } else {
                                        if ($model_master_leave->leave_apply_limit == 'Y') {   //Leave limit condition when negative salary deduction
                                            if ($model_master_leave->max_leave_apply >= $leave_days) {
                                                if ($model_master_leave->salary_deduction_negative_leave != 'N') {
                                                    $salary_deduction_leave = $leave_days - $available_leave;
                                                    $days = $leave_days;
                                                    $normal_leave = $available_leave;
                                                    $status = 'success';
                                                    $message = 'Available leave is ' . $normal_leave . ' and applied for ' . $days . ' leaves.Salary deducted for ' . $salary_deduction_leave . ' leaves.'; //8
                                                } else {
                                                    $days = $leave_days;
                                                    $normal_leave = $leave_days;
                                                    $salary_deduction_leave = 0.00;
                                                    $status = 'success';
                                                    $message = '';
                                                }
                                            } else {
                                                $message = 'Maximum leave limit for this leave type is ' . $model_master_leave->max_leave_apply;    //Leave apply limit error 9
                                                $status = 'error';
                                            }
                                        } else {
                                            if ($model_master_leave->salary_deduction_negative_leave != 'N') {
                                                $salary_deduction_leave = $leave_days - $available_leave;
                                                $days = $leave_days;
                                                $normal_leave = $available_leave;
                                                $status = 'success';
                                                $message = 'Available leave is ' . $normal_leave . ' and applied for ' . $days . ' leaves.Salary deducted for ' . $salary_deduction_leave . ' leaves.'; //8
                                            } else {
                                                $days = $leave_days;
                                                $normal_leave = $leave_days;
                                                $salary_deduction_leave = 0.00;
                                                $status = 'success';
                                                $message = '';
                                            }
                                        }
                                    }
                                } else {
                                    if ($leave_days > $available_leave) {
                                        $message = 'Leaves not availabe.Maximum available leave is ' . $available_leave;    //Leave not available 4
                                        $status = 'error';
                                    } else {
                                        if ($model_master_leave->leave_apply_limit == 'Y') {
                                            if ($model_master_leave->max_leave_apply >= $leave_days) {
                                                $days = $leave_days;
                                                $normal_leave = $leave_days;
                                                $salary_deduction_leave = 0.00;
                                                $status = 'success';
                                            } else {
                                                $message = 'Maximum leave limit for this leave type is ' . $model_master_leave->max_leave_apply;
                                                $status = 'error';
                                            }
                                        } else {
                                            $days = $leave_days;
                                            $normal_leave = $leave_days;
                                            $salary_deduction_leave = 0.00;
                                            $status = 'success';
                                        }
                                    }
                                }
                            } else {
                                $message = 'Leave applied in this date range';    //Already Leave applied 3
                                $status = 'error';
                            }
                        } else {
                            $message = 'Leave should be applied before ' . $model_master_leave->apply_before;    //Apply before master set value 5
                            $status = 'error';
                        }
                    } else {
                        $date_array = array();
                        foreach ($model_attendance_present as $key => $value) {
                            $date_array[] = date("d/m/Y", strtotime($value->attendance_date));
                        }
                        $attendancedate = implode(',', $date_array);
                        $message = 'Attendance marked as present for ' . $attendancedate;    //Attendance-Present added 6
                        $status = 'error';
                    }
                } else {
                    $message = 'Leave Balance Record not Present.Contact HR';    //Leave balance record error 7
                    $status = 'error';
                }
            } else {
                if ($start_date == '') {
                    $message = 'Select Start Date'; //Start Date Null 1
                } else if ($end_date == '') {
                    $message = 'Select End Date'; //End Date Null 2
                }
                $status = 'error';
            }
            $model_ticket_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="11"'));
            $ticket_approve_level = 0;
            if (!empty($model_ticket_approve_setting)) {
                $ticket_approve_level = $model_ticket_approve_setting->id;
            }
            $document_medical_certificate_upload='N';
            $model_upload_medical = HrMasterUpload::model()->findByPK(16);
            if ($model_master_leave->document_medical_certificate_upload == 'Y' && $days >= $model_master_leave->min_day_upload && $model_master_leave->min_day_upload>0 && $model_upload_medical->isActive=='Y') {
                $document_medical_certificate_upload = 'Y';
            }
            $data = array(
                "days" => $days,
                "normal_leave" => $normal_leave,
                "salary_deduction_leave" => $salary_deduction_leave,
                "status" => $status,
                "message" => $message,
                'employee_id' => $data_array["employee_id"],
                'available_leave' => $data_array["available_leave"],
                'leave_type' => $data_array["leave_type"],
                'start_date' => $data_array["start_date"],
                'end_date' => $data_array["end_date"],
                'ticket_approve_level' => $ticket_approve_level,
                'document_medical_certificate_upload' => $document_medical_certificate_upload,
            );
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo CJSON::encode($data);
    }
    public function actionUploadDocument($folder = NULL) {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $model_upload_document = HrMasterUpload::model()->findByPK(1);
            if($model_upload_document->isActive=='Y'){
                
                $upload_size = $model_upload_document->max_upload_size * 1024 * 1024;
                $employee_id =$userModel->employee_id;
                $certificate_name = $_FILES["file"]["name"];
                $extension = pathinfo($certificate_name, PATHINFO_EXTENSION);
                $fileSize = $_FILES["file"]['size'];
                if ($fileSize < $upload_size) {
                    $model_employee= Employee::model()->findbyPK($employee_id);
                    //$model_employee=
                    $current_date =date('Y-m-d');
                    $new_file_name="Employee_document_";
                    if(!empty($model_employee)){
                        $new_file_name.=str_replace(' ', '_', $model_employee->employeecode);
                    }
                    $new_file_name.='_'.$current_date.'_'.uniqid().'.'.$extension;
                    $folder = Yii::getPathOfAlias('webroot') . '/uploads/documents/' . $new_file_name;
                    move_uploaded_file($_FILES["file"]["tmp_name"], $folder);
                    $jsonData['filename'] = $new_file_name;
                    $jsonData['status'] = 'success';
                }else{
                    $jsonData = array('status' => "failed", "msg" => "File too large. Maximum size is ".$model_upload_document->max_upload_size." MB",'filename'=>'', "token_status" => "UA");
                
                }
            }else{
                 $jsonData = array('status' => "failed", "msg" => "Document uploads are not allowed under your current subscription plan",'filename'=>'', "token_status" => "UA");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $jsonData = array('status' => "failed", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo json_encode($jsonData);
    }
    public function actionUploadDocumentold($folder = NULL) {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            // $model_employee = Employee::model()->findbypk($_REQUEST['employee_id']);
            $certificate_name = $_FILES["file"]["name"];
            $folder = Yii::getPathOfAlias('webroot') . '/uploads/documents/' . $certificate_name;
            move_uploaded_file($_FILES["file"]["tmp_name"], $folder);
            $jsonData['filename'] = $certificate_name;
            $jsonData['status'] = 'success';
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $jsonData = array('status' => "failed", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo json_encode($jsonData);
    }


    public function actionSalarySlip() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            ini_set("memory_limit", "-1");
            ini_set('max_execution_time', "-1");
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array['employee_id'];
            $month = $data_array['month'];
            $year = $data_array['year'];
            $model_employee = Employee::model()->findByPk($employee_id);
            $sal_slip_app_view = 0;
            if ($model_employee->branch_sponsor->salary_slip_view_ess == "Y") {
                $model = SalarySlip::model()->with('processing')->find(array('condition' => 'employee_id="' . $employee_id . '" and MONTH(processing.payroll_enddate)="' . $month . '" and YEAR(processing.payroll_enddate)= "' . $year . '"  AND processing.show_pay_slip_employee="Y"'));
                if ($model->id > 0) {
                    $month_name=HrGenerelSettings::getMonthAbb($month);
                    $pdf_name=$model_employee->employeecode.'_'.$month_name.'_'.$year.'_'.date('Y-m-d H:i:s').'.pdf';
                    // $pdf_name = "salaryslip.pdf";
                    $file_path = 'uploads/apppdf/' . $pdf_name;
                    $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
                    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
                    $mPDF1->WriteHTML($stylesheet, 1);
                    $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.salary.pdf.new_salary_slip', array('employee_id' => $employee_id, 'id' => $model->salary_processing_id), true));
                    $mPDF1->Output($file_path, 'F');
                    $data = array('status' => "success", "msg" => "Success", "pdflink" => $file_path, "file_name" => $pdf_name);
                } else {
                    $data = array('status' => "error", "msg" => "Salary Slip not available for this month");
                }
            } else {
                $data = array('status' => "error", "msg" => "Payslip is currently Disabled");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo json_encode($data);
    }
    public function actionDocumentlist() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $data = [];
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array["employee_id"];
            if ($id > 0) {
                $model_documents = EmployeeDocuments::model()->with('document')->findAll(array('condition' => 'employee_id="' . $id . '" and document.view_in_employee="Y" '));
                $data = [];
                if (!empty($model_documents)) {
                    foreach ($model_documents as $row) {
                        $validity = "";
                        $view_button = 0;
                        $extension = "";
                        if ($row->validate_till_date != '' && $row->validate_till_date != '0000-00-00') {
                            $validity = date("d/m/Y", strtotime($row->validate_till_date));
                        }
                        $renew_on = "";
                        if ($row->renew_on != '' && $row->renew_on != '0000-00-00') {
                            $renew_on = $row->renew_on = date("d/m/Y", strtotime($row->renew_on));
                        }
                        $date_show = "N";
                        if ($row->document->document_type == 1) {
                            $date_show = "Y";
                        }
                        $document_file = '';
                        $dwn_btn = 0;
                        $pdf_url = '';
                        if ($row->document_file != '') {
                            $dwn_btn = 1;
                            $file = $row->document_file;
                            $extension = pathinfo($file, PATHINFO_EXTENSION);
                            $arr_doc_val = explode(',', $row->document_file);
                            if (count($arr_doc_val) > 1) {
                                $document_file = 'document.zip';
                            } else {
                                $document_file = $row->document_file;
                                $view_button = 1;
                            }
                            $document_file_name = str_replace(' ', '%20', $document_file);
                            $pdf_url = '/uploads/documents/' . $document_file_name;
                        }


                        $data[] = [
                            "id" => (string) $row->id,
                            "document_name" => $row->document->document_name,
                            "document_no" => $row->document_number,
                            "document_file" => $pdf_url,
                            "download" => $dwn_btn,
                            "date_of_validity" => $validity,
                            "renew_on" => $renew_on,
                            "date_show" => $date_show,
                            "view_button" => $view_button,
                            "file_format" => $extension
                        ];
                    }
                    $response = array("status" => "success", "msg" => "success", 'data' => $data);
                } else {
                    $response = array("status" => "success", "msg" => "No data available", 'data' => $data);
                }
            } else {
                $response = array("status" => "error", "msg" => "Input parameters missing", 'data' => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array("status" => "error", "msg" => "Unauthorized user", 'data' => $data, "token_status" => "UA");
        }
        echo json_encode($response);
    }

    public function actiondownloadDocument() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $id = $_REQUEST["id"];
            $arr_employee_document = EmployeeDocuments::model()->findByPk($id);
            $file = $arr_employee_document->document_file;
            $arr_doc_val = explode(',', $arr_employee_document->document_file);
            if (count($arr_doc_val) > 1) {
                $zip = new ZipArchive();
                $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/documents/document.zip";
                if ($zip->open($zip_file_path, ZipArchive::CREATE) === TRUE) {
                    for ($i = 0; $i < count($arr_doc_val); $i++) {
                        $path = "uploads/documents/" . $arr_doc_val[$i];
                        // Add the files to the .zip file
                        $zip->addFile($path, $arr_doc_val[$i]);
                    }
                    // Closing the zip file
                    $zip->close();
                }
                header("Content-type:application/zip"); //for pdf file
                header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
                header('Content-Length: ' . filesize($zip_file_path));
                readfile($zip_file_path);
                unlink($zip_file_path);
                Yii::app()->end();
            } else {
                $file = $arr_employee_document->document_file;
                $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file;
                header("Content-type:application/octet-stream"); //for txt file
                header("Content-Type: application/download");
                header('Content-Disposition: attachment; filename="' . basename($path) . '"');
                header('Content-Length: ' . filesize($path));
                readfile($path);
                Yii::app()->end();
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed", "msg" => "Unauthorized user", "token_status" => "UA");
            echo json_encode($data);
        }
    }

    public function actionDocumentTypes() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $model = new MasDocument();
            $condition = "t.view_in_employee = 'Y'";
            $doc_tyes = $model->findall(array('condition' => $condition, 'order' => 't.id ASC'));
            $data = [];
            if (!empty($doc_tyes)) {
                foreach ($doc_tyes as $tp) {
                    $data[] = [
                        "id" => (string) $tp['id'],
                        "doc_name" => $tp['document_name'],
                        "renewal_remainder" => (string) $tp['renewal_remainder'],
                    ];
                }
                header("HTTP/1.1 200 OK");
                header('Content-Type: application/json');
                $responseArray = array('status' => "success", "msg" => "success", "data" => $data);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $responseArray = array('status' => "error", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo json_encode($responseArray);
    }

    public function actionUpdateDocument() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            date_default_timezone_set("Asia/Dubai");
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array['employee_id'];
            $user_id = $userModel->id;
            if ($data_array['document_id'] != '') {
                if ($data_array['id'] > 0) {
                    $model_document = EmployeeDocuments::model()->findByPK($data_array['id']);
                    $model_document->updated_by = $user_id;
                    $model_document->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model_document = new EmployeeDocuments();
                    $model_document->created_by = $user_id;
                    $model_document->created_date_time = date('Y-m-d H:i:s');
                }
                $model_document->document_id = $data_array['document_id'];
                $model_document->document_number = $data_array['document_number'];
                $model_document->employee_id = $employee_id;
                $model_document->document_file = $data_array['document_file'];
                if ($data_array['validate_till_date'] != '' && $data_array['validate_till_date'] != '0000-00-00') {
                    $valid_date = $data_array['validate_till_date'];
                    $model_document->validate_till_date = $data_array['validate_till_date'];
                    $current_date = date("Y-m-d");
                    if (strtotime($valid_date) > strtotime($current_date)) {
                        $model_document->status = 0;
                        $model_document->expiry_notify = 0;
                    }
                }
                if ($data_array['renew_on'] != '' && $data_array['renew_on'] != '0000-00-00') {
                    $model_document->renew_on = $data_array['renew_on'];
                }
                if ($model_document->validate()) {
                    $model_document->save();
                    $response = array('status' => "success", "msg" => "success");
                } else {
                    $errors = $model_document->errors;
                    $arr_err = array();
                    foreach ($model_document->errors as $t => $value) {
                        $arr_err[] = $value[0];
                    }
                    $response = array('status' => "error", 'msg' => $arr_err);
                }
            } else {
                $response = array('status' => "error", "msg" => "Please Select Document");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "error", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo json_encode($response);
    }

    public function actionGetEmployeeGeocode() {
        $response = array();
        $data = array();
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $baseUrl = Yii::app()->baseUrl;
            $data_array = json_decode(file_get_contents('php://input'), true);
            $id = $data_array['employee_id'];
            $model_geocode = HrEmployeeGeocode::model()->with('geolocation_details')->findAll(array('condition' => 't.isActive="Y" AND employee_id="' . $id . '"'));
            if (!empty($model_geocode)) {
                foreach ($model_geocode as $key => $value) {

                    $data [] = [
                        "id" => $value->id,
                        "latitude" => $value->geolocation_details->latitude,
                        "longitude" => $value->geolocation_details->longitude,
                    ];
                } $bounding_box_radius = 0;
                $radius = HrGenerelSettings::model()->find();
                if (!empty($radius)) {
                    $bounding_box_radius = $radius['geo_location_distance'];
                }
                $response = array('status' => "success", "msg" => "success", "geocordinates_avaialble" => $data, 'bounding_box_radius' => $bounding_box_radius, 'punch_access' => 1);
            } else {
                $response = array('status' => "error", "msg" => "No data", "geocordinates_avaialble" => $data, 'punch_access' => 0);
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "error", "msg" => "Unauthorized user", "geocordinates_avaialble" => $data, "token_status" => "UA");
        }
        echo json_encode($response);
    }

    public function includecomingweekend($employee_id, $start_date, $end_date) {
        $weekend_count = 0;
        $model = Employee::model()->findbyPK($employee_id);
        $weekend_off1_type = $model->weekend_off1_type;
        $weekend_off2_type = $model->weekend_off2_type;
        $weekend_off3_type = $model->weekend_off3_type;
        $weekend_off1 = $model->weekend_off1;
        $weekend_off2 = $model->weekend_off2;
        $weekend_off3 = $model->weekend_off3;
        $datediff = strtotime($end_date) - strtotime($start_date);
        $total_days = $datediff / (60 * 60 * 24) + 1;
        //For One weekend
//        echo $start_date;
        $days = $weekvalue = 0;
        if ($weekend_off1 > 0 && $weekend_off2 == 0 && $weekend_off3 == 0 && $total_days > 1) {
            if ($weekend_off1_type == 'F') {
                $weekend_start_date = date('Y-m-d', strtotime('+2 days', strtotime($start_date)));
                $weekvalue = date('w', strtotime($weekend_start_date));
                $weekvalue += 1;
            }
            if (($weekend_off1 == $weekvalue) && (strtotime($weekend_start_date) > strtotime($end_date))) {
                $days = 1;
            }
            if ($days == 0 && $total_days > 2) {
                $weekend_end_date = date('Y-m-d', strtotime('-1 days', strtotime($end_date)));
                $weekend_start_date = date('Y-m-d', strtotime('+2 days', strtotime($weekend_end_date)));
                $weekvalue = date('w', strtotime($weekend_start_date));
                $weekvalue += 1;
                if (($weekend_off1 == $weekvalue) && (strtotime($weekend_start_date) > strtotime($end_date))) {
                    $days = 1;
                }
            }
        } else if ($weekend_off1 > 0 && $weekend_off2 > 0 && $weekend_off3 == 0 && $total_days > 1) {
            if ($weekend_off1_type == 'F') {
                $weekend_start_date = date('Y-m-d', strtotime('+2 days', strtotime($start_date)));
                $next_date = date('Y-m-d', strtotime('+1 days', strtotime($start_date)));
                $weekvalue = date('w', strtotime($weekend_start_date));
                $weekvalue += 1;
            }
            if (($weekend_off1 == $weekvalue) && (strtotime($weekend_start_date) > strtotime($end_date))) {
                $days++;
            }
            if ($weekend_off2_type == 'F') {
                $weekend_start_date_1 = date('Y-m-d', strtotime('+2 days', strtotime($next_date)));
                $weekvalue_1 = date('w', strtotime($weekend_start_date_1));
                $weekvalue_1 += 1;
            }
            if (($weekend_off2 == $weekvalue_1) && (strtotime($weekend_start_date_1) > strtotime($end_date))) {
                $days++;
            }
            if ($days == 0 && $total_days > 2) {
                $weekend_end_date = date('Y-m-d', strtotime('-1 days', strtotime($end_date)));
                $weekend_start_date = date('Y-m-d', strtotime('+2 days', strtotime($weekend_end_date)));
                $weekvalue = date('w', strtotime($weekend_start_date));
                $weekvalue += 1;
                if (($weekend_off1 == $weekvalue) && (strtotime($weekend_start_date) > strtotime($end_date))) {
                    $days++;
                }
                if (($weekend_off2 == $weekvalue) && (strtotime($weekend_start_date) > strtotime($end_date))) {
                    $days++;
                }
                if ($weekend_off2_type == 'F') {
                    $weekend_next_date = date('Y-m-d', strtotime('+1 days', strtotime($weekend_start_date)));
                    $weekvalue_1 = date('w', strtotime($weekend_next_date));
                    $weekvalue_1 += 1;
                    if (($weekend_off2 == $weekvalue_1) && (strtotime($weekend_next_date) > strtotime($end_date))) {
                        $days++;
                    }
                }
            }
        }
        return $days;
    }

    public function actionUpdatePassword() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);

        if ($userModel->id > 0) {
            $user_id = $userModel->id;
            $data_array = json_decode(file_get_contents('php://input'), true);
            $employee_id = $data_array['employee_id'];
            $curr_pwd = $data_array['user_current_password'];
            $new_pwd = $data_array['user_new_password'];
            $rep_pwd = $data_array['user_reenter_password'];
            $arr_user_details = User::model()->findByPk($user_id);
            $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
            $password = crypt($curr_pwd, $salt);
            if ($arr_user_details->password == $password) {
                $new_password = crypt($new_pwd, $salt);
                $arr_user_details->password = $new_password;
                $arr_user_details->password_reset = 'Y';
                $arr_user_details->token = "";
                $arr_user_details->save(false);
                $response = array('status' => "success", "msg" => "success");
            } else {
                $response = array('status' => "failed", "msg" => "Incorrect current password ");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $response = array('status' => "error", "msg" => "Unauthorized user", "token_status" => "UA");
        }
        echo json_encode($response);
    }
    public function actionProfilePhoto() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $model_employee = Employee::model()->findbypk($_REQUEST['employee_id']);
            $profile_pic_name=$model_employee->employeecode.'_'.$_FILES["file"]["name"];
            $folder = Yii::getPathOfAlias('webroot') . '/uploads/profilephotos/'.$profile_pic_name;
            move_uploaded_file($_FILES["file"]["tmp_name"], $folder);
            $jsonData['filename'] = $profile_pic_name;
            $jsonData['status'] = 'success';
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $jsonData = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }
        echo json_encode($jsonData);
    }
    public function actionSaveProfilePic() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $data_array = json_decode(file_get_contents('php://input'), true); 
            $id=$data_array['id'];
            $profile_photo=$data_array['profile_photo'];
            if ($profile_photo!="") {
                Employee::model()->updateByPK($id, array('profile_photo' => $profile_photo, 'updated_date_time' => date('Y-m-d H:i:s'), 'updated_by' => Yii::app()->user->id));
                $data['status'] = 'success';
            } else {
                $arr_err=array();
                if ($profile_photo!="") {
                   $arr_err[]="Please Upload Image";
                }else{
                   $arr_err[]="Error in getting employee details";
                }
                $data=array('status' => 'error','message'=>$arr_err);
            }
        }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data[] = array('status' => "failed","msg"=>"Unauthorized user");
        }
        echo json_encode($data);
    }
    function getserviceyear($joining_date, $payroll_start) {
        $date1 = new DateTime($joining_date);
        $date2 = new DateTime($payroll_start);
        $dd = date_diff($date1, $date2);
        $service_yr = $dd->y;
        return $service_yr;
    }
    
}
