<?php
$cs = Yii::app()->getClientScript();
?>



<script>
    param_index = 8;
    $(document).ready(function() {
        table_id = "#tbl_header_details";
        table = $(table_id).on("preXhr.dt", function(e, settings, data) {

            data.display_type = $("#display_type").val();
            data.status_type = $("#status_type").val();
            data.to_date = $("#to_date").val();
            data.from_date = $("#from_date").val();
            data.issue_types = $("#issue_types").val();
            data.priority = $("#priority").val();
            return data;
        }).DataTable({

            scrollY: "645px",
            pageLength: 50,
            processing: true,
            "order": [
                [0, "desc"]
            ],
            ajax: {

                url: "<?php echo Yii::app()->createUrl('fm/ticket/GetList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function(nRow, aData, iDataIndex) {

                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {

                AddContextMenu(nRow, aData);
                //alert(aData[6].color_code);
                $("td", nRow).css("background-color", aData[param_index].color_code);
                var status_id = aData[param_index].status_id.toString().trim();
                if (status_id === "5") {
                    $("td", nRow).css("text-decoration", "line-through");
                }
            }



        });
    });

    function AddContextMenu(row, datas) {

        var mas_edit = 0;
        var mas_allotment = 0;
        var param_id = 6;
        var mas_disable = 0;
        <?php if (isset(Yii::app()->user->havePermissionOn['job_order_edit']) || Yii::app()->user->authorised_user == 1) { ?>

            var mas_edit = 1;
        <?php } ?>

        <?php if (isset(Yii::app()->user->havePermissionOn['job_order_allotment']) || Yii::app()->user->authorised_user == 1) { ?>

            var mas_allotment = 1;
        <?php } ?>

        $(row).contextMenu({

            selector: 'td',
            items: {
                <?php if (isset(Yii::app()->user->havePermissionOn['job_order_edit']) || Yii::app()->user->authorised_user == 1) { ?> "edit": {

                        name: "Edit",
                        icon: "edit",
                        accesskey: "e",
                        callback: function() {

                            loadPopupModal("fm/ticket/create&id=" + datas[param_index].id, "Edit - " + datas[param_index].id, "xl");
                        },
                        visible: function(key, opt) {

                            // this references the trigger element

                            return (datas[param_index].view == 'N');
                        }

                    },
                    "view": {

                        name: "View",
                        icon: "edit",
                        accesskey: "e",
                        callback: function() {

                            loadPopupModal("fm/ticket/create&id=" + datas[param_index].id + '&frm=view', "View - " + datas[param_index].id, "xl");
                        },
                        visible: function(key, opt) {
                            return (datas[param_index].view == 'Y');
                        }

                    },
                <?php } ?> "print": {

                    name: "Print Job",
                    icon: "fa-print",
                    accesskey: "e",
                    callback: function() {

                        var url = "index.php?r=fm/ticket/print&id=" + datas[param_index].id;
                        window.open(url);
                    },
                    disabled: function(key, opt) {

                        // this references the trigger element

                        if (mas_edit == '0') {

                            return !this.data('editDisabled');
                        }

                    }

                },


                "print_completion": {

                    name: "Print Completion Report",
                    icon: "fa-print",
                    accesskey: "e",
                    callback: function() {

                        var url = "index.php?r=fm/snag/printJobCompletionReport&ticket_id=" + datas[param_index].id;
                        window.open(url);
                    },
                    disabled: function(key, opt) {

                        // this references the trigger element

                        if (datas[param_index].showCompletion_pdf == 'N') {

                            return !this.data('editDisabled');
                        }

                    }

                },


                "print_maintenance": {

                    name: "Print Maintenance Request",
                    icon: "fa-print",
                    accesskey: "e",
                    callback: function() {

                        var url = "index.php?r=fm/snag/print&id=" + datas[param_index].snag_id;
                        window.open(url);
                    },
                    disabled: function(key, opt) {

                        // this references the trigger element

                        if (datas[param_index].snag_id <=0) {

                            return !this.data('editDisabled');
                        }

                    }

                },

                <?php if (isset(Yii::app()->user->havePermissionOn['job_order_allotment']) || Yii::app()->user->authorised_user == 1) { ?> "Allot": {

                        name: "Alot Technician",
                        icon: "edit",
                        accesskey: "a",
                        callback: function() {

                            loadPopupModal("fm/ticket/alot&id=" + datas[param_index].id, "Alot Technician to - " + datas[param_index].id, "xl");
                        },
                        disabled: function(key, opt) {

                            // this references the trigger element

                            if (mas_allotment == '0') {

                                return !this.data('Disable_EnableDisabled');
                            }

                        },
                        visible: function(key, opt) {

                            //visible only on open, alloted, and work in progress.

                            var status_id = datas[param_index].status_id.toString();
                            return (status_id === "1" || status_id === "2" || status_id === "6");
                        }

                    },
                <?php } ?>
                <?php if (isset(Yii::app()->user->havePermissionOn['job_order_edit']) || Yii::app()->user->authorised_user == 1) { ?>
                    start_job: {

                        name: "Start Job",
                        icon: "edit",
                        accesskey: "s",
                        callback: function(key, opt) {

                            loadPopupModal("fm/jobtime/startjob&id=" + datas[param_index].id, "Start Job - " + datas[param_index].id, "xl");
                        },
                        visible: function(key, opt) {

                            //visible only on open, alloted, and work in progress.

                            var status_id = datas[param_index].status_id.toString();
                            return (status_id === "2" || status_id === "6");
                        }



                    },
                    "Stop": {

                        name: "Stop Job",
                        icon: "edit",
                        accesskey: "a",
                        callback: function() {

                            loadPopupModal("fm/jobtime/stopjob&id=" + datas[param_index].id, "Stop - " + datas[param_index].id, "lg");
                        },
                        disabled: function(key, opt) {

                            // this references the trigger element

                            if (mas_disable == '0') {

                                return !this.data('Disable_EnableDisabled');
                            }

                        },
                        visible: function(key, opt) {

                            //visible only on work in progress(6).

                            var status_id = datas[param_index].status_id.toString();
                            return (status_id === "6");
                        }

                    },
                <?php } ?>
                <?php
                //if (isset(Yii::app()->user->havePermissionOn['job_order_request_item']) || Yii::app()->user->authorised_user == 1) {
                ?>
                //                "Request": {
                //
                //                name: "Request Material",
                //                        icon: "edit",
                //                        accesskey: "a",
                //                        callback: function () {
                //
                //                        loadPopupModal("fm/ticket/requestmaterial&id=" + datas[param_index].id, "Request Material For - " + datas[param_index].id, "xl");
                //                        },
                //                        visible: function (key, opt) {
                //                        var status_id = datas[param_index].status_id.toString().trim();
                //                        return (status_id === "1" || status_id === "2" || status_id === "6");
                //                        }
                //
                //                },
                <?php
                //}
                ?>
                <?php if (isset(Yii::app()->user->havePermissionOn['job_order_issue_item']) || Yii::app()->user->authorised_user == 1) { ?> "Issue": {

                        name: "Issue Material",
                        icon: "edit",
                        accesskey: "a",
                        callback: function() {
                            var good_issuse_id = datas[param_index].good_issuse_id.toString().trim();
                            var good_issuse_type = datas[param_index].good_issuse_type.toString().trim();
                            if (good_issuse_id === "" || good_issuse_id === "0") {
                                loadPopupModal("issues/create&ticket_id=" + datas[param_index].id, "Issue Material For - " + datas[param_index].id, "xl");
                            } else {
                                loadPopupModal("issues/create&id=" + good_issuse_id + "&status=" + good_issuse_type, "Issue Material For - " + datas[param_index].id, "xl");
                            }
                        },
                        visible: function(key, opt) {
                            var status_id = datas[param_index].status_id.toString().trim();
                            return (status_id === "1" || status_id === "2" || status_id === "6");
                        }

                    },
                <?php } ?>
                <?php if (isset(Yii::app()->user->havePermissionOn['fm_snag_add']) || isset(Yii::app()->user->havePermissionOn['fm_snag_edit']) || Yii::app()->user->authorised_user == 1) { ?> "snag": {

                        name: "Snag List",
                        icon: "edit",
                        accesskey: "a",
                        callback: function() {
                            var job_id = datas[param_index].id.toString();
                            loadPopupModal("fm/snag/create&job_id=" + job_id, "Snag For - " + datas[param_index].id, "xl");
                        },
                        visible: function(key, opt) {
                            var status_id = datas[param_index].status_id.toString().trim();
                            return (status_id === "1" || status_id === "2" || status_id === "6");
                        }

                    },
                <?php }
                if (isset(Yii::app()->user->havePermissionOn['job_order_edit']) || Yii::app()->user->authorised_user == 1) { ?>
                    finish: {

                        name: "Work FInished",
                        icon: "quit",
                        callback: () => {



                            workfinished(datas[param_index].id.toString());
                        },
                        visible: function(key, opt) {

                            //visible only on work in progress(6).

                            var status_id = datas[param_index].status_id.toString();
                            return (status_id === "6");
                        }

                    },
                    complete: {

                        name: "Work Completed",
                        icon: "quit",
                        callback: () => {



                            loadPopupModal("fm/jobtime/Jobcompleted&id=" + datas[param_index].id, "Work Completed - " + datas[param_index].id, "lg");
                        },
                        visible: function(key, opt) {

                            //visible only on work in finished.

                            var status_id = datas[param_index].status_id.toString();
                            return (status_id === "7");
                        }

                    },
                <?php } ?>
                <?php if (isset(Yii::app()->user->havePermissionOn['job_order_convert']) || Yii::app()->user->authorised_user == 1) { ?>
                    convert_quote: {
                        name: "Convert to Quote",
                        icon: "quit",
                        callback: function() {
                            var quotation_id = datas[param_index].quotation_id.toString().trim();
                            var snag_id = datas[param_index].snag_id.toString().trim();
                            var url = "quotation/create&";
                            console.log("quotation_id " + quotation_id);
                            if (quotation_id === "0" || quotation_id === "") {
                                url += "snag_id=" + snag_id + "&ticket_id=" + datas[param_index].id;
                            } else {
                                url += "id=" + quotation_id + "&file_id=" + datas[param_index].master_file_id;
                            }
                            loadPopupModal(url, "Quotation Job Order - " + datas[param_index].id, "xl");
                        },
                        visible: function() {
                            var status_id = datas[param_index].status_id.toString().trim();
                            var quotation_id = datas[param_index].quotation_id.toString().trim();
                            if (status_id === "5") {
                                return false;
                            } else if (quotation_id === '' || quotation_id === '0') {
                                return true;
                            } else {
                                return false;
                            }
                        }
                    },
                <?php } ?>
                <?php if (isset(Yii::app()->user->havePermissionOn['job_order_cancel']) || Yii::app()->user->authorised_user == 1) { ?>
                    cancel: {
                        name: "Cancel Ticket",
                        icon: "quit",
                        callback: function() {
                            var ticket_id = datas[param_index].id.toString().trim();
                            cancelTicket(ticket_id);
                        },
                        visible: function(key, opt) {
                            var status_id = datas[param_index].status_id.toString().trim();
                            var visible = ((status_id === "1") || (status_id === "2") || (status_id === "6"));
                            return visible;
                        }

                    },
                <?php } ?>


            }

        });
    }
</script>

<script>
    function Disable(id, status) {

        var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
        if (r == true)

        {

            jQuery.ajax({

                'type': 'post',
                'datatype': 'json',
                'data': 'id=' + id + "&status=" + status,
                'url': $('#liveSite').val() + 'index.php?r=property/Disable',
                'cache': false,
                'success': function(data) {

                    if (data.status == 'fail') {

                        t8.error('Error while Delete');
                    } else {

                        $('#tbl_header_details').DataTable().ajax.reload()

                        t8.success(' Success!');
                    }

                }

            });
        }





    }
</script>

<section class="panel" style="background-color:#F6F3EE;">

    <header class="panel-heading clearfix panel-theame">

        <i class="fa fa-bank"></i> Job Order
        <div class="col-sm-1 pull-right">
            <?php
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["job_order_add"])) {
            ?>
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('fm/ticket/create', 'Add New Job Order', 'xl')"> <i class="fa fa-plus"></i> ADD</button>
            <?php
            }
            ?>


        </div>

        <div class="pull-right">

            <button class="btn btn-sm btn-theme" onclick="reloadTable('#tbl_header_details');"> <i class="fa fa-refresh"></i> LOAD</button>

        </div>
        <div class="top_controls_select col-sm-8 pull-right">
            <div class="col-sm-2 pull-right">

                <?php echo CHtml::dropdownList('priority', '', FmPriority::getAll(), array('class' => 'form-control', 'onChange' => 'reloadTable("#tbl_header_details")', 'empty' => 'Priority')); ?>

            </div>


            <div class="col-sm-2 pull-right">

                <?php echo CHtml::dropdownList('issue_types', '', MasterIssueType::getIssueType(), array('class' => 'form-control', 'onChange' => 'reloadTable("#tbl_header_details")', 'empty' => 'Issue Type')); ?>

            </div>



            <div class="col-sm-2 pull-right">

                <?php echo CHtml::dropdownList('status_type', '', FmTicketStatus::getAll(), array('class' => 'form-control', 'empty' => 'All Status', 'onChange' => 'reloadTable("#tbl_header_details")')); ?>

            </div>

            <div class="col-sm-2 pull-right">

                <?php echo CHtml::textField('to_date', date("t/m/Y"), array('data-label' => 'Select End Date', 'class' => 'datepicker form-control ')); ?>

            </div>

            <div class="col-sm-2 pull-right">

                <?php echo CHtml::textField('from_date', date('01/m/Y'), array('data-label' => 'Select From Date', 'class' => 'datepicker form-control ')); ?>

            </div>



        </div>



    </header>

    <div class="panel-body">

        <div class="custom-data-table">

            <table class="table table-hover table-bordered personal-task" id="tbl_header_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>Job Order No</th>
                        <th>Issue Type</th>
                        <th>Unit</th>
                        <th>Notes</th>
                        <th>Remark</th>
                        <th>Ticket Date</th>
                        <th>Ticket Status</th>
                    </tr>
                </thead>
            </table>
            <div>
                <?php
                $statusList = FmTicketStatus::model()->findAll(["condition" => "isActive ='Y' ", 'order' => 'status_name desc']);
                foreach ($statusList as $key => $value) {
                ?>
                    <div class="color-box" style="background: <?= $value->color_code ?>">
                        <?php echo ucwords($value->status_name) ?>
                    </div>
                <?php
                }
                ?>
            </div>
        </div>

    </div>

</section>
<style>
    .status-Q {
        background: #04aa6d;
    }

    .status-I {
        background: #04aa6d;
    }

    .color-box {
        width: 150px;
        float: right;
        display: inline;
        padding: 2px;
        padding-left: 6px;
        margin: 4px;
        border: 1px #f3f6f4 solid;
        border-radius: 3px;
    }
</style>
<script>
    function cancelTicket(ticket_id) {
        var message = "Do you want to cancel this ticket?";
        var dr = confirm(message);
        if (dr) {
            jQuery.ajax({
                dataType: 'json',
                type: 'POST',
                url: 'index.php?r=fm/ticket/deletecancel',
                cache: false,
                data: {
                    id: ticket_id
                },
                success: function(data) {
                    $("#loader").hide();
                    if (data.status == "success") {
                        t8.success("Details cancelled successfully!");
                        reloadTable(table_id);
                    } else {
                        $.each(data, function(key, val) {
                            $("#plate-type-form #" + key + "_em_").text(val).show();
                            t8.error("" + val + "");
                        });
                    }
                },
                complete: function() {
                    $("#loader").hide();
                },
                beforeSend: function() {
                    $("#loader").show();
                }
            });
        }
    }
</script>
<script>
    function workfinished(job_id) {
        var message = "Do you want to finish this job?";
        var dr = confirm(message);
        if (dr) {
            jQuery.ajax({
                dataType: 'json',
                type: 'POST',
                url: 'index.php?r=fm/jobtime/jobfinished',
                cache: false,
                data: {
                    job_id: job_id
                },
                success: function(data) {
                    $("#loader").hide();
                    if (data.status == "success") {
                        t8.success("Details Saved successfully!");
                        reloadTable(table_id);
                    } else {
                        t8.error("Error in finishing.");
                        $.each(data, function(key, val) {
                            $("#sales-form #" + key + "_em_").text(val).show();
                            t8.error("" + val + "");
                        });
                    }
                },
                complete: function() {
                    $("#loader").hide();
                },
                beforeSend: function() {
                    $("#loader").show();
                }
            });
        }
    }
</script>