<?php
$cs = Yii::app()->getClientScript();
?>
<script>
    param_index = 6;
    $(document).ready(function() {
        table_id = "#tbl_header_details";
        table = $(table_id).on("preXhr.dt", function(e, settings, data) {

            data.display_type = $("#display_type").val();
            data.status_type = $("#status_type").val();
            data.to_date = $("#to_date").val();
            data.from_date = $("#from_date").val();
            data.issue_types = $("#issue_types").val();
            data.priority = $("#priority").val();
            return data;
        }).DataTable({

            scrollY: "645px",
            pageLength: 50,
            processing: true,
            order: [
                [0, "desc"]
            ],
            ajax: {

                url: "<?php echo Yii::app()->createUrl('fm/snag/getlist') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            fnCreatedRow: function(nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            fnRowCallback: function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
            }
        });
    });
</script>

<script>
    function AddContextMenu(nRow, datas) {
        <?php
        if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fm_snag_edit"]) || ((int) Yii::app()->user->havePermissionOn["fm_snag_view"]) || ((int) Yii::app()->user->havePermissionOn["fm_snag_convert"])) {
        ?>
            $(nRow).contextMenu({
                selector: 'td',
                items: {

                    <?php
                    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fm_snag_edit"])) {
                    ?>
                        edit: {
                            name: "Edit",
                            icon: "edit",
                            accesskey: "e",
                            callback: function() {
                                loadPopupModal("fm/snag/create&job_id=" + datas[param_index].job_id, "Edit - " + datas[param_index].id, "xl");
                            },
                            visible: function(key, opt) {
                                return true;
                            }
                        },
                    <?php
                    }
                    ?>
                    <?php
                    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fm_snag_view"])) {
                    ?>
                        print_snag: {
                            name: "Print Maintenance Request",
                            icon: "fa-print",
                            accesskey: "e",
                            callback: function() {
                                window.open("index.php?r=fm/snag/print&id=" + datas[param_index].id, "_blank");
                            },
                            visible: function(key, opt) {
                                return true;
                            }
                        },
                    <?php } ?>
                    <?php
                    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fm_snag_convert"])) {
                    ?>
                        convert: {
                            name: "Convert to Quote",
                            icon: "fa-exchange",
                            accesskey: "e",
                            callback: function() {
                                loadPopupModal("quotation/create&snag_id=" + datas[param_index].id, "Quote fronm Snag  #" + datas[param_index].id, "xl");
                            },
                            visible: function(key, opt) {
                                return true;
                            }
                        },
                    <?php } ?>


                    "print_Completion": {

                        name: "Print Completion Report",
                        icon: "fa-print",
                        accesskey: "e",
                        callback: function() {

                            var url = "index.php?r=fm/snag/printJobCompletionReport&ticket_id=" + datas[param_index].job_id;
                            window.open(url);
                        },
                        disabled: function(key, opt) {

                            // this references the trigger element

                            if (datas[param_index].showCompletion_pdf == 'N') {

                                return !this.data('editDisabled');
                            }

                        }

                    },


                }
            });
            /// ending full permission
        <?php } ?>
    }
</script>


<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-bank"></i> Maintenance Snag List
        <div class="col-sm-1 pull-right">

        </div>
        <div class="pull-right">
            <button class="btn btn-sm btn-theme" onclick="reloadTable(table_id);"> <i class="fa fa-refresh"></i> LOAD</button>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_header_details" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Job Order No</th>
                        <th>Building</th>
                        <th>Unit</th>
                        <th>Date</th>
                        <th>Technician</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>