<?php
$machine_list = $model->machine_rel;
if (empty($machine_list)) {
    $machine_list = [new FmServiceContractMachine()];
}
?>

<table class="table table-hover table-bordered personal-task" id="tbl-machine-list">
    <thead>
        <tr>
            <th>#</th>
            <th>Serial no</th>
            <th>Machine</th>
            <th>Machine No</th>
            <th class="text-center">
                <a class="btn btn-xs btn-theme" href="javascript:void(0);" onclick="addTableRow($('#tbl-machine-list'));">
                    <i class="fa fa-plus"></i>
                </a>
            </th>
    </thead>
    <tbody>
        <?php
        foreach ($machine_list as $key => $machine) {
            ?>
            <tr>
                <td>
                    <label>
                        <?php echo ($key + 1) ?>
                    </label>
                </td>
                <td>
                    <?php
                    if (!empty($machine->id)) {
                        $machine->machine_serial_no = $machine->machine_rel->serial_no;
                        $machine->machine_name = $machine->machine_rel->machine_name;
                        $machine->machine_no = $machine->machine_rel->machine_id;
                    }

                    echo $form->hiddenField($machine, "[$key]id")
                    ?>
                    <?php echo $form->hiddenField($machine, "[$key]machine_id") ?>
                    <?php echo $form->textField($machine, "[$key]machine_serial_no", ['class' => 'form-control go', 'onkeyup' => 'js:autoCompleteMachine(this.id,"machine-list");']) ?>
                </td>
                <td>
                    <?php echo $form->textField($machine, "[$key]machine_name", ['class' => 'form-control go', 'readonly' => true]) ?>
                </td>
                <td>
                    <?php echo $form->textField($machine, "[$key]machine_no", ['class' => 'form-control go', 'readonly' => true]) ?>
                </td>
                <td class="text-center" >
                    <a class="btn btn-xs btn-danger " onclick="removeMachineTableRow($('#tbl-machine-list'), this)" title="Remove this item" href="javascript:void(0);">
                        <i class="fa fa-times"></i>
                    </a>
                </td>
            </tr>
            <?php
        }
        ?>
    </tbody>
</table>
<script>
    function autoCompleteMachine(field_id, frm) {
        var url = 'index.php?r=fm/machinery/autocomplete';

        var arr_field_id = field_id.split('_');

        var index = arr_field_id[1];

        $('#' + field_id).autocomplete({
            minLength: 1,
            source: function (request, response) {
                jQuery.ajax({
                    url: url,
                    dataType: 'json',
                    type: 'GET',
                    data: {term: request.term},
                    success: function (data) {
                        response(data);
                    },
                }, );
            },
            focus: function (event, ui) {
                $(this).val((ui.item.label));
                return false;
            },
            select: function (event, ui) {
                event.preventDefault();
                trigger_target_id = $(event.target).attr('id');
                $("#FmServiceContractMachine_" + index + "_machine_name").val(ui.item.label);
                $("#FmServiceContractMachine_" + index + "_machine_no").val(ui.item.machine_id);
                $("#FmServiceContractMachine_" + index + "_machine_id").val(ui.item.value);
                $("#FmServiceContractMachine_" + index + "_machine_serial_no").val(ui.item.serial_no);
                console.log(ui);
            }
        });

    }
</script>
<script>

    function removeMachineTableRow(jQtable, evt) {
        var dResult = Confirm("Do you want to delete this?");
        if (dResult) {
            formIdStarter = jQtable.attr('id').split(/_(.+)?/)[0];
            var num_rows = jQtable.find('tr:gt(0)').length;
            var input_array = $(evt).parents('tr').find('input:first').attr('id').toString().split("_");
            var row_index = input_array[0];
            var id = $("#FmServiceContractMachine_" + row_index + "_id").val();
            jQuery.ajax({
                dataType: 'json',
                type: 'POST',
                url: 'index.php?r=fm/servicecontract/deletemachine',
                cache: false,
                data: {id: id},
                success: function (data) {
                    if (data.status == "success") {
                        if (num_rows > 1) {
                            $(evt).parents('tr').remove();
                        } else {
                            $(evt).parents('tr').find('input, textarea, select').val('');
                        }
                        var i = 0;
                        jQtable.find('tr:gt(0)').each(function () {
                            $(this).find('input,select,textarea,.errorMessage').each(function () {
                                old_id = $(this).attr('id');
                                new_id = old_id.replace(/\d+/, i);
                                $(this).attr('id', new_id);
                                old_name = $(this).attr('name');
                                if (old_name !== undefined) {
                                    new_name = old_name.replace(/\d+/, i);
                                    $(this).attr('name', new_name);
                                }
                            });
                            $(this).find('td:first label').html(++i);
                        });
                    } else {
                        $.each(data, function (key, val) {
                            $("#plate-type-form #" + key + "_em_").text(val).show();
                            t8.error("" + val + "");
                        });
                    }
                },

            });
//            if (num_rows > 1) {
//                var tr = $(evt).parent().parent();
//                if (isRowEmpty(tr)) {
//
//                }
//            } else {
//                alert('Atleast one item needed here');
//            }
        }
    }
</script>