<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("deletebuilding", "function deletebuilding(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'datatype':'json',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=fm/scheduled/deletebuilding',
              'cache': false,
              'success':function(data){
                console.log(data);
                if(data.status=='success'){
                    reloadTable('#tbl_service_contract');
                    t8.success('building Deleted!');

                }else {
                    t8.error('history exists, Deletion failed!');
                }
               }
            });
        }


};", CClientScript::POS_HEAD);

$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>

<script>
    $(document).ready(function() {
        table_id = "#tbl_service_contract";
        param_index = 7;
        var table = $(table_id).on("preXhr.dt", function(e, settings, data) {
            data.from_date = $("#from_date").val();
            data.to_date = $("#to_date").val();
            data.converted_id = $("#converted_id").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            order: [
                [0, "ASC"]
            ],
            ajax: {
                url: "index.php?r=fm/scheduled/GetList",
                type: "POST",
                cache: false,
            },
            
            serverSide: true,
            fixedColumns: true,
            "fnCreatedRow": function(nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
                if (aData[param_index].is_converted == "N") {
                    $("td", nRow).css("background-color", "#FFE6E6");
                } else {
                    $("td", nRow).css("background-color", "#a3f199");
                }
            },
        });
        $('#tbl_service_contract tbody').on('mouseover', 'tr', function() {
            $.contextMenu('destroy');
        });
        $('#tbl_service_contract tbody').on('click', 'tr', function() {
            var data = table.row(this).data();
            $.contextMenu({
                selector: '.context-menu',
                items: {
                    <?php if (isset(Yii::app()->user->havePermissionOn['planned_maintenance_edit']) || Yii::app()->user->authorised_user == 1) { ?>
                        edit: {
                            name: "Contract",
                            icon: "fa-eye",
                            disabled: function(key, opt) {},
                            callback: function() {
                              //  loadPopupModal("fm/plannedmaintenance/create&id=" + data[param_index].header_id, 'Contract#' + data[param_index].header_id, "xl");
                               
                                loadPopupModal("fm/plannedmaintenance/create&id=" + data[param_index].header_id + "&view=scheduled", 'Contract#' + data[param_index].header_id, "xl");

                            },
                        },
                    <?php } ?>
                    <?php if (isset(Yii::app()->user->havePermissionOn['planned_maintenance_convert']) || Yii::app()->user->authorised_user == 1) { ?>
                        convert: {
                            name: "Convert to Job",
                            icon: "fa-exchange",
                            callback: function() {
                                loadPopupModal("fm/ticket/create&scheduled_id=" + data[param_index].id, 'Contract#' + data[param_index].header_id, "xl");
                            },
                            visible: function() {
                                var is_converted = data[param_index].is_converted.toString().trim();
                                return (is_converted == 'N');
                            }
                        },
                    <?php } ?>
                    <?php if (isset(Yii::app()->user->havePermissionOn['job_order_view']) || Yii::app()->user->authorised_user == 1) { ?>
                        view_ticket: {
                            name: "View Job",
                            icon: "fa-ticket",
                            callback: function() {
                                loadPopupModal("fm/ticket/create&id=" + data[param_index].ticket_id, 'Job Order#' + data[param_index].ticket_id, "xl");
                            },
                            visible: function() {
                                var is_converted = data[param_index].is_converted.toString().trim();
                                return (is_converted == 'Y');
                            }
                        },
                    <?php } ?>
                },
            });
        });
    });
</script>

<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="material-icons"></i> Scheduled Maintenance List
        <div class="col-sm-2 pull-right">
            <?php echo CHtml::dropDownList('converted_id', "N", ["Y" => "Converted", "N" => "Not Converted"], ['class' => 'form-control input-sm', 'onchange' => 'refresh()']) ?>
        </div>
        <div class="col-sm-2 pull-right">
            <?php echo CHtml::textField('from_date', date('t/m/Y'), array('data-label' => 'Select From Date', 'class' => 'datepicker form-control', 'onblur' => 'refresh()')); ?>
        </div>
        <div class="col-sm-2 pull-right">
            <?php echo CHtml::textField('to_date', date("01/m/Y"), array('data-label' => 'Select End Date', 'class' => 'datepicker form-control', 'onblur' => 'refresh()')); ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_service_contract" style="font-size:13px;">
                <thead>
                    <tr>

                        <th>Sl No</th>
                        <th>Contract ID</th>
                        <th>Planned Date</th>
                        <th>Unit</th>
                        <th>Contract type</th>
                        <th>Scheduled Type</th>
                        <th>Converted to Job</th>

                    </tr>
                </thead>
                <tfoot>
                    <tr>


                        <th>Sl No</th>
                        <th>Contract ID</th>
                        <th>Planned Date</th>
                        <th>Unit</th>
                        <th>Contract Type</th>
                        <th>Scheduled Type</th>
                        <th>Converted to Job</th>

                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</section>
<script>
    function Disable(id, status) {

        var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
        if (r == true)

        {

            jQuery.ajax({

                'type': 'post',
                'datatype': 'json',
                'data': 'id=' + id + "&status=" + status,
                'url': $('#liveSite').val() + 'index.php?r=fm/plannedmaintenance/Disable',
                'cache': false,
                'success': function(data) {

                    if (data.status == 'fail') {

                        t8.error('Error while Delete');
                    } else {

                        $('#tbl_service_contract').DataTable().ajax.reload()

                        t8.success(' Success!');
                    }

                }

            });
        }





    }
</script>
<script>
    function refresh() {
        reloadTable(table_id);
    }
</script>