
<script>
    $(document).ready(function() {
        loadIssueList();
    });
    function loadIssueList() {
        var table_id = "#tble_purchase_invoice";
        var table = $(table_id).on("preXhr.dt", function(e, settings, data) {
            data.contract_id = $("#contract_id").val();
            return data;
        }).DataTable({
            scrollY: "300px",
            pageLength: 50,
            processing: true,
            columns: [
                  {className: "nw sl col-max-2"},
                      {className: "nw sl col-max-2"},      
                      {className: "nw sl col-max-2"},      
                      {className: "nw sl col-max-2"},
                      {className: "nw sl col-max-6"},
                      {className: "nw sl col-max-2"},      
                      {className: "text-right"},
                      {className: "text-right"},
                      {className: "nw sl col-max-2"},
                      {className: "nw sl col-max-2"},
                     
            ],
             "columnDefs": [
                          {
                             "targets": [10],
                             "visible": false,
                          },
                          {
                             "targets": [8],
                             "orderable": false,
                          }
                       ],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('fm/plannedmaintenance/GetContractPurchaseInvoiceList') ?>",
                type: "POST",
                cache: false,
            },
             "fnDrawCallback": function() {
                                var api = this.api()
                                var json = api.ajax.json();
                                $(api.column(6).footer()).html(Number(json.total_amount).toFixed(2));
                                $(api.column(7).footer()).html(Number(json.total_tax).toFixed(2));
                                $(api.column(8).footer()).html(Number(json.grand_total).toFixed(2));
                            },
                            
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function(nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            }
        });
        $('#tble_purchase_invoice tbody').on('mouseover', 'tr', function() {
            $.contextMenu('destroy');
        });
        $('#tble_purchase_invoice tbody').on('click', 'tr', function() {
            var data = table.row(this).data();

            var id				    =	data[2];
     
		var crm_user_id		    =   data[10];
     
       
            $.contextMenu({
                selector: '.context-menu',
                callback: function(key, options) {
                    var action_id = key;
                    
                    if (action_id == "print") {
                        	   window.open($('#liveSite').val()+"/index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id="+id+"&c_id="+crm_user_id,"_blank");
                    }
                },
                items: {
                    <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mov_issue_view"])) { ?> "print": {
                            name: "Print Purchase",
                            icon: "fa-print"
                        },
                    <?php } ?>
                }
            });
        });
    }
</script>




            <section class="panel" >
        <header class="panel-heading clearfix panel-theame">
            <i class="material-icons">list</i> Purchase Invoice
           
        </header>  
         <?php echo CHtml::hiddenField('contract_id', $model->id); ?>
    <div class="panel-body">
         
          <div class="custom-data-table">
                  <table class="table table-hover table-bordered personal-task" id="tble_purchase_invoice" style="font-size:13px;">
                      <thead>
                        <tr>
                            <th>Job Order</th>
                            <th>Order No</th>
                            <th>Invoice No</th>
                            <th>MRV No</th>
                            <th>Supplier</th>
                            <th>Invoice Date</th>
                            <th>Amount</th>
                            <th>VAT</th>
                            <th>Net Amount</th>
                            <th>Created by</th>
                            
                        </tr>
                    </thead>
                    <tfoot>
                    <tr>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th>Total:</th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                    </tr>
                </tfoot>
                </table>
               
            </div>
             
        </div>
   </section>











    



