<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;
?>
<script>
    param_index = 3;
    $(document).ready(function () {
        table_id = "#tbl_area";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,
            order: [[1, "asc"]],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('fm/masarea/GetList') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
                if (aData[param_index].status == "N") {
                    $("td", nRow).addClass("bg-danger");
                }

            }

        });
    });
    function AddContextMenu(row, datas) {

        var mas_edit = 0;
        var mas_disable = 0;
<?php if (isset(Yii::app()->user->havePermissionOn['fm_mas_area_edit']) || Yii::app()->user->authorised_user == 1) { ?>

            mas_edit = 1;
<?php } ?>

<?php if (isset(Yii::app()->user->havePermissionOn['fm_mas_area_disable']) || Yii::app()->user->authorised_user == 1) { ?>

            mas_disable = 1;
<?php } ?>

        $(row).contextMenu({
            selector: 'td',
            items: {

                "edit": {
                    name: "Edit",
                    icon: "edit",
                    accesskey: "e",
                    callback: function () {
                        loadPopupModal("fm/masarea/create&id=" + datas[param_index].id, datas[param_index].code, "lg");
                    },
                    visible: function () {
                        return (mas_edit == 1);
                    }
                },

                "Disable_Enable": {

                    name: (datas[param_index].status == "Y") ? "Disable" : "Enable",
                    icon: "edit",
                    accesskey: "d",
                    callback: function () {

                        Disable(datas[param_index].id, datas[param_index].status);
                    },
                    visible: function () {
                        return (mas_disable == 1);
                    }
                }

            }

        });
    }

</script>

<script>
    function Disable(id, status) {
        var r = confirm((status == "Y") ? 'Are you sure to disable this?' : 'Are you sure to enable this?');
        if (r == true) {
            jQuery.ajax({
                'type': 'post',
                'datatype': 'json',
                'data': 'id=' + id + "&status=" + status,
                'url': $('#liveSite').val() + 'index.php?r=fm/masarea/Disable',
                'cache': false,
                'success': function (data) {
                    if (data.status == 'fail') {
                        t8.error('Error while Delete');
                    } else {
                        $('#tbl_area').DataTable().ajax.reload()
                        t8.success(' Success');
                    }
                }
            });
        }
    }
</script>
<section class="panel" style="background-color:#F6F3EE;">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-users"></i> Master Area
        <div class="pull-right">
            <?php if (isset(Yii::app()->user->havePermissionOn['fm_mas_area_add']) || Yii::app()->user->authorised_user == 1) { ?>
                <button class="btn btn-sm btn-theme" onclick="loadPopupModal('fm/masarea/Create', 'Add Period Type', 'lg')"><i class="fa fa-plus"></i> ADD</button>

            <?php } ?>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_area" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Area Name</th>
                        <th>Sort Order</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>