<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'machinery-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
        ));
       $style='style="display:none;"';
       if($model->item_type=='S'){
           $style='';
       }
?>
<ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li class="active"><a href="#machinery_tab1" data-toggle="tab">General</a></li>
    <li><a href="#machinery_tab2" data-toggle="tab" onclick="setvaluesmaintenance();">Maintenance Schedules</a></li>
</ul>
<div class="tab-content">
    <div class="tab-pane active" id="machinery_tab1">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php echo $form->hiddenField($model, 'id'); ?>
                <?php echo $form->textField($model, 'machine_name', array('data-label' => 'Equipment Name <span style="color:red">*</span>')); ?>
                <?php echo $form->error($model, 'machine_name'); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'machine_id', array('data-label' => 'Equipment ID  <span style="color:red">*</span>')); ?>
                <?php echo $form->error($model, 'machine_id'); ?>
            </li>	

            <li class="col-sm-3">
                <?php echo $form->textField($model, 'make', array('data-label' => 'Make  <span style="color:red">*</span>')); ?>
                <?php echo $form->error($model, 'make'); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'model_no', array('data-label' => 'Model No')); ?>
                <?php echo $form->error($model, 'model_no'); ?>
            </li>	
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'year_of_manufacture', array('data-label' => 'Year')); ?>
                <?php echo $form->error($model, 'year_of_manufacture'); ?>
            </li>	
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'serial_no', array('data-label' => 'Serial no')); ?>
                <?php echo $form->error($model, 'serial_no'); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'location', array('data-label' => 'Location')); ?>
                <?php echo $form->error($model, 'location'); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'capacity', array('data-label' => 'Capacity')); ?>
                <?php echo $form->error($model, 'capacity '); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->dropdownList($model, 'period_type',MasterPeriodType::getPeriodType(),array('data-label' => 'Period Type ', 'empty' => '-Select-')); ?>
                <?php echo $form->error($model, 'period_type'); ?>
            </li>
            <li class="col-sm-3">
                <?php
                if (empty($model->start_date)) {
                    $model->start_date = date('d/m/Y');
                } else {
                    $model->start_date = date('d/m/Y', strtotime($model->start_date));
                }
                echo $form->textField($model, 'start_date', array('class' => 'tooltipster datepicker', 'title' => 'Start Date', 'data-label' => 'Start Date <span style="color:red">*</span>','onclick' =>'adddates();'));
                ?>
                <?php echo $form->error($model, 'start_date'); ?>
            </li>
            <li class="col-sm-3">
                <?php
                if (empty($model->end_date)) {
                    $model->end_date = date('d/m/Y');
                } else {
                    $model->end_date = date('d/m/Y', strtotime($model->end_date));
                }
                echo $form->textField($model, 'end_date', array('class' => 'tooltipster datepicker', 'title' => 'End Date', 'data-label' => 'End Date <span style="color:red">*</span>'));
                ?>
                <?php echo $form->error($model, 'end_date'); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->dropDownList($model, 'item_type', array('M' => 'MainItem', 'S' => 'SubItem'), array('data-label' => 'Item Type', 'onchange' => 'checkItemType(this.value)')); ?>
            </li>
            <li class="col-sm-3" id="li_main_list" <?php echo $style;?>>
                <?php echo $form->dropDownList($model, 'main_item_id',Machinery::getMainitem(), array('data-label' => 'Main Item','empty' => '-Select-')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model, 'preferred_vendor', array('data-label' => 'Preferred Vendor')); ?>
                <?php echo $form->error($model, 'preferred_vendor'); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->dropDownList($model, 'is_active',array('Y' => 'Active', 'N' => 'Disable'), array('data-label' => 'Status')); ?>
                <?php echo $form->error($model, 'is_active'); ?>
            </li>
            
        </ul>
    </div>
    <div class="tab-pane" id="machinery_tab2">
        <?php $this->renderPartial('maintenance_schedules', array('model' => $model,'form'=>$form,'modelDetails'=>$modelDetails));?>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="machinery_close" data-dismiss="modal">Close</button>
    <?php
    $url = Yii::app()->createUrl('fm/machinery/Save');
    echo CHtml::ajaxsubmitButton('Save', $url, array(
        'dataType' => 'json',
        'type' => 'post',
        'success' => 'function(data) {
            $("#loader").hide();
            if(data.status=="success"){  
                 t8.success("Details Saved Successfully!");
                 $("#machinery_close").click();
                reloadTable("#tbl_machinery_details");
            } else { 
               $("#machinery_form .machinery_save-btn").prop("disabled", false);
                $("#machinery_form .machinery_save-btn").addClass("btn-theme").removeClass("btn_loding");
                $.each(data, function(key, val) {
                        // $("#machinery_form #"+key+"_em_").text(val).show(); 
                        t8.error(""+val+""); 
                }); 
            } 
        }',
        'beforeSend' => 'function(){
            $("#loader").show();
            $(".toast8-error").hide(); 
            $("#machinery_form .machinery_save-btn").prop("disabled", true);
            $("#machinery_form .machinery_save-btn").addClass("btn_loding").removeClass("btn-theme");
        }'
    ), array('id' => 'mybtn' . rand(), 'class' => 'machinery_save-btn btn btn-theme'));
    ?>
</div>
<?php $this->endWidget(); ?>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("checkItemType", "function checkItemType(type){
    if(type=='S'){
        $('#li_main_list').show();
    }else{
        $('#li_main_list').hide();
    }
}", CClientScript::POS_HEAD);
$cs->registerScript("setvaluesmaintenance", "function setvaluesmaintenance(){
    function parseDate(str) {
        var mdy = str.split('/')
        return new Date(mdy[2], mdy[1]-1, mdy[0]);
    }
    function daydiff(first, second) {
        return (second-first)/(1000*60*60*24)
    }

    var id = $('#Machinery_id').val();
    var period_type = $('#Machinery_period_type').val();
    var start_date  = $('#Machinery_start_date').val();
    var end_date    = $('#Machinery_end_date').val();
    var no_of_days  = daydiff(parseDate(start_date), parseDate(end_date));
    $('#no_of_days').val(no_of_days);
    $('#no_of_days').addClass('filled');  
    if(Number(id)==0)
        findFrequency();
   
}", CClientScript::POS_HEAD);


$cs->registerScript("adddates", " function adddates() {
        var strt_dates;
        var strt_dates=$('#Machinery_start_date').val();
       
        $('#start_date').val(strt_dates);
        $('#start_date').addClass('filled');
        return false;
    }", CClientScript::POS_HEAD);
    ?>