<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        List of Equipment Maintenance Schedule
        <div class="pull-right">
            <div class="filter_details">
                <?php
                if ($planned_start_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>Maintenance From :</label>
                        <?php echo $planned_start_date ?>
                    </div>
                    <?php
                }
                ?>
                <?php
                if ($planned_end_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>Maintenance To :</label>
                        <?php echo $planned_end_date ?>
                    </div>
                    <?php
                }
                ?>

            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">

            <table id="tbl_lead_table" class="table table-fixed table-bordered table-primary dataTable" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Equipment #</th>
                        <th>Equipment Name</th>
                        <th>Planned Date</th>
                        <th>Actual Date</th>
                        <th>Period Type</th>
                        <th>Added By</th>
                        <th>Remarks</th>
                        <th>Maintenance Value</th>



                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = '1=1';

                    if ($planned_start_date != '') {
                        $planned_start_date = str_replace('/', '-', $planned_start_date);
                        $planned_start_date = date('Y-m-d', strtotime($planned_start_date));
                        $condition .= ' AND t.planned_date >="' . $planned_start_date . '"';
                    }
                    if ($planned_end_date != '') {
                        $planned_end_date = str_replace('/', '-', $planned_end_date);
                        $planned_end_date = date('Y-m-d', strtotime($planned_end_date));
                        $condition .= ' AND t.planned_date <="' . $planned_end_date . '"';
                    }

                    if ($machinery_id != '') {
                        $condition .= ' AND t.machinery_id ="' . $machinery_id . '"';
                    }

                    if ($period_type_id != '') {
                        $condition .= ' AND t.period_type ="' . $period_type_id . '"';
                    }

                   

                    $model = MachineMaintenanceSchedules::model()->with('period_details', 'machinery')->findAll(array('condition' => $condition));
                    foreach ($model as $i => $row) {
                        ?>

                        <tr>
                            <td><?php echo $row->id; ?></td>
                            <td><?php echo $row->machinery_id; ?></td>
                            <td class="nw"><?php echo $row->machinery->machine_name; ?></td>

                            <?php if ($row->planned_date != '0000-00-00 00-00-00') { ?>
                                <td><?php echo date("d/m/Y", strtotime($row->planned_date)); ?></td>
                            <?php } else { ?>
                                <td>&nbsp;</td>
                            <?php } ?>
                            <?php if ($row->actual_date != '0000-00-00 00-00-00') { ?>
                                <td><?php echo date("d/m/Y", strtotime($row->actual_date)); ?></td>
                            <?php } else { ?>
                                <td>&nbsp;</td>
                            <?php } ?>
                            <td class="nw"><?php echo $row->period_details->period_type; ?></td>  
                           
                            <td class="nw"><?php echo $row->added_by; ?></td>
                            <td class="nw"><?php echo $row->remarks; ?></td>
                             <td class="text-right"> <?php echo $row->maintanance_value; ?></td>
                            <?php
                            $total+=$row->maintanance_value;
                            ?>
                        </tr>
                    <?php } ?>

                </tbody>
                <tr>
                <td colspan="8"> Total</td>
                <td class="text-right"> <?php echo number_format($total, 2); ?></td></td>
                </tr>
            </table>
            <br>
            <div class="btn-wrap text-center">
                <?php echo CHtml::link('<i class="fa fa-file-pdf-o"></i> PDF', array('fmreports/PrintMachineryScheduleReportPDF', 'machinery_id' => $machinery_id, 'planned_start_date' => $planned_start_date, 'planned_end_date' => $planned_end_date, 'period_type_id' => $period_type_id), array('title' => 'Equipment Schedule Pdf', 'target' => '_blank', 'class' => 'btn btn-theme')); ?>
                <button type="button" class="btn btn-theme" onclick="excelMachineryScheduleList();" title="Export Excel"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button>

            </div>
        </div>
    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("excelMachineryScheduleList", "function excelMachineryScheduleList(){

            var url= '" . Yii::app()->createUrl('fm/fmreports/PrintMachineryScheduleExcel') . "';
            var machinery_id = $('#machinery_id').val();
            var planned_start_date = $('#planned_start_date').val();
            var planned_end_date = $('#planned_end_date').val();
            var period_type_id = $('#period_type_id').val();
         
    window.open($('#liveSite').val()+'index.php?r=fm/fmreports/PrintMachineryScheduleExcel&machinery_id='+machinery_id+'&planned_start_date='+planned_start_date+'&planned_end_date='+planned_end_date+'&period_type_id='+period_type_id+'&report_from='+report_from, '_blank');

}", CClientScript::POS_HEAD);
