<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        List of Job Order Issues
        <div class="pull-right">
            <div class="filter_details">
                <?php
                if ($job_start_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>Job Order From :</label>
                        <?php echo $job_start_date ?>
                    </div>
                    <?php
                }
                ?>
                <?php
                if ($job_end_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>Job Order To :</label>
                        <?php echo $job_end_date ?>
                    </div>
                    <?php
                }
                ?>


                <?php
                if ($customer_id != '') {
                    ?>
                    <div class="filter-item ">
                        <label>Customer :</label>
                        <?php
                        $c = Customer::model()->findByPK($customer_id);
                        echo $c->customer_name;
                        ?>
                    </div>
                    <?php
                }
                ?>


            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">

            <table id="tbl_lead_table" class="table table-fixed table-bordered table-primary dataTable" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>Job#</th>
                        <th>Job Date</th>
                        <th>Unit ID</th>
                        <th>Name</th>
                        <th>Status</th>
                        <th>Issue</th>
                        <th>Man Hours</th>
                        <th>Material</th>


                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = '1=1';

                    if ($job_start_date != '') {
                        $job_start_date = str_replace('/', '-', $job_start_date);
                        $job_start_date = date('Y-m-d', strtotime($job_start_date));
                        $condition .= ' AND ticket_header_det.ticket_date >="' . $job_start_date . '"';
                    }
                    if ($job_end_date != '') {
                        $job_end_date = str_replace('/', '-', $job_end_date);
                        $job_end_date = date('Y-m-d', strtotime($job_end_date));
                        $condition .= ' AND ticket_header_det.ticket_date <="' . $job_end_date . '"';
                    }

                    if ($job_property_id != '') {
                        $condition .= ' AND ticket_header_det.property_id ="' . $job_property_id . '"';
                    }
                    if ($job_job_issue_id != '') {
                        $condition .= ' AND t.issue_id ="' . $job_job_issue_id . '"';
                    }
                    if ($status != '') {
                        $condition .= ' AND ticket_header_det.ticket_status ="' . $status . '"';
                    }
//           
                    $model = TicketDetails::model()->with('issue_details', 'ticket_header_det')->findAll(array('condition' => $condition));
                    //$all_total = 0;
                    foreach ($model as $i => $row) {
                        // $modelTicketHeader = TicketHeader::model()->findBYPK((int)$row->ticket_id);
                        ?>

                        <tr>
                            <td><?php echo $row->ticket_header_det->id; ?></td>
                            <?php if ($row->ticket_header_det->ticket_date != '0000-00-00') { ?>
                                <td><?php echo date("d/m/Y", strtotime($row->ticket_header_det->ticket_date)); ?></td>
                            <?php } else { ?>
                                <td>&nbsp;</td>
                            <?php } ?>
                            <td class="nw"><?php echo $row->ticket_header_det->property_details->flat_no; ?></td>
                            <td class="nw"><?php echo $row->ticket_header_det->property_details->property_name; ?></td>

                            <td><?php echo $row->ticket_header_det->status; ?></td>

                            <td class="nw"><?php echo $row->issue_details->issue_type; ?></td>
                            <td class="text-right">
                                <?php $modeljobtime = TicketJobTime::model()->findAll(array('condition' => 'ticket_item_id=' . $row->id)); ?>
                                <?php
                                $total_cost = 0;
                                foreach ($modeljobtime as $time) {
                                    if ($time->job_end_time == '0000-00-00 00:00:00') {
                                        echo "--";
                                    } else {
                                        $starttimestamp = strtotime($time->job_start_time);
                                        $stoptimestamp = strtotime($time->job_end_time);
                                        $hour = abs($stoptimestamp - $starttimestamp) / (60 * 60) . " hour(s)";
                                        $hour = number_format($hour, 2);
                                    }
                                    $unit_rate = $time->technician_det->unit_hour_rate;
                                    $total_cost += $hour * $unit_rate;
                                }
                                $all_total += $total_cost;
                                ?> 
                                <?php echo number_format($total_cost, 2); ?></td>
                            <td class="text-right"><?php
                                $modelIssueDetails = TicketIssueMaterials::model()->findAll(array('condition' => 'ticket_item_id="' . (int) $row->id . '"'));
                                $issue_amount = 0;
                                //$total_issue_amount = 0;
                                foreach ($modelIssueDetails as $eachissue) {
                                    $issue_amount += ($eachissue->rate * $eachissue->quantity);
                                }
                                $total_issue_amount += $issue_amount;
                                echo number_format($issue_amount, 2);
                                ?></td>
                            <?php
                            ?>
                        </tr>
                    <?php } ?>

                </tbody>
                <tr>
                    <td colspan="6"></td>
                    <td class="text-right"> <?php echo number_format($all_total, 2); ?></td>
                    <td class="text-right"> <?php echo number_format($total_issue_amount, 2); ?></td>
                <tr>
            </table>

            <br>
            <div class="btn-wrap text-center">
                <?php echo CHtml::link('<i class="fa fa-file-pdf-o"></i> PDF', array('fmreports/PrintJobOrderIssueReportPDF', 'job_start_date' => $job_start_date, 'job_end_date' => $job_end_date, 'job_property_id' => $job_property_id, 'job_job_issue_id' => $job_job_issue_id,'status' => $status), array('title' => 'Export Job Order Pdf', 'target' => '_blank', 'class' => 'btn btn-theme')); ?>
                <button type="button" class="btn btn-theme" onclick="excelJobOrderIssueList();" title="Export Excel"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button>


            </div>
        </div>
    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("excelJobOrderIssueList", "function excelJobOrderIssueList(){

    var url= '" . Yii::app()->createUrl('fm/fmreports/PrintexceljoborderIssueList') . "';
    var job_start_date = $('#job_start_date').val();
    var job_end_date = $('#job_end_date').val();
    var job_property_id = $('#job_property_id').val();
    var job_job_issue_id =$('#job_job_issue_id').val();
    var status = $('#status').val();

    window.open($('#liveSite').val()+'index.php?r=fm/fmreports/PrintexceljoborderIssueList&job_start_date='+job_start_date+'&job_end_date='+job_end_date+'&job_property_id='+job_property_id+'&status='+status+'&job_job_issue_id='+job_job_issue_id, '_blank');

}", CClientScript::POS_HEAD);
