<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        List of Job Orders
        <div class="pull-right">
            <div class="filter_details">
                <?php
                if ($ticket_start_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>Job Order From :</label>
                        <?php echo $ticket_start_date ?>
                    </div>
                    <?php
                }
                ?>
                <?php
                if ($ticket_end_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>Job Order To :</label>
                        <?php echo $ticket_end_date ?>
                    </div>
                    <?php
                }
                ?>


                <?php
                if ($customer_id != '') {
                    ?>
                    <div class="filter-item ">
                        <label>Customer :</label>
                        <?php
                        $c = Customer::model()->findByPK($customer_id);
                        echo $c->customer_name;
                        ?>
                    </div>
                    <?php
                }
                ?>


            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">

            <table id="tbl_lead_table" class="table table-fixed table-bordered table-primary dataTable" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>Job#</th>
                        <th>Job Date</th>
                        <th>Unit ID</th>
                        <th>name</th>
                        <th>Status</th>
                        <th>No Of Issue</th>
                        <th>Man Hours</th>
                        <th>Material</th>
                        <th>Actions</th>

                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = '1=1';

                    if ($ticket_start_date != '') {
                        $ticket_start_date = str_replace('/', '-', $ticket_start_date);
                        $ticket_start_date = date('Y-m-d', strtotime($ticket_start_date));
                        $condition .= ' AND t.ticket_date >="' . $ticket_start_date . '"';
                    }
                    if ($ticket_end_date != '') {
                        $ticket_end_date = str_replace('/', '-', $ticket_end_date);
                        $ticket_end_date = date('Y-m-d', strtotime($ticket_end_date));
                        $condition .= ' AND t.ticket_date <="' . $ticket_end_date . '"';
                    }

                    if ($property_id != '') {
                        $condition .= ' AND t.property_id ="' . $property_id . '"';
                    }
                    if ($status != '') {
                        $condition .= ' AND t.ticket_status ="' . $status . '"';
                    }
//           
                    $model = TicketHeader::model()->with('property_details')->findAll(array('condition' => $condition));
                   
                    foreach ($model as $i => $row) {
                        ?>

                        <tr>
                            <td><?php echo $row->id; ?></td>
                            <?php if ($model->ticket_date != '0000-00-00') { ?>
                            <td><?php echo date("d/m/Y", strtotime($row->ticket_date)); ?></td>
                            <?php } else { ?>
                            <td>&nbsp;</td>
                            <?php } ?>
                            <td class="nw"><?php echo $row->property_details->flat_no; ?></td>
                            <td class="nw"><?php echo $row->property_details->property_name; ?></td>

                           
                            <td><?php echo $row->status; ?></td>

                            <?php
                            //$condition = 'ticket_id="' . $id . '"';
                            $count = TicketDetails::model()->count(array('condition' => 'ticket_id=' . $row->id));
                            ?>
                            <td class="text-right"><?php echo $count; ?></td>

                            <?php
                            $condition = 'ticket_id="' . (int) $row->id . '"';
                            $ticketjobtime = TicketJobTime::model()->findAll(array('condition' => $condition));
                            $total_cost = 0;
                            $grand = 0;
                            foreach ($ticketjobtime as $time) {
                                if ($time->job_end_time == '0000-00-00 00:00:00') {
                                    echo "--";
                                } else {
                                    $starttimestamp = strtotime($time->job_start_time);
                                    $stoptimestamp = strtotime($time->job_end_time);
                                    $hour = abs($stoptimestamp - $starttimestamp) / (60 * 60) . " hour(s)";
                                    $hour = number_format($hour, 2);
                                }
                                $unit_rate = $time->technician_det->unit_hour_rate;
                                $total_cost = $hour * $unit_rate;
                                $grand += $total_cost;
                            }
                            ?>
                            <td class="text-right"><?php echo number_format($grand, 2); ?></td>

                            <?php
                            $modelIssueDetails = TicketIssueMaterials::model()->findAll(array('condition' => 'ticket_id="' . (int) $row->id . '"'));
                            $issue_amount = 0;
                            foreach ($modelIssueDetails as $eachissue) {
                                $issue_amount += ($eachissue->rate * $eachissue->quantity);
                            }
                            ?>


                            <td class="text-right"> <?php echo number_format($issue_amount, 2); ?></td>
                            <td>
                                <a></a>
                                <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="index.php?r=fm/fmreports/PrintJoborderReportPDF&id=<?php echo $row->id; ?> "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>
                            </td>

                        </tr>
                    <?php } ?>

                </tbody>
            </table>

            <br>
            <div class="btn-wrap text-center">
                <?php echo CHtml::link('<i class="fa fa-file-pdf-o"></i> PDF', array('fmreports/PrintJobReportPDF', 'ticket_start_date' => $ticket_start_date, 'ticket_end_date' => $ticket_end_date, 'property_id' => $property_id, 'status' => $status), array('title' => 'Export Job Order Pdf', 'target' => '_blank', 'class' => 'btn btn-theme')); ?>
                <button type="button" class="btn btn-theme" onclick="excelJobOrderList();" title="Export Excel"><i class="fa fa-file-excel-o"></i> &nbsp;Excel</button>
                <input type="hidden" value="<?= $enq_from_date ?>" id="enq_from_date">
                <input type="hidden" value="<?= $enq_to_date ?>" id="enq_to_date">
                <input type="hidden" value="<?= $closing_from_date ?>" id="closing_from_date">
                <input type="hidden" value="<?= $closing_to_date ?>" id="closing_to_date">
                <input type="hidden" value="<?= $sales_group_id ?>" id="sales_group_id">
                <input type="hidden" value="<?= $del_to_date ?>" id="del_to_date">
                <input type="hidden" value="<?= $customer_id ?>" id="customer_id">
                <input type="hidden" value="<?= $lead_owner_id ?>" id="lead_owner_id">
                <input type="hidden" value="<?= $status ?>" id="status">

            </div>
        </div>
    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("excelJobOrderList", "function excelJobOrderList(){

    var url= '" . Yii::app()->createUrl('fm/fmreports/PrintexceljoborderList') . "';
    var ticket_start_date = $('#ticket_start_date').val();
    var ticket_end_date = $('#ticket_end_date').val();
    var property_id = $('#property_id').val();
    var status = $('#status').val();

    window.open($('#liveSite').val()+'index.php?r=fm/fmreports/PrintexceljoborderList&ticket_start_date='+ticket_start_date+'&ticket_end_date='+ticket_end_date+'&property_id='+property_id+'&status='+status, '_blank');

}", CClientScript::POS_HEAD);
