<div id="div_master_report_machinerylist">
    <?php
    $fin_month = Yii::app()->user->fin_year;

    $year = date('Y');
    $year_next = $year + 1;
    if ($fin_month == 1) {
        $from_date = $year . '-01-01';
        $end_date = $year . '-12-31';
    } else {
        $from_date = $year . '-04-01';
        $end_date = $year_next . '-03-31';
    }
    $startDate = date("d-m-Y", strtotime($from_date));

    $endDate = date("d-m-Y", strtotime($end_date));
    ?>
    <ul class="clearfix form-ul material" id="machinery-form-hide"> 
        <li class="col-sm-3">
            <div class="material"> 
               <?php
                echo CHtml::dropDownList('machine_name', 'machine_name', Machinery::getMainitem(), array('class' => 'tooltipster', 'data-label' => 'Equipment', 'empty' => 'Select'));?>
            </div>
        </li>
        <li class="col-sm-3">
            <div class="material"> 
                <?php echo CHtml::textField('machine_id', '', array('class' => 'tooltipster', 'data-label' => 'Equipment Id')); ?>

            </div>
        </li>
        <li class="col-sm-2">
            <div class="material"> 
                <?php echo CHtml::textField('make', '', array('class' => 'tooltipster', 'data-label' => 'Make')); ?>

            </div>
        </li>
        <li class="col-sm-2">
            <div class="material"> 
                <?php echo CHtml::textField('model_no', '', array('class' => 'tooltipster', 'data-label' => 'Model No')); ?>

            </div>
        </li>
        <li class="col-sm-2">
            <div class="material"> 
                <?php echo CHtml::textField('serial_no', '', array('class' => 'tooltipster', 'data-label' => 'Serial No')); ?>

            </div>
        </li>
        <li class="col-sm-3">
            <div class="material"> 
                <?php echo CHtml::textField('location', '', array('class' => 'tooltipster', 'data-label' => 'Location')); ?>

            </div>
        </li>
        <li class="col-sm-3">
            <div class="material">    
                <?php
                echo CHtml::dropDownList('period_type', 'period_type', MasterPeriodType::getPeriodType(), array('class' => 'tooltipster', 'data-label' => 'Period Type', 'empty' => 'Select'));
                ?>
            </div>
        </li>
        <li class="col-sm-2">
            <div class="material">
                <?php
                $year = date("Y");
                echo CHtml::dropDownList('year', year, Machinery::listYears(6, 0), array('class' => 'tooltipster', 'data-label' => 'Year', 'empty' => 'Select'));
                ?>
            </div>
        </li>
        <li class="col-sm-2" style="display: none;">
            <div class="material">    
                <?php echo CHtml::textField('maintenance_start_date', $startDate, array('class' => 'datepicker', 'data-label' => 'Start Date')); ?>
            </div>
        </li>
        <li class="col-sm-2" style="display: none;">
            <div class="material">    
                <?php echo CHtml::textField('maintenance_end_date', $endDate, array('class' => 'datepicker', 'data-label' => 'End Date')); ?>
            </div>
        </li>
        <li class="col-sm-3">
            <div class="material">    
                <?php
                echo CHtml::dropDownList('item_type', 'item_type', array('M' => 'MainItem', 'S' => 'SubItem'), array('class' => 'tooltipster', 'data-label' => 'Item Type', 'onchange' => 'checkItemType(this.value)','empty' => 'Select'));
                ?>
            </div>
        </li>
        <li class="col-sm-3" id="li_main_list" <?php echo $style; ?>>
            <div class="material">    
                <?php
                echo CHtml::dropDownList('main_item_id', 'main_item_id', Machinery::getMainitem(), array('class' => 'tooltipster', 'data-label' => 'Main item', 'empty' => 'Select'));
                ?>
            </div>
        </li>

    </ul>
</div>
<div class='btn-wrap text-center'>
    <input type="button" value="Load" onclick="loadMasterReport();return false;" class='plan-save-btn btn btn-theme'>
</div>

<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("checkItemType", "function checkItemType(type){
    if(type=='S'){
        $('#li_main_list').show();
    }else{
        $('#li_main_list').hide();
    }
}", CClientScript::POS_HEAD);
?>