<?php

/**
 * This is the model class for table "{{fm_ticket_header}}".
 *
 * The followings are the available columns in table '{{fm_ticket_header}}':
 * @property integer $id
 * @property integer $property_id
 * @property integer $unit_id
 * @property string $ticket_no
 * @property string $ticket_date
 * @property integer $raised_by
 * @property string $priority
 * @property string $remarks
 * @property integer $ticket_status
 * @property integer $created_by
 * @property string $created_date_time
 */
class TicketHeader extends CActiveRecord
{

    public $status_name;
    public $material_cost;
    public $labour_cost;
    public $total_cost;

    const RAISED_FROM_APP = "APP";
    const RAISED_FROM_WEB = "WEB";

    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{fm_ticket_header}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('property_id,ticket_date, raised_by,ticket_status, issue_type_id, priority_id,description', 'required'),
            array('unit_id', 'required', 'on' => 'ticket'),
            array('unit_id', 'validateunit'),
            array('unit_id', 'numerical', 'min' => 0, 'on' => 'ticket'),
            array('raised_by,unit_id,quotation_id, ticket_status, ticket_status, created_by, issue_type_id, priority_id', 'numerical', 'integerOnly' => true),
            array('ticket_no', 'length', 'max' => 10),
            //array('priority', 'length', 'max'=>8),
            array('description, remarks, rating_remarks', 'length', 'max' => 5000),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, property_id, ticket_no, ticket_date, raised_by, remarks, ticket_status, created_by, created_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'property_details' => array(self::BELONGS_TO, 'Machinery', 'property_id'),
            'building_details' => array(self::BELONGS_TO, 'FmMasBuilding', 'property_id'),
            'unit_details' => array(self::BELONGS_TO, 'MasBuildingUnit', 'unit_id'),
            'ticket_details' => array(self::BELONGS_TO, 'TicketDetails', 'id'),
            'status_details' => array(self::BELONGS_TO, 'FmTicketStatus', 'ticket_status'),
            'priority_details' => array(self::BELONGS_TO, 'FmPriority', 'priority_id'),
            'issue_details' => array(self::BELONGS_TO, 'MasterIssueType', 'issue_type_id'),
            'allotted_rel' => array(self::HAS_MANY, 'TicketAllotTechnicians', 'ticket_id')
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'property_id' => 'Property',
            'ticket_no' => 'Ticket No',
            'ticket_date' => 'Ticket Date',
            'raised_by' => 'Raised By',
            //'priority' => 'Priority',
            'remarks' => 'Remarks',
            'ticket_status' => 'Ticket Status',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'project_classification_id'=>'Project Classification',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('property_id', $this->property_id);
        $criteria->compare('ticket_no', $this->ticket_no, true);
        $criteria->compare('ticket_date', $this->ticket_date, true);
        $criteria->compare('raised_by', $this->raised_by);
        //$criteria->compare('priority',$this->priority,true);
        $criteria->compare('remarks', $this->remarks, true);
        $criteria->compare('ticket_status', $this->ticket_status);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return TicketHeader the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    public function getMaterialCost()
    {
        $value = 0;
        $condition = "ticket_id = '" . (int) $this->id . "'";
        $issueHeaderList = InventoryGoodsIssue::model()->findAll(['condition' => $condition]);
        foreach ($issueHeaderList as $issueHeader) {
            if (!empty($issueHeader)) {
                $modelIssueDetails = $issueHeader->items;
                if (!empty($modelIssueDetails)) {
                    foreach ($modelIssueDetails as $modelIssueDetail) {
                        $value += $modelIssueDetail->picked_qty * $modelIssueDetail->rate;
                    }
                }
            }
        }
        return $value;
    }

    public function getlabourCost()
    {
        $value = 0;
        $sql = "select SUM(total_cost) from erp_fm_ticket_job_time where ticket_id = '$this->id'";
        $value = Yii::app()->db->createCommand($sql)->queryScalar();
        return $value;
    }

    public function validateunit($attribute, $param)
    {
        if (!empty($this->unit_id)) {
            $fmUnit = new MasBuildingUnit();
            $fmUnit = $fmUnit->findByPK($this->unit_id);
            if ($fmUnit->building_id != $this->property_id) {
                $this->addError('unit_id', "Unit not found.");
            }
        }
    }


    public static function GetJoblist()
    {
       // $condition = 'isActive =  "Y"'; 
        $condition = '1=1';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'id Desc'));
        return CHtml::listData($model, 'id', 'id');
    }
}
