<?php

/**
 * This is the model class for table "{{fm_ticket_allot_technicians}}".
 *
 * The followings are the available columns in table '{{fm_ticket_allot_technicians}}':
 * @property integer $id
 * @property integer $ticket_id
 * @property integer $ticket_item_id
 * @property integer $issue_id
 * @property integer $technician_id
 * @property string $allotted_date
 * @property string $from_time
 * @property string $to_time
 * @property string $remarks
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class TicketAllotTechnicians extends CActiveRecord {

    const STATUS_WAITING = "A";
    const STATUS_WORK_IN_PROGRESS = "P";
    const STATUS_COMPLETED = "C";

    public $selected;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fm_ticket_allot_technicians}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('ticket_id, issue_id, technician_id, allotted_date,allot_type_id, from_time, to_time, created_by, created_date_time, updated_by, updated_date_time', 'required'),
            array('id, ticket_id, issue_id, technician_id, created_by, updated_by, allot_type_id', 'numerical', 'integerOnly' => true),
            array('from_time', 'validatedate'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, ticket_id, ticket_item_id, issue_id, technician_id, allotted_date, from_time, to_time, remarks, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'issue_details' => array(self::BELONGS_TO, 'MasterIssueType', 'issue_id'),
            'technician_details' => array(self::BELONGS_TO, 'Technician', 'technician_id'),
            'ticket_details' => array(self::BELONGS_TO, 'TicketDetails', 'ticket_item_id'),
            'allot_type' => array(self::BELONGS_TO, 'FmAllotType', 'allot_type_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'ticket_id' => 'Ticket',
            'ticket_item_id' => 'Ticket Item',
            'issue_id' => 'Issue',
            'technician_id' => 'Technician',
            'allotted_date' => 'Allotted Date',
            'from_time' => 'From Time',
            'to_time' => 'To Time',
            'remarks' => 'Remarks',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('ticket_id', $this->ticket_id);
        $criteria->compare('ticket_item_id', $this->ticket_item_id);
        $criteria->compare('issue_id', $this->issue_id);
        $criteria->compare('technician_id', $this->technician_id);
        $criteria->compare('allotted_date', $this->allotted_date, true);
        $criteria->compare('from_time', $this->from_time, true);
        $criteria->compare('to_time', $this->to_time, true);
        $criteria->compare('remarks', $this->remarks, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return TicketAllotTechnicians the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getStatusList() {
        return [
            self::STATUS_COMPLETED => "Completed",
            self::STATUS_WAITING => "Waiting",
            self::STATUS_WORK_IN_PROGRESS => "Work In Progress"
        ];
    }

    public function getStatusName() {
        $list = $this->getStatusList();
        return isset($list[$this->status]) ? $list[$this->status] : "";
    }

    public function validatedate() {

        $from_time = $this->from_time;
        $to_time = $this->to_time;
        if ($from_time != '' && $to_time != '') {
            if ($from_time > $to_time) {

                $this->addError("from_time", 'From time should greater than to time.');
                return false;
            }
        }
    }

}
