<?php

/**
 * This is the model class for table "{{fm_mas_unit}}".
 *
 * The followings are the available columns in table '{{fm_mas_unit}}':
 * @property integer $id
 * @property string $unit_name
 * @property integer $building_id
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class MasBuildingUnit extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fm_mas_unit}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('unit_name, building_id', 'required'),
            array('building_id, created_by, updated_by, customer_id', 'numerical', 'integerOnly' => true),
            array('sort_order', 'numerical', 'min' => 0, 'integerOnly' => true),
            array('unit_name', 'length', 'max' => 100),
            array('unit_name', 'existanceCheck', 'on' => 'add'),
            //array('unit_name, building_id', 'unique',)
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, unit_name, building_id, created_by, created_date_time, updated_by, updated_date_time,sort_order', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'building' => array(self::BELONGS_TO, 'FmMasBuilding', 'building_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'unit_name' => 'Unit Name',
            'building_id' => 'Building',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
            'updated_by' => 'Updated By',
            'updated_date_time' => 'Updated Date Time',
            'sort_order' => 'Sort Order',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('unit_name', $this->unit_name, true);
        $criteria->compare('building_id', $this->building_id);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);
        $criteria->compare('sort_order', $this->sort_order, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasBuildingUnit the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getUnit($building_id = 0) {
        $condition = 'building_id =' . $building_id;
        $model = self::model()->findAll(array('condition' => $condition));
        return CHtml::listData($model, 'id', 'unit_name');
    }

    public function existanceCheck($attribute) {
        if ($this->unit_name != '') {
            $condition = '  lower(unit_name)="' . strtolower(trim($this->unit_name)) . '" AND building_id="' . $this->building_id . '" ';
            if (!empty($this->id)) {
                $condition .= " AND id != " . $this->id;
            }
            $model = self::model()->findAll(array('condition' => $condition));
            if (!empty($model)) {
                $this->addError($attribute, 'Record Already Exists');
                return false;
            }
        }
    }

}
