<?php

/**
 * This is the model class for table "{{fm_snag_items}}".
 *
 * The followings are the available columns in table '{{fm_snag_items}}':
 * @property integer $id
 * @property integer $header_id
 * @property integer $unit_id
 * @property integer $building_id
 * @property integer $snag_id
 * @property string $qty
 * @property string $chargeable
 * @property string $remark
 */
class FmSnagItems extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fm_snag_items}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('header_id, unit_id, building_id, snag_id, repair_qty, replace_qty, qty, chargeable', 'required'),
            array('header_id, unit_id, building_id, snag_id', 'numerical', 'integerOnly' => true),
            array('qty, repair_qty, replace_qty', 'numerical', 'min' => 0),
            array('chargeable', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, header_id, unit_id, building_id, snag_id,   qty, chargeable, remark', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'snag' => [self::BELONGS_TO, 'FmMasSnag', 'snag_id']
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'header_id' => 'Header',
            'unit_id' => 'Unit',
            'building_id' => 'Building',
            'snag_id' => 'Snag',
            'qty' => 'Qty',
            'chargeable' => 'Chargeable',
            'remark' => 'Remark',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('header_id', $this->header_id);
        $criteria->compare('unit_id', $this->unit_id);
        $criteria->compare('building_id', $this->building_id);
        $criteria->compare('snag_id', $this->snag_id);

        $criteria->compare('qty', $this->qty, true);
        $criteria->compare('chargeable', $this->chargeable, true);
        $criteria->compare('remark', $this->remark, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return FmSnagItems the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}
