<?php

/**
 * This is the model class for table "{{fm_snag_before_after_images}}".
 *
 * The followings are the available columns in table '{{fm_snag_before_after_images}}':
 * @property integer $id
 * @property integer $ticket_id
 * @property integer $snag_id
 * @property string $img
 * @property string $document_name
 * @property string $added_frm
 * @property integer $created_by
 * @property string $created_date_time
 */
class FmSnagBeforeAfterImages extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{fm_snag_before_after_images}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('ticket_id, snag_id, img, created_by, created_date_time', 'required'),
			array('ticket_id, snag_id, created_by', 'numerical', 'integerOnly'=>true),
			array('img, document_name', 'length', 'max'=>255),
			array('added_frm', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, ticket_id, snag_id, img, document_name, added_frm, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'ticket_id' => 'Ticket',
			'snag_id' => 'Snag',
			'img' => 'Img',
			'document_name' => 'Document Name',
			'added_frm' => 'Added Frm',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('ticket_id',$this->ticket_id);
		$criteria->compare('snag_id',$this->snag_id);
		$criteria->compare('img',$this->img,true);
		$criteria->compare('document_name',$this->document_name,true);
		$criteria->compare('added_frm',$this->added_frm,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FmSnagBeforeAfterImages the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
