<?php

/**
 * This is the model class for table "{{fm_planned_maintenance}}".
 *
 * The followings are the available columns in table '{{fm_planned_maintenance}}':
 * @property integer $id
 * @property integer $property_id
 * @property integer $unit_id
 * @property string $contract_start_date
 * @property string $contract_end_date
 * @property integer $contract_type_id
 * @property integer $service_frequency_id
 * @property string $remark
 */
class FmPlannedMaintenance extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fm_planned_maintenance}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('property_id, unit_id, contract_start_date, contract_end_date, contract_type_id, service_frequency_id', 'required'),
            array('property_id, unit_id, contract_type_id, service_frequency_id', 'numerical', 'integerOnly' => true),
            array('contract_end_date', 'validatecontractdate'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, property_id, unit_id, contract_start_date, contract_end_date, contract_type_id, service_frequency_id, remark', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'unit_rel' => array(self::BELONGS_TO, 'MasBuildingUnit', 'unit_id'),
            'building_rel' => array(self::BELONGS_TO, 'FmMasBuilding', 'property_id'),
            'planned_rel' => array(self::HAS_MANY, 'FmPlannedSchedule', 'header_id'),
            'frequency_rel' => array(self::BELONGS_TO, 'FmMasFrequency', 'service_frequency_id'),
            'type_rel' => array(self::BELONGS_TO, 'MasterPeriodType', 'contract_type_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'property_id' => 'Property',
            'unit_id' => 'Unit',
            'contract_start_date' => 'Contract Start Date',
            'contract_end_date' => 'Contract End Date',
            'contract_type_id' => 'Contract Type',
            'service_frequency_id' => 'Service Frequency',
            'remark' => 'Remark',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('property_id', $this->property_id);
        $criteria->compare('unit_id', $this->unit_id);
        $criteria->compare('contract_start_date', $this->contract_start_date, true);
        $criteria->compare('contract_end_date', $this->contract_end_date, true);
        $criteria->compare('contract_type_id', $this->contract_type_id);
        $criteria->compare('service_frequency_id', $this->service_frequency_id);
        $criteria->compare('remark', $this->remark, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return FmPlannedMaintenance the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function validatecontractdate($attribute, $params) {
        $start = strtotime($this->contract_start_date);
        $end = strtotime($this->contract_end_date);
        if ($start >= $end) {
            $this->addError('contract_end_date', "Contract end date must be greater than start date.");
        }

        if (!empty($this->service_frequency_id)) {
            $date1 = new DateTime($this->contract_start_date);
            $date2 = new DateTime($this->contract_end_date);
            $interval = $date1->diff($date2);
            $days_difference = $interval->days;
            if ($days_difference < 7) {
                $this->addError('contract_end_date', "Contract period must be 1 week long.");
            }
        }
    }

    public function getScheduledstatus() {
        $sql = "SELECT `is_converted`, COUNT(*) as qty FROM `erp_fm_planned_schedule` WHERE `header_id` = '$this->id'  GROUP BY `is_converted`; ";
        $rawData = Yii::app()->db->createCommand($sql)->queryAll();
        $pending = 0;

        $completed = 0;
        foreach ($rawData as $value) {
            if ($value['is_converted'] == "Y") {
                $completed = (int) $value['qty'];
            } else if ($value['is_converted'] == "N") {
                $pending = (int) $value['qty'];
            }
        }
        $total = $pending + $completed;
        $percentage = (int) (($completed * 100) / $total);
        $status = $completed . "/" . $total;
        return '<span  >' . $status . '</span>';
    }
    
    
    
    public function GetFmPlannedMaintenanceList()
    {
       // $condition = 'isActive =  "Y"'; 
        $condition = '1=1';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'id Desc'));
        return CHtml::listData($model, 'id', 'id');
    }

}
