<?php

/**
 * This is the model class for table "{{fm_mas_area}}".
 *
 * The followings are the available columns in table '{{fm_mas_area}}':
 * @property integer $id
 * @property string $name
 * @property string $isActive
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_date_time
 * @property string $updated_date_time
 */
class FmMasArea extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fm_mas_area}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('name, isActive, created_by, updated_by, created_date_time, updated_date_time', 'required'),
            array('created_by, updated_by, sort_order', 'numerical', 'integerOnly' => true),
            array('name', 'length', 'max' => 124),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, name, isActive, created_by, updated_by, created_date_time, updated_date_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'snag_rel' => [self::HAS_MANY, 'FmMasSnag', 'area_id']
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'name' => 'Name',
            'isActive' => 'Is Active',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_date_time' => 'Created Date Time',
            'updated_date_time' => 'Updated Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('name', $this->name, true);
        $criteria->compare('isActive', $this->isActive, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('created_date_time', $this->created_date_time, true);
        $criteria->compare('updated_date_time', $this->updated_date_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return FmMasArea the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getAll() {
        $condition = 'isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'name'));
        return CHtml::listData($model, 'id', 'name');
    }

}
