<?php

//modified by jisha on 09-11-21

class TicketController extends Controller {

    public $title = "Job Order";

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'), //,'temp_form','CompanyFieldDetails'
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'Save', 'Disable', 'Documentupload',
                    'GetDocumentList', 'SaveTicket', 'UploadDocuments', 'DeleteDocument', 'UploadDocuments',
                    'downloaddocument', 'print',
                    'Alot', 'Alotmentsave', 'Workinprogress', 'GetProgressList',
                    'Requestmaterial', 'Requestmaterialsave', 'Issuematerial', 'Issuematerialsave',
                    'DeleteOrderDetails', 'DeleteRequest', 'DeleteIssue',
                    'Usedmaterials', 'GetProducts', 'Getunitdrop', 'MaterialList',
                    'Material', 'CreateMaterial', 'Materialsummary', 'MaterialsummaryList', 'IssuedMaterial','getCustName',
                    'deletecancel'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {

        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**

     * This is the default 'index' action that is invoked

     * when an action is not explicitly requested by users.

     * //modified by jisha on 30-04-21.

     */
    public function actionIndex() {

        $this->render('index');
    }

    public function actionGetList() {



        $model = new TicketHeader();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $display_type = $_POST['display_type'];

        $status_type = $_POST['status_type'];
        $issue_types = $_POST['issue_types'];

        $to_date = $_POST['to_date'];

        $from_date = $_POST['from_date'];
        $priority = $_POST['priority'];

        $from_date = str_replace('/', '-', $from_date);

        $from_date = date("Y-m-d", strtotime($from_date));

        $to_date = str_replace('/', '-', $to_date);

        $to_date = date("Y-m-d", strtotime($to_date));

        $columns = array(
            // datatable column index  => database column name

            0 => 't.id',
            1 => 't.id',
            2 => 'remarks',
            3 => 'ticket_date',
            4 => 'ticket_status',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 'ticket_date >= "' . $from_date . '" AND ticket_date <= "' . $to_date . '"';

        if ($display_type != "")
            $condition .= ' AND (t.type = "' . $display_type . '")';





        if ($status_type != "")
            $condition .= ' AND (t.ticket_status = "' . $status_type . '")';


        if ($issue_types != "") {

            $condition .= ' AND (t.issue_type_id = "' . $issue_types . '")';
        }
        if ($priority != "") {

            $condition .= ' AND (t.priority_id = "' . $priority . '")';
        }



        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND (remarks LIKE '%" . $searchString . "%' "
                    . " OR building_details.building_name LIKE '%" . $searchString . "%' OR unit_details.unit_name LIKE '%" . $searchString . "%' )";
        }



        $count = $model->with('building_details', 'unit_details')->count(array('condition' => $condition));

        $model = $model->with('building_details', 'unit_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $model_condition = $condition;
        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {

            $ticket_date = date("d/m/Y h:i A", strtotime($row['ticket_date']));

            if ($row['raised_by'] == 1) {



                $raised = "Admin";
            } else if ($row['raised_by'] == 2) {



                $raised = "User";
            }

            if ($row['type'] == "T") {



                $machine_prop_name = $row->building_details->building_name;

                $unit_name = $row->unit_details->unit_name;

                $machine_prop_name .= " - " . $unit_name;

                $machine_prop_name .= " <span title='" . $row->priority_details->name . "' style='color:" . $row->priority_details->color_code . "' ><i class='fa fa-exclamation-circle'></i></span>";
            } else {

                $machine_prop_name = "";
            }
            $current_process_status = "";
            $status_name = $row->status_details->status_name;
            $issue_type = $row['issue_details']['issue_type'];
            if (!empty($row->master_file_id)) {
                $file = MasterFile::model()->findByPK($row->master_file_id);
                $current_process_status = $file->current_process_status;
                $status_name .= " <span class= 'status-$current_process_status badge'>$current_process_status</span";
            }
            $goods_issuse_id = "0";
            $goods_issuse_type = "GI";
            $condition = "ticket_id = $row->id ";
            $goods_issuses = InventoryGoodsIssue::model()->findAll(["condition" => $condition]);
            if (!empty($goods_issuses)) {
                $condition = "ticket_id = '$row->id' AND stock_updated='N' ";
                $goods_issuse = InventoryGoodsIssue::model()->find(["condition" => $condition]);
                if (!empty($goods_issuse)) {
                    $goods_issuse_id = $goods_issuse->id;
                }
                $issue_type .= "&nbsp;<span style='color:green' ><i class='fa fa-location-arrow' ></span>";
            }
            $view = 'N';
            if ($row->ticket_status == 3) {
                $view = 'Y';
            }
            $param = [
                "id" => $row->id,
                "status_id" => $row->ticket_status,
                "title" => $row->id,
                "color_code" => $row->status_details->color_code,
                "quotation_id" => $row->quotation_id,
                "master_file_id" => $row->master_file_id,
                "invoice_status" => $current_process_status,
                "good_issuse_id" => $goods_issuse_id,
                "good_issuse_type" => $goods_issuse_type,
                "view" => $view
            ];

            $rowData[] = array($row['id'],
                $issue_type,
                $machine_prop_name,
                $row['description'],
                $ticket_date,
                $status_name,
                $row['ticket_details']['issue_priority'],
                $param,
            );

            $m++;
        }



        $data['data'] = $rowData;
        $data['condition'] = $model_condition;

        echo json_encode($data);
    }

    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $scheduled_id = (int) Yii::app()->request->getParam('scheduled_id');
        $type = Yii::app()->request->getParam('type');
        $model = new TicketHeader;

        //set default medium priority
        $model->priority_id = 3;
        $modelDetails = array(new TicketDetails);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelDetails = TicketDetails::model()->findAll(array('condition' => 'ticket_id=' . $id));
            if (empty($modelDetails)) {
                $modelDetails = array(new TicketDetails());
            }
            $condition = 'ticket_id="' . $id . '"';
//            $modelIssueDetails = TicketIssueMaterials::model()->findAll(array('condition' => $condition));
            $modelTicketJobTime = TicketJobTime::model()->findAll(array('condition' => 'ticket_id=' . $id));
        } else if ($scheduled_id > 0) {
            $planned = FmPlannedSchedule::model()->findByPk($scheduled_id);
            $model = new TicketHeader;
            $contract = $planned->header;
            $model->property_id = $contract->property_id;
            $model->unit_id = $contract->unit_id;
            $model->issue_type_id = MasterIssueType::MAINTENANCE_SCHEDULE;
            $model->priority_id = FmPriority::MEDIUM;
            $model->description = $planned->remark;
            $model->schedule_maintenance_id = $planned->id;
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);

        $this->renderPartial('create', array('model' => $model, /* 'modelIssueDetails' => $modelIssueDetails, */ 'modelDetails' => $modelDetails, 'modelTicketJobTime' => $modelTicketJobTime, 'type' => $type), false, true);
    }

    /*
      public function actionSave() {

      $model = new TicketHeader();

      $modelDetails = [];

      $other_error = [];

      if (isset($_POST['TicketHeader'])) {

      $model->created_by = Yii::app()->user->id;

      $model->created_date_time = date("Y-m-d H:i:s");

      if ((int) @$_POST['TicketHeader']['id'] > 0) {

      $id = (int) @$_POST['TicketHeader']['id'];

      $model = $model->findByPk($id);
      } else {

      $model->ticket_status = 1;
      }

      if ((int) @$_POST['TicketHeader']['property_id'] > 0) {

      $model->property_id = $_POST['TicketHeader']['property_id'];
      }

      if ((int) @$_POST['TicketHeader']['unit_id'] > 0) {

      $model->unit_id = $_POST['TicketHeader']['unit_id'];
      }

      $model->scenario = "ticket";

      $model->attributes = $_POST['TicketHeader'];
      $model->schedule_maintenance_id = $_POST['TicketHeader']['schedule_maintenance_id'];

      $model->raised_by = Yii::app()->user->id;

      $mod_his = TicketHeader::model()->find(array('order' => 'id Desc'));

      if (empty($mod_his)) {

      $model->ticket_no = 1001;
      } else {

      $model->ticket_no = (int) $mod_his->ticket_no + 1;
      }



      if ($_POST['TicketHeader']['ticket_date'] != '') {

      $model->ticket_date = str_replace('/', '-', $_POST['TicketHeader']['ticket_date']);

      $model->ticket_date = date("Y-m-d", strtotime($model->ticket_date));
      }

      $valid = $model->validate();

      $p = 0;

      if (is_array($_POST['TicketDetails'])) {

      foreach ($_POST['TicketDetails'] as $i => $item) {

      $modelDetails[$p] = new TicketDetails;

      $modelDetails[$p]->attributes = $item;

      $modelDetails[$p]->issue_id = $item['issue_id'];

      $modelDetails[$p]->notes = $item['notes'];

      $modelDetails[$p]->issue_priority = $item['issue_priority'];

      $modelDetails[$p]->created_by = Yii::app()->user->id;

      $modelDetails[$p]->created_date_time = date("Y-m-d H:i:s");

      $valid = $modelDetails[$p]->validate() && $valid;

      $p++;
      }
      }

      if (empty($modelDetails)) {

      $other_error[] = ["item" => "No items to save."];

      $valid = false;
      }



      if ($valid) {
      $model->save();
      foreach ($modelDetails as $eachModel) {
      $eachModel->ticket_id = $model->id;
      $eachModel->save(false);
      }
      $jsonData['status'] = 'success';
      $jsonData['id'] = $model->id;
      echo CJSON::encode($jsonData);
      if (!empty($model->schedule_maintenance_id)) {
      FmPlannedSchedule::model()->updateByPk($model->schedule_maintenance_id, [
      'is_converted' => 'Y',
      'ticket_id' => $model->id
      ]);
      }
      } else {

      $error2 = array();

      $error1 = json_decode(CActiveForm::validate($model, '', false), true);

      if (!empty($modelDetails))
      $error2 = json_decode(CActiveForm::validateTabular($modelDetails, '', false), true);
      else
      $error2[] = "Please add atleast one line item";

      $error = CJSON::encode(array_merge_recursive($error1, $error2));

      if ($error != '[]')
      echo $error;
      }
      }
      }
     */

    public function actionDisable() {

        $id = Yii::app()->request->getparam('id');

        $status = Yii::app()->request->getparam('status');

        $model = new TicketDetails();

        $model = $model->findByPk($id);

        $model->is_active = ($status == "Y" ) ? "N" : "Y";

        $model->save();

        echo json_encode(array("status" => "success"));
    }

    public function actionDocumentupload() {

        $type_id = Yii::app()->request->getparam("type_id");

        $modelDocument = FmDocuments::model()->find(array('condition' => 'type_id = "' . $type_id . '" AND document_type="TECHNICIAN"'));

        if (empty($modelDocument)) {

            $modelDocument = new FmDocuments();
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);

        $this->renderPartial('document_index', array('modelDocument' => $modelDocument, 'type_id' => $type_id), false, true);
    }

    public function actionGetDocumentList() {



        $model = new FmDocuments();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(
            // datatable column index  => database column name

            0 => 't.type_id',
            1 => 't.document_name',
            2 => 't.created_by',
            3 => 't.created_datetime',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 't.type_id > 0 AND t.document_type="TICKET" and t.type_id = "' . $_POST['type_id'] . '"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " and (document_name LIKE '%" . $searchString . "%')";
        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {

            $button_string = "";

            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));

            $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteTicketDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a> &nbsp;';

            $button_string .= ' <a href ="' . Yii::app()->createUrl('fm/ticket/downloaddocument&id=' . $row['id']) . '" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';

            $rowData[] = array($m, $row['document_name'], $model2->username, date("d/m/Y h:i:s", strtotime($row['created_date_time'])), '<div class="btn-wrap text-center">' . $button_string . '</div>');
        }

        $data['data'] = $rowData;

        echo json_encode($data);
    }

    public function actionSaveTicket() {



        $model = new TicketHeader();

        $other = array();

        if (isset($_POST['TicketHeader'])) {

            $model->created_by = Yii::app()->user->id;

            date_default_timezone_set('Asia/Kolkata');

            $model->created_date_time = date("Y-m-d H:i:s");

            if ((int) @$_POST['TicketHeader']['id'] > 0) {

                $id = (int) @$_POST['TicketHeader']['id'];

                $model = $model->findByPk($id);
            } else {

                $model->ticket_status = 1;
            }

            if ((int) @$_POST['TicketHeader']['property_id'] > 0) {

                $model->property_id = $_POST['TicketHeader']['property_id'];
            }

            $model->attributes = $_POST['TicketHeader'];
           //add customer id also inthis header table
            $unit_id=$_POST['TicketHeader']['unit_id'];
               //$model->customer_id=$_POST['TicketHeader']['customer_id'];
            if($unit_id>0){
                 $unit_model = new MasBuildingUnit();
                 $unit_model = $unit_model->findByPk($unit_id);
                 $model->customer_id=$unit_model->customer_id;
            }
            
           
            //end code
            $model->raised_by = Yii::app()->user->id;

            $mod_his = TicketHeader::model()->find(array('order' => 'id Desc'));

            if (empty($mod_his)) {

                $model->ticket_no = 1001;
            } else {

                $model->ticket_no = (int) $mod_his->ticket_no + 1;
            }





            if ($_POST['TicketHeader']['ticket_date'] != '') {

                $model->ticket_date = str_replace('/', '-', $_POST['TicketHeader']['ticket_date']);

                $model->ticket_date = date("Y-m-d H:i", strtotime($model->ticket_date));
            }

            if ($_POST['TicketHeader']['rating'] != '') {

                $model->rating = $_POST['TicketHeader']['rating'];

                $model->rating_remarks = $_POST['TicketHeader']['rating_remarks'];
            }
            $model->schedule_maintenance_id = $_POST['TicketHeader']['schedule_maintenance_id'];

            $valid = true;

            //if ($valid) {

            if ($valid && $model->validate()) {

                $model->save();

                if (isset($_POST['Icon']['file']) && $_POST['Icon']['file'] != '') {

                    $modelDocument = new FmDocuments;

                    $modelDocument->document_type = "TICKET";

                    $modelDocument->type_id = $model->id;

                    $modelDocument->created_by = Yii::app()->user->id;

                    $modelDocument->created_date_time = date('Y-m-d H:i:s');

                    $modelDocument->document_name = $_POST['FmDocuments']['document_name'];

                    $modelDocument->file_name = $_POST['Icon']['file'];

                    $modelDocument->save(false);
                }



                //$model->save();



                $jsonData['status'] = 'success';

                //$jsonData['frm'] = $_POST['Song'];

                $jsonData['id'] = $model->id;
                if (!empty($model->schedule_maintenance_id)) {
                    FmPlannedSchedule::model()->updateByPk($model->schedule_maintenance_id, [
                        'is_converted' => 'Y',
                        'ticket_id' => $model->id
                    ]);
                }
                echo CJSON::encode($jsonData);
            } else {



                $error1 = json_decode(CActiveForm::validate($model, '', false), true);

//                if (!empty($modelDetails))
//                    $error2 = json_decode(CActiveForm::validateTabular($modelDetails, '', false), true);
//                else
//                    $error2[] = "Please add atleast one line item";



                $error = CJSON::encode(array_merge_recursive($error1));

                if ($error != '[]') {



                    echo $error;
                }
            }
        }
    }

    public function actionDeleteDocument() {

        $id = $_POST['id'];

        $modelDocument = new FmDocuments();

        $model_doc = FmDocuments::model()->findbyPK($id);

        $document_details = explode(',', $model_doc->file_name);

        foreach ($document_details as $value) {

            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $value;

            unlink($path);
        }

        $modelDocument->deleteByPk($id);

        echo "success";
    }

    public function actiondownloaddocument() {

        $id = (int) Yii::app()->request->getParam('id');

        $arr_technician_doc = FmDocuments::model()->findByPk($id);

        $file = $arr_technician_doc->file_name;

        $arr_doc_val = explode(',', $arr_technician_doc->file_name);

        if (count($arr_doc_val) > 1) {

            $zip = new ZipArchive();

            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $arr_technician_doc->file_name . "_" . date('d-m-Y') . ".zip";

            if ($zip->open($zip_file_path, 1 ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) === TRUE) {

                for ($i = 0; $i < count($arr_doc_val); $i++) {

                    $path = "images/attachment/" . $arr_doc_val[$i];

                    // Add the files to the .zip file

                    $zip->addFile($path, $arr_doc_val[$i]);
                }

                // Closing the zip file

                $zip->close();
            }

            header("Content-type:application/zip"); //for pdf file
            //if you want to read text file using text/plain header

            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');

            header('Content-Length: ' . filesize($zip_file_path));

            readfile($zip_file_path);

            Yii::app()->end();
        } else {

            $file = $arr_technician_doc->file_name;

            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file;

            header("Content-type:application/octet-stream"); //for txt file

            header("Content-Type: application/download");

            //header('Content-Type:text/plain; charset=ISO-8859-15');
            //if you want to read text file using text/plain header

            header('Content-Disposition: attachment; filename="' . basename($path) . '"');

            header('Content-Length: ' . filesize($path));

            readfile($path);

            Yii::app()->end();
        }
    }

    public function actionAlot() {

        $id = (int) Yii::app()->request->getParam('id');

        $model = new TicketHeader;

        $modelDetails = array(new TicketDetails);

        $modelTechnician = array(new Technician);

        $modelTechnicianalot = array(new TicketAllotTechnicians);

        if ($id > 0) {

            $model = $model->findByPk($id);

            $modelTechnicianalot = TicketAllotTechnicians::model()->findAll(array('condition' => 'ticket_id=' . $id));

            if (empty($modelTechnicianalot)) {

                $modelDetails = TicketDetails::model()->findAll(array('condition' => 'ticket_id=' . $id));

                foreach ($modelDetails as $k => $each) {

                    $modelTechnicianalot[$k] = new TicketAllotTechnicians;

                    $modelTechnicianalot[$k]->issue_id = $each->issue_id;

                    $modelTechnicianalot[$k]->issue_remarks = $each->issue_remarks;

                    $modelTechnicianalot[$k]->ticket_item_id = $each->id;
                }
            }
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);

        $this->renderPartial('alot', array('model' => $model, 'modelDetails' => $modelDetails, 'modelTechnicianalot' => $modelTechnicianalot), false, true);
    }

    public function actionAlotmentsave() {

        $other = array();

        $model = new TicketHeader();

        $modelticketdetails = new TicketDetails();

        $modelalottechnicians = array(new TicketAllotTechnicians());

        if ((int) @$_POST['TicketHeader']['id'] > 0) {

            $id = (int) @$_POST['TicketHeader']['id'];

            $model = $model->findByPk($id);

            if ($model->ticket_status != 6) {

                // if not in work in progress

                $model->ticket_status = 2;
            }

            $valid = $model->validate();

            $p = 0;

            $technicianArray = [];

            foreach ($_POST['TicketAllotTechnicians'] as $i => $item) {

                date_default_timezone_set('Asia/Kolkata');

                $modelalottechnicians[$p] = new TicketAllotTechnicians;

                if ((int) $item['id'] > 0) {

                    $modelalottechnicians[$p] = TicketAllotTechnicians::model()->findByPK((int) $item['id']);
                } else {

                    $modelalottechnicians[$p]->created_by = Yii::app()->user->id;

                    $modelalottechnicians[$p]->created_date_time = date("Y-m-d H:i:s");
                }

                $modelalottechnicians[$p]->attributes = $item;

                $modelalottechnicians[$p]->technician_id = $item['technician_id'];

                $modelalottechnicians[$p]->ticket_item_id = 0;

                $modelalottechnicians[$p]->ticket_id = $id;

                $modelalottechnicians[$p]->issue_remarks = $item['issue_remarks'];

                $modelalottechnicians[$p]->remarks = $item['remarks'];

                $modelalottechnicians[$p]->issue_id = $model->issue_type_id;

                $modelalottechnicians[$p]->allotted_date = date("Y-m-d H:i:s");

                if ($item['from_time'] != '') {

                    $modelalottechnicians[$p]->from_time = str_replace('/', '-', $item['from_time']);

                    $modelalottechnicians[$p]->from_time = date("Y-m-d H:i:s", strtotime($modelalottechnicians[$p]->from_time));
                }

                if ($item['to_time'] != '') {

                    $modelalottechnicians[$p]->to_time = str_replace('/', '-', $item['to_time']);

                    $modelalottechnicians[$p]->to_time = date("Y-m-d H:i:s", strtotime($modelalottechnicians[$p]->to_time));
                }

                if (isset($technicianArray[$modelalottechnicians[$p]->technician_id])) {

                    $valid = false;

                    $other[] = 'Duplicate allocation found.';
                }

                $technicianArray[$modelalottechnicians[$p]->technician_id] = "Y";

                $modelalottechnicians[$p]->updated_by = Yii::app()->user->id;

                $modelalottechnicians[$p]->updated_date_time = date("Y-m-d H:i:s");

                $valid = $valid && $modelalottechnicians[$p]->validate();

                $p++;
            }
        } else {

            $valid = false;

            $other[] = 'Invalid Job Order';
        }



        if ($valid) {

            $model->save(false);

            $model->refresh();

            foreach ($modelalottechnicians as $eachModel) {

                $eachModel->ticket_id = $model->id;

                $eachModel->save(false);
            }

            $jsonData['status'] = 'success';

            $jsonData['id'] = $model->id;

            echo CJSON::encode($jsonData);
        } else {

            $error2 = array();

            $error1 = json_decode(CActiveForm::validate($model, '', false), true);

            if (!empty($modelalottechnicians))
                $error2 = json_decode(CActiveForm::validateTabular($modelalottechnicians, '', false), true);
            else
                $error2[] = "Please add atleast one line item";

            $error = CJSON::encode(array_merge_recursive($error1, $error2, $other));

            if ($error != '[]')
                echo $error;
        }
    }

    public function actionWorkinprogress() {

        $this->render('workinprogress');
    }

    public function actionGetProgressList() {

        $modelTechnicianalot = new TicketAllotTechnicians;

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $display_type = $_POST['display_type'];

        $to_date = $_POST['to_date'];

        $from_date = $_POST['from_date'];

        $status_id = $_POST['status_id'];

        $from_date = str_replace('/', '-', $from_date);

        $from_date = date("Y-m-d", strtotime($from_date));

        $to_date = str_replace('/', '-', $to_date);

        $to_date = date("Y-m-d", strtotime($to_date));

        $columns = array(
            // datatable column index  => database column name

            0 => 't.ticket_id',
            1 => 'technician_details.technician_name',
            2 => 'issue_details.issue_type',
            3 => 'remarks',
            4 => 'allotted_date',
            5 => 'from_time',
            6 => 'to_time'
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 'date(t.from_time) >= "' . $from_date . '" AND date(t.from_time) <= "' . $to_date . '"';

        if ($display_type == 1)
            $condition = 'date(t.from_time) >= "' . $from_date . '" AND date(t.from_time) <= "' . $to_date . '"';

        else if ($display_type == 2)
            $condition = 'date(t.from_time) >= "' . $from_date . '" AND date(t.from_time) <= "' . $to_date . '" AND t.issue_id != "4"';

        else if ($display_type == 3)
            $condition = 'date(t.from_time) >= "' . $from_date . '" AND date(t.from_time) <= "' . $to_date . '" AND t.issue_id = "4"';

        if (!empty($status_id)) {

            $condition .= " AND  t.status ='$status_id'";
        }



        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND (technician_details.technician_name LIKE '%" . $searchString . "%' OR issue_details.issue_type LIKE '%" . $searchString . "%'OR t.remarks LIKE '%" . $searchString . "%')";
        }

        $count = $modelTechnicianalot->with('technician_details', 'issue_details', 'ticket_details')->count(array('condition' => $condition));

        $modelTechnicianalot = $modelTechnicianalot->with('technician_details', 'issue_details', 'ticket_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($modelTechnicianalot as $row) {



            $rowData[] = array($row['ticket_id'],
                $row['technician_details']['technician_name'],
                $row['issue_details']['issue_type'],
                $row['issue_remarks'],
                date('d/m/Y', strtotime($row['allotted_date'])),
                date('d/m/Y h:i:s a', strtotime($row['from_time'])),
                date('d/m/Y h:i:s a', strtotime($row['to_time'])),
                array('ticket_item_id' => $row['ticket_item_id'],
                    'issue_priority' => $row['ticket_details']['issue_priority'],
                    "id" => $row->id
                )
            );

            $m++;
        }



        $data['data'] = $rowData;

        $data['cond'] = $condition;

        echo json_encode($data);
    }

    public function actionRequestmaterial() {

        $id = (int) Yii::app()->request->getParam('id');

        $item_id = (int) Yii::app()->request->getParam('item_id');

        $model = new TicketHeader;

        $modelRequestDetails = array(new TicketRequestMaterials());

        if ($id > 0) {

            $model = $model->findByPk($id);

            $condition = 'ticket_id="' . $id . '" ';

            $modelRequestDetails = TicketRequestMaterials::model()->findAll(array('condition' => $condition));

            if (empty($modelRequestDetails)) {
                $newRequest = new TicketRequestMaterials();
                $newRequest->unit_id = 1; // just default unit
                $modelRequestDetails = array($newRequest);
            }
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);

        $this->renderPartial('requestmaterial', array('model' => $model, 'item_id' => $item_id, 'modelRequestDetails' => $modelRequestDetails), false, true);
    }

    public function actionRequestmaterialsave() {

        $other = array();

        $model = new TicketHeader;

        $modelRequestDetails = array(new TicketRequestMaterials);

        date_default_timezone_set('Asia/Kolkata');

        if ((int) @$_POST['TicketHeader']['id'] > 0) {

            $id = (int) @$_POST['TicketHeader']['id'];

            $ticket_item_id = (int) $_POST['ticket_item_id'];

            $model = $model->findByPk($id);

            $valid = $model->validate();

            $p = 0;

            foreach ($_POST['TicketRequestMaterials'] as $i => $item) {

                $modelRequestDetails[$p] = new TicketRequestMaterials;

                if ((int) $item['id'] > 0) {

                    $modelRequestDetails[$p] = TicketRequestMaterials::model()->findByPK((int) $item['id']);
                } else {

                    $modelRequestDetails[$p]->created_by = Yii::app()->user->id;

                    $modelRequestDetails[$p]->created_date_time = date("Y-m-d H:i:s");
                }

                $modelRequestDetails[$p]->attributes = $item;

                $modelRequestDetails[$p]->ticket_id = $id;

                $modelRequestDetails[$p]->ticket_item_id = $ticket_item_id;

                $modelRequestDetails[$p]->description = $item['description'];

                $modelRequestDetails[$p]->quantity = $item['quantity'];

                $modelRequestDetails[$p]->unit_id = $item['unit_id'];

                $unit_model = Unit::model()->findByPk((int) $item['unit_id']);

                $modelRequestDetails[$p]->unit_name = $unit_model->unit_name;

                $modelRequestDetails[$p]->updated_by = Yii::app()->user->id;

                $modelRequestDetails[$p]->updated_date_time = date("Y-m-d H:i:s");

                $valid = $valid && $modelRequestDetails[$p]->validate();

                $p++;
            }
        } else {

            $valid = false;

            $other[] = 'Invalid Work Allotment';
        }



        if ($valid) {



            foreach ($modelRequestDetails as $eachModel) {

                $eachModel->ticket_id = $model->id;

                $eachModel->save(false);
            }

            $jsonData['status'] = 'success';

            $jsonData['id'] = $model->id;

            echo CJSON::encode($jsonData);
        } else {

            $error2 = array();

            $error1 = json_decode(CActiveForm::validate($model, '', false), true);

            if (!empty($modelRequestDetails))
                $error2 = json_decode(CActiveForm::validateTabular($modelRequestDetails, '', false), true);
            else
                $error2[] = "Please add atleast one line item";

            $error = CJSON::encode(array_merge_recursive($error1, $error2, $other));

            if ($error != '[]')
                echo $error;
        }
    }

    public function actionIssuematerial() {

        $id = (int) Yii::app()->request->getParam('id');

        $item_id = (int) Yii::app()->request->getParam('item_id');

        $model = new TicketHeader;

        $modelIssueDetails = array(new TicketIssueMaterials());

        if ($id > 0) {

            $model = $model->findByPk($id);

            $condition = 'ticket_id="' . $id . '" AND ticket_item_id ="' . $item_id . '"';

            $modelIssueDetails = TicketIssueMaterials::model()->findAll(array('condition' => $condition));

            if (empty($modelIssueDetails)) {

                $modelIssueDetails = array(new TicketIssueMaterials);
            }
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);

        $this->renderPartial('issuematerial', array('model' => $model, 'item_id' => $item_id, 'modelIssueDetails' => $modelIssueDetails), false, true);
    }

    public function actionIssuematerialsave() {

        $other = array();

        $model = new TicketHeader;

        $modelIssueDetails = array(new TicketIssueMaterials);

        date_default_timezone_set('Asia/Kolkata');

        if ((int) @$_POST['TicketHeader']['id'] > 0) {

            $id = (int) @$_POST['TicketHeader']['id'];

            $ticket_item_id = (int) $_POST['ticket_item_id'];

            $model = $model->findByPk($id);

            $valid = $model->validate();

            $p = 0;

            $groups = array();

            foreach ($_POST['TicketIssueMaterials'] as $i => $item) {

                $modelIssueDetails[$p] = new TicketIssueMaterials;

                if ((int) $item['id'] > 0) {

                    $modelIssueDetails[$p] = TicketIssueMaterials::model()->findByPK((int) $item['id']);
                } else {

                    $modelIssueDetails[$p]->created_by = Yii::app()->user->id;

                    $modelIssueDetails[$p]->created_date_time = date("Y-m-d H:i:s");
                }

                $modelIssueDetails[$p]->attributes = $item;

                $modelIssueDetails[$p]->ticket_id = $id;

                $modelIssueDetails[$p]->ticket_item_id = $ticket_item_id;

                $modelIssueDetails[$p]->description = $item['description'];

                $modelIssueDetails[$p]->quantity = $item['quantity'];

                $modelIssueDetails[$p]->unit_id = $item['unit_id'];

                $unit_model = UnitOfMeasurement::model()->findByPk((int) $item['unit_id']);

                $unit_exchange = $unit_model->factor;

                $modelIssueDetails[$p]->unit_name = $unit_model->name;

                $modelIssueDetails[$p]->rate = $item['rate'];

                $modelIssueDetails[$p]->amount = $item['amount'];

                $modelIssueDetails[$p]->updated_by = Yii::app()->user->id;

                $modelIssueDetails[$p]->updated_date_time = date("Y-m-d H:i:s");

                $valid = $valid && $modelIssueDetails[$p]->validate();

                $p++;

                $key = $item['product_id'];

                if (!array_key_exists($key, $groups)) {

                    $groups[$key] = array(
                        'id' => $item['product_id'],
                        'quantity' => $item['quantity'] * $unit_exchange,
                    );
                } else {

                    $groups[$key]['quantity'] = $groups[$key]['quantity'] + $item['quantity'] * $unit_exchange;
                }
            }

            // QTY Checking

            if (!empty($groups)) {

                foreach ($groups as $key => $eachProduct) {

                    /* $product=Store::model()->findByPk($key);

                      if($product->type!='S'){

                      $qty=Yii::app()->db->createCommand("select SUM(quantity*U.unit_exchange_rate) from {{sales_invoice_items}} S INNER JOIN {{master_unit}} U ON S.unit=U.id where invoice_id='".$model->id."' AND product_id='".$key."'")->queryScalar();

                      $bal=$eachProduct['quantity']-$qty;

                      $in_qty=Yii::app()->db->createCommand("select SUM(quantity*unit_exchange_rate) from {{stock_ledger}} where transaction_type='IN' AND product_id='".$key."' AND outlet=".Yii::app()->user->outlet_id." AND created_by=".$model->sales_man." AND transaction_date<='".$model->invoice_date."'")->queryScalar();

                      $out_qty=Yii::app()->db->createCommand("select SUM(quantity*unit_exchange_rate) from {{stock_ledger}} where transaction_type='OUT' AND product_id='".$key."' AND outlet=".Yii::app()->user->outlet_id." AND created_by=".$model->sales_man." AND transaction_date<='".$model->invoice_date."'")->queryScalar();

                      $current_stock=$in_qty-$out_qty;

                      $available_in_qty=Yii::app()->db->createCommand("select SUM(quantity*unit_exchange_rate) from {{stock_ledger}} where transaction_type='IN' AND product_id='".$key."' AND outlet=".Yii::app()->user->outlet_id." AND created_by=".$model->sales_man)->queryScalar();

                      $available_out_qty=Yii::app()->db->createCommand("select SUM(quantity*unit_exchange_rate) from {{stock_ledger}} where transaction_type='OUT' AND product_id='".$key."' AND outlet=".Yii::app()->user->outlet_id." AND created_by=".$model->sales_man)->queryScalar();

                      $available_stock=$available_in_qty-$available_out_qty;

                      $qty_check=true;

                      if($bal>0 && $current_stock<$bal)

                      {

                      $other[]=$product->part_number.' maximum sellable qty : '.($current_stock+$qty).' '.$product->units->unit_name;

                      $valid=false;

                      $qty_check=false;

                      }

                      if($qty_check)

                      {

                      if($bal>0 && $available_stock<$bal)

                      {

                      $other[]=$product->part_number.' maximum sellable qty : '.($available_stock+$qty).' '.$product->units->unit_name.'(Available Stock)';

                      $valid=false;

                      }

                      }

                      } */
                }
            }
        } else {

            $valid = false;

            $other[] = 'Invalid Work Allotment';
        }



        if ($valid) {



            foreach ($modelIssueDetails as $eachModel) {

                $eachModel->ticket_id = $model->id;

                $eachModel->save(false);
            }

            $jsonData['status'] = 'success';

            $jsonData['id'] = $model->id;

            echo CJSON::encode($jsonData);
        } else {

            $error2 = array();

            $error1 = json_decode(CActiveForm::validate($model, '', false), true);

            if (!empty($modelIssueDetails))
                $error2 = json_decode(CActiveForm::validateTabular($modelIssueDetails, '', false), true);
            else
                $error2[] = "Please add atleast one line item";

            $error = CJSON::encode(array_merge_recursive($error1, $error2, $other));

            if ($error != '[]')
                echo $error;
        }
    }

    public function actionDeleteOrderDetails() {

        $id = $_POST['id'];

        if ($id > 0) {

            TicketDetails::model()->deleteByPk($id);

            $status['status'] = 'success';
        } else {

            $status['status'] = 'error';
        }

        echo CJSON::encode($status);
    }

    public function actionDeleteRequest() {

        $id = $_POST['id'];

        if ($id > 0) {

            TicketRequestMaterials::model()->deleteByPk($id);

            $status['status'] = 'success';
        } else {

            $status['status'] = 'error';
        }

        echo CJSON::encode($status);
    }

    public function actionDeleteIssue() {

        $id = $_POST['id'];

        if ($id > 0) {

            TicketIssueMaterials::model()->deleteByPk($id);

            $status['status'] = 'success';
        } else {

            $status['status'] = 'error';
        }

        echo CJSON::encode($status);
    }

    public function actionTimeforjob() {

        $id = (int) Yii::app()->request->getParam('id');

        $model = new TicketHeader;

        $modelTicketJobTime = array(new TicketJobTime());

        if ($id > 0) {

            $model = $model->findByPk($id);

            $condition = 'ticket_id="' . $id . '"';

            $modelTicketJobTime = TicketJobTime::model()->findAll(array('condition' => $condition));

            echo $modelTicketJobTime;

            if (empty($modelTicketJobTime)) {

                $modelTicketJobTime = array(new TicketIssueMaterials());
            }
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);

        $this->renderPartial('usedmaterials', array('model' => $model, 'modelTicketJobTime' => $modelTicketJobTime), false, true);
    }

    public function actionGetProducts() {



        $condition = '(part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%") and t.isActive="Y"';

        $model = new Store();

        $model = $model->with('tax')->findAll(array('select' => 'id,part_number,description,unit_id,inventory_item_type,purchase_from,rate', 'condition' => $condition, 'limit' => 200));

        $i = 0;

        $data = array();

        foreach ($model as $eachModel) {

            $data[$i]['value'] = $eachModel->id;

            $data[$i]['label'] = $eachModel->part_number . ' : ' . $eachModel->description;

            $data[$i]['part_number'] = $eachModel->part_number;

            $data[$i]['description'] = $eachModel->description;

            $data[$i]['unit_id'] = $eachModel->unit->id;

            $data[$i]['unit_name'] = $eachModel->unit->symbol;

            $data[$i]['tax_code'] = $eachModel->tax;

            $data[$i]['part_no'] = $eachModel->part_number;

            $data[$i]['other'] = $eachModel->inventory_item_type;

            $data[$i]['purchasefrm'] = $eachModel->purchase_from;

            $data[$i]['rate'] = $eachModel->rate;

            $i++;
        }

        echo CJSON::encode($data);

        Yii::app()->end();
    }

    public function actionGetunitdrop() {

        $row = $_POST['row_field'];

        $product = $_POST['product_id'];

        $type = $_POST['type'];

        $drop = array();

        $modelIssue = new TicketIssueMaterials;

        if ($product > 0) {

            $modelIssue->unit_id = UnitOfMeasurement::getBaseunit($product);

            $drop['drop'] = CHtml::activedropdownlist($modelIssue, "[" . $row . "]unit_id", UnitOfMeasurement::getUnits($product), array('class' => 'unit go'));
        }

        echo CJSON::encode($drop);
    }

    public function actionMaterial() {

        $this->render('material_list');
    }

    public function actionMaterialList() {



        $model = new TicketRequestMaterials();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $req_date = $_POST['req_date'];

        $req_date = str_replace('/', '-', $req_date);

        $req_date = date("Y-m-d", strtotime($req_date));

        $columns = array(
            // datatable column index  => database column name

            0 => 't.id',
            1 => 'description',
            2 => 'quantity',
            3 => 'unit_name',
            4 => 'created_date_time',
            5 => 'issued',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 't.issued ="N"';

        $date = date('Y-m-d');

        if ($req_date < $date) {

            $condition .= ' AND date(t.created_date_time) >= "' . $req_date . '" ';
        }



        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND (description LIKE '%" . $searchString . "%' OR t.ticket_id LIKE '%" . $searchString . "%')";
        }

        //echo $condition; exit;



        $count = $model->with('ticket_det')->count(array('condition' => $condition));

        $model = $model->with('ticket_det')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {







            $SQL = "SELECT A.technician_id AS technician_id, T.technician_name AS technician_name,H.id AS ticket_id FROM erp_fm_ticket_allot_technicians A

                LEFT JOIN erp_fm_ticket_header H ON H.id = A.ticket_id

                LEFT JOIN erp_fm_technician T ON T.id = A.technician_id

                WHERE A.ticket_id =" . $row['ticket_id'] . " AND A.ticket_item_id =" . $row['ticket_item_id'];

            $condition_issued = "ticket_item_id=" . $row['ticket_item_id'];

            $model_TicketIssueMaterials = TicketIssueMaterials::model()->find(array('condition' => $condition_issued));

            if ($model_TicketIssueMaterials['quantity'] == "") {

                $TicketIssueMaterials_quantity = "0.00";
            } else {

                $TicketIssueMaterials_quantity = $model_TicketIssueMaterials['quantity'];
            }



            $balance = $row['quantity'] - $TicketIssueMaterials_quantity;

            $balance = sprintf('%.2f', $balance);

            $tech_details = Yii::app()->db->createCommand($SQL)->queryAll();

            foreach ($tech_details as $tech_name) {

                $ticket_date = date("d/m/Y h:i a", strtotime($row['created_date_time']));

                $rowData[] = array($row['id'],
                    $tech_name['ticket_id'],
                    //'ticket_id=' .$row['ticket_id'].' AND ticket_item_id='. $row['ticket_item_id'],
                    $tech_name['technician_name'],
                    $row['description'],
                    $row['quantity'],
                    $TicketIssueMaterials_quantity,
                    $balance,
                    $row['unit_name'],
                    $ticket_date,
                    $row['issued']
                );

                $m++;
            }
        }



        $data['data'] = $rowData;

        echo json_encode($data);
    }

    public function actionMaterialsummary() {

        $this->render('material_summary');
    }

    public function actionMaterialsummaryList() {



        $model = new TicketRequestMaterials();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(
            // datatable column index  => database column name

            0 => 't.ticket_id',
            1 => 'description',
            2 => 'created_date_time',
            3 => 'unit_name'
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = '1=1';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND (description LIKE '%" . $searchString . "%')";
        }



        $count = $model->with('ticket_det')->count(array('condition' => $condition));

        $model = $model->with('ticket_det')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy, 'group' => 'description'));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {



            $conditions = " description LIKE '%" . $row['description'] . "%'";

            $modelmaterials = TicketRequestMaterials::model()->find(array('select' => 'sum(quantity)as quantity', 'condition' => $conditions, 'group' => 'description'));

            $quantity = $modelmaterials->quantity;

            $condition_issued = " description LIKE '%" . $row['description'] . "%'";

            $model_TicketIssueMaterials = TicketIssueMaterials::model()->find(array('select' => 'sum(quantity)as quantity', 'condition' => $condition_issued, 'group' => 'description'));

            //echo '<pre>'; print_r($model_TicketIssueMaterials); exit;

            if ($model_TicketIssueMaterials->quantity != "") {

                $issued_qty = $model_TicketIssueMaterials->quantity;
            } else {

                $issued_qty = "0.00";
            }

            $balance = $quantity - $issued_qty;

            $balance = sprintf('%.2f', $balance);

            $ticket_date = date("d/m/Y h:i a", strtotime($row['created_date_time']));

            $rowData[] = array($row['ticket_item_id'],
                //'ticket_id=' .$row['ticket_id'].' AND ticket_item_id='. $row['ticket_item_id'],
                $row['description'],
                $quantity,
                $issued_qty,
                $balance,
                $row['unit_name']
            );

            $m++;
        }



        $data['data'] = $rowData;

        echo json_encode($data);
    }

    public function actionIssuedMaterial() {

        $id = (int) Yii::app()->request->getParam('id');

        $modelRequestMaterials = new TicketRequestMaterials();

        $modelRequestMaterials = $modelRequestMaterials->findByPk($id);

        $ticket_id = $modelRequestMaterials->ticket_id;

        $ticket_item_id = $modelRequestMaterials->ticket_item_id;

        $modelTicketIssueMaterials = array(new TicketIssueMaterials);

        //$modelTicketIssueMaterials = TicketIssueMaterials::model()->findAll(array('select' => 'sum(quantity) as quantity','condition' => 'ticket_id=' . $ticket_id . ' AND ticket_item_id=' .$ticket_item_id));

        $modelTicketIssueMaterials = TicketIssueMaterials::model()->findAll(array('condition' => 'ticket_id=' . $ticket_id . ' AND ticket_item_id=' . $ticket_item_id));

        //print_r($modelTicketIssueMaterials); exit;

        if (!empty($modelTicketIssueMaterials)) {

            /* if($modelRequestMaterials->quantity == $modelTicketIssueMaterials->quantity)

              { */

            /* $modelTicketIssueMaterials->issued = 'Y';

              $modelTicketIssueMaterials->save(false); */

            $modelRequestMaterials->updateByPk($id, array('issued' => 'Y'));

            $jsonData['status'] = 'success';

            //}
        }



        echo CJSON::encode($jsonData);
    }

    public function actionPrint() {

        $id = (int) Yii::app()->request->getParam('id');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');

        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial('print', array('id' => $id), true));

        $mPDF1->Output("Ticket.pdf", 'I');
    }

    public function actionDeletecancel() {
        $id = (int) Yii::app()->request->getParam('id');
        $ticketModel = TicketHeader::model()->findByPk($id);

        if ($ticketModel->ticket_status == 1 || $ticketModel->ticket_status == 2 || $ticketModel->ticket_status == 5) {
            TicketHeader::model()->updateByPk($id, [
                "ticket_status" => 5
            ]);
            echo json_encode(["status" => "success", "message" => "Ticket closed"]);
        } else {
            echo json_encode(["message" => "Error in cancelling ticket."]);
        }
    }
    public function actiongetCustName(){
      $unit_id= (int) Yii::app()->request->getParam('unit_id');
        $jsonData=[];
        if($unit_id>0){
             $unit_model = new MasBuildingUnit();
             $unit_model = $unit_model->findByPk($unit_id);
             $unit_address=$unit_model->address;
             $customer_model=new Customer();
             $customer_model=$customer_model->findByPk((int)$unit_model->customer_id);
             //print_r( $unit_model);exit;
             $jsonData['cust_name'] = $customer_model->customer_name;
             $jsonData['cust_id'] = $customer_model->id;
             $jsonData['unit_address'] = $unit_address;
             $jsonData['status'] = 'success';
        }
        else{

            $jsonData['status'] = 'error';
        } 
         echo CJSON::encode($jsonData);
       
    }
}
