<?php

class SnagController extends Controller
{

    public $title = "Snag";

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'Save', 'GetList', 'print', 'printJobCompletionReport'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex()
    {
        if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fm_snag_view"])) {
            $this->render('index');
        } else {
            echo "Access denied.";
        }
    }

    public function actionGetList()
    {
        $model = new FmSnag();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name

            0 => 't.id',
            1 => 't.job_id',
            2 => 'building_rel.building_name',
            3 => 'unit_rel.unit_name',
            4 => 't.snag_date',
            5 => 'technician_rel.technician_name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = ' 1=1 ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (t.job_id LIKE '%" . $searchString . "%') OR  (building_rel.building_name LIKE '%" . $searchString . "%')
            OR  (technician_rel.technician_name LIKE '%" . $searchString . "%')
            ";
        }
        $count = $model->with('building_rel','unit_rel','technician_rel')->count(array('condition' => $condition));
        $model = $model->with('building_rel','unit_rel','technician_rel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
       


        foreach ($model as $row) {


             // --------------added by indhu on 07_11_2023---------------------
        $condition_qc = "ticket_id = " . $row->job_id . "   AND allot_type_id = " . FmAllotType::TYPE_QC . " ";
        $modelJobTime = new TicketJobTime();
        $modelJobTimes = $modelJobTime->find(["condition" => $condition_qc]);
        $showCompletion_pdf = (empty($modelJobTimes)) ? 'N' : 'Y';

        // -----------------------------------

        
            $rowData[] = array(
                $m,
                $row->job_id, 
                $row->building_rel->building_name,
                $row->unit_rel->unit_name,
                date("d/m/Y", strtotime($row->snag_date)),
                $row->technician_rel->technician_name,
                array(
                    'id' => $row->id,
                    'job_id' => $row->job_id,'showCompletion_pdf' => $showCompletion_pdf
                )
            );

            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $model = new FmSnag();
        $id = (int) Yii::app()->request->getParam('job_id');
        $ticket_model = new TicketHeader();
        $ticket_model = $ticket_model->findbyPk($id);
        if ($id > 0) {
            $condition = "t.job_id = " . $id;
            $model = $model->find(["condition" => $condition]);
            if (empty($model)) {
                $model = new FmSnag();
            }
        }
        $model->job_id = $id;
        $model->building_id = $ticket_model->property_id;
        $model->unit_id = $ticket_model->unit_id;
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionSave()
    {

        $valid = true;
        $other_errors = [];
        $header_id = (int) $_POST['FmSnag']['id'];
        $snag_model = new FmSnag();
        if (empty($header_id)) {
            $snag_model->snag_date = date("Y-m-d");
            $snag_model->time_out = date("Y-m-d H:i:s");
            $snag_model->time_in = date("Y-m-d H:i:s");
            $snag_model->created_by = Yii::app()->user->id;
            $snag_model->created_date_time = date("Y-m-d H:i:s");
        } else {
            $snag_model = $snag_model->findByPk($header_id);
        }

        $snag_model->attributes = $_POST['FmSnag'];
        $date_model = new DateModel();
        $snag_model->snag_date = $date_model->toSqlDate($_POST['FmSnag']['snag_date']);
        $snag_model->termination_date = $date_model->toSqlDate($_POST['FmSnag']['termination_date']);
        $snag_model->vacating_date = $date_model->toSqlDate($_POST['FmSnag']['vacating_date']);
        if (is_array($_POST['FmSnag']['type_list'])) {
            $snag_model->type_list = implode(",", $_POST['FmSnag']['type_list']);
        } else {
            $snag_model->type_list = "";
        }

        $valid = $valid && $snag_model->validate();

        $snag_item_model = [];
        $key = 0;

        foreach ($_POST['FmSnagItems'] as $items) {
            $snag_item_model[$key] = new FmSnagItems();
            $id = $items["id"];
            if (!empty($id)) {
                $snag_item_model[$key] = $snag_item_model[$key]->findByPk($id);
            }
            $snag_item_model[$key]->attributes = $items;
            $snag_item_model[$key]->remark = trim($items['remark']);
            $snag_item_model[$key]->header_id = 0;
            if (empty($snag_item_model[$key]->repair_qty)) {
                $snag_item_model[$key]->repair_qty = 0;
            }
            if (empty($snag_item_model[$key]->replace_qty)) {
                $snag_item_model[$key]->replace_qty = 0;
            }
            $snag_item_model[$key]->qty = $snag_item_model[$key]->replace_qty + $snag_item_model[$key]->repair_qty;
            $snag_item_model[$key]->unit_id = $snag_model->unit_id;
            $snag_item_model[$key]->building_id = $snag_model->building_id;
            $valid = $valid && $snag_item_model[$key]->validate();
            $key++;
        }

        if ($valid) {
            $snag_model->save();
            foreach ($snag_item_model as $value) {
                $value->header_id = $snag_model->id;
                $value->save();
            }

            $job_order = new TicketHeader();
            $job_order->updateByPK($snag_model->job_id, [
                'snag_id' => $snag_model->id
            ]);

            echo json_encode([
                "status" => "success",
                "snag_id" => $snag_model->id,
            ]);
        } else {

            $error1 = json_decode(CActiveForm::validate($snag_model, '', false), true);
            $error2 = json_decode(CActiveForm::validateTabular($snag_item_model, '', false), true);
            $error = CJSON::encode(array_merge_recursive($error1, $error2, $other_errors));
            echo $error;
        }
    }

    public function actionPrint()
    {
        $id = Yii::app()->request->getparam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('print', array('id' => $id), true));
        $mPDF1->Output("Snag.pdf", 'I');
    }

    public function actionprintJobCompletionReport()
    {
        $ticket_id = Yii::app()->request->getparam('ticket_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('print_job_completion', array('ticket_id' => $ticket_id), true));
        $mPDF1->Output("CompletionReport.pdf", 'I');
    }
}
