<?php

class ServicecontractController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'Create', 'Save', 'GetList', 'deletemachine',),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {

        $this->render('index', array());
    }

    public function actionGetList() {
        $model = new FmServiceContract();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
// datatable column index  => database column name
            0 => 't.id',
            1 => 'name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = 'id';
        $condition = '1=1 ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (id LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $param = ["id" => $row->id,
                "status" => $row->status];
            $rowData[] = array($m,
                $row->vendor_rel->vendor_name,
                $row->type_rel->period_type,
                $row->frequency_rel->name,
                date("d/m/Y", strtotime($row->contract_start_date)),
                date("d/m/Y", strtotime($row->contract_end_date)),
                $param,
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new FmServiceContract();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model->vendor_name = $model->vendor_rel->vendor_name;
            $model->contract_start_date = date("d/m/Y", strtotime($model->contract_start_date));
            $model->contract_end_date = date("d/m/Y", strtotime($model->contract_end_date));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionSave() {
        $model = new FmServiceContract();
        $machineList = [];
        $plannedList = [];
        if ((int) @$_POST['FmServiceContract']['id'] > 0) {
            $id = (int) @$_POST['FmServiceContract']['id'];
            $model = $model->findByPk($id);
        } else {
            $model->created_date_time = date("Y-m-d H:i");
            $model->created_by = Yii::app()->user->id;
        }
        $model->updated_date_time = date("Y-m-d H:i");
        $model->update_by = Yii::app()->user->id;
        // storing previous value
        $prev_contract_start_date = $model->contract_start_date;
        $prev_contract_end_date = $model->contract_end_date;
        $prev_service_frequency = $model->service_frequency;

        $model->attributes = $_POST['FmServiceContract'];

        $model->contract_start_date = DateModel::toSqlDate($_POST['FmServiceContract']['contract_start_date']);
        $model->contract_end_date = DateModel::toSqlDate($_POST['FmServiceContract']['contract_end_date']);

        $valid = $model->validate();

        foreach ($_POST['FmServiceContractMachine'] as $key => $eachMachine) {
            $machineList[$key] = new FmServiceContractMachine();
            if (!empty($eachMachine['id'])) {
                $machineList[$key] = FmServiceContractMachine::model()->findByPk($eachMachine['id']);
            }
            $machineList[$key]->contract_id = 0;
            $machineList[$key]->machine_id = $eachMachine['machine_id'];
            $machineList[$key]->attributes = $eachMachine;
            $valid = $valid && $machineList[$key]->validate();
        }
        foreach ($_POST['FmServicePlanned'] as $key => $value) {
            $plannedList[$key] = new FmServicePlanned();
            if (!empty($value['id'])) {
                $plannedList[$key] = FmServicePlanned::model()->findByPk($value['id']);
            }
            $plannedList[$key]->contract_id = 0;
            $plannedList[$key]->attributes = $value;
            $plannedList[$key]->planned_date = DateModel::toSqlDate($value['planned_date']);
            $plannedList[$key]->remark = $value['remark'];
            $plannedList[$key]->is_converted = 'N';
            $valid = $valid && $plannedList[$key]->validate();
        }
        if ($valid) {
            $model->save();
            foreach ($machineList as $key => $value) {
                $value->contract_id = $model->id;
                $value->save();
            }
            $condition = "contract_id ='" . $model->id . "' ";
            FmServicePlanned::model()->deleteAll(["condition" => $condition]);
            foreach ($plannedList as $key => $value) {
                $value->contract_id = $model->id;
                $value->save();
            }

            $jsonData['status'] = 'success';
            //$jsonData['frm'] = $_POST['Song'];
            $jsonData['id'] = $model->id;
            echo CJSON::encode($jsonData);
        } else {
            $error_2 = [];
            $error_3 = [];
            $error_1 = json_decode(CActiveForm::validateTabular($model, '', false), true);
            $error_2 = json_decode(CActiveForm::validateTabular($machineList, '', false), true);
            $error_3 = json_decode(CActiveForm::validateTabular($plannedList, '', false), true);

            $error = CJSON::encode(array_merge_recursive($error_1, $error_2, $error_3));
            if ($error != '[]') {
                echo $error;
            }
        }
    }

    public function actionDeletemachine() {
        $id = $_POST['id'];

        if (!empty($id)) {
            // need to check hsitory before delete.
            // thats part no developed yet
            $model = new FmServiceContractMachine();
            $model->deleteByPk($id);
        } else {
            // no data to delete
            echo json_encode(["status" => "success"]);
        }
    }

}
