<?php

class MaterialsummaryController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'Create', 'Save', 'GetList', 'Delete', 'MaterialList'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $model = new Types();
        $this->render('index', array('model' => $model));
    }

    public function actionGetList() {




        $model = new ViewFmRequestedMaterial();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(
            // datatable column index  => database column name

            0 => 't.description',
            1 => 't.description',
            2 => 'description',
            3 => 'unit_name'
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = '1=1';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND (description LIKE '%" . $searchString . "%')";
        }



        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy, 'group' => 'description'));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {

            $rowData[] = array($m, $row->description,
                $row->quantity,
                $row->unit_name,
            );

            $m++;
        }



        $data['data'] = $rowData;

        echo json_encode($data);
    }

    public function actionMaterialList() {



        $model = new TicketRequestMaterials();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $req_date = $_POST['req_date'];

        $req_date = str_replace('/', '-', $req_date);

        $req_date = date("Y-m-d", strtotime($req_date));

        $columns = array(
            // datatable column index  => database column name

            0 => 't.id',
            1 => 'description',
            2 => 'quantity',
            3 => 'unit_name',
            4 => 'created_date_time',
            5 => 'issued',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;
        $orderBy = " t.id desc";

        $condition = ' ticket_det.ticket_status IN (1,2,6) ';

        $date = date('Y-m-d');

        if ($req_date < $date) {

            $condition .= ' AND date(t.created_date_time) >= "' . $req_date . '" ';
        }



        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition .= " AND (t.description LIKE '%" . $searchString . "%' OR t.ticket_id LIKE '%" . $searchString . "%')";
        }

        //echo $condition; exit;



        $count = $model->with('ticket_det')->count(array('condition' => $condition));

        $model = $model->with('ticket_det')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {
            $goods_issuse_id = "0";
            $goods_issuse_type = "GI";
            $condition = "ticket_id = $row->ticket_id";
            $goods_issuses = InventoryGoodsIssue::model()->findAll(["condition" => $condition]);
            if (!empty($goods_issuses)) {
                $condition = "ticket_id = '$row->ticket_id' AND stock_updated='N' ";
                $goods_issuse = InventoryGoodsIssue::model()->find(["condition" => $condition]);
                if (!empty($goods_issuse)) {
                    $goods_issuse_id = $goods_issuse->id;
                }
                $issue_type .= "&nbsp;<span style='color:green' ><i class='fa fa-location-arrow' ></span>";
            }
            $param = [
                "ticket_id" => $row->ticket_id,
                "good_issuse_id" => $goods_issuse_id,
                "good_issuse_type" => $goods_issuse_type
            ];
            $rowData[] = [$m,
                $row->ticket_id,
                $row->description,
                $row->quantity,
                $row->unit_name,
                date("d/m/Y", Strtotime($row->created_date_time)),
                $param
            ];
        }



        $data['data'] = $rowData;

        echo json_encode($data);
    }

}
