<?php



class MasterPeriodTypeController extends Controller {



    public function accessRules() {

        return array(

            array('allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array('login', 'error', 'logout'),

                'users' => array('*'),

            ),

            array('allow', // allow authenticated user to perform 'create' and 'update' actions

                'actions' => array('Index', 'Getlist', 'Create', 'Save', 'Disable'),

                'expression' => '$user->isMember()',

            ),

            array('deny', // deny all users

                'users' => array('*'),

            ),

        );

    }



    public function filters() {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    }



    public function actionIndex() {

        $this->render('index');

    }



    public function actionGetList() {



        $model = new MasterPeriodType();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            0 => 't.id',

            1 => 'period_typee',

            2 => 'is_active'

        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = 'period_type';

        $condition = 't.is_active="Y"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition = "  (period_type LIKE '%" . $searchString . "%')";

        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;

        foreach ($model as $row) {





            $rowData[] = array($m,

                $row['period_type'],

                $row['id'],

                $row['is_active'],

            );



            $m++;

        }



        $data['data'] = $rowData;

        echo json_encode($data);

    }



    public function actionCreate() {

        $model = new MasterPeriodType();

        $id = (int) Yii::app()->request->getParam('id');

        if ($id > 0) {

            $model = $model->findByPk($id);

        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);



        $this->renderPartial('create', array('model' => $model), false, true);

    }



    public function actionSave() {

        $model = new MasterPeriodType();

        if (isset($_POST['MasterPeriodType'])) {



            if ((int) @$_POST['MasterPeriodType']['id'] > 0) {

                $id = (int) @$_POST['MasterPeriodType']['id'];

                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;

                $model->updated_date_time = date("Y-m-d H:i:s");

            } else {



                $model->created_by = Yii::app()->user->id;

                $model->created_date_time = date("Y-m-d H:i:s");

            }



            $model->attributes = $_POST['MasterPeriodType'];

            $model->period_type =  trim(strtoupper($_POST['MasterPeriodType']['period_type']));

           

            if ($model->save()) {





                $jsonData['status'] = 'success';

                //$jsonData['frm'] = $_POST['Song'];

                $jsonData['id'] = $model->id;

                echo CJSON::encode($jsonData);

            } else {

                $error = CActiveForm::validate($model, '', false);

                if ($error != '[]')

                    echo $error;

            }

        }

    }



    public function actionDisable() {

        $id = Yii::app()->request->getparam('id');

        $status = Yii::app()->request->getparam('status');

        $model = new MasterPeriodType();

        $model = $model->findByPk($id);

        $model->is_active = ($status == "Y" ) ? "N" : "Y";

        $model->save();

        echo json_encode(array("status" => "success"));

    }



}