<?php

class MassnagController extends Controller {

    public $title = "Master Snag";

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'Save', 'GetList', 'Disable', 'getservice'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetList() {
        $model = new FmMasSnag();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name

            0 => 't.id',
            1 => 'name',
            2 => 'isActive',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {

            $rowData[] = array($m,
                $row['name'],
                $row->service_rel->description,
                $row->area_rel->name,
                array('id' => $row['id'], 'code' => $row['name'], 'status' => $row->isActive));

            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new FmMasSnag();
        $id = (int) Yii::app()->request->getParam('id');

        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionSave() {
        $model = new FmMasSnag();
        if (isset($_POST['FmMasSnag'])) {
            if ((int) @$_POST['FmMasSnag']['id'] > 0) {
                $id = (int) @$_POST['FmMasSnag']['id'];
                $model = $model->findByPk($id);
            } else {
                $model->isActive = 'Y';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = date('Y-m-d h:i:s');
            $model->attributes = $_POST['FmMasSnag'];
            $valid = $model->validate();
            if ($valid && $model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = [];
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new FmMasSnag();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save(false);
        echo json_encode(array("status" => "success"));
    }

    public function actionGetservice() {
        $term = trim(Yii::app()->request->getParam('term'));
        $store_model = new Store();
        $condition = "(t.part_number LIKE '%$term%' OR t.description LIKE '%$term%' ) AND t.isActive = 'Y' ";
        $store_model = $store_model->findAll(["condition" => $condition, 'order' => 'part_number']);
        $data = [];
        foreach ($store_model as $key => $value) {
            $data[] = [
                "value" => $value->id,
                "label" => $value->description
            ];
        }
        echo json_encode($data);
    }

}
