<?php

class MasbuildingunitController extends Controller {

    public $title = "Master Building Unit";

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'Save', 'GetList', 'Disable', 'deleteunit'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetList() {

        $model = new MasBuildingUnit();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name

            0 => 't.id',
            1 => 'unit_name',
            2 => 'isActive',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (unit_name LIKE '%" . $searchString . "%' OR building.building_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('building')->count(array('condition' => $condition));
        $model = $model->with('building')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {

            $rowData[] = array($m,
                $row['unit_name'],
                $row['building']['building_name'],
                $row['customer']['customer_name'],
                array('id' => $row['id'], 'code' => $row['unit_name'], 'status' => $row->isActive));

            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasBuildingUnit();
        $id = (int) Yii::app()->request->getParam('id');
        $c_id = (int) Yii::app()->request->getParam('c_id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        if ($c_id > 0) {
            $model->customer_id = $c_id;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionSave() {

        $model = new MasBuildingUnit();
        if (isset($_POST['MasBuildingUnit'])) {
            if ((int) @$_POST['MasBuildingUnit']['id'] > 0) {
                $id = (int) @$_POST['MasBuildingUnit']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
                $audit_type = 'UPDATED';
                $model->scenario = 'edit';
                $edit_flag = 1;
            } else {
                $audit_type = 'CREATED';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->scenario = 'add';
            }
            $model->attributes = $_POST['MasBuildingUnit'];
            $model->unit_name = ucfirst(trim($_POST['MasBuildingUnit']['unit_name']));
            $model->customer_id = $_POST['MasBuildingUnit']['customer_id'];
            $model->address = $_POST['MasBuildingUnit']['address'];
            $model->longitude = $_POST['MasBuildingUnit']['longitude'];
            $model->latitude = $_POST['MasBuildingUnit']['latitude'];

            $model->isActive = 'Y';
            $modelCus = new Customer();
            if (!empty($model->customer_id)) {
                $modelCus = Customer::model()->findByPk($model->customer_id);
            } else {
                $currency_id = MasCurrency::base_currency_id();
                $modelCus->customer_currency_id = $currency_id;
                $modelCus->customer_country = 143;
                $term = MasPaymentTerm::model()->find(['condition' => "isBasePaymentTerm='Y' "]);
                if (!empty($term)) {
                    $modelCus->customer_payment_term = $term->id;
                }
                $modelSalesPriceGroupName = new SalesPriceGroupName();
                $arr_default_pricing_group = $modelSalesPriceGroupName->find(array('condition' => 'default_pricing_group="Y"'));
                $default_pricing_group_id = $arr_default_pricing_group->id;
                $modelCus->default_pricing_group_id = $default_pricing_group_id;
                if (!empty($_POST['customer_name'])) {
                    $modelCus->customer_name = $_POST['customer_name'];
                } else {
                    $modelCus->customer_name = $model->unit_name . " - " . $model->building->building_name;
                }
            }

            $valid = $modelCus->validate();
            $valid = $valid && $model->validate();

            if ($valid && $model->save()) {
                if (empty($model->customer_id)) {
                    $modelCus->save();
                    $modelCus->refresh();
                    $model->customer_id = $modelCus->id;
                }
                $model->save();

                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'BUILDING_UNIT_MASTER',
                        Yii::app()->user->id,
                        $audit_type,
                        " with name: - {$model->unit_name}  "
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = json_decode(CActiveForm::validate($modelCus, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDeleteunit() {
        $id = $_POST['id'];
        $modelTicket = new TicketHeader();
        $modelunit = new MasBuildingUnit();
        $modelTicket = $modelTicket->find(array('condition' => 'unit_id="' . $id . '" '));
        if (empty($modelTicket)) {
            $modelunit->deletebypk($id);
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'fail';
        }
        header('Content-Type: application/json; charset=utf-8');
        echo CJSON::encode($jsonData);
    }

    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasBuildingUnit();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

}
