<?php

class JobtimeController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'), //,'temp_form','CompanyFieldDetails'
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Startjob', 'Stopjob', 'TicketJobTimesave',
                    'Ticketstoptimesave', 'jobcompleted', 'savejobcompleted', 'Jobfinished'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     * //modified by jisha on 30-04-21.
     */
    public function actionIndex() {
        $this->render('index');
    }

    public function actionStartjob() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = TicketHeader::model()->findByPk($id);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->renderPartial('startjob', array('model' => $model, 'id' => $id), false, true);
    }

    public function actionStopjob() {
        $id = (int) Yii::app()->request->getParam('id');
        $item_id = (int) Yii::app()->request->getParam('item_id');
        $model = new TicketHeader;
        $modelTechnician = array(new Technician);
        $modelTicketJobTime = array(new TicketJobTime());
        if ($id > 0) {
            $model = $model->findByPk($id);
            $condition = 'ticket_id = "' . $id . '" AND   status = "IN"';
            $modelTicketJobTime = TicketJobTime::model()->findAll(array('condition' => $condition));
            if (empty($modelTicketJobTime)) {
                //$modelTicketJobTime = array(new TicketJobTime);
                $modelTicketJobTime = array();
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->renderPartial('stopjob', array('model' => $model, 'item_id' => $item_id, 'modelTicketJobTime' => $modelTicketJobTime), false, true);
    }

    public function actionTicketJobTimesave() {
        $other = array();
        $model = new TicketHeader;
        $modelTicketJobTime = [];

        if ((int) @$_POST['TicketHeader']['id'] > 0) {
            $id = (int) @$_POST['TicketHeader']['id'];
            $ticket_item_id = (int) $_POST['ticket_item_id'];
            $model = $model->findByPk($id);
            if ($model->ticket_status != 2 || $model->ticket_status = 6) {
                $valid = false;
                $other[] = "You can't start this job";
            }
            $model->ticket_status = 6;
            $valid = $valid && $model->validate();

            $p = 0;
            foreach ($_POST['TicketAllotTechnicians'] as $i => $item) {
                if (!empty($item['selected'])) {
                    $allot = TicketAllotTechnicians::model()->findByPk($item['id']);
                    $mod_history = TicketJobTime::model()->find(array('condition' => 'status = "IN" AND technician_id = ' . (int) $allot->technician_id));
                    if (!empty($mod_history)) {
                        $valid = false;
                        $other[] = 'Technician ' . $mod_history->technician_det->technician_name . ' already on work.';
                    }

                    $modelTicketJobTime[$p] = new TicketJobTime;
                    $modelTicketJobTime[$p]->created_by = Yii::app()->user->id;
                    $modelTicketJobTime[$p]->created_date_time = date("Y-m-d H:i:s");
                    $modelTicketJobTime[$p]->attributes = $item;
                    $modelTicketJobTime[$p]->allot_type_id = $allot->allot_type_id;
                    $modelTicketJobTime[$p]->ticket_id = $id;
                    $modelTicketJobTime[$p]->ticket_item_id = 0;
                    $modelTicketJobTime[$p]->technician_id = $allot->technician_id;
                    $modelTicketJobTime[$p]->job_start_time = date("Y-m-d H:i:s");
                    $modelTicketJobTime[$p]->job_end_time = '0';
                    $valid = $valid && $modelTicketJobTime[$p]->validate();
                    $p++;
                }
            }
        } else {
            $valid = false;
            $other[] = 'Invalid Work Allotment';
        }
        $valid = (count($modelTicketJobTime) > 0);
        if ($valid) {
            $model->ticket_status = 6;
            $model->save();
            foreach ($modelTicketJobTime as $eachModel) {
                $eachModel->ticket_id = $model->id;
                $eachModel->save(false);
                $eachModel->calculateCost();
                $eachModel->save(false);
            }
            $jsonData['status'] = 'success';
            $jsonData['id'] = $model->id;
            echo CJSON::encode($jsonData);
        } else {
            $error2 = array();
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            if (!empty($modelTicketJobTime))
                $error2 = json_decode(CActiveForm::validateTabular($modelTicketJobTime, '', false), true);
            else
                $error2[] = "Please add atleast one line item";
            $error = CJSON::encode(array_merge_recursive($error1, $error2, $other));
            if ($error != '[]')
                echo $error;
        }
    }

    public function actionTicketstoptimesave() {
        $other = array();
        $model = new TicketHeader;
        $modelTicketJobTime = array(new TicketJobTime);
        if ((int) @$_POST['TicketHeader']['id'] > 0) {
            $id = (int) @$_POST['TicketHeader']['id'];
            $ticket_item_id = (int) $_POST['ticket_item_id'];
            $model = $model->findByPk($id);
            $valid = $model->validate();

            $p = 0;
            foreach ($_POST['TicketJobTime'] as $i => $item) {
                $modelTicketJobTime[$p] = new TicketJobTime;
                if ((int) $item['id'] > 0) {
                    $modelTicketJobTime[$p] = TicketJobTime::model()->findByPK((int) $item['id']);
                    $mod_history = TicketJobTime::model()->find(array('condition' => 'technician_id = ' . $item['technician_id']));
                    if (!empty($mod_history)) {
                        $modelTicketJobTime[$p]->status = $item['status'];
                        $modelTicketJobTime[$p]->job_end_time = date("Y-m-d H:i:s");
                        $modelTicketJobTime[$p]->status = "OUT";
                    }
                }

                $modelTicketJobTime[$p]->attributes = $item;
                $modelTicketJobTime[$p]->ticket_id = $id;
                $modelTicketJobTime[$p]->ticket_item_id = 0;
                $modelTicketJobTime[$p]->technician_id = $item['technician_id'];

                $modelTicketJobTime[$p]->created_by = Yii::app()->user->id;
                $modelTicketJobTime[$p]->calculateCost();
                $valid = $valid && $modelTicketJobTime[$p]->validate();
                $p++;
            }
        } else {
            $valid = false;
            $other[] = 'Invalid Work Allotment';
        }

        if ($valid) {

            foreach ($modelTicketJobTime as $eachModel) {
                $eachModel->ticket_id = $model->id;
                $eachModel->calculateCost();
                $eachModel->save(false);
            }
            $jsonData['status'] = 'success';
            $jsonData['id'] = $model->id;
            echo CJSON::encode($jsonData);
        } else {
            $error2 = array();
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            if (!empty($modelTicketJobTime))
                $error2 = json_decode(CActiveForm::validateTabular($modelTicketJobTime, '', false), true);
            else
                $error2[] = "Please add atleast one line item";
            $error = CJSON::encode(array_merge_recursive($error1, $error2, $other));
            if ($error != '[]')
                echo $error;
        }
    }

    public function actionJobcompleted() {
        $id = (int) Yii::app()->request->getParam('id');

        $model = new TicketHeader;

        if ($id > 0) {
            $model = $model->findByPk($id);
        }


        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->renderPartial('job_completed', array('model' => $model), false, true);
    }

    public function actionSavejobcompleted() {
        
     
        $ticket_id = $_POST['TicketHeader']['id'];
        $model = TicketHeader::model()->findByPk($ticket_id);
        $valid = true;
        if ($model->ticket_status == FmTicketStatus::WORK_FINISHED) {
            // work in progress  status is 6
            $model->ticket_status = FmTicketStatus::COMPLETED; //Completed
            $model->rating_remarks = $_POST['TicketHeader']['rating_remarks']; //Completed
            $model->rating = $_POST['TicketHeader']['rating']; //Completed
            $model->work_finished_date = date("Y-m-d"); //Completed
               
               
            $valid = $valid && $model->validate();
            $condition = "ticket_id = " . $model->id;
            $ticketAllotTechnicians = TicketAllotTechnicians::model()->findAll(['condition' => $condition]);

            $condition = "status = 'IN' AND ticket_id = " . $model->id;
            $jobTimes = TicketJobTime::model()->findAll(["condition" => $condition]);
            $condition = "ticket_id = " . $model->id;
            $ticketAllotTechnicians = TicketAllotTechnicians::model()->findAll(['condition' => $condition]);
            foreach ($jobTimes as $key => $job) {
                $jobTimes[$key]->status = "OUT";
                $jobTimes[$key]->job_end_time = date("Y-m-d H:i:s");
                $valid = $valid && $jobTimes[$key]->validate();
            }
            foreach ($ticketAllotTechnicians as $key => $allot) {
                $ticketAllotTechnicians[$key]->status = "C";
                $valid = $valid && $ticketAllotTechnicians[$key]->validate();
            }
            if ($valid) {
                $model->save();
                foreach ($jobTimes as $key => $job) {
                    $job->calculateCost();
                    $job->save();
                }
                foreach ($ticketAllotTechnicians as $key => $allot) {
                    $allot->save();
                }
                echo json_encode([
                    "status" => "success",
                ]);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = [];
                $error3 = [];
                if (!empty($ticketAllotTechnicians)) {
                    $error2 = json_decode(CActiveForm::validateTabular($ticketAllotTechnicians, '', false), true);
                }
                if (!empty($jobTimes)) {
                    $error3 = json_decode(CActiveForm::validateTabular($jobTimes, '', false), true);
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3));
                if ($error != '[]') {
                    echo $error;
                }
            }
        } else {
            echo json_encode(["status" => "You can't completed this job."]);
        }
    }

    public function actionJobfinished() {
        $ticket_id = (int) $_POST['job_id'];
        $model = TicketHeader::model()->findByPk($ticket_id);
        $valid = true;
        $other_error = [];
        if ($model->ticket_status == FmTicketStatus::WORK_IN_PROGRESS) {
            $condition = "status = 'IN' AND ticket_id = " . $model->id;
            $jobTimes = TicketJobTime::model()->findAll(["condition" => $condition]);
            $condition = "ticket_id = " . $model->id;
            $ticketAllotTechnicians = TicketAllotTechnicians::model()->findAll(['condition' => $condition]);
            foreach ($jobTimes as $key => $job) {
                $jobTimes[$key]->status = "OUT";
                $jobTimes[$key]->job_end_time = date("Y-m-d H:i:s");
                $valid = $valid && $jobTimes[$key]->validate();
            }
            foreach ($ticketAllotTechnicians as $key => $allot) {
                $ticketAllotTechnicians[$key]->status = "C";
                $valid = $valid && $ticketAllotTechnicians[$key]->validate();
            }
            /// Job finished only after QC completed;
            $condition_qc = "ticket_id = $ticket_id   AND allot_type_id = " . FmAllotType::TYPE_QC;
            $modelJobTime = new TicketJobTime();
            $modelJobTimes = $modelJobTime->find(["condition" => $condition_qc]);
            if (empty($modelJobTimes)) {
                $valid = false;
                $other_error[] = "Quality check is not completed yet.";
            }
            /// QC check ends
            if ($valid) {
                TicketHeader::model()->updateByPk($ticket_id, ["ticket_status" => FmTicketStatus::WORK_FINISHED,"job_finished_date" => date("Y-m-d")]);
                foreach ($jobTimes as $key => $job) {
                    $job->calculateCost();
                    $job->save();
                }
                foreach ($ticketAllotTechnicians as $key => $allot) {
                    $allot->save();
                }
                echo json_encode([
                    "status" => "success",
                ]);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = [];
                $error3 = [];
                if (!empty($ticketAllotTechnicians)) {
                    $error2 = json_decode(CActiveForm::validateTabular($ticketAllotTechnicians, '', false), true);
                }
                if (!empty($jobTimes)) {
                    $error3 = json_decode(CActiveForm::validateTabular($jobTimes, '', false), true);
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $other_error));
                if ($error != '[]') {
                    echo $error;
                }
            }
        } else {
            echo json_encode(["status" => "You can't completed this job."]);
        }
    }

}
