<?php

class FmreportsController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
            'actions' => array('PrintJobOrderReport', 'PrintJoborderReportPDF',
                    'PrintWorkProgressReport', 'PrintBookReport', 'GetLocationDetails', 'PrintBookingReportPDF',
                    'PrintWorkprogressReportPDF', 'PrintJobReportPDF', 'PrintBookingExcel', 'PrintexcelworkprogressList',
                    'PrintexceljoborderList', 'PrintJobOrderIssueReport', 'PrintPropertyReport', 'PrintPropertyReportPDF', 'PrintPropertyExcel', 'PrintInvestorReport',
                    'PrintInvestorReportPDF', 'PrintInvestorExcel', 'PrintJobOrderIssueReportPDF','PrintexceljoborderIssueList','PrintMachineryReport','PrintMachineryReportPDF','PrintMachineryExcel',
                    'PrintMachineryScheduleReport','PrintMachineryScheduleReportPDF','PrintMachineryScheduleExcel','PrintLeaveBalancelist','PrintLeaveBalancelist','PrinLeaveBalancePDF',
                    'PrintAdvancelist','PrintAdvanceReportPDF','PrintCompanyDocument','PrintCompanyDocumentReportPDF','PrintMonthlyAttendance',
                    'PrintTrainingList','PrintTrainingListPDF','GetPrintMonthlyAttendanceReportList','FilterJobOrderReport','JobRreportHtml','JobReportExcel'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionPrintJobOrderReport() {

        $ticket_start_date = $_POST['ticket_start_date'];
        $ticket_end_date = $_POST['ticket_end_date'];
        $property_id = $_POST['property_id'];
        $status = $_POST['status'];
        //$status= $_POST['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('print_joborder', array('ticket_start_date' => $ticket_start_date, 'ticket_end_date' => $ticket_end_date,
            'property_id' => $property_id, 'status' => $status), false, true);
       
    }
     public function actionPrintJobReportPDF() {
        $ticket_start_date = Yii::app()->request->getParam('ticket_start_date');
        $ticket_end_date = Yii::app()->request->getParam('ticket_end_date');
        $property_id = Yii::app()->request->getParam('property_id');
        $status = (int)Yii::app()->request->getParam('status');
        $param = array('ticket_start_date' => $ticket_start_date,
            'ticket_end_date' => $ticket_end_date,
            'property_id' => $property_id,
            'status' => $status);
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.modules.fm.views.fmreports.pdf.print_joborder_pdf', $param, true));
        $mpdf->Output("Joborder.pdf", 'I');
    }
     public function actionPrintexceljoborderList() {

        $ticket_start_date = Yii::app()->request->getParam('ticket_start_date');
        $ticket_end_date = Yii::app()->request->getParam('ticket_end_date');
        $property_id = Yii::app()->request->getParam('property_id');
        $status = (int)Yii::app()->request->getParam('status');
        $filename = 'job_order_report' . date('dmYhis') . '.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderpartial('application.modules.fm.views.fmreports.excel.print_job_order_excel', array('ticket_start_date' => $ticket_start_date,
            'ticket_end_date' => $ticket_end_date,
            'property_id' => $property_id,
            'status' => $status), false, true);
        Yii::app()->end();


        return;
    }
    public function actionPrintJoborderReportPDF() {

        $model=new TicketHeader();
        $id = Yii::app()->request->getParam('id');
       
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.fm.views.fmreports.joborder_list_individual', array('model' => $model, 'id' => $id),true));
        $mPDF1->Output("Leadreport.pdf", 'I');
    }
    public function actionPrintWorkProgressReport() {

        $work_start_date = $_POST['work_start_date'];
        $work_end_date = $_POST['work_end_date'];
        $technician_id = $_POST['technician_id'];
        $issue_id = $_POST['issue_id'];
        //$status= $_POST['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('print_workprogress', array('work_start_date' => $work_start_date, 'work_end_date' => $work_end_date,
            'technician_id' => $technician_id, 'issue_id' => $issue_id), false, true);
       
    }
     public function actionPrintWorkprogressReportPDF() {
        $work_start_date = Yii::app()->request->getParam('work_start_date');
        $work_end_date = Yii::app()->request->getParam('work_end_date');
        $technician_id = Yii::app()->request->getParam('technician_id');
        $issue_id = Yii::app()->request->getParam('issue_id');
        $param = array('work_start_date' => $work_start_date,
            'work_end_date' => $work_end_date,
            'technician_id' => $technician_id,
            'issue_id' => $issue_id);
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.modules.fm.views.fmreports.pdf.print_work_progress_pdf', $param, true));
        $mpdf->Output("Work_In_ProgressReport.pdf", 'I');
    }
     public function actionPrintexcelworkprogressList() {

        $work_start_date = Yii::app()->request->getParam('work_start_date');
        $work_end_date = Yii::app()->request->getParam('work_end_date');
        $technician_id = Yii::app()->request->getParam('technician_id');
        $issue_id = Yii::app()->request->getParam('issue_id');
        $filename = 'work_progress_report' . date('dmYhis') . '.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderpartial('application.modules.fm.views.fmreports.excel.print_work_progress_excel', array('work_start_date' => $work_start_date,
            'work_end_date' => $work_end_date,
            'technician_id' => $technician_id,
            'issue_id' => $issue_id), false, true);
        Yii::app()->end();


        return;
    }

    
    
    public function actionGetLocationDetails() {

        $from = $_GET['frm'];

        $searchTerm = $_GET['term'];

        $model = new Properties();

        $condition = 'location LIKE "%' . $searchTerm . '%" AND t.is_active="Y"';

        $model = $model->findAll(array('condition' => $condition));

        $i = 0;

        $data = array();

        foreach ($model as $eachModel) {

            $data[$i]['value'] = $eachModel->id;
            
            
            $data[$i]['label'] = $eachModel->location;

            $i++;

        }

        echo CJSON::encode($data);

        Yii::app()->end();

    }
    
     public function actionPrintJobOrderIssueReport() {

        $job_start_date = $_POST['job_start_date'];
        $job_end_date = $_POST['job_end_date'];
        $job_property_id = $_POST['job_property_id'];
        $job_job_issue_id = $_POST['job_job_issue_id'];
        $status = $_POST['status'];
        //$status= $_POST['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('print_joborder_issue_details', array('job_start_date' => $job_start_date, 'job_end_date' => $job_end_date,
            'job_property_id' => $job_property_id,'job_job_issue_id' => $job_job_issue_id, 'status' => $status), false, true);
       
    }
    public function actionPrintJobOrderIssueReportPDF() {
        $job_start_date = Yii::app()->request->getParam('job_start_date');
        $job_end_date = Yii::app()->request->getParam('job_end_date');
        $job_property_id = Yii::app()->request->getParam('job_property_id');
        $job_job_issue_id = Yii::app()->request->getParam('job_job_issue_id');
        $status = Yii::app()->request->getParam('status');
         $param = array('job_start_date' => $job_start_date,
            'job_end_date' => $job_end_date,
            'job_property_id' => $job_property_id,
            'job_job_issue_id' => $job_job_issue_id,
            'status' => $status);
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.modules.fm.views.fmreports.pdf.print_joborder_issue_pdf', $param, true));
        $mpdf->Output("JobOrderIssueReport.pdf", 'I');
    }
     public function actionPrintexceljoborderIssueList() {

        $job_start_date = Yii::app()->request->getParam('job_start_date');
        $job_end_date = Yii::app()->request->getParam('job_end_date');
        $job_property_id = Yii::app()->request->getParam('job_property_id');
        $job_job_issue_id = Yii::app()->request->getParam('job_job_issue_id');
        $status = Yii::app()->request->getParam('status');
        $filename = 'joborder_issue_report' . date('dmYhis') . '.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderpartial('application.modules.fm.views.fmreports.excel.print_joborder_issue_excel', array('job_start_date' => $job_start_date,
            'job_end_date' => $job_end_date,
            'job_property_id' => $job_property_id,
            'job_job_issue_id' => $job_job_issue_id,
            'status' => $status), false, true);
        Yii::app()->end();


        return;
    }
     
    
     public function actionPrintMachineryReport() {

        $machine_name = $_POST['machine_name'];
        $machine_id = $_POST['machine_id'];
        $make = $_POST['make'];
        $model_no = $_POST['model_no'];
        $serial_no = $_POST['serial_no'];
        $location = $_POST['location'];
        $period_type = $_POST['period_type'];
        $maintenance_start_date = $_POST['maintenance_start_date'];
        $maintenance_end_date = $_POST['maintenance_end_date'];
        $item_type = $_POST['item_type'];
        $main_item_id = $_POST['main_item_id'];
        $year = $_POST['year'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('print_machinery_report', array('machine_name' => $machine_name, 'machine_id' => $machine_id,'make' => $make, 'model_no' => $model_no,
            'serial_no' => $serial_no,'location' => $location,'period_type' => $period_type,'maintenance_start_date' => $maintenance_start_date, 'maintenance_end_date' => $maintenance_end_date,
            'item_type' => $item_type,'main_item_id' => $main_item_id,'year' => $year), false, true);
       
    }
    public function actionPrintMachineryReportPDF() {
        $machine_name = Yii::app()->request->getParam('machine_name');
        $machine_id = Yii::app()->request->getParam('machine_id');
        $make = Yii::app()->request->getParam('make');
        $model_no = Yii::app()->request->getParam('model_no');
        $serial_no = Yii::app()->request->getParam('serial_no');
        $location = Yii::app()->request->getParam('location');
        $period_type = Yii::app()->request->getParam('period_type');
        $maintenance_start_date = Yii::app()->request->getParam('maintenance_start_date');
        $maintenance_end_date = Yii::app()->request->getParam('maintenance_end_date');
        $item_type = Yii::app()->request->getParam('item_type');
        $main_item_id = Yii::app()->request->getParam('main_item_id');
        $year = Yii::app()->request->getParam('year');
         $param = array('machine_name' => $machine_name, 'machine_id' => $machine_id,'make' => $make, 'model_no' => $model_no,
            'serial_no' => $serial_no,'location' => $location,'period_type' => $period_type,'maintenance_start_date' => $maintenance_start_date, 'maintenance_end_date' => $maintenance_end_date,
            'item_type' => $item_type,'main_item_id' => $main_item_id,'year' => $year);
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.modules.fm.views.fmreports.pdf.print_machinery_pdf', $param, true));
        $mpdf->Output("MachineryReport.pdf", 'I');
    }
     public function actionPrintMachineryExcel() {

       $machine_name = Yii::app()->request->getParam('machine_name');
        $machine_id = Yii::app()->request->getParam('machine_id');
        $make = Yii::app()->request->getParam('make');
        $model_no = Yii::app()->request->getParam('model_no');
        $serial_no = Yii::app()->request->getParam('serial_no');
        $location = Yii::app()->request->getParam('location');
        $period_type = Yii::app()->request->getParam('period_type');
        $maintenance_start_date = Yii::app()->request->getParam('maintenance_start_date');
        $maintenance_end_date = Yii::app()->request->getParam('maintenance_end_date');
        $item_type = Yii::app()->request->getParam('item_type');
        $main_item_id = Yii::app()->request->getParam('main_item_id');
        $year = Yii::app()->request->getParam('year');
        $filename = 'Machinery_report' . date('dmYhis') . '.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderpartial('application.modules.fm.views.fmreports.excel.print_machinery_excel', array('machine_name' => $machine_name, 'machine_id' => $machine_id,'make' => $make, 'model_no' => $model_no,
            'serial_no' => $serial_no,'location' => $location,'period_type' => $period_type,'maintenance_start_date' => $maintenance_start_date, 'maintenance_end_date' => $maintenance_end_date,
            'item_type' => $item_type,'main_item_id' => $main_item_id,'year' => $year), false, true);
        Yii::app()->end();


        return;
    }
     public function actionPrintMachineryScheduleReport() {
        $machinery_id = $_POST['machinery_id'];
        $planned_start_date = $_POST['planned_start_date'];
        $planned_end_date = $_POST['planned_end_date'];
        $period_type_id = $_POST['period_type_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_machinery_schedule_report', array('machinery_id' => $machinery_id, 'planned_start_date' => $planned_start_date, 'planned_end_date' => $planned_end_date, 'period_type_id' => $period_type_id), false, true);
    }
    public function actionPrintMachineryScheduleReportPDF() {
      $machinery_id = Yii::app()->request->getParam('machinery_id');
        $planned_start_date = Yii::app()->request->getParam('planned_start_date');
        $planned_end_date = Yii::app()->request->getParam('planned_end_date');
        $period_type_id = Yii::app()->request->getParam('period_type_id');
       
         $param = array('machinery_id' => $machinery_id, 'planned_start_date' => $planned_start_date, 'planned_end_date' => $planned_end_date, 'period_type_id' => $period_type_id);
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.modules.fm.views.fmreports.pdf.print_machinery_schedule_pdf', $param, true));
        $mpdf->Output("EquipmentScheduleReport.pdf", 'I');
    }
     public function actionPrintMachineryScheduleExcel() {

        $machinery_id = Yii::app()->request->getParam('machinery_id');
        $planned_start_date = Yii::app()->request->getParam('planned_start_date');
        $planned_end_date = Yii::app()->request->getParam('planned_end_date');
        $period_type_id = Yii::app()->request->getParam('period_type_id');        $filename = 'Equipment_Schedule_report' . date('dmYhis') . '.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderpartial('application.modules.fm.views.fmreports.excel.print_machinery_schedule_excel', array('machinery_id' => $machinery_id, 'planned_start_date' => $planned_start_date, 'planned_end_date' => $planned_end_date, 'period_type_id' => $period_type_id), false, true);
        Yii::app()->end();


        return;
    }
    
    
     public function actionFilterJobOrderReport()
    {
       $this->render('filter_job_order_report');
    }
    
    
     public function actionJobRreportHtml()
    {
       
        $from_date             = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date               = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
      
        $this->renderPartial('job_order_report_html', array(
            'from_date'   => $from_date,
            'to_date'     => $to_date,
        ));
    }
    
    public function actionJobReportExcel()
    {

        $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
        $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');

        $param = array(
            'from_date'    => $from_date,
            'to_date'      => $to_date,
        
        );

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'JOB_ORDER_Excel.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('application.modules.fm.views.fmreports.excel.job_order_Excel', $param, false, true);
        Yii::app()->end();
    }
   
}
