<?php

class DashboardController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetGraph','Jobordergraphdetails','GetissueDetail','GetTechnicianDetail','GetStatusDetail','Issuetypedetails','Techniciandetails','Statusdetails',
                'Statusmonthdetails','Technicianmonthdetails','Issuemonthdetails','getOpenTickets','getTotalTickets','getTotalIssues','getOpenIssues'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    // Uncomment the following methods and override them if needed

    public function filters() 
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $this->render('index');
    }
    public function actionGetGraph() 
    {

        $page = Yii::app()->request->getparam("page");
        
        if($page=='count_details')
        {
            $fromdate = Yii::app()->request->getparam("total_count_from_date");
            $todate = Yii::app()->request->getparam("total_count_to_date");
            
            $arr_pars = array('fromdate' => $fromdate, 'todate' => $todate);
        }
        else
        {
            $fromdate = Yii::app()->request->getparam("fromdate");
            $todate = Yii::app()->request->getparam("todate");
            $arr_pars = array('fromdate' => $fromdate, 'todate' => $todate);
        }
        $this->render($page, $arr_pars);
    }
    /*     * *********************   End - Quote Owner *********************************************************** */
   
   public function actionJobordergraphdetails() {
        $type = (int) Yii::app()->request->getParam('type');
        $fromdate = Yii::app()->request->getParam('from_date');
        $todate = Yii::app()->request->getParam('end_date');
        $currentYear = date("Y");
        $fromdate = str_replace('/', '-', $fromdate);
        $from_date = date("Y-m-d", strtotime($fromdate));
        $todate = str_replace('/', '-', $todate);
        $end_date = date("Y-m-d", strtotime($todate));
        $month = date("m", strtotime($fromdate));
        $month_1 = date("m", strtotime($todate));
        $year = date("Y", strtotime($todate));
        $leadextra_cndt = '';
        /*if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $leadextra_cndt = ' AND lead.lead_owner_id=' . Yii::app()->user->id;
        }*/
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false);
        if ($type == 1) {
            $SQL= "SELECT COUNT(D.id) AS y_value,I.issue_type AS x_value 
                FROM `erp_fm_ticket_details` D
                LEFT JOIN erp_fm_ticket_header H ON H.id = D.ticket_id
                LEFT JOIN erp_fm_master_issue_type I ON I.id = D.issue_id
                WHERE ((H.ticket_date BETWEEN '".$from_date."' AND '".$end_date."') ) 
                GROUP BY I.issue_type";
    
            $graph_data_issue = Yii::app()->db->createCommand($SQL)->queryAll();
            if (!empty($graph_data_issue)) {
                $plot = '[';
                foreach ($graph_data_issue as $m => $eachdata) {
                    $color = substr(md5(rand()), 0, 6);
                    $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
                }
                $plot .= ']';
            } else {
                $plot = '';
            }
            $this->render('issue_view', array('plot' => $plot, 'from_date' => $from_date, 'end_date' => $end_date));
        } 
        
       else if ($type == 2) {
                
                $SQL= "SELECT T.id AS z_value,COUNT(A.id) AS y_value,T.technician_name AS x_value FROM erp_fm_ticket_allot_technicians A 
                LEFT JOIN erp_fm_ticket_header H ON H.id = A.ticket_id 
                LEFT JOIN erp_fm_technician T ON T.id = A.technician_id 
                WHERE ((H.ticket_date BETWEEN '".$from_date."' AND '".$end_date."') ) 
                GROUP BY A.technician_id";
    
    $graph_data_tech = Yii::app()->db->createCommand($SQL)->queryAll();
            if (!empty($graph_data_tech)) {

                $plot = '[';
                foreach ($graph_data_tech as $m => $eachdata) {
                    $color = substr(md5(rand()), 0, 6);
                    $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
                }
                $plot .= ']';
            } else {
                $plot = '';
            }
            $this->render('technician_view', array('plot' => $plot, 'from_date' => $from_date, 'end_date' => $end_date));
        } 
        else if ($type == 3) {
            $SQL= "SELECT COUNT(H.id) AS y_value,H.ticket_status AS x_value 
                FROM erp_fm_ticket_header H
                LEFT JOIN erp_fm_ticket_details D ON  D.ticket_id = H.id
                WHERE ((H.ticket_date BETWEEN '".$from_date."' AND '".$end_date."') ) 
                GROUP BY H.ticket_status";
            
            $graph_data_status = Yii::app()->db->createCommand($SQL)->queryAll();
            if (!empty($graph_data_status)) {
                $plot = '[';
                foreach ($graph_data_status as $m => $eachdata) {
                    if($eachdata['x_value'] =='1')
                     {
                        $eachdata['x_value'] = "Open";
                     }
                     else if($eachdata['x_value'] =='2')
                     {
                        $eachdata['x_value'] = "Alloted";
                     }
                     else if($eachdata['x_value'] =='3')
                     {
                        $eachdata['x_value'] = "Completed";
                     }
                     else if($eachdata['x_value'] =='4')
                     {
                        $eachdata['x_value'] = "CLosed";
                     }
                    $color = substr(md5(rand()), 0, 6);
                    $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
                }
                $plot .= ']';
            } else {
                $plot = '';
            }
            $this->render('status_view', array('plot' => $plot, 'from_date' => $from_date, 'end_date' => $end_date));
        } 
        
    }
    
    
    public function actionGetissueDetail() {
        $issue_graph_details = array();
        
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $leadextra_cndt = '';
        /*if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $leadextra_cndt = ' AND lead.lead_owner_id=' . Yii::app()->user->id;
        }*/
        
        $SQL= "SELECT COUNT(D.id) AS y_value,I.issue_type AS x_value 
                FROM `erp_fm_ticket_details` D
                LEFT JOIN erp_fm_ticket_header H ON H.id = D.ticket_id
                LEFT JOIN erp_fm_master_issue_type I ON I.id = D.issue_id
                WHERE ((H.ticket_date BETWEEN '".$from_date."' AND '".$end_date."') ) 
                GROUP BY I.issue_type";
        
        $data_issue = Yii::app()->db->createCommand($SQL)->queryAll();
        $s = 1;    
        $plot = '[';
        foreach ($data_issue as $m => $eachdata) {
            $color = substr(md5(rand()), 0, 6);
            $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            $issue_graph_details[$m]['slno'] = $m + 1;
            $issue_graph_details[$m]['issue_type'] = $eachdata['x_value'];
            $issue_graph_details[$m]['issue_count'] = $eachdata['y_value'];
            
            $issue_graph_details[$m]['issue_color'] = "#" . $color;
        }
        $plot .= ']';

        foreach ($data_issue as $key => $value) {
            $rowData[] = array($s, $value['x_value'], $value['y_value']);
            $s++;
        } 
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }
    
    public function actionGetTechnicianDetail() {
        $tech_graph_details = array();
        
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $leadextra_cndt = '';
        /*if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $leadextra_cndt = ' AND lead.lead_owner_id=' . Yii::app()->user->id;
        }*/
        
        $SQL= "SELECT T.id AS z_value,COUNT(A.id) AS y_value,T.technician_name AS x_value FROM erp_fm_ticket_allot_technicians A 
                LEFT JOIN erp_fm_ticket_header H ON H.id = A.ticket_id 
                LEFT JOIN erp_fm_technician T ON T.id = A.technician_id 
                WHERE ((H.ticket_date BETWEEN '".$from_date."' AND '".$end_date."') ) 
                GROUP BY A.technician_id";
        
        $data_tech = Yii::app()->db->createCommand($SQL)->queryAll();
        $s = 1;    
        $plot = '[';
        foreach ($data_tech as $m => $eachdata) {
            $color = substr(md5(rand()), 0, 6);
            $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            $tech_graph_details[$m]['slno'] = $m + 1;
            $tech_graph_details[$m]['tech_name'] = $eachdata['x_value'];
            $tech_graph_details[$m]['tech_count'] = $eachdata['y_value'];
            $tech_graph_details[$m]['issue_color'] = "#" . $color;
        }
        $plot .= ']';

        foreach ($data_tech as $key => $value) {
            $rowData[] = array($s, $value['x_value'], $value['y_value'],$value['z_value']);
            $s++;
        } 
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }
   
   
    public function actionGetStatusDetail() {
        $tech_graph_details = array();
        
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        $leadextra_cndt = '';
        /*if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $leadextra_cndt = ' AND lead.lead_owner_id=' . Yii::app()->user->id;
        }*/
        
        $SQL= "SELECT COUNT(H.id) AS y_value,H.ticket_status AS x_value 
                FROM erp_fm_ticket_header H
                LEFT JOIN erp_fm_ticket_details D ON  D.ticket_id = H.id
                WHERE ((H.ticket_date BETWEEN '".$from_date."' AND '".$end_date."') ) 
                GROUP BY H.ticket_status";
        
        $data_status = Yii::app()->db->createCommand($SQL)->queryAll();
        
        $s = 1;    
        $plot = '[';
        foreach ($data_status as $m => $eachdata) {
            if($eachdata['x_value'] =='1')
             {
                $eachdata['x_value'] = "Open";
             }
             else if($eachdata['x_value'] =='2')
             {
                $eachdata['x_value'] = "Alloted";
             }
             else if($eachdata['x_value'] =='3')
             {
                $eachdata['x_value'] = "Completed";
             }
             else if($eachdata['x_value'] =='4')
             {
                $eachdata['x_value'] = "CLosed";
             }
            $color = substr(md5(rand()), 0, 6);
            $plot .= '{label:"' . $eachdata['x_value'] . '", value:"' . $eachdata['y_value'] . '", color: "#' . $color . '"},';
            $tech_graph_details[$m]['slno'] = $m + 1;
            $tech_graph_details[$m]['status_name'] = $eachdata['x_value'];
            $tech_graph_details[$m]['status_count'] = $eachdata['y_value'];
            $tech_graph_details[$m]['issue_color'] = "#" . $color;
        }
        $plot .= ']';

        foreach ($data_status as $key => $value) {
            if($value['x_value'] =='1')
             {
                $status = "Open";
             }
             else if($value['x_value'] =='2')
             {
                $status = "Alloted";
             }
             else if($value['x_value'] =='3')
             {
                $status = "Completed";
             }
             else if($value['x_value'] =='4')
             {
                $status = "Closed";
             }
            $rowData[] = array($s, $status, $value['y_value'],$value['x_value']);
            $s++;
        } 
        $data['data'] = $rowData;
        $data['plot'] = $plot;
        echo json_encode($data);
    }
    
    public function actionIssuetypedetails() {

        $issue_id = $_POST['issue_id'];
        //$currentYear  = date("Y");
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        
        /*$leadextra_cndt = '';
        if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $leadextra_cndt = ' AND lead.lead_owner_id=' . Yii::app()->user->id;
        }*/
        $SQL= "SELECT YEAR(H.ticket_date) as y, MONTH(H.ticket_date) as m, COUNT(D.id) as TOTAL_COUNT
                FROM `erp_fm_ticket_details` D
                LEFT JOIN erp_fm_ticket_header H ON H.id = D.ticket_id
                WHERE ((H.ticket_date BETWEEN '".$from_date."' AND '".$end_date."')  AND D.issue_id = '".$issue_id."')
                GROUP BY D.issue_id,YEAR(H.ticket_date),MONTH(H.ticket_date)";
        
        $data_issue = Yii::app()->db->createCommand($SQL)->queryAll();

        $this->render('issue_details', array('data_issue' => $data_issue,  'action' => 'view_issue_detail','month' => $month, 'year' => $year,'issue_id' => $issue_id));
    }
    
    public function actionTechniciandetails() {

        $user_id = $_POST['user_id'];
        
        //$currentYear  = date("Y");
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
        
        
        /*if (Yii::app()->user->authorised_user != 1 && User::isSalesman() == 'Y') {
            $leadextra_cndt = ' AND lead.lead_owner_id=' . Yii::app()->user->id;
        }*/
        
        
        $SQL= "SELECT YEAR(H.ticket_date) as y, MONTH(H.ticket_date) as m, COUNT(D.id) as TOTAL_COUNT
                FROM `erp_fm_ticket_details` D
                LEFT JOIN erp_fm_ticket_header H ON H.id = D.ticket_id
                LEFT JOIN erp_fm_ticket_allot_technicians A ON A.ticket_id = D.ticket_id AND A.ticket_item_id = D.id
                LEFT JOIN erp_fm_technician T ON T.id = A.technician_id
                WHERE (H.ticket_date BETWEEN '".$from_date."' AND '".$end_date."' AND T.id = '".$user_id."')
                GROUP BY T.id,YEAR(H.ticket_date),MONTH(H.ticket_date)";
        
        
        $data_tech = Yii::app()->db->createCommand($SQL)->queryAll();
        $this->render('technician_details', array('data_tech' => $data_tech,'action' => 'view_tech_detail','month' => $month, 'year' => $year, 'user_id' => $user_id));
    }
    
    public function actionStatusdetails() {

        $status_id = $_POST['status_id'];
        
        //$currentYear  = date("Y");
        $from_date = Yii::app()->request->getParam('fromdate');
        $end_date = Yii::app()->request->getParam('todate');
                
        $SQL= "SELECT YEAR(H.ticket_date) as y, MONTH(H.ticket_date) as m, COUNT(D.id) as TOTAL_COUNT
                FROM erp_fm_ticket_header H
                LEFT JOIN erp_fm_ticket_details D ON  D.ticket_id = H.id
                WHERE (H.ticket_date BETWEEN '".$from_date."' AND '".$end_date."' AND H.ticket_status = '".$status_id."')
                GROUP BY H.ticket_status,YEAR(H.ticket_date),MONTH(H.ticket_date)";
                
        
        $data_status = Yii::app()->db->createCommand($SQL)->queryAll();
        $this->render('status_details', array('data_status' => $data_status, 'action' => 'view_status_detail', 'month' => $month, 'year' => $year,'status_id' => $status_id));
    }
   
   public function actionStatusmonthdetails() {

        $status_id = $_POST['status_id'];
        
        
        $month = $_POST['month'];
        $year = $_POST['year'];
        $currentYear = date("Y");
                
        $SQL= "SELECT *
                FROM erp_fm_ticket_header H
                LEFT JOIN erp_fm_ticket_details D ON  D.ticket_id = H.id
                WHERE (YEAR(H.ticket_date) = '" . $year . "' AND MONTH(H.ticket_date) = ' " . $month . " ' AND H.ticket_status = '".$status_id."')";
        
        //print_r($SQL); exit;
        $data_status_month = Yii::app()->db->createCommand($SQL)->queryAll();
        $this->render('status_details', array('data_status_month' => $data_status_month, 'action' => 'view_status_month_detail', 'month' => $month, 'year' => $year,'status_id' => $status_id));
    }
    
    public function actionTechnicianmonthdetails() {

        $user_id = $_POST['user_id'];
        
        
        $month = $_POST['month'];
        $year = $_POST['year'];
        $currentYear = date("Y");
                
        $SQL= "SELECT *
                FROM `erp_fm_ticket_details` D
                LEFT JOIN erp_fm_ticket_header H ON H.id = D.ticket_id
                LEFT JOIN erp_fm_ticket_allot_technicians A ON A.ticket_id = D.ticket_id AND A.ticket_item_id = D.id
                LEFT JOIN erp_fm_technician T ON T.id = A.technician_id
                WHERE (YEAR(H.ticket_date) = '" . $year . "' AND MONTH(H.ticket_date) = ' " . $month . " ' AND T.id = '".$user_id."')";
        
        
        $data_tech_month = Yii::app()->db->createCommand($SQL)->queryAll();
        $this->render('technician_details', array('data_tech_month' => $data_tech_month, 'action' => 'view_tech_month_detail', 'month' => $month, 'year' => $year,'user_id' => $user_id));
    }
    
    public function actionIssuemonthdetails() {

        $issue_id = $_POST['issue_id'];
        
        
        $month = $_POST['month'];
        $year = $_POST['year'];
        $currentYear = date("Y");
                
        $SQL= "SELECT *
            FROM `erp_fm_ticket_details` D
            LEFT JOIN erp_fm_ticket_header H ON H.id = D.ticket_id
            WHERE (YEAR(H.ticket_date) = '" . $year . "' AND MONTH(H.ticket_date) = ' " . $month . " ' AND D.issue_id = '".$issue_id."')";
        $data_issue_month = Yii::app()->db->createCommand($SQL)->queryAll();
        $this->render('issue_details', array('data_issue_month' => $data_issue_month, 'action' => 'view_issue_month_detail', 'month' => $month, 'year' => $year,'issue_id' => $issue_id));
    }
    
    public function actiongetTotalTickets() {
        $fromdate = Yii::app()->request->getParam('fdate');
        $todate = Yii::app()->request->getParam('tdate');
        
        $this->render('open_tickets', array('fromdate' => $fromdate, 'todate' => $todate));
    }
    
    public function actiongetOpenTickets() {
        $fromdate = Yii::app()->request->getParam('fdate');
        $todate = Yii::app()->request->getParam('tdate');
        
        $this->render('open_tickets_open', array('fromdate' => $fromdate, 'todate' => $todate));
    }
    
    public function actiongetTotalIssues() {
        $fromdate = Yii::app()->request->getParam('fdate');
        $todate = Yii::app()->request->getParam('tdate');
        
        $this->render('total_issues', array('fromdate' => $fromdate, 'todate' => $todate));
    }
    
    public function actiongetOpenIssues() {
        $fromdate = Yii::app()->request->getParam('fdate');
        $todate = Yii::app()->request->getParam('tdate');
        
        $this->render('open_issues', array('fromdate' => $fromdate, 'todate' => $todate));
    }
}