<?php

class CalendarController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetEvents', 'GetEventsAll'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetEventsAll() {
        $jasonevents = array(
            array(
                'title' => 'Event 1',
                'start' => '2021-11-01',
                'school' => '1',
                'type' => 'Calls'
            ),
            array(
                'title' => 'Event 1',
                'start' => '2021-02-02',
                'school' => '1',
                'type' => 'Calls'
            ),
            array(
                'title' => 'Event 1',
                'start' => '2021-11-03',
                'school' => '1',
                'type' => 'Calls'
            ),
            array(
                'title' => 'Event 1',
                'start' => '2021-10-04',
                'school' => '1',
                'type' => 'Calls'
            ),
            array(
                'title' => 'Event 1',
                'start' => '2021-02-05',
                'school' => '1',
                'type' => 'Notes'
            ),
        );
        echo CJSON::encode($jasonevents);
        Yii::app()->end();
    }

    public function actionGetEvents() {

        $start = Yii::app()->request->getParam('start');
        $end = Yii::app()->request->getParam('end');
        $condition = "date(ticket_date) >=  '$start' AND date(ticket_date) <= '$end' ";
        $condition .= " AND ticket_status != 5";
        $models = TicketHeader::model()->findAll(["condition" => $condition]);
        $data = [];
        foreach ($models as $value) {
            $issue_type = $value->issue_details->issue_type;
            $title = $issue_type . " " . $value->building_details->building_name . " - " . $value->unit_details->unit_name . " (" . $value->status_details->status_name . ")";
            $data[] = [
                "type" => "JO",
                "backgroundColor" => $value->status_details->color_code,
                "textColor" => "black",
                'title' => $title,
                'start' => date("Y-m-d", strtotime($value->ticket_date)),
                'description' => $value->description,
                'id' => $value->id
            ];
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

}
