<?php

class ApiticketController extends Controller {

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'create'
                ),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        $valid_user = false;
        if (isset($_SERVER['HTTP_TOKEN'])) {
            $this->ChangeDB();
            $token = trim($_SERVER['HTTP_TOKEN']);
            $appAuthentication = new AppAuthentication($token);
            $valid_user = $appAuthentication->login();
        }
        if ($valid_user) {
            return parent::beforeAction($action);
        } else {
            $json_data = [
                "status" => "error",
                "messsage" => "Access denied."
            ];
            echo json_encode($json_data);
        }
    }

    public function actionCreate() {
        $token = trim($_SERVER['HTTP_TOKEN']);
        $user = new User();
        $user = $user->findBytoken($token);
        $customer = new Customer();
        $customer = $customer->findBytoken($token);

        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);

        $ticketModel = new TicketHeader();
        $ticketModel->attributes = $variables;
        $ticketModel->property_id = $variables['property_id'];
        $ticketModel->unit_id = $variables['unit_id'];
        $ticketModel->ticket_status = FmTicketStatus::OPEN;
        $ticketModel->raised_from = TicketHeader::RAISED_FROM_APP;
        $ticketModel->ticket_date = date("Y-m-d H:i:s");
        $ticketModel->issue_type_id = $variables['issue_type_id'];
        $ticketModel->priority_id = $variables['priority_id'];
        $ticketModel->description = trim($variables['description']);
        $ticketModel->created_by = 1;
        $ticketModel->raised_by = 1;
        $ticketModel->created_date_time = date("Y-m-d H:i:s");
        $valid = $ticketModel->validate();
        if ($valid) {
            $ticketModel->save();
            echo json_encode([
                "status" => "success",
                "ticket_id" => $ticketModel->id,
            ]);
        } else {
            $errorlog = $ticketModel->getErrors();

            echo json_encode([
                "status" => "error",
                "ticket_id" => 0,
                "error_message" => $errorlog
            ]);
        }
    }

}
