<?php

class ApitechnicianController extends Controller {

    function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('review','TicketRequestMaterials'),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        $valid_user = false;
        if (isset($_SERVER['HTTP_TOKEN'])) {
            $this->ChangeDB();
            $token = trim($_SERVER['HTTP_TOKEN']);
            $appAuthentication = new AppAuthentication($token);
            $valid_user = $appAuthentication->login();
        }
        if ($valid_user) {
            return parent::beforeAction($action);
        } else {
            $json_data = [
                "status" => "error",
                "messsage" => "Access denied."
            ];
            echo json_encode($json_data);
        }
    }

    public function actionReview() {
        $token = trim($_SERVER['HTTP_TOKEN']);
        $user_model = new User();
        $user_model = $user_model->findBytoken($token);
        $technician_id = 0;
        if (!empty($user_model) && !empty($user_model->technician_id)) {
            $technician_id = $user_model->technician_id;
        }
        $condition = "allotted_rel.technician_id = " . $technician_id . " AND t.ticket_status = " . FmTicketStatus::COMPLETED;
        $model = new TicketHeader();
        $models = $model->with("allotted_rel")->findAll(["order" => "t.id desc", "condition" => $condition]);
        $data_rating = [];
        foreach ($models as $row) {
            $data_rating[] = [
                "id" => $row->id,
                "rating" => $row->rating,
                "ticket_date" => date("d/m/Y", strtotime($row->ticket_date)),
                "rating_remarks" => trim($row->rating_remarks),
                "description" => trim($row->description),
                "issuse_type" => $row->issue_details->issue_type,
                "issue_type_id" => $row->issue_type_id,
                "building_id" => $row->property_id,
                "building_name" => $row->building_details->building_name,
                "unit_id" => $row->unit_id,
                "unit_name" => $row->unit_details->unit_name,
                "customer_name" => ucwords($row->unit_details->customer->customer_name),
                "customer_id" => $row->unit_details->customer_id,
                "priority_id" => $row->priority_id,
            ];
        }

        echo json_encode([
            "status" => "success",
            "data" => $data_rating]);
    }
    public function actionTicketRequestMaterials(){
        $token = trim($_SERVER['HTTP_TOKEN']);
        $user_model = new User();
        $user_model = $user_model->findBytoken($token);
        if (!empty($user_model) && !empty($user_model->technician_id)) {
            $technician_id = $user_model->technician_id;
            $condition = "allotted_rel.technician_id = '" . $technician_id . "' AND t.ticket_status  NOT IN ('" . FmTicketStatus::COMPLETED . "','" . FmTicketStatus::WORK_FINISHED . "')";
            $model = new TicketHeader();
            $models = $model->with("allotted_rel")->findAll(["order" => "t.id desc", "condition" => $condition]);
            $data = [];
            foreach ($models as $row) {
                $modelTicketRequestMaterials = new TicketRequestMaterials();
                $materials = $modelTicketRequestMaterials->findAll(['condition' => 'ticket_id="' . $row->id . '"']);
                foreach ($materials as $material) {
                    $data[] = [
                        "description" => $material->description,
                        "quantity" => $material->quantity,
                        "ticket_id" => $material->ticket_id,
                    ];
                }
            }
            echo json_encode([
                "status" => "success",
                "data" => $data
            ]);
        }
    }






}
