<?php

class ApisnagController extends Controller {

    function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('area', 'mastersnag', 'save', 'Print', 'Snaglistimageupload',
                    'Snagimageupdatelist', 'Snagimageupdate', 'PrintSangCompletionPdf',
                    'DeleteSnaglistimageupload'),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        $this->ChangeDB();
        return parent::beforeAction($action);
        $valid_user = false;
        if (isset($_SERVER['HTTP_TOKEN'])) {
            $this->ChangeDB();
            $token = trim($_SERVER['HTTP_TOKEN']);
            $appAuthentication = new AppAuthentication($token);
            $valid_user = $appAuthentication->login();
        }
        if ($valid_user) {
            return parent::beforeAction($action);
        } else {
            $json_data = [
                "status" => "error",
                "messsage" => "Access denied."
            ];
            echo json_encode($json_data);
        }
    }

    public function actionArea() {
        $area_model = new FmMasArea();
        $condition = "t.isActive='Y' ";
        $area_models = $area_model->findAll(["condition" => $condition, "order" => "sort_order"]);
        $data = [];
        foreach ($area_models as $row) {
            $data[] = [
                "id" => $row->id,
                "name" => $row->name
            ];
        }
        $json_array = [
            "status" => "success",
            "data" => $data
        ];
        echo json_encode($json_array);
    }

    public function actionMasterSnag() {
        header('Content-type: application/json');
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);
        $job_id = $variables["job_id"];
        $snag_header = new FmSnag();
        $snag_header = $snag_header->find(["condition" => "job_id = " . $job_id]);
        $header_id = 0;
        $header = [
            "id" => "",
            "observation" => "",
            "signature" => "",
            "technician_id" => "",
            "charges" => "0",
            "type_array" => []
        ];
        $type_array_list = "0";
        if (!empty($snag_header)) {
            $header_id = (int) $snag_header->id;
            $type_array_list = $snag_header->type_list;
            $header = [
                "id" => $header_id,
                "observation" => $snag_header->observation,
                "signature" => $snag_header->signature,
                "technician_id" => $snag_header->technician_id,
                "charges" => $snag_header->charges,
            ];
        }
        $types_array = [];
        $type_array_id = explode(",", $type_array_list);
        $condition_type = " 1=1 ";
        $model_issuses = new MasterIssueType();
        $model_issuses = $model_issuses->findAll(["condition" => $condition_type]);
        foreach ($model_issuses as $value) {
            $types_array[] = [
                "id" => $value->id,
                "issue_type" => $value->issue_type,
                "selected" => in_array($value->id, $type_array_id)
            ];
        }

        $header['type_array'] = $types_array;
        /// UI heading hiding.
        $header['hide'] = false;
        $area_model = new FmMasArea();
        $condition = "t.isActive='Y' ";
        $area_models = $area_model->findAll(["condition" => $condition, "order" => "sort_order"]);
        $data = [];
        foreach ($area_models as $row) {
            $snag_model = new FmMasSnag();
            $condition = "t.isActive = 'Y' AND t.area_id = " . $row->id;
            $snag_models = $snag_model->findAll(["condition" => $condition]);
            $area_details = [];

            foreach ($snag_models as $key => $value) {
                $id = "0";
                $qty = "0";
                $repair = "0";
                $replace = "0";
                $chargeable = "N";
                $remark = "";
                $condition_snag_item = "t.header_id = " . $header_id . " AND  t.snag_id = " . $value->id;
                $snag_item_model = new FmSnagItems();
                $snag_item_model = $snag_item_model->find(["condition" => $condition_snag_item]);
                if (!empty($snag_item_model)) {
                    $id = $snag_item_model->id;
                    $qty = (int) $snag_item_model->qty;
                    $replace = (int) $snag_item_model->replace_qty;
                    $repair = (int) $snag_item_model->repair_qty;
                    $chargeable = $snag_item_model->chargeable;
                    $remark = $snag_item_model->remark;
                }
                $area_details[] = [
                    "id" => $id,
                    "snag_id" => $value->id,
                    "type" => $value->name,
                    "repair_qty" => (string) $repair,
                    "replace_qty" => (string) $replace,
                    "qty" => (string) $qty,
                    "chargeable" => $chargeable,
                    "remark" => $remark,
                ];
            }
            $data[] = [
                "id" => $row->id,
                "area" => $row->name,
                // for app UI manipulation.
                "hide" => true,
                "details" => $area_details
            ];
        }
        $json_array = [
            "status" => "success",
            "data" => $data,
            "header" => $header
        ];
        echo json_encode($json_array);
    }

    public function actionSave() {
        $input = file_get_contents('php://input');
        $other_errors = [];
        $valid = true;
        $variables = json_decode($input, true);
        $token = trim($_SERVER['HTTP_TOKEN']);
        $user_model = new User();
        $user_model = $user_model->findBytoken($token);
        $job_id = (int) $variables["job_id"];
        $technician_id = (int) $user_model->technician_id;
        $snag_header = new FmSnag();
        $snag_header = $snag_header->find(["condition" => "job_id = " . $job_id]);
        $header_id = 0;
        if (!empty($snag_header)) {
            $header_id = (int) $snag_header->id;
        }

        $snag_model = new FmSnag();
        if (empty($header_id)) {
            $snag_model->snag_date = date("Y-m-d");
            $snag_model->time_out = date("Y-m-d H:i:s");
            $snag_model->time_in = date("Y-m-d H:i:s");
            $snag_model->created_by = $user_model->id;
            $snag_model->created_date_time = date("Y-m-d H:i:s");
        } else {
            $snag_model = $snag_model->findByPk($header_id);
        }
        $snag_model->attributes = $variables;
        if (isset($variables['type_array']) && is_array($variables['type_array'])) {
            $type_array = [];
            foreach ($variables['type_array'] as $type_value) {
                if ($type_value['selected']) {
                    $type_array[] = $type_value["id"];
                }
            }
            $snag_model->type_list = implode(",", $type_array);
        }
        $valid = $valid && $snag_model->validate();

        $snag_item_model = [];
        $key = 0;
        foreach ($variables["items"] as $i => $area_items) {

            foreach ($area_items["details"] as $items) {
                $snag_item_model[$key] = new FmSnagItems();
                $id = $items["id"];
                if (!empty($id)) {
                    $snag_item_model[$key] = $snag_item_model[$key]->findByPk($id);
                }
                $snag_item_model[$key]->attributes = $items;
                $snag_item_model[$key]->remark = trim($items['remark']);
                $snag_item_model[$key]->header_id = 0;
                $snag_item_model[$key]->unit_id = $snag_model->unit_id;

                $snag_item_model[$key]->building_id = $snag_model->building_id;
                $valid = $valid && $snag_item_model[$key]->validate();
                $key++;
            }
        }
        /// check if inspection started. only allow if inspection is started.
        $condition_inspt = "status ='IN' AND t.technician_id = $technician_id AND ticket_id = $job_id   AND allot_type_id = " . FmAllotType::TYPE_INSPECTION;
        $modelJobTime = new TicketJobTime();
        $modelJobTimes = $modelJobTime->find(["condition" => $condition_inspt]);
        if (empty($modelJobTimes)) {
            $valid = false;
            $other_errors[] = "No active Inspection. Please start inspection.";
        }
        /// -ends
        header('Content-type: application/json');
        if ($valid) {
            $snag_model->save();
            foreach ($snag_item_model as $value) {
                $value->header_id = $snag_model->id;
                $value->save();
            }
            $job_order = new TicketHeader();
            $job_order->updateByPK($job_id, [
                'snag_id' => $snag_model->id
            ]);
            echo json_encode([
                "status" => "success",
                "snag_id" => $snag_model->id,
            ]);
        } else {
            $message = implode(". ", $other_errors);
            $error1 = json_decode(CActiveForm::validate($snag_model, '', false), true);
            $error2 = json_decode(CActiveForm::validateTabular($snag_item_model, '', false), true);
            $error = CJSON::encode(["status" => "error",
                        'cond' => $condition_inspt,
                        "message" => "Unable to save snag list." . $message,
                        "error_message" => array_merge_recursive($error1, $error2, $other_errors)
            ]);
            echo $error;
        }
    }

    public function actionPrint_old() {
        $id = Yii::app()->request->getparam('id');
        $job_id = (int) Yii::app()->request->getparam('job_id');
        if ($job_id > 0) {
            $model = new FmSnag();
            $condition = "t.job_id = " . $job_id;
            $model = $model->find(["condition" => $condition]);
            if (!empty($model)) {
                $id = $model->id;
            }
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.fm.views.snag.print', array('id' => $id), true));
        $mPDF1->Output("Snag.pdf", 'I');
    }

    public function actionPrint() {
        try {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);
            if ((int) $userModel->id > 0) {
                $id = (int) Yii::app()->request->getparam('id');
                $input = file_get_contents('php://input');
                $variables = json_decode($input, true);
                $job_id = (int) $variables['job_id'];
                if ($job_id > 0) {
                    $model = new FmSnag();
                    $condition = "t.job_id = " . $job_id;
                    $model = $model->find(["condition" => $condition]);
                    if (!empty($model)) {
                        $id = $model->id;
                    }
                }
                $pdf_name = "snag_" . $job_id . '.pdf';
                $file_path = 'uploads/apppdf/' . $pdf_name;
                $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
                $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
                $mPDF1->WriteHTML($stylesheet, 1);
                $mPDF1->WriteHTML($this->renderPartial('application.modules.fm.views.snag.print', array('id' => $id), true));
                $mPDF1->Output($file_path, 'F');
                header('Content-Type: application/json');
                $data = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name);
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $data = array('status' => "failed", "msg" => "Unauthorized user");
            }
        } catch (Exception $e) {
            header("HTTP/1.1 500 Internal Server Error");
            header('Content-Type: application/json');
            $data = ['status' => "error", "message" => "Unexpected Server error"];
        }
        echo json_encode($data);
    }

//   ---------------added by indhu-----------------------------------------
    public function actionSnaglistimageupload() {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ((int) $userModel->id > 0) {
            /*  $today        = date("Y-m-d");
              $filename     = $today . "_" . rand(0, getrandmax()) . "_" . basename($_FILES["file"]["name"]); */

            $today = date("Y-m-d");
            $originalFileName = $_FILES["file"]["name"];
            $originalFileName = str_replace(array(' ', ','), '_', $originalFileName); // Replace spaces and commas with underscores
            $fileExtension = pathinfo($originalFileName, PATHINFO_EXTENSION); // Get the file extension
            // Generate a unique identifier (You can use a variety of methods)
            $uniqueIdentifier = uniqid();
            // Concatenate the timestamp, unique identifier, and original file extension
            $filename = $today . "_" . $uniqueIdentifier . "." . $fileExtension;

            $destination = "uploads/snaglist_before_after/" . $filename;
            if (move_uploaded_file($_FILES["file"]["tmp_name"], $destination)) {
                $data = ["status" => "success", "filename" => $filename];
            } else {
                $data = ["status" => "error", "message" => "Upload Failed"];
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "error", "message" => "Unauthorized user");
        }
        echo json_encode($data);
    }

//   ---------------added by indhu-----------------------------------------
    public function actionSnagimageupdatelist() {
        $token = trim($_SERVER['HTTP_TOKEN']);
        $user_model = new User();
        $user_model = $user_model->findBytoken($token);
        $technician_id = $user_model->technician_id;

        header('Content-type: application/json');
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);
        $job_id = $variables["job_id"];
        $snag_header = new FmSnag();
        $snag_header = $snag_header->find(["condition" => "job_id = " . $job_id]);
        $header_id = 0;
        $header = [
            "id" => "",
            "observation" => "",
            "signature" => "",
            "technician_id" => "",
            "charges" => "0",
            "type_array" => []
        ];
        $type_array_list = "0";
        if (!empty($snag_header)) {
            $header_id = (int) $snag_header->id;
            $type_array_list = $snag_header->type_list;
            $header = [
                "id" => $header_id,
                "observation" => $snag_header->observation,
                "signature" => $snag_header->signature,
                "technician_id" => $snag_header->technician_id,
                "charges" => $snag_header->charges,
            ];
        }
        $types_array = [];
        $type_array_id = explode(",", $type_array_list);
        $condition_type = " 1=1 ";
        $model_issuses = new MasterIssueType();
        $model_issuses = $model_issuses->findAll(["condition" => $condition_type]);
        foreach ($model_issuses as $value) {
            $types_array[] = [
                "id" => $value->id,
                "issue_type" => $value->issue_type,
                "selected" => in_array($value->id, $type_array_id)
            ];
        }

        $header['type_array'] = $types_array;
        /// UI heading hiding.
        $header['hide'] = false;
        $area_model = new FmMasArea();
        $condition = "t.isActive='Y' ";
        $area_models = $area_model->findAll(["condition" => $condition, "order" => "sort_order"]);
        $data = [];
        foreach ($area_models as $row) {
            $snag_model = new FmMasSnag();
            $condition = "t.isActive = 'Y' AND t.area_id = " . $row->id;
            $snag_models = $snag_model->findAll(["condition" => $condition]);
            $area_details = [];

            foreach ($snag_models as $key => $value) {

                $array_before_img = $array_after_img = [];
                $images_before = Yii::app()->db->createCommand('SELECT img FROM {{fm_snag_before_after_images}} WHERE ticket_id = "' . $job_id . '"  AND snag_id = "' . $value->id . '"  AND type = "B"')->queryAll();
                $images_after = Yii::app()->db->createCommand('SELECT img FROM {{fm_snag_before_after_images}} WHERE ticket_id = "' . $job_id . '"  AND snag_id = "' . $value->id . '"  AND type = "A"')->queryAll();

                if (!empty($images_before)) {
                    foreach ($images_before as $before) {
                        $image_before = "uploads/snaglist_before_after/" . $before['img'];
                        $extension_be = pathinfo($before['img'], PATHINFO_EXTENSION);
                        $array_before_img[] = [
                            "img" => $image_before,
                            "image_extension" => $extension_be,
                        ];
                    }
                }

                if (!empty($images_after)) {
                    foreach ($images_after as $after) {
                        $image_after = "uploads/snaglist_before_after/" . $after['img'];
                        $extension_af = pathinfo($after['img'], PATHINFO_EXTENSION);
                        $array_after_img[] = [
                            "img" => $image_after,
                            "image_extension" => $extension_af,
                        ];
                    }
                }


                $id = "0";
                $qty = "0";
                $repair = "0";
                $replace = "0";
                $chargeable = "N";
                $remark = "";
                $condition_snag_item = "t.header_id = " . $header_id . " AND  t.snag_id = " . $value->id . "  AND  t.qty > 0";
                $snag_item_model = new FmSnagItems();
                $snag_item_model = $snag_item_model->find(["condition" => $condition_snag_item]);
                if (!empty($snag_item_model)) {
                    $id = $snag_item_model->id;
                    $qty = $snag_item_model->qty;
                    $replace = $snag_item_model->replace_qty;
                    $repair = $snag_item_model->repair_qty;
                    $chargeable = $snag_item_model->chargeable;
                    $remark = $snag_item_model->remark;

                    $area_details[] = [
                        "id" => $id,
                        "snag_id" => $value->id,
                        "type" => $value->name,
                        "qty" => $qty,
                        "remark" => $remark,
                        "before_img" => $array_before_img,
                        'after_img' => $array_after_img,
                    ];
                }
            }
            if (!empty($area_details)) {

                $data[] = [
                    "id" => $row->id,
                    "area" => $row->name,
                    "hide" => false,
                    "details" => $area_details,
                ];
            }
        }
        ///
        $block_before_image = "Y";
        $block_after_image = "Y";
        $message_array = [];
        $condition_inspt = "status ='IN' AND t.technician_id = $technician_id AND ticket_id = $job_id   AND allot_type_id = " . FmAllotType::TYPE_INSPECTION;
        $modelJobTime = new TicketJobTime();
        $modelJobTimes = $modelJobTime->find(["condition" => $condition_inspt]);
        if (empty($modelJobTimes)) {
            $block_before_image = "Y";
            $message_array[] = "No active inspection.";
        } else {
            $block_before_image = "N";
        }
        $condition_qc = "status ='IN' AND t.technician_id = $technician_id AND ticket_id = $job_id   AND allot_type_id = " . FmAllotType::TYPE_QC;
        $modelJobTime = new TicketJobTime();
        $modelJobTimes = $modelJobTime->find(["condition" => $condition_qc]);
        if (empty($modelJobTimes)) {
            $block_after_image = "Y";
            $message_array[] = "No active QC.";
        } else {
            $block_after_image = "N";
        }

        $json_array = [
            "status" => "success",
            "block_before_image" => $block_before_image,
            "block_after_image" => $block_after_image,
            "msg" => implode(" ", $message_array),
            "data" => $data,
        ];
        echo json_encode($json_array);
    }

//   ---------------added by indhu-----------------------------------------
    public function actionSnagimageupdate() {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $other = array();
        $valid = true;
        if ((int) $userModel->id > 0) {
            $input = file_get_contents('php://input');
            $variables = json_decode($input, true);
            $ticket_id = $variables['ticket_id'];
            $snag_id = $variables['snag_id'];
            $array_after_img_list = $variables['after_img_list'];

            $array_before_img_list = $variables['before_img_list'];

            if ($ticket_id <= 0) {
                $other[] = 'Ticket ID is Null';
                $valid = false;
            }


            if ($snag_id <= 0) {
                $other[] = 'Sang ID is Null';
                $valid = false;
            }

            if (empty($array_after_img_list || $array_before_img_list)) {
                $other[] = 'Please Upload At Least One Image';
                $valid = false;
            }
            if ($valid) {


                $p = $i = 0;
                if (is_array($array_before_img_list)) {
                    if (!empty($array_before_img_list)) {
                        foreach ($array_before_img_list as $before) {
                            $modeluploadbefore[$p] = new FmSnagBeforeAfterImages;
                            $modeluploadbefore[$p]->created_by = (int) $userModel->id;
                            $modeluploadbefore[$p]->created_date_time = date('Y-m-d H:i:s');
                            $modeluploadbefore[$p]->ticket_id = $ticket_id;
                            $modeluploadbefore[$p]->snag_id = $snag_id;
                            $modeluploadbefore[$p]->img = $before['img'];
                            $modeluploadbefore[$p]->added_frm = 'A';
                            $modeluploadbefore[$p]->type = 'B';
                            $valid = $modeluploadbefore[$p]->validate();
                            $p++;
                        }
                    }
                }

                if (is_array($array_after_img_list)) {

                    if (!empty($array_after_img_list)) {
                        foreach ($array_after_img_list as $after) {
                            $modeluploadafter[$i] = new FmSnagBeforeAfterImages;
                            $modeluploadafter[$i]->created_by = (int) $userModel->id;
                            $modeluploadafter[$i]->created_date_time = date('Y-m-d H:i:s');
                            $modeluploadafter[$i]->ticket_id = $ticket_id;
                            $modeluploadafter[$i]->snag_id = $snag_id;
                            $modeluploadafter[$i]->img = $after['img'];
                            $modeluploadafter[$i]->added_frm = 'A';
                            $modeluploadafter[$i]->type = 'A';
                            $valid = $modeluploadafter[$i]->validate();
                            $i++;
                        }
                    }
                }

                if ($valid) {
                    if (!empty($modeluploadbefore)) {
                        foreach ($modeluploadbefore as $eachItem) {
                            $eachItem->save(false);
                        }
                    }

                    if (!empty($modeluploadafter)) {
                        foreach ($modeluploadafter as $eachItemafter) {
                            $eachItemafter->save(false);
                        }
                    }
                    $data['status'] = 'success';
                    $data['ticket_id'] = $ticket_id;
                    $data['snag_id'] = $snag_id;
                } else {
                    $data['status'] = 'error';
                    $error1 = $error2 = $error3 = array();
                    $error2 = json_decode(CActiveForm::validate($modeluploadafter, '', false), true);
                    $error3 = json_decode(CActiveForm::validate($modeluploadbefore, '', false), true);
                    $error = array_merge_recursive($error1, $error2, $error3, $other);
                    foreach ($error as $a => $eacherror) {
                        $other[] = $eacherror[0];
                    }
                    if ($error != '[]')
                        $data['msg'] = implode(',', $other);
                }
            } else {
                $err_msg = implode(',', $other);
                $data = ['status' => "error", "message" => $err_msg];
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "error", "message" => "Unauthorized user");
        }
        echo json_encode($data);
    }

//   ---------------added by indhu-----------------------------------------

    public function actionDeleteSnaglistimageupload() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        $other = array();
        $valid = true;
        if ((int) $userModel->id > 0) {
            $input = file_get_contents('php://input');
            $variables = json_decode($input, true);
            $ticket_id = $variables['ticket_id'];
            $snag_id = $variables['snag_id'];
            $img_name = $variables['img_name'];
            if ($ticket_id <= 0) {
                $other[] = 'Ticket ID is Null';
                $valid = false;
            }


            if ($snag_id <= 0) {
                $other[] = 'Sang ID is Null';
                $valid = false;
            }


            if (empty($img_name)) {
                $other[] = 'Image is Null';
                $valid = false;
            }

            if ($valid) {
                $modelDocument = new FmSnagBeforeAfterImages();
                $model_doc = $modelDocument->find([
                    'condition' => 'snag_id = ' . $snag_id . ' AND ticket_id = ' . $ticket_id . ' AND img = "' . $img_name . '"'
                ]);
                $document_details = explode(',', $model_doc->img);
                foreach ($document_details as $value) {
                    $path = Yii::getPathOfAlias('webroot') . "/uploads/snaglist_before_after/" . $value;
                    unlink($path);
                }
                $modelDocument->deleteByPk($model_doc->id);
                $data['status'] = 'success';
                $data['ticket_id'] = $ticket_id;
                $data['snag_id'] = $snag_id;
            } else {
                $err_msg = implode(',', $other);
                $data = ['status' => "error", "message" => $err_msg];
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "error", "message" => "Unauthorized user");
        }
        echo json_encode($data);
    }

    //   ---------------added by indhu-----------------------------------------
    public function actionPrintSangCompletionPdf() {

        try {
            $valid = true;
            $other = array();
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);

            if ($userModel->id > 0) {

                $input = file_get_contents('php://input');
                $variables = json_decode($input, true);

                $ticket_id = $variables['ticket_id'];


                if ((int) $ticket_id == 0) {
                    $valid = false;
                    $other[] = "Ticket ID Canont Be Null";
                }
                if ($valid) {
                    $param = array(
                        'ticket_id' => $ticket_id,
                        'coming_frm' => 'APP',
                    );
                    $pdf_name = "CompletionReport_" . '.pdf';
                    $file_path = 'uploads/apppdf/' . $pdf_name;
                    $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
                    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
                    $mPDF1->WriteHTML($stylesheet, 1);

                    $mPDF1->WriteHTML($this->renderPartial('application.modules.fm.views.snag.print_job_completion', $param, true));
                    $mPDF1->Output($file_path, 'F');

                    header('Content-Type: application/json');
                    $data = array('status' => "success", "pdflink" => $file_path, "file_name" => $pdf_name);
                } else {
                    $err_msg = implode(',', $other);
                    $data = ['status' => "error", "message" => $err_msg];
                }
            } else {

                header("HTTP/1.1 401 Unauthorized");

                header('Content-Type: application/json');

                $data = array('status' => "failed", "msg" => "Unauthorized user");
            }
        } catch (Exception $e) {
            header("HTTP/1.1 500 Internal Server Error");
            header('Content-Type: application/json');
            $data = ['status' => "error", "message" => "Unexpected Server error"];
        }
        echo json_encode($data);
    }

}
