<?php

/**
 * @author Manu
 */
class ApijobController extends Controller {

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('getlist', 'view', 'startjob', 'stopjob',
                    'completejob', 'jobfinished', 'uploadsign'),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        $valid_user = false;
        if (isset($_SERVER['HTTP_TOKEN'])) {
            $this->ChangeDB();
            $token = trim($_SERVER['HTTP_TOKEN']);
            $appAuthentication = new AppAuthentication($token);
            $valid_user = $appAuthentication->login();
        }
        if ($valid_user) {
            return parent::beforeAction($action);
        } else {
            $json_data = [
                "status" => "error",
                "messsage" => "Access denied."
            ];
            echo json_encode($json_data);
        }
    }

    public function actionGetlist() {
        $input = file_get_contents('php://input');
        //error_log($input);
        $variables = json_decode($input, true);
        $token = trim($_SERVER['HTTP_TOKEN']);
        $user = new User();
        $user = $user->findBytoken($token);
        ///

        $model = new TicketHeader();
        $json_array = ["status" => "success"];
        $data_row = [];
        $condition = " 1=1 ";

        //filtering start here
        // from date
        $form_date = date("Y-m-01");
        if (isset($variables['from_date']) && !empty($variables['from_date'])) {
            $form_date = $variables['from_date'];
        }
        $condition .= " AND date(t.ticket_date) >= '$form_date' ";

        // to date
        $to_date = date("Y-m-t");
        if (isset($variables['to_date']) && !empty($variables['to_date'])) {
            $to_date = $variables['to_date'];
        }
        $condition .= " AND date(t.ticket_date) <= '$to_date' ";
        /// status
        if (isset($variables['ticket_status']) && !empty($variables['ticket_status'])) {
            $ticket_status = $variables['ticket_status'];
            $condition .= " AND t.ticket_status IN ($ticket_status) ";
        } else {

        }
        ///filter by user assigned work
        if (!empty($user->technician_id)) {
            $condition .= " AND allotted_rel.technician_id = " . $user->technician_id;
        }

        //filtering ends here
        $models = $model->with('allotted_rel')->findAll(array('condition' => $condition, 'order' => "t.id desc"));
        foreach ($models as $row) {
            $issue_type = $row['issue_details']['issue_type'];
            $allocation_technician = [];

            $condition_technician = "ticket_id = " . $row->id;
            $technicianModelArray = TicketAllotTechnicians::model()->findAll(["condition" => $condition_technician]);
            foreach ($technicianModelArray as $eachTechnician) {
                $allocation_technician[] = [
                    "allocation_id" => $eachTechnician->id,
                    "technician_name" => $eachTechnician->technician_details->technician_name,
                    "technician_id" => $eachTechnician->technician_id,
                ];
            }
            $data_row[] = [
                "id" => $row->id,
                "ticket_date" => date("d/m/Y h:i:s", strtotime($row->ticket_date)),
                "description" => trim($row->description),
                "issuse_type" => $row->issue_details->issue_type,
                "issue_type_id" => $row->issue_type_id,
                "building_id" => $row->property_id,
                "building_name" => $row->building_details->building_name,
                "unit_id" => $row->unit_id,
                "unit_name" => $row->unit_details->unit_name,
                "customer_name" => ucwords($row->unit_details->customer->customer_name),
                "customer_id" => $row->unit_details->customer_id,
                "priority_id" => $row->priority_id,
                "priority_name" => $row->priority_details->name,
                "ticket_status_id" => $row->ticket_status,
                "ticket_status" => $row->status_details->status_name,
                "technician" => $allocation_technician
            ];
        }
        $json_array['data'] = $data_row;
        $json_array['cond'] = $condition;
        header('Content-Type: application/json');
        echo json_encode($json_array);
    }

    public function actionView() {

        $input = file_get_contents('php://input');
        //error_log($input);
        $variables = json_decode($input, true);
        $token = trim($_SERVER['HTTP_TOKEN']);

        $user = new User();
        $user = $user->findBytoken($token);
        ///

        $model = new TicketHeader();
        $ticket_id = (int) $variables['ticket_id'];

        $model = $model->findByPk($ticket_id);

        $json_data = ["status" => "success"];

        /// Allocation
        $allocation_technician = [];
        $technicianModelArray = $model->allotted_rel;
        foreach ($technicianModelArray as $eachTechnician) {
            $allocation_technician[] = [
                "allocation_id" => $eachTechnician->id,
                "technician_name" => $eachTechnician->technician_details->technician_name,
                "technician_id" => $eachTechnician->technician_id,
            ];
        }
        /// Requested Material
        $request_material_array = [];
        $condition_request_material = "ticket_id = '$model->id' ";
        $ticketrequestmaterialModels = TicketRequestMaterials::model()->findAll(["condition" => $condition_request_material, "order" => "t.id"]);
        foreach ($ticketrequestmaterialModels as $request_material) {
            $request_material_array[] = [
                "id" => $request_material->id,
                "description" => $request_material->description,
                "quantity" => $request_material->quantity,
                "unit_name" => $request_material->unit_det->unit_name
            ];
        }
        // used material
        $condition_used = "ticket_id = '" . (int) $model->id . "'";
        $used_material_array = [];
        $issueHeader = InventoryGoodsIssue::model()->findAll(['condition' => $condition_used]);
        if (!empty($issueHeader)) {
            foreach ($issueHeader as $key => $value) {
                $modelIssueDetails = $value->items;
                foreach ($modelIssueDetails as $i => $modelIssueDetail) {
                    $used_material_array[] = [
                        "id" => $modelIssueDetail->id,
                        "part_number" => $modelIssueDetail->product->part_number,
                        "description" => $modelIssueDetail->description,
                        "qty" => $modelIssueDetail->picked_qty,
                        "unit_name" => $modelIssueDetail->uom->uom->unit_name,
                        "rate" => $modelIssueDetail->rate,
                        "amount" => $modelIssueDetail->picked_qty * $modelIssueDetail->rate
                    ];
                }
            }
        }
///
        $time_array = [];
        $condition_time = 'ticket_id= "' . $model->id . '" ';
        $modelTicketJobTime = TicketJobTime::model()->findAll(array('condition' => $condition_time));
        $button_status = 'STOPPED';
        foreach ($modelTicketJobTime as $i => $modelJobTime) {
            if ($modelJobTime->status == "IN") {
                $button_status = 'STARTED';
            }
            $time_array[] = [
                "technician_name" => $modelJobTime->technician_det->technician_name,
                "start_time" => date('d/m/Y h:i a', strtotime($modelJobTime->job_start_time)),
                "status" => $modelJobTime->status,
                "end_time" => ($modelJobTime->status == "OUT") ? date('d/m/Y h:i a', strtotime($modelJobTime->job_end_time)) : "",
                "working_hours" => ($modelJobTime->status == "OUT") ? $modelJobTime->working_hours : "",
                "rate" => $modelJobTime->rate,
                "total" => $modelJobTime->total_cost,
            ];
        }
        if (!in_array($model->ticket_status, [FmTicketStatus::WORK_IN_PROGRESS, FmTicketStatus::ALLOTED])) {
            $button_status = "DISABLED";
        }
        $job_data = [
            "id" => $model->id,
            "ticket_date" => date("d/m/Y h:i:s", strtotime($model->ticket_date)),
            "description" => trim($model->description),
            "issuse_type" => $model->issue_details->issue_type,
            "issue_type_id" => $model->issue_type_id,
            "building_id" => $model->property_id,
            "building_name" => $model->building_details->building_name,
            "unit_id" => $model->unit_id,
            "unit_name" => $model->unit_details->unit_name,
            "priority_id" => $model->priority_id,
            "priority_name" => $model->priority_details->name,
            "ticket_status_id" => $model->ticket_status,
            "ticket_status" => $model->status_details->status_name,
            "rating_remarks" => $model->rating_remarks,
            "rating" => $model->rating,
            "allocation_technicians" => $allocation_technician,
            "request_material" => $request_material_array,
            "used_material" => $used_material_array,
            "time_usage" => $time_array,
            "customer_name" => ucwords($model->unit_details->customer->customer_name),
            "button_status" => $button_status
        ];
        header('Content-Type: application/json');
        $json_data["job"] = $job_data;
        echo json_encode($json_data);
    }

    public function actionStartjob() {
        $input = file_get_contents('php://input');
        //error_log($input);
        $variables = json_decode($input, true);
        $token = trim($_SERVER['HTTP_TOKEN']);
        $user = new User();
        $user = $user->findBytoken($token);
        ///
        $ticket_id = (int) $variables['ticket_id'];
        $technician_id = (int) $user->technician_id;
        $condition = "ticket_id = $ticket_id AND technician_id = $technician_id AND status ='IN' ";
        $model = new TicketJobTime();
        $model = $model->find(["condition" => $condition]);
        $valid = true;
        $other_error = [];
        if (!empty($model)) {
            $valid = false;
            $other_error[] = "Job already started";
        } else {
            // checking if technician is working in other job
            $condition = "technician_id = $technician_id AND status ='IN' ";
            $model = new TicketJobTime();
            $model = $model->find(["condition" => $condition]);
            if (!empty($model)) {
                $valid = false;
                $other_error[] = "Technician already working in another job. Please close to start this job.";
            }
        }
        $condition_allot = "ticket_id = $ticket_id AND technician_id = $technician_id";
        $allot_model = new TicketAllotTechnicians();
        $allot_model = $allot_model->find(["condition" => $condition_allot]);
        if (empty($allot_model)) {
            $valid = false;
            $other_error[] = "You are not allotted tothis job";
        }
        $ticket_model = new TicketHeader();
        $ticket_model = $ticket_model->findByPk($ticket_id);
        if ($ticket_model == null) {
            $valid = false;
            $other_error[] = "Job ticket not found";
        } else if ($ticket_model->ticket_status == FmTicketStatus::CANCELLED || $ticket_model->ticket_status == FmTicketStatus::CLOSED || $ticket_model->ticket_status == FmTicketStatus::COMPLETED) {
            $valid = false;
            $other_error[] = "Job ticket is not active";
        }
        if ($valid) {
            $modelTicketJobTime = new TicketJobTime;
            $modelTicketJobTime->created_by = Yii::app()->user->id;
            $modelTicketJobTime->created_date_time = date("Y-m-d H:i:s");
            $modelTicketJobTime->ticket_id = $ticket_id;
            $modelTicketJobTime->ticket_item_id = 0;
            $modelTicketJobTime->technician_id = $technician_id;
            $modelTicketJobTime->job_start_time = date("Y-m-d H:i:s");
            $modelTicketJobTime->job_end_time = '0';
            $modelTicketJobTime->status = 'IN';
            $valid = $valid && $modelTicketJobTime->validate();
            if ($valid && $modelTicketJobTime->save()) {
                $ticket_model->updateByPk($ticket_id, ["ticket_status" => FmTicketStatus::WORK_IN_PROGRESS]);
                $message = "Job started.";
                $json_array = ["status" => "success",
                    "ticket_id" => $ticket_id,
                    "id" => $modelTicketJobTime->id,
                    "message" => $message
                ];
                echo json_encode($json_array);
            } else {
                $message = trim(implode(". ", $modelTicketJobTime->getErrors()));
                $json_array = ["status" => "error",
                    "message" => $message
                ];
                echo json_encode($json_array);
            }
        } else {
            $message = trim(implode(". ", $other_error));
            $json_array = ["status" => "error",
                "message" => $message
            ];
            echo json_encode($json_array);
        }
    }

    public function actionStopjob() {
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);
        $token = trim($_SERVER['HTTP_TOKEN']);
        $user = new User();
        $user = $user->findBytoken($token);
        $ticket_id = (int) $variables['ticket_id'];
        $technician_id = (int) $user->technician_id;

        $valid = true;
        $other_error = [];
        $ticket_model = new TicketHeader();
        $ticket_model = $ticket_model->findByPk($ticket_id);
        if ($ticket_model == null) {
            $valid = false;
            $other_error[] = "Job ticket not found";
        } else if ($ticket_model->ticket_status == FmTicketStatus::CANCELLED || $ticket_model->ticket_status == FmTicketStatus::CLOSED || $ticket_model->ticket_status == FmTicketStatus::COMPLETED) {
            $valid = false;
            $other_error[] = "Job ticket is not active";
        }
        $condition = "ticket_id = $ticket_id AND technician_id = $technician_id AND status ='IN' ";
        $modelJobTime = new TicketJobTime();
        $modelJobTime = $modelJobTime->find(["condition" => $condition]);
        if ($modelJobTime == null) {
            $valid = false;
            $other_error[] = "No active job found.";
        } else if ($valid) {
            $modelJobTime->job_end_time = date("Y-m-d H:i:s");
            $modelJobTime->status = "OUT";
            $modelJobTime->calculateCost();
            $modelJobTime->save();
            echo json_encode(["status" => "success", "message" => "Job stopped"]);
        }
        if (!$valid) {
            $message = trim(implode(". ", $other_error));
            $json_array = ["status" => "error",
                "message" => $message
            ];
            echo json_encode($json_array);
        }
    }

    public function actionCompletejob() {
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);
        $token = trim($_SERVER['HTTP_TOKEN']);

        $ticket_id = (int) $variables['ticket_id'];

        $valid = true;
        $other_error = [];

        $ticket_model = new TicketHeader();
        $ticket_model = $ticket_model->findByPk($ticket_id);
        if ($ticket_model == null) {
            $valid = false;
            $other_error[] = "Job ticket not found";
        } else if ($ticket_model->ticket_status == FmTicketStatus::COMPLETED) {
            $valid = false;
            $other_error[] = "This Work Already Completed";
        } else if ($ticket_model->ticket_status != FmTicketStatus::WORK_FINISHED) {
            $valid = false;
            $other_error[] = "Work is not finished yet";
        }
        $rating = (int) $variables['rating'];
        if ($rating < 0 || $rating > 5) {
            $valid = false;
            $other_error[] = "Invalid rating.";
        }
        if ($valid) {
            $rating = (int) $variables['rating'];
            $rating_remarks = $variables['rating_remarks'];
            $sign_filename = $variables['sign_filename'];
            $ticket_model->updateByPk($ticket_id, [
                "rating" => $rating,
                "rating_remarks" => $rating_remarks,
                "sign_filename" => $sign_filename,
                "ticket_status" => FmTicketStatus::COMPLETED]);
            echo json_encode(["status" => "success", "message" => "Job Completed"]);
        } else {
            $message = trim(implode(". ", $other_error));
            $json_array = ["status" => "error",
                "message" => $message
            ];
            echo json_encode($json_array);
        }
    }

    public function actionJobfinished() {
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);
        $token = trim($_SERVER['HTTP_TOKEN']);
        $user = new User();
        $user = $user->findBytoken($token);
        $ticket_id = (int) $variables['ticket_id'];
        $technician_id = (int) $user->technician_id;

        $valid = true;
        $other_error = [];
        if (empty($technician_id)) {
            $valid = false;
            $other_error[] = "No Technician found";
        }
        $ticket_model = new TicketHeader();
        $ticket_model = $ticket_model->findByPk($ticket_id);
        if ($ticket_model == null) {
            $valid = false;
            $other_error[] = "Job ticket not found";
        } else if ($ticket_model->ticket_status != FmTicketStatus::WORK_IN_PROGRESS) {
            $valid = false;
            $other_error[] = "Job is not in progress";
        }
        if ($valid) {
            $condition = "ticket_id = $ticket_id   AND status ='IN' ";
            $modelJobTime = new TicketJobTime();
            $modelJobTimes = $modelJobTime->findAll(["condition" => $condition]);
            foreach ($modelJobTimes as $times) {
                $times->job_end_time = date("Y-m-d H:i:s");
                $times->status = "OUT";
                $times->calculateCost();
                $times->save();
            }
            $ticket_model->updateByPk($ticket_id, ["ticket_status" => FmTicketStatus::WORK_FINISHED]);
            echo json_encode(["status" => "success", "message" => "Job Completed"]);
        } else {
            $message = trim(implode(". ", $other_error));
            $json_array = ["status" => "error",
                "message" => $message
            ];
            echo json_encode($json_array);
        }
    }

    public function actionUploadsign() {
        $this->ChangeDB();
        //  $data = ["status" => false];
        $year = date("Y");
        $month = date("m-Y");
        $today = date("Y-m-d");
        $folder = "uploads/signature/";
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/' . $year . "/";
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        $folder .= $month . "/";
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        $path = "/" . $year . "/" . $month . "/";
        $filename = $today . "_" . rand(0, getrandmax()) . "_" . basename($_FILES["file"]["name"]);
        $destination = $folder . $filename;
        if (move_uploaded_file($_FILES["file"]["tmp_name"], $destination)) {
            $data = ["status" => "success", "filename" => $path . $filename];
        } else {
            $data = ["status" => "error", "message" => "Upload Failed",];
        }

        echo json_encode($data);
    }

}
