<?php

class ApidashboardController extends Controller {

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'Home'
                ),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        $valid_user = false;
        if (isset($_SERVER['HTTP_TOKEN'])) {
            $token = trim($_SERVER['HTTP_TOKEN']);
            $user_array = explode(".", $token);
            if (isset($user_array[0])) {
                $user_id = $user_array[0];
                $user = new User();
                $user = $user->findBytoken($token);
                if ($user != null && $user->isActive === "Y") {
                    $valid_user = true;
                }
            }
        }
        if ($valid_user) {
            $this->ChangeDB();
            return parent::beforeAction($action);
        } else {
            $json_data = [
                "status" => "error",
                "messsage" => "Access denied."
            ];
            echo json_encode($json_data);
        }
    }

    public function actionHome() {
        $token = trim($_SERVER['HTTP_TOKEN']);
        $user = new User();

        $user = $user->findBytoken($token);
        $technician_id = (int) $user->technician_id;

        ////
        $sql = "SELECT t.ticket_status, COUNT(*) as qty FROM erp_fm_ticket_header t JOIN erp_fm_ticket_allot_technicians a ON (t.id = a.ticket_id) WHERE a.technician_id = $technician_id GROUP BY t.ticket_status; ";
        $rawData = Yii::app()->db->createCommand($sql)->queryAll();
        $fm_status = new FmTicketStatus();
        $fm_statuses = $fm_status->findAll(["condition" => "isActive='Y'"]);
        $status_has_value = [];
        $dataCount = [];
        foreach ($rawData as $value) {
            $status_has_value[(int) $value['ticket_status']] = $value['qty'];
        }
        foreach ($fm_statuses as $each) {
            if (isset($status_has_value[$each->id])) {
                $dataCount[] = ["name" => $each->status_name, "count" => $status_has_value[$each->id]];
            } else {
                $dataCount[] = ["name" => $each->status_name, "count" => "0"];
            }
        }
        ///
        $jobTime = new TicketJobTime();
        $jobTime = $jobTime->find(["order" => "id desc"]);
        $jobTime_data = [];
        if (!empty($jobTime)) {
            $ticket_model = new TicketHeader();
            $ticket_model = $ticket_model->findByPk($jobTime->ticket_id);
            $jobTime_data = ["id" => $jobTime->id,
                "ticket_id" => $jobTime->ticket_id,
                "buidling" => $ticket_model->building_details->building_name,
                "buidling_unit" => $ticket_model->unit_details->unit_name,
                "status" => $jobTime->status,
                "start_time" => date('d/m/Y h:i a', strtotime($jobTime->job_start_time)),
                "end_time" => ($jobTime->status == "OUT") ? date('d/m/Y h:i a', strtotime($jobTime->job_end_time)) : "",
                "working_hours" => ($jobTime->status == "OUT") ? $jobTime->working_hours : "",
                "rate" => $jobTime->rate,
                "total" => $jobTime->total_cost,
            ];
        }
        $last_job = ["status" => ""];
        $json_data = [
            "status" => "success",
            "work_count" => $dataCount,
            "last_job" => $jobTime_data
        ];

        echo json_encode($json_data);
    }

}
