<?php

class ApicustomerController extends Controller {

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('create', 'mycustomer', 'myreview','MyOpenJobs'),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /*
      public function beforeAction($action) {
      $valid_user = false;
      if (isset($_SERVER['HTTP_TOKEN'])) {
      $this->ChangeDB();
      $token = trim($_SERVER['HTTP_TOKEN']);
      $appAuthentication = new AppAuthentication($token);
      $valid_user = $appAuthentication->login();
      }
      if ($valid_user) {
      return parent::beforeAction($action);
      } else {
      $json_data = [
      "status" => "error",
      "messsage" => "Access denied."
      ];
      echo json_encode($json_data);
      }
      }
     */

    public function actionCreate() {
        $this->ChangeDB();
        $input = file_get_contents('php://input');
        //error_log($input);
        $variables = json_decode($input, true);
        $token = trim($_SERVER['HTTP_TOKEN']);
        $customer_model = new Customer();
        $customer_model->isActive = "Y";
        $id = isset($variables["id"]) ? $variables["id"] : "0";
        if (!empty($id)) {
            $customer_model = $customer_model->findByPk($id);
            if (empty($customer_model)) {
                $customer_model = new Customer();
                $customer_model->isActive = "Y";
            }
        }
        $customer_model->attributes = $variables;
        $customer_model->customer_name = ucwords($variables['customer_name']);
        $customer_model->customer_phone_no = $variables['customer_phone_no'];
        $customer_model->customer_email_id = $variables['customer_email_id'];
        $customer_model->firebase_uid = $variables['firebase_uid'];
        if (empty($customer_model->customer_payment_term)) {
            $term = MasPaymentTerm::model()->find(['condition' => "isBasePaymentTerm='Y' "]);
            if (!empty($term)) {
                $customer_model->customer_payment_term = $term->id;
            }
        }
        if (empty($customer_model->customer_currency_id)) {
            $currency_id = (int) MasCurrency::base_currency_id();
            $customer_model->customer_currency_id = $currency_id;
        }
        if (empty($customer_model->default_pricing_group_id)) {
            $modelSalesPriceGroupName = new SalesPriceGroupName();
            $arr_default_pricing_group = $modelSalesPriceGroupName->find(array('condition' => 'default_pricing_group="Y"'));
            $default_pricing_group_id = $arr_default_pricing_group->id;
            $customer_model->default_pricing_group_id = (int) $default_pricing_group_id;
        }
        if (empty($customer_model->customer_country)) {
            $country = new MasCountry();
            $customer_model->customer_country = $country->getDefaultID();
        }
        if ($customer_model->validate() && $customer_model->save()) {
            $customer_model->get_generate_token();
            $unit_id = isset($variables['unit_id']) ? $variables['unit_id'] : "";
            if (!empty($unit_id)) {
                $unit_model = new MasBuildingUnit();
                $unit_model->updateByPk($unit_id, [
                    "customer_id" => $customer_model->id
                ]);
            }
            $unit_array = [];
            $condition = "t.customer_id = " . $customer_model->id;
            $unit = new MasBuildingUnit();
            $unit = $unit->findAll(array('condition' => $condition, 'order' => 'sort_order'));
            if (!empty($unit)) {
                foreach ($unit as $i => $each) {
                    $unit_array[] = [
                        "id" => $each->id,
                        "unit" => $each->unit_name,
                        "building" => $each->building->building_name,
                        "building_id" => $each->building_id
                    ];
                }
            }
            echo json_encode([
                "status" => "success",
                "message" => "Customer saved",
                "token" => $customer_model->token,
                "id" => $customer_model->id,
                "customer_name" => $customer_model->customer_name,
                "customer_phone_no" => $customer_model->customer_phone_no,
                "customer_email_id" => $customer_model->customer_email_id,
                "unit_array" => $unit_array
            ]);
        } else {
            echo json_encode([
                "status" => "error",
                "message" => "Error in saving customer",
                "error_array" => $customer_model->getErrors()
            ]);
        }
    }

    public function actionMycustomer() {
        $token = trim($_SERVER['HTTP_TOKEN']);
        $user = new User();
        $user_model = $user->findBytoken($token);
        $condition = "t.ticket_status IN(6, 2)  ";
        if (!empty($user_model) && !empty($user_model->technician_id)) {
            $condition .= " AND technician_id = " . $user_model->technician_id;
        } else {
            $condition .= " AND technician_id = 0 ";
        }
        $sql = "SELECT erp_fm_mas_unit.customer_id,erp_fm_mas_unit.id as unit_id, erp_fm_mas_unit.unit_name, customer_name, erp_fm_mas_building.id as building_id ,erp_fm_mas_building.building_name FROM ( SELECT DISTINCT t.unit_id FROM erp_fm_ticket_allot_technicians allot JOIN erp_fm_ticket_header t ON (t.id = allot.ticket_id) WHERE $condition ) U JOIN erp_fm_mas_unit ON U.unit_id = erp_fm_mas_unit.id JOIN erp_fm_mas_building ON ( erp_fm_mas_building.id = erp_fm_mas_unit.building_id ) JOIN erp_customer ON erp_customer.id = erp_fm_mas_unit.customer_id; ";
        $rawData = Yii::app()->db->createCommand($sql)->queryAll();

        $data = [];

        foreach ($rawData as $each_data) {
            $data[] = [
                "customer_id" => $each_data["customer_id"],
                "unit_name" => $each_data["unit_name"],
                "unit_id" => $each_data["unit_id"],
                "building_id" => $each_data["building_id"],
                "building_name" => $each_data["building_name"],
            ];
        }
        echo json_encode(["status" => "success", "data" => $data]);
    }

    public function actionReview() {
        $token = trim($_SERVER['HTTP_TOKEN']);
        $user_model = new User();
        $user_model = $user_model->findBytoken($token);
        $technician_id = 0;
        if (!empty($user_model) && !empty($user_model->technician_id)) {
            $technician_id = $user_model->technician_id;
        }
        $condition = "allotted_rel.technician_id = " . $technician_id . " AND t.ticket_status = " . FmTicketStatus::COMPLETED;
        $model = new TicketHeader();
        $models = $model->with("allotted_rel")->findAll(["order" => "t.id desc", "condition" => $condition]);
        $data_rating = [];
        foreach ($models as $row) {
            $data_rating[] = [
                "id" => $row->id,
                "rating" => $row->rating,
                "ticket_date" => date("d/m/Y", strtotime($row->ticket_date)),
                "rating_remarks" => trim($row->rating_remarks),
                "description" => trim($row->description),
                "issuse_type" => $row->issue_details->issue_type,
                "issue_type_id" => $row->issue_type_id,
                "building_id" => $row->property_id,
                "building_name" => $row->building_details->building_name,
                "unit_id" => $row->unit_id,
                "unit_name" => $row->unit_details->unit_name,
                "customer_name" => ucwords($row->unit_details->customer->customer_name),
                "customer_id" => $row->unit_details->customer_id,
                "priority_id" => $row->priority_id,
            ];
        }
        echo json_encode([
            "status" => "success",
            "data" => $data_rating]);
    }

    public function actionMyreview() {
         $this->ChangeDB();
        $token = trim($_SERVER['HTTP_TOKEN']);

        $customer_model = new Customer();
        $customer_model = $customer_model->findBytoken($token);
        $data_rating = [];
        //$technician=[];
        if (!empty($customer_model)) {
            $model = new TicketHeader();
            $condition = "unit_details.customer_id = " . $customer_model->id;
            $models = $model->with('unit_details')->findAll(["condition" => $condition, "order" => "t.id desc"]);
            $technician_name='';
            foreach ($models as $row) {

                $ModelAllotTech=TicketAllotTechnicians::model()->find(["condition" =>'ticket_id='.$row->id.' ' ,'order' => "id desc"]);
                $technician_name= $ModelAllotTech->technician_details->technician_name;
                $data_rating[] = [
                    "id" => $row->id,
                    "rating" => $row->rating,
                    "ticket_date" => date("d/m/Y", strtotime($row->ticket_date)),
                    "rating_remarks" => trim($row->rating_remarks),
                    "description" => trim($row->description),
                    "issuse_type" => $row->issue_details->issue_type,
                    "issue_type_id" => $row->issue_type_id,
                    "building_id" => $row->property_id,
                    "building_name" => $row->building_details->building_name,
                    "unit_id" => $row->unit_id,
                    "unit_name" => $row->unit_details->unit_name,
                    "customer_name" => ucwords($row->unit_details->customer->customer_name),
                    "customer_id" => $row->unit_details->customer_id,
                    "priority_id" => $row->priority_id,
                    "technician" => $technician_name,
                ];
            }
            echo json_encode([
                "status" => "success",
                "data" => $data_rating]);
        } else {
            echo json_encode([
                "status" => "error",
                "message" => "Customer not found",
                "data" => $data_rating]
            );
        }
    }

    public function actionMyOpenJobs(){
        $this->ChangeDB();
        $token = trim($_SERVER['HTTP_TOKEN']);
        $customer_model = new Customer();
        $customer_model = $customer_model->findBytoken($token);
        if (!empty($customer_model)) {
            $model = new TicketHeader();
            $open_status=FmTicketStatus::OPEN;
            $condition = "unit_details.customer_id = '" . $customer_model->id."' AND t.ticket_status='".$open_status."' ";
            $models = $model->with('unit_details')->findAll(["condition" => $condition, "order" => "t.id desc"]);
            foreach ($models as $row) {
                $open_Arr[] = [
                        "id" => $row->id,
                        
                        "ticket_date" => date("d/m/Y", strtotime($row->ticket_date)),
                        "rating_remarks" => trim($row->rating_remarks),
                        "description" => trim($row->description),
                        "issuse_type" => $row->issue_details->issue_type,
                        "issue_type_id" => $row->issue_type_id,
                        "building_id" => $row->property_id,
                        "building_name" => $row->building_details->building_name,
                        "unit_id" => $row->unit_id,
                        "unit_name" => $row->unit_details->unit_name,
                        "customer_name" => ucwords($row->unit_details->customer->customer_name),
                        "customer_id" => $row->unit_details->customer_id,
                        "priority_id" => $row->priority_id,
                        "priority_name" => $row->priority_details->name,
                        
                    ];
            }
            echo json_encode([
                "status" => "success",
                "data" => $open_Arr]);
        } 
        else{
              echo json_encode([
                "status" => "error",
                "message" => "Customer not found",
                "data" => $open_Arr]
            );
        }
        
    }

}
