<?php
class FixedAssetRegister extends CActiveRecord {
    public function tableName() {
        return '{{fixed_asset_register}}';
    }   

    // validation rules for the master fixed asset form
    public function rules()
    {
        return array(
                        array('master_id,part_no,description,quantity,serial_no,purchase_date,depreciation_start_date', 'required'),
                        array('rate,total_value,current_book_value,monthly_depreciation,daily_depreciation,sold_amount', 'numerical'),
                        array('debit_account,credit_account,master_id,created_by,updated_by', 'numerical', 'integerOnly' => true),
                        array('active', 'length', 'max' => 5),
                        array('location', 'length', 'max' => 225),
                        array('notes', 'length', 'max' => 2225),
                        array('id,master_id,fixed_asset_no,part_no,description,quantity,serial_no,rate,total_value,current_book_value,monthly_depreciation', 'safe', 'on' => 'search'),
        );
    }
    public function relations()
	{
		return array(
			'master' => array(self::BELONGS_TO, 'FixedAssetMaster', 'master_id'),
		);
    }
    public function attributeLabels()
	{
		return array(
			'id' => 'ID',
		);
	}
    public function search()
	{
		$criteria = new CDbCriteria;
		$criteria->compare('id', $this->id);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
    }
    public static function model($className=__CLASS__)
	{
	return parent::model($className);
    }
}
