<style type="text/css">
    .align-right { text-align: right; max-width: 80px; }
</style>

<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        Fixed Assets Depreciated
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_depreciate_fixed_asset_details">
                <thead>
                    <tr>
                        <th>Fixed Asset Number</th>
                        <th>Fixed Asset Type</th>
                        <th>Description</th>   
                        <th>Depreciated Date</th>
                        <th>Amount</th>                   
                        <th>Depreciation Done Date</th>
                        <th>Depreciated By</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>

<script>
$(document).ready(function () {
    var table_id = "#tbl_depreciate_fixed_asset_details";

    var table = $(table_id).DataTable({
        ajax: {
            url: "<?php echo Yii::app()->createUrl('fixedasset/depreciate/GetList'); ?>",
            type: "POST",
            cache: false
        },
        serverSide: true,
        processing: true,
        scrollY: "645px",
        pageLength: 50,
        fixedColumns: true,
        order: [[1, "asc"], [0, "desc"]],
        columnDefs: [
            { targets: [3, 4, 5, 6], className: 'align-right' } // right-align numeric/date columns
        ],
        fnCreatedRow: function (nRow, aData, iDataIndex) {
            $(nRow).addClass("context-menu");
        },
        fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            AddContextMenu(nRow, aData);
        }
    });
});

function AddContextMenu(row, datas) {
    $(row).contextMenu({
        selector: 'td',
        items: {
            <?php if (isset(Yii::app()->user->havePermissionOn['depreciation_edit']) || Yii::app()->user->authorised_user == 1) { ?>
            "edit": {
                name: "Edit",
                icon: "edit",
                accesskey: "e",
                callback: function () {
                    // loadPopupModal('fixedasset/register/CreateSerialize&id='+datas[8].id,'Edit','xl');
                }
            }
            <?php } ?>
        }
    });
}
</script>
