<?php

class DepreciateController extends Controller
{
    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','AggregateIndex', 'GetListAggregate', 'CalculateDepreciate' ,'Create', 'SaveRegisterFixedAsset', 'GetList', 'DeleteFixedAssetMaster', 'GetInvoiceFromPurchase', 'CreateSerialize', 'GetSerialNumber'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {
        //setting the layout as the fixed asset module layout
        $this->layout='layout';
        $this->render('index');
    }

    public function actionAggregateIndex(){
        //setting the layout as the fixed asset module layout
        $this->layout='layout';
        $this->render('aggregateindex');
    }


    // calculate depreciation
    public function actionCalculateDepreciate(){
       
        // begin database transaction
        $transaction = Yii::app()->db->beginTransaction();
        try
        {
            $to_depreciate = Yii::app()->db->createCommand()
                                            ->select('er.fixed_asset_register_number, er.fixed_asset_master_number, em.depreciation_period, er.depreciation_start_date, er.current_book_value, em.id as fixed_asset_type')
                                            ->from('erp_fixed_asset_register as er')
                                            ->join('erp_fixed_asset_master as em', 'er.fixed_asset_master_number = em.id')
                                            ->where("   er.isActive = :active
                                                        and er.depreciation_start_date <= CURDATE()
                                                        and CURDATE() < DATE_ADD(CURDATE(), INTERVAL em.depreciation_period MONTH)
                                                        and er.current_book_value >= 0"
                                                        , array(':active' => 'Y'))     
                                            ->queryAll();

            $depreciate_insert_string = '';
            foreach ($to_depreciate as $depre){
                $depreciate_update_string = '';
                $depreciate_update_fixed_asset_numbers = '';
                $dep_per_year = 100/($depre['depreciation_period']/12);
                $dep_per_year = round(($dep_per_year/100)*$depre['current_book_value'], 2);
                $dep_per_month = round($dep_per_year/12, 2);
                $dep_per_day = round($dep_per_month/30, 2);
            

                $fixed_register_number = $depre['fixed_asset_register_number'];
                $fixed_asset_type = $depre['fixed_asset_type'];
                $depreciate = Yii::app()->db->createCommand(
                                                                "select count(ed.fixed_asset_register) as register_count 
                                                                from erp_fixed_asset_depreciation as ed 
                                                                where ed.fixed_asset_register = $fixed_register_number and ed.fixed_asset_type = $fixed_asset_type
                                                                and ed.month in (select month from erp_fixed_asset_depreciation where fixed_asset_register = $fixed_register_number and fixed_asset_type = $fixed_asset_type )"
                                                            )->queryRow(); 
                
                  $current_date =  date('Y-m-d');
                  if ($depreciate['register_count'] == 0){
                    $total_number_of_days = round((time() - strtotime($depre['depreciation_start_date'])) / (60 * 60 * 24));;
                    $date_from =  $depre['depreciation_start_date'];
                    $date_to = date("Y-m-d");

                    $depreciated_date = Yii::app()->db->createCommand(
                                                "select max(depreciated_date) as depreciated_date
                                                from erp_fixed_asset_depreciation as ed  
                                                 where ed.fixed_asset_register = $fixed_register_number "
                                                 )->queryRow();   

                    $ts1 = strtotime($date_from);
                    $ts2 = strtotime( $date_to);
                    $year1 = date('Y', $ts1);
                    $year2 = date('Y', $ts2);
                    $month1 = date('m', $ts1);
                    $month2 = date('m', $ts2);
                    $diff = (($year2 - $year1) * 12) + ($month2 - $month1);
                   
                    if ($diff > 0){
                        foreach (range(0, $diff) as $i){
                                $dep_by = 0;
                                if ($i == 0){
                                    $date_from_depre = $date_from;
                                    $date_to_depre = date("Y-m-t", strtotime($date_from_depre));
                                    $total_number_of_days = round(((strtotime($date_to_depre) - strtotime($date_from_depre))) / (60 * 60 * 24));
                                    if ($total_number_of_days == 0) $total_number_of_days = 1;
                                    if (($depre['current_book_value'] - ($dep_per_day*$total_number_of_days)) >= 0) $cbv = $depre['current_book_value'] - round($dep_per_day*$total_number_of_days, 2);
                                    else $cbv = 0;
                                    $dep_by = $dep_per_day*$total_number_of_days;
                                } 
                                else{
                                    $date_from_depre = date("Y-m-01", strtotime('first day of next month', strtotime($date_from_depre)));
                                    if (($depre['current_book_value'] - $dep_per_month) >= 0) $cbv = $cbv -  $dep_per_month;
                                    else $cbv = 0;
                                    $date_to_depre = date("Y-m-t", strtotime($date_from_depre));
                                    $dep_by = $dep_per_month; 
                                }
                                
                                $depreciated = array (
                                $depre['fixed_asset_register_number'],
                                $depre['fixed_asset_type'],
                                "'{$current_date}'",
                                $dep_by,
                                $cbv,
                                "'{$date_from_depre}'",
                                "'{$date_to_depre}'",
                                date("mY", strtotime($date_from_depre)),
                                "'Y'",
                                Yii::app()->user->id,
                                "'{$current_date}'"
                            );

                            $depreciate_insert_string .= '('. implode(",", $depreciated). '),';
                            $current_book_value = $cbv;
                            $depreciate_update_string .= " WHEN {$depre['fixed_asset_register_number']} THEN {$current_book_value} ";
                           $depreciate_update_fixed_asset_numbers .= '('.$depre['fixed_asset_register_number'].','.$depre['fixed_asset_master_number'].')'.',';
                        }
                        
                    }
                    
                    if ($diff < 1){
                            $date_from_depre = $date_from;
                            $date_to_depre = date("Y-m-t", strtotime($date_from_depre));

                            $total_number_of_days = round((strtotime($date_to_depre) - strtotime($date_from_depre)) / (60 * 60 * 24));;
                            if (($depre['current_book_value'] - ($dep_per_day*$total_number_of_days)) >= 0) $cbv = $depre['current_book_value'] - ($dep_per_day*$total_number_of_days);
                            else $cbv = 0;
                            $dep_by = $dep_per_day*$total_number_of_days;

                            $depreciated = array (
                            $depre['fixed_asset_register_number'],
                            $depre['fixed_asset_type'],
                            "'{$current_date}'",
                            $dep_by,
                            $cbv,
                            "'{$date_from_depre}'",
                            "'{$date_to_depre}'",
                            date("mY", strtotime($date_from_depre)),
                            "'Y'",
                            Yii::app()->user->id,
                            "'{$current_date}'"
                        );
    
                        $depreciate_insert_string .= '('. implode(",", $depreciated). '),';
                        $current_book_value = $cbv;
                        $depreciate_update_string .= " WHEN {$depre['fixed_asset_register_number']} THEN {$current_book_value} ";
                        $depreciate_update_fixed_asset_numbers .= '('.$depre['fixed_asset_register_number'].','.$depre['fixed_asset_master_number'].')'.',';
    
                    }

                     
                     $register = $depre['fixed_asset_register_number'];
                     $master = $depre['fixed_asset_master_number'];
                     Yii::app()->db->createCommand(
                                "update erp_fixed_asset_register
                                   set current_book_value = $cbv
                                   Where fixed_asset_register_number = $register and fixed_asset_master_number = $master"
                          )->execute();

                     // inserting to audit log
                     AuditLog::saveAuditLogs(
                        'DEPRECIATION',
                        Yii::app()->user->id,
                        'UPDATED',
                        " with DEPREC for register No: - {$register}  "
                    );
                    // end audit log
                  }
            } 
            if (!empty($depreciate_insert_string)) {
                $depreciate_insert_string = rtrim($depreciate_insert_string, ",");
               
                Yii::app()->db->createCommand(
                    "insert into erp_fixed_asset_depreciation(fixed_asset_register,fixed_asset_type, depreciated_date, depreciated_by, current_book_value, date_from, date_to, month, isActive, updated_by, updated_date_time)
                     values $depreciate_insert_string"
                )->execute();

                // updating fixed_asset_register book value
                     //$depreciate_update_fixed_asset_numbers = rtrim($depreciate_update_fixed_asset_numbers, ',');
                
                $transaction->commit();

                $jsonData['status'] = 'success';
                $jsonData['msg'] = "Depreciation Performed Successfully";
                echo CJSON::encode($jsonData);
                
            }else{
                $jsonData['status'] = 'success';
                $jsonData['msg'] = "Depreciation already Performed";
                echo CJSON::encode($jsonData);
            }
            
        }
        catch(\yii\db\Exception $e)
        {
            $transaction->rollback();
            $jsonData['status'] = 'failure';
            $jsonData['msg'] = "An error occured. Please try again";
            echo CJSON::encode($jsonData);
        }

    }

     // action to get list of fixed asset aggregate depreciation register
     public function actionGetListAggregate() {
        $model = new FixedAssetMaster();
        $num = 0;
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'erd.date_from',
            1 => 'erm.fixed_asset_name',
            2 => 'erd.depreciated_by',
        );
        //sort by fixest_asset_id
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];

        //sort by month
        $filterColumn2 = $columns[$_POST['order'][1]['column']];
        $filterOrder2 = $_POST['order'][1]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder. ", ".$filterColumn2 . " " . $filterOrder2 ;

       if (!empty($filterColumn2) && !empty($filterOrder2)){
            $orderBy = $filterColumn . " " . $filterOrder. ", ".$filterColumn2 . " " . $filterOrder2 ;
        }else{
            $orderBy = $filterColumn . " " . $filterOrder;
        }

        $condition = '';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " where erm.fixed_asset_name LIKE '%" . $searchString . "%' ";
        }
        
        $count = count($this->getFixedAssetDepreciationAggregate());
        $depreciations = $this->getFixedAssetDepreciationAggregate($condition, $limit, $offset, $orderBy);
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($depreciations as $row) {
            $div = '';
            $rowData[] = array(
                $row['month_name']. ' '. $row['year'],
                $row['fixed_asset_name'],
                number_format($row['total_book_value'], 2, '.', ''),
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id']),);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    // action to get list of fixed asset register
  /* public function actionGetList() {
        $model = new Depreciate();
        $num = 0;
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'ed.fixed_asset_register',
            1 => 'em.fixed_asset_name',
            2 => 'ed.depreciated_date',
            3 => 'ed.depreciated_by',
            4 => 'ed.current_book_value',
            5 => 'ed.date_from',
        );
        //sort by fixest_asset_id
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];

        //sort by fixed asset type
        $filterColumn2 = $columns[$_POST['order'][1]['column']];
        $filterOrder2 = $_POST['order'][1]['dir'];

        //sort by fixed asset type
        $filterColumn3 = $columns[$_POST['order'][2]['column']];
        $filterOrder3 = $_POST['order'][2]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder. ",". $filterColumn2. " ". $filterOrder2. ",". $filterColumn3." ".$filterOrder3;
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (em.fixed_asset_name LIKE '%" . $searchString . "%' OR ed.fixed_asset_register LIKE '%" . $searchString . "%')";
        }
        $count = count($this->getFixedAssetDepreciation());
        $depreciations = $this->getFixedAssetDepreciation($condition, $limit, $offset, $orderBy);
       print_r( $depreciations ); die();
     
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($depreciations as $row) {
            $div = '';
            $rowData[] = array(
               // $row['fixed_asset_register'],
                $row['serial_no'],
                $row['fixed_asset_name'],
                $row['description'],
                $row['depr_check_date'],
                number_format($row['depreciated_by'], 2, '.', ''),
                number_format($row['current_book_value'], 2, '.', ''),
                date("d M Y", strtotime($row['date_from'])).' to '.date("d M Y", strtotime($row['date_to'])),
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id']),);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
        //print_r($data); die();
    }
*/
public function actionGetList()
{
    $model = new Depreciate();
    $num = 0;
    $draw = $_POST['draw'];
    $offset = $_POST['start'];
    $limit = $_POST['length'];

    $columns = array(
        0 => 'ed.fixed_asset_register',
        1 => 'em.fixed_asset_name',
        2 => 'ed.depreciated_date',
        3 => 'ed.depreciated_by',
        4 => 'ed.current_book_value',
        5 => 'ed.date_from',
    );

    // Sorting
    $filterColumn  = $columns[$_POST['order'][0]['column']];
    $filterOrder   = $_POST['order'][0]['dir'];

    $filterColumn2 = $columns[$$_POST['order'][1]['column']];
    $filterOrder2  = $_POST['order'][1]['dir'];

    $filterColumn3 = $columns[$_POST['order'][2]['column']];
    $filterOrder3  = $_POST['order'][2]['dir'];

    $orderBy = $filterColumn . " " . $filterOrder . "," .
               $filterColumn2 . " " . $filterOrder2 . "," .
               $filterColumn3 . " " . $filterOrder3;
    $condition = "depreciation_amount>0";
    // Search filter
    if (!empty($_POST['search']['value'])) {
        $searchString = $_POST['search']['value'];
        $condition = " (em.fixed_asset_name LIKE '%$searchString%' 
                          OR fr.serial_no LIKE '%$searchString%' 
                          OR fr.description LIKE '%$searchString%')";
    }

    // Count total
    $count = count($this->getFixedAssetDepreciation());

    // Fetch all rows (including repeated depreciation rows)
    $depreciations = $this->getFixedAssetDepreciation($condition, $limit, $offset, $orderBy);

    $recordsTotal = $count;
    $recordsFiltered = $count;
    $data['draw'] = $draw;
    $data['recordsTotal'] = $recordsTotal;
    $data['recordsFiltered'] = $recordsFiltered;

    $rowData = array();

    foreach ($depreciations as $row) {

        // NEW: formatted depreciated date
        $deprDate = $row['depreciated_date']
                    ? date("d/m/Y", strtotime($row['depreciated_date']))
                    : "-";

        // NEW: depreciation done date (same as depreciated_date)
        $doneDate =  $row['created_at']
                    ? date("d/m/Y", strtotime($row['created_at']))
                    : "-";

        // NEW: Who depreciated
        $user = User::model()->findByPk($row['created_by']);
        $doneBy = $user ? $user->username : null;
        

        // NEW: depreciation amount
        $amount = number_format($row['depreciation_amount'], 2, '.', '');

        // NEW: date range
        $range = "";
        if (!empty($row['date_from']) && !empty($row['date_to'])) {
            $range = date("d M Y", strtotime($row['date_from'])) . ' to ' .
                     date("d M Y", strtotime($row['date_to']));
        }

        $rowData[] = array(
            $row['serial_no'],
            $row['fixed_asset_name'],
            $row['description'],
           // $row['depr_check_date'] ? date("d/m/Y", strtotime($row['depr_check_date'])) : "-",

            // NEW COLUMNS
            $deprDate,          // depreciated date
            $amount,            // depreciation amount
            $doneDate,          // depreciation done date
            $doneBy,            // depreciation done by

          //  number_format($row['current_book_value'], 2, '.', ''),
         //   $range,

            '<div class="btn-wrap text-center"></div>',
            array('id' => $row['id']),
        );
    }

    $data['data'] = $rowData;
   // print_r($data['data']); die();
    echo json_encode($data);
}


   
    private function getFixedAssetDepreciationAggregate($condition = null, $limit = null, $offset = null, $orderBy = null){
        if ($limit == null && $offset == null && $orderBy == null){
            $aggregate = Yii::app()->db->createCommand(
                                                      "select erm.fixed_asset_name, erd.fixed_asset_type, SUM(erd.depreciated_by) as total_book_value, monthname(erd.date_from) as month_name, year(erd.date_from) as year
                                                        from erp_fixed_asset_depreciation as erd 
                                                      join erp_fixed_asset_master as erm
                                                        on erd.fixed_asset_type = erm.id 
                                                      $condition
                                                        group by erd.fixed_asset_type, month(erd.date_from)"            )
                                            ->queryAll();
        }else{
            $aggregate = Yii::app()->db->createCommand(
                                                      "select erm.fixed_asset_name, erd.fixed_asset_type, SUM(erd.depreciated_by) as total_book_value, monthname(erd.date_from) as month_name, year(erd.date_from) as year
                                                      from erp_fixed_asset_depreciation as erd 
                                                      join erp_fixed_asset_master as erm
                                                      on erd.fixed_asset_type = erm.id 
                                                     $condition
                                                      group by erd.fixed_asset_type, month(erd.date_from)
                                                      order by $orderBy
                                                     limit $limit
                                                     offset $offset "
                                                    )
                                                    ->queryAll();
        }
        
      return $aggregate;
    }
   
    private function getFixedAssetDepreciation($condition = null, $limit = null, $offset = null, $orderBy = null){
        if ($limit == null && $offset == null && $orderBy == null){
           /* $depreciation = Yii::app()->db->createCommand()
                                            ->select('ed.id, ed.fixed_asset_register, ed.depreciated_date, ed.depreciated_by, ed.current_book_value, ed.date_from, ed.date_to, ed.updated_date_time, em.fixed_asset_name')
                                            ->from('erp_fixed_asset_depreciation as ed')
                                            ->join('erp_fixed_asset_master as em', 'ed.fixed_asset_type = em.id')
                                            ->where("ed.isActive = :active $condition", array(':active' => 'Y'))
                                            ->queryAll();*/
     $depreciation = Yii::app()->db->createCommand()
    ->select('fr.id, fr.serial_no, fr.master_id, fr.description, fr.depr_check_date,
              em.fixed_asset_name, fd.depreciated_date, fd.depreciation_amount,fd.created_at' )
    ->from('erp_fixed_asset_register fr')
    ->join('erp_fixed_asset_master em', 'fr.master_id = em.id')
    ->leftJoin('erp_fixed_asset_depreciation fd', 'fd.fixed_asset_register = fr.id')
    ->order('fr.id DESC')   // ← ORDER BY added here
    ->queryAll();

return $depreciation;
        }else{
           /*  $depreciation = Yii::app()->db->createCommand()
                                            ->select('ed.id, ed.fixed_asset_register, ed.depreciated_date, ed.depreciated_by, ed.current_book_value, ed.date_from, ed.date_to, ed.updated_date_time, em.fixed_asset_name')
                                            ->from('erp_fixed_asset_depreciation as ed')
                                            ->join('erp_fixed_asset_master as em', 'ed.fixed_asset_type = em.id')
                                            ->where("ed.isActive = :active $condition", array(':active' => 'Y'))
                                            ->limit($limit)
                                            ->offset($offset)
                                            ->order($orderBy)
                                            ->queryAll();*/
           $depreciation = Yii::app()->db->createCommand()
    ->select('fr.id, fr.serial_no, fr.master_id, fr.description, fr.depr_check_date,
              em.fixed_asset_name, fd.depreciated_date, fd.depreciation_amount,fd.created_at,fd.created_by')
    ->from('erp_fixed_asset_register fr')
    ->join('erp_fixed_asset_master em', 'fr.master_id = em.id')
    ->leftJoin('erp_fixed_asset_depreciation fd', 'fd.fixed_asset_register = fr.id')
    ->where( $condition)
    ->order('fr.id DESC')   
   
                                            ->limit($limit)
                                            ->offset($offset)
                                          //  ->order($orderBy)
                                            ->queryAll();
            return $depreciation;
        }
        
    }

}
